function LY = lihtsim(L,LX,varargin)
% Equivalent function to liht.m to run lihtsim.slx from existing L,LX
% liutsim.slx has 2 referenced subsystems;
% liuxslx.slx outputs the LX bus object (from LX data in its data dictionary)
% lihtslx.slx is the time stepper that receives LX and outputs LY.
% Data dictionaries are automatically created, linked and deleted as necessary
%
% Custom parameters:
% .bslvdprec    flag for real precision in block solver
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

for k = 1:2:length(varargin)
  L.P.(varargin{k}) = varargin{k+1};
end
L = liusimc(L,LX);

%% Simulate model
lihsmodel = 'lihsim.slx';
out = sim(lihsmodel);

%% Convert timeseries results to LY
LY = ts2meq(L,out.LY);
LY.t = LX.t; % Restore original time

%% Close without saving
close_system(lihsmodel,0);
close_system('lihtslx.slx',0);
close_system('liuxslx.slx',0);

%% Plot for debug
if L.P.debug
  for it = 1:numel(LY.t)
    meqplott(L,meqxk(LY,it));
    drawnow;
  end
end
end

