/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"
# ifdef SINGLE
# define FCT  sresp
# define GEMM cblas_sgemm
# else
# define FCT  dresp
# define GEMM cblas_dgemm
# endif

/* Y = [A*B C*D] */
void FCT(FLT *Y, FLT*A, FLT *B, FLT*C, FLT *D, int m, int nA, int nB, int nC, int nD) {
 GEMM(CblasColMajor, CblasNoTrans, CblasNoTrans, m, nB, nA, FLTC(1.0), A, m, B, nA, FLTC(0.0), Y     , m);
 GEMM(CblasColMajor, CblasNoTrans, CblasNoTrans, m, nD, nC, FLTC(1.0), C, m, D, nC, FLTC(0.0), Y+m*nB, m);
}
