/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"
# ifdef SINGLE
# define FCT sbbox
# else
# define FCT dbbox
# endif

void FCT(FLT *x1, FLT *y1, FLT *x2, FLT *y2, bool *lxy, FLT *x, FLT *y, int nx, int ny) {
 int kx, ky;
 FLT *xp, *yp, xv, yv, xa, xb, ya, yb;
 bool *lp = lxy, init = true;
 for (ky = ny, yp = y; ky--; ) {
  yv = *yp++;
  xp = x;
  for (kx = nx; kx--; ) {
   xv = *xp++;
   if (*lp++) {
    if (init) {
     xa = xb = xv;
     ya = yb = yv;
     init = false;
    } else {
     if      (xv < xa) xa = xv;
     else if (xv > xb) xb = xv;
     if      (yv < ya) ya = yv;
     else if (yv > yb) yb = yv;
    }
   }
  }
 }
 if (init) {
  *x1 = *x2 = *y1 = *y2 = FLTC(0.0);
 } else {
  *x1 = xa; *x2 = xb; *y1 = ya; *y2 = yb;
 }
}
