function w = weeknum(d)

% WEEKNUM   Week number of a date
%   WEEKNUM(D) returns the week number in the year of D given as a DATESTR or 
%   DATENUM. (ISO-8601)
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

[Y,M,D] = datevec(datenum(d));
a = floor((14-M)/12);
y = Y+4800-a;
m = M+12*a-3;
J = D+floor((153*m+2)/5)+365*y+floor(y/4)-floor(y/100)+floor(y/400)-32045;
d4 = rem(rem(rem(J+31741-rem(J,7),146097),36524),1461);
l = floor(d4/1460);
d1 = rem(d4-l,365)+l;
w = floor(d1/7)+1;
