classdef pp2bsp_test < genlib_test
  % Test class for conversions between matlab pp spline to genlib bsp
  % spline objects
  %
  % [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties
    x_ = linspace(0,1,21).';
    tol_ = 1e-8;
  end
  
  properties (TestParameter)
    size = struct('scalar',1,'vector',3,'multi',[3,4]);
  end
  
  methods (Test)
    function test_pp2bsp(testCase,size)
      % test_pp2bsp verify that function evaluation yields the same result
      
      x = testCase.x_;
      tol = testCase.tol_;

      y = rand([size,numel(x)]);
      
      % First construct pchip interpolation
      pp = pchip(x,y);

      % Convert it to BSP format
      [M,tau] = pp2bsp(pp);
      
      % Compute interpolated values with both formats
      nx0 = 1001;
      x0 = linspace(0,1,nx0).';
      y0pp = ppval(pp,x0);
      % Handle differences in size management
      if ~isvector(y0pp)
        y0pp = shiftdim(y0pp,ndims(y0pp)-1);
      end
      y0bsp = bspsum(tau,M,x0);

      % Compare them
      testCase.verifyEqual(y0bsp,y0pp,'AbsTol',tol);

    end
  end

end
