classdef cell2str_test < genlib_test
  % Tests for cell2str
  %
  % [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties (TestParameter)
    % cells to test
    C = {...
         {1,2,3},...
         num2cell(rand(3,2)),...
         {int16(1),2,'bla'},...
         {rand(3,2),1,'bla'},...
         {1,{{2,3}}},...
         {1,struct('a',1,'b',2,'c',{{2,1}})},...
        };
  end
  
  methods (Test)
    function test_cell2str(testCase,C)
      nprec = ceil(log10(1/eps))+1; % number of digits to separate numbers within machine precision
      str = cell2str(C,nprec);
      testCase.verifyEqual(eval(str),C,sprintf('Could not match this cell with %s',str));
    end
  end
  
end
