classdef bsp_test < genlib_test
  % Tests class for bsp (Bsplines)
  %
  % [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  methods (Test)
    function test_bspbase(testCase)
      %%
      n = 101;
      order = 4;
      nsp = 15;
      
      knots = linspace(0,1,nsp+order);
      X = linspace(knots(order),knots(end-order+1),n);
      y = bspbase(knots,order,X);
      %%
      testCase.verifyTrue(all(size(y)==[nsp,n]));
      testCase.verifyFalse(any(isnan(y(:))),'bspbase returned NaN')
      testCase.verifyTrue(max(sum(y,1)-1)<10*eps,'splines must sum to 1')
    end
    
    function test_bspsum(testCase)
      %%
      n = 101;
      nsp = 15;
      order = 4;
      nkts = nsp-order+1;
      knots = (1:nsp)-(order-1);
      
      y = bspsum(knots,eye(nkts,nsp),linspace(0,10,n),0,0,order);
      %%
      testCase.verifyTrue(all(size(y)==[n,nsp]),'bspsum size problem');
      testCase.verifyTrue(all(sum(y,2)==1),'bsp splines should sum to 1');
      testCase.verifyFalse(any(isnan(y(:))),'bspsum returned NaNs')
    end
  end 
end
