/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
/*
iround

returns the indices of the elements in a look-up table which are the nearest of
given values

void iround(k,T,sizeT,X,sizeX)

int	*k;	indices of the nearest elements in table T for each value of X.
double	*T;	table to lookup, must be sorted
int	sizeT;
double	*X;	values to look up, must be sorted
int	sizeX;
*/

void iround(k,T,sizeT,X,sizeX)

int	*k;
double	*T;
int	sizeT;
double	*X;
int	sizeX;

{
	register int	i = 0, j = 0;

	for (; i < sizeX; i++) {
		k[i] = sizeT - 1; /* treat values larger than T[sizeT-1] */
		for (; j < sizeT - 1; j++)
			if (X[i] - T[j] <= T[j+1] - X[i]) {
				k[i] = j;
				break;
			}
	}

}
/* CMS REPLACEMENT HISTORY, Element IROUND.C*/
/* *2     6-MAR-1995 17:21:00 MORET "do not remember why"*/
/* *1    26-JUL-1993 15:13:47 MORET ""*/
/* CMS REPLACEMENT HISTORY, Element IROUND.C*/
