/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "genlib.h"
# include <math.h>

void greenem(int *mode, int nm, bool der1, bool der2, double r1, double z1, double r2, double z2, double **y)
{
 int k; 
 double r, h, s, is, w, d, m, x, lx, K, E, v0, u0;
   
 r   = r1+r2;
 h   = z1-z2;
 w   = r1-r2;
 s   = r*r+h*h;
 d   = w*w+h*h;
 is  = 1.0/s;
 r1 *= 2.0;
 r2 *= 2.0;
 r  *= 2.0;
 m   = r1*r2*is;
 x   = d*is; /* more precise than 1-m if x is close to 0 (close pair of concentric circles) */
 lx  = log(x);
 K   = (((0.01451196212  * x + 0.03742563713) * x + 0.03590092383) * x + 0.09666344259) * x + 1.38629436112 -
      ((((0.00441787012  * x + 0.03328355346) * x + 0.06880248576) * x + 0.12498593597) * x + 0.50000000000) * lx;
 E   = (((0.01736506451  * x + 0.04757383546) * x + 0.06260601220) * x + 0.44325141463) * x + 1.00000000000 -
      ((((0.00526449639  * x + 0.04069697526) * x + 0.09200180037) * x + 0.24998368310) * x                ) * lx;
 v0  = (1.0-0.5*m)*K-E;
 u0  = sqrt(s);

 double s2, mr, m1, m3, m2, im, v1, u1, ir1;
 if (der1) {
  # define s1 r
  # define s3 r
  s2  = 2*h;
  mr  = m*r;
  m1  = (2.0*r2-mr  )*is;
  m3  = (2.0*r1-mr  )*is;
  m2  =        -m*s2 *is;
  im  = 1.0/x;
  v1  = 0.25*(E*im-K);
  u1  = 0.5/u0;
  ir1 = 2.0/r1;
 }

 double m11, m33, m22, m12, m23, m13, v2, u2;
 if (der2) {
  is *= -2.0;
  m11 = (   s1   * m1    +m    )*is;
  m33 = (   s3   * m3    +m    )*is;
  m22 = (   s2   * m2    +m    )*is;
  m12 = (    h*is*(mr-r2)      )*is;
  m23 = (    h*is*(mr-r1)      )*is;
  m13 = (0.5*r*is*(mr-r )+m-2.0)*is;
  v2  = (v1 + 0.125*K)*im; /* 0.25*(E*im - 0.5*K)*im */     
  u2  = -2.0*u1*u1*u1;
 }

 # define mu0 1.256637061435917e-6 /*4e-7*pi*/
 # define mu1                 2e-7
 # define G0(u0,v0) (u0*v0)
 # define G1(u0,u1,v0,v1,dx,kx) (u1*v0*dx+u0*v1*kx)
 # define G2(u0,u1,u2,v0,v1,v2,dx,dy,kx,ky,kxy) (2.0*u1*v0+u0*v1*kxy+u2*v0*dx*dy+u1*v1*(dx*ky+kx*dy)+u0*v2*kx*ky)
 # define GZ(u0,u1,u2,v0,v1,v2,dx,dy,kx,ky,kxy) (          u0*v1*kxy+u2*v0*dx*dy+u1*v1*(dx*ky+kx*dy)+u0*v2*kx*ky)
 for (k=0; k<nm; k++) {
  switch (mode[k]) {
   case  0      : *(y[k]) =  mu0* G0(u0,v0); break;
   case  1      : *(y[k]) =  mu0* G1(u0,u1,v0,v1,s1,m1); break;
   case  2      : *(y[k]) =  mu0* G1(u0,u1,v0,v1,s2,m2); break;
   case  3      : *(y[k]) =  mu0* G1(u0,u1,v0,v1,s3,m3); break;
   case  4      : *(y[k]) = -mu0* G1(u0,u1,v0,v1,s2,m2); break;
   case  5      : *(y[k]) = -mu1* G1(u0,u1,v0,v1,s2,m2)*ir1; break;
   case  6      : *(y[k]) =  mu1* G1(u0,u1,v0,v1,s1,m1)*ir1; break;
   case 11      : *(y[k]) =  mu0* G2(u0,u1,u2,v0,v1,v2,s1,s1,m1,m1,m11); break;
   case 12/*21*/: *(y[k]) =  mu0* GZ(u0,u1,u2,v0,v1,v2,s1,s2,m1,m2,m12); break;
   case 13/*31*/: *(y[k]) =  mu0* G2(u0,u1,u2,v0,v1,v2,s1,s3,m1,m3,m13); break;
   case 14/*41*/: *(y[k]) = -mu0* GZ(u0,u1,u2,v0,v1,v2,s1,s2,m1,m2,m12); break;
   case 22/*44*/: *(y[k]) =  mu0* G2(u0,u1,u2,v0,v1,v2,s2,s2,m2,m2,m22); break;
   case 23/*32*/: *(y[k]) =  mu0* GZ(u0,u1,u2,v0,v1,v2,s3,s2,m3,m2,m23); break;
   case 24/*42*/: *(y[k]) = -mu0* G2(u0,u1,u2,v0,v1,v2,s2,s2,m2,m2,m22); break;
   case 33      : *(y[k]) =  mu0* G2(u0,u1,u2,v0,v1,v2,s3,s3,m3,m3,m33); break;
   case 34/*43*/: *(y[k]) = -mu0* GZ(u0,u1,u2,v0,v1,v2,s3,s2,m3,m2,m23); break;
   case 51      : *(y[k]) = -mu1*(GZ(u0,u1,u2,v0,v1,v2,s1,s2,m1,m2,m12)-
                                    G1(u0,u1,v0,v1,s2,m2)*ir1            )*ir1; break;
   case 52      : *(y[k]) = -mu1*(G2(u0,u1,u2,v0,v1,v2,s2,s2,m2,m2,m22))*ir1; break;
   case 53      : *(y[k]) = -mu1*(GZ(u0,u1,u2,v0,v1,v2,s3,s2,m3,m2,m23))*ir1; break;
   case 54      : *(y[k]) =  mu1*(G2(u0,u1,u2,v0,v1,v2,s2,s2,m2,m2,m22))*ir1; break;
   case 61      : *(y[k]) =  mu1*(G2(u0,u1,u2,v0,v1,v2,s1,s1,m1,m1,m11)-
                                    G1(u0,u1,v0,v1,s1,m1)*ir1            )*ir1; break;
   case 62      : *(y[k]) =  mu1*(GZ(u0,u1,u2,v0,v1,v2,s1,s2,m1,m2,m12))*ir1; break;
   case 63      : *(y[k]) =  mu1*(G2(u0,u1,u2,v0,v1,v2,s1,s3,m1,m3,m13))*ir1; break;
   case 64      : *(y[k]) = -mu1*(GZ(u0,u1,u2,v0,v1,v2,s1,s2,m1,m2,m12))*ir1; break;
  } /* switch mode */
 } /* for k */
}
