/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
/* dgreenemmex.c */

# include <math.h>
double ellipfast();

double dgreenem(mode,r1,z1,r2,z2)
 int	mode; /* mut=0,br=1,bz=2,dbzdr1=3,dbzdz1=4;dbrdr1=5;dbrdz1=6;
		 dbzdr2=7;dbzdz2=8;dbrdr2=9;dbrdz2=10;dmdr1=11;dmdz1=12;
		 dmdr2=13;dmdz2=14 */
 double	r1,z1,r2,z2;
 
{
 register double r12,r22,h,h2,d2,u2,u,k2,K,E,v2,w2,d2u2,d2u3; 

 r12 = r1*r1; r22 = r2*r2;
 h = z1-z2; h2 = h*h;
 d2 = r2-r1; d2 = d2*d2+h2;
 u2 = r2+r1; u2 = u2*u2+h2; u=sqrt(u2);
 if (d2==0.) return -log(0.0);/* Inf */
 k2 = d2==0. ? 1. : 4.*r1*r2/u2;
 K = ellipfast(k2,1); E = ellipfast(k2,2);
 if (mode==0) return ((2.-k2)*K-2.*E)*6.28318530718e-07*u;
 E /= d2; u /= 2e-7; v2 = r22+r12+h2;
 if (mode==1) return (v2*E-K)*h/r1/u;
 w2 = r22-r12-h2;
 if (mode==2) return (w2*E+K)/u;
 d2u2 = d2*u2; d2u3 = d2u2*u;
 if (mode==3||mode==6) return ((h2*v2-d2u2)*K+(v2*d2u2-h2*(d2*d2+k2*u2*u2))*E)/d2u3/r1;
 if (mode==10) return -((h2*v2-d2u2)*K+(v2*d2u2-h2*(d2*d2+k2*u2*u2))*E)/d2u3/r1;
 if (mode==4) return (w2*K-(4.*v2*w2+3.*d2u2)*E)*h/d2u3;
 if (mode==8) return -(w2*K-(4.*v2*w2+3.*d2u2)*E)*h/d2u3;
 if (mode==5) return ((4.*v2*w2+3.*d2u2)*E-w2*K)*h/d2u3-(v2*E-K)*h/r12/u;
 if (mode==11) return 6.283185307187*r1*(w2*E+K)/u;
 if (mode==12) return -6.283185307187*r1*(v2*E-K)*h/r1/u;
 if (mode==14) return 6.283185307187*r1*(v2*E-K)*h/r1/u;
 E *= d2; u *= 2e-7;  
 if (mode==7) return -4e-7*r2/d2/d2/pow(u,3)*((-3*h2*h2+pow((r12-r22),2)-2*h2*(r12+r22))*E+h2*(h2+pow((r1-r2),2))*K);
 if (mode==9) return -2e-7*r2*h/r1/d2/d2/pow(u,3)*((h2*h2+(2*r22-6*r12)*h2-7*r12*r12+r22*r22+6*r12*r22)*E-(h2*h2+2*r2*h2*(r2-r1)-pow((r1-r2),3)*(r1+r2))*K); 
 if (mode==13) return 2*6.28318530718e-07*r2/d2/u*(d2*K-(h2-r12+r22)*E);
}
/* 23-JAN-2008 New variable added by Francesco PIRAS */
/* CMS REPLACEMENT HISTORY, Element DGREENEM.C*/
/* *1     1-MAR-1995 16:23:23 MORET ""*/
/* CMS REPLACEMENT HISTORY, Element DGREENEM.C*/
