function A = sep2mat(a,sep)

% SEP2MAT   Single separated string to string matrix
%   SEP2MAT(A) builts a matrix of strings from A in which individual string are
%   separated by '|'. An optional second argument specifies an alternate
%   separator.
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin < 2, sep = '|'; end
k = find([sep a sep] == sep); n = length(k)- 1 - isempty(a);
A = repmat(' ',n,max(diff(k))-1);
for i = 1:n
 A(i,1:k(i+1)-k(i)-1) = a(k(i):k(i+1)-2);
end
