function cs = polygc(xp,yp,cc)
% POLYGC   contours contained in polygon
% POLYGC(XP,YP,CC) returns the part of CC (output of CONTOURC) contained
% in polygon XP,YP.
%
% MODIFICATIONS
%   11-04-2016  HR  Add check that contour is longer than 2 points.
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
nc = size(cc,2);
cs = []; kc = 1;
while kc < nc
 xl = cc(1,kc+1:kc+cc(2,kc));
 yl = cc(2,kc+1:kc+cc(2,kc));
 if length(xl)>2
   [xc,yc] = polygx(xp,yp,xl,yl);
   if ~isempty(xc)
     xc = [NaN xc];
     yc = [NaN yc];
     k = find(isnan(xc));
     xc(k) = cc(1,kc);
     yc(k) = diff([k length(xc)+1]) - 1;
     cs = [cs [ xc ; yc ] ];
   end
 end
 kc = kc + cc(2,kc) + 1;

end
