function nedit(file)

% NEDIT   
%   EDIT MFILE opens the file MFILE.M in NEDIT. MFILE must be the name of an
%   m-file or a MATLABPATH relative partial pathname (see PARTIALPATH). NEDIT
%   FILE.EXT opens the specified text file.
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

f = '';
if nargin
 f = which(file,'-all');
 if isempty(f)
  f = file;
 elseif iscell(f)
  f = f{1};
 end
end

switch computer
case 'IBM_RS', cmd = 'nc';
case 'GLNXA64', cmd = 'nedit-client';
end
unix([cmd ' -noask ' f ' >/dev/null 2>&1 &']);
