/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
#include <string.h>
#include "genlib.h"

void mexFunction (int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

# define MEXNAME bytesofmex

/* out = bytesofmex(in); */

#define OUT pout[0]

#define IN  prhs[0] /* any */

 CHECK_NARGIN_EQ(1);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1];
	
 int m,n;
 
 n = mxGetNumberOfElements(IN);
 m = mxGetElementSize(IN);
 OUT = mxCreateNumericMatrix(m,n,mxUINT8_CLASS,mxREAL);
 memcpy(mxGetData(OUT),mxGetData(IN),m*n);

 ASSIGN_PLHS;
}
