function y = ifc(c,a,b)
% IFC(C,A,B) returns A if the scalar logical C is TRUE, B otherwise.
% To avoid evaluating A or B if not necessary use the form
% IF(C,@()A,@()B)
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if c
 y = a;
else
 y = b;
end
if isa(y,'function_handle')
 y = evalin('caller',['feval(' func2str(y) ')']);
end