function f = ellipfast(m,kind)

% ELLIPFAST	Fast computation of the complete elliptic integral
%   ELLIPFAST(M,KIND) computes the complete elliptic integral of the first kind
%   K(M) and second kind E(M) for 0 <= M <= 1 with an error of less than 2e-8.
%   KIND is either 1 or 2 or 'K' or 'E'. Don't confuse the modulus K with M : M
%   = K^2.
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Source: Abramowitz 17.3.34 (page 591)

if ischar(kind), kind = 13.5 - double(kind)/6; end
f = ellipfastmex(m,kind);
