function [f,gr,gz,hrr,hrz,hzz] = bsp2deval(rk,zk,c,r,z,d,npar)
% BSP2DEVAL evaluate 2D B-splines and their derivatives
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

hasd0 = any(d==0);
hasd1 = any(d>0);
hasd2 = any(d>1);

f = [];
gr = [];
gz = [];
hrr = [];
hrz = [];
hzz = [];

cr0 = bspsum(rk,c,r,0,0,npar).';
if hasd1
  cr1 = bspsum(rk,c,r,1,0,npar).';
  if hasd2
    cr2 = bspsum(rk,c,r,2,0,npar).';
    hrr = bspsum(zk,cr2,z,0,1,npar);
    hrz = bspsum(zk,cr1,z,1,1,npar);
    hzz = bspsum(zk,cr0,z,2,1,npar);
  end
  gr  = bspsum(zk,cr1,z,0,1,npar);
  gz  = bspsum(zk,cr0,z,1,1,npar);
end
if hasd0
  f = bspsum(zk,cr0,z,0,1,npar);
end
end
