%FSGIMEX  Flux surface geometrical integrals
% [Q0,Q1,Q2,Q3,Q4,IQ] =
% FSGI(A1,A2,R,IR,RA,FA,FB,D2FA,LX,RX,IT,IDTH) computes
%
% Geometrical integrals -------- S() th integral ----------- axis ---- X            
% Q0 <1/R>                         S(A1)/S(A1*R)             1/RA   1/RX
% Q1 -dpsi/dV                   2/pi*FAB/S(A1*R)   1/4/pi^2*BA/RA      0
% Q2 <1/R^2>                     S(A1/R)/S(A1*R)           1/RA^2 1/RX^2
% Q3 <(grad psi)^2/R^2> 16*FAB^2*S(A2/R)/S(A1*R)                0      0
% Q4 <(grad psi)^2>     16*FAB^2*S(A2*R)/S(A1*R)                0      0
% IQ 1/q                        4*FAB*IT/S(A1/R) 1/2/pi*ITA*BA*RA      0
%
% A1=da^2/drh/rh, A2=((da^2/dth/2)^2/a^2+a^2)/(da^2/drh/rh) with a(rh,th)
% the distance from the magnetic axis to the flux surface with normalised
% coordinate rh~=0 at poloidal angle th. R=RA-a*cos(th), IR=1/R. RA,FA
% position and flux of magnetic axis. FB flux on LCFS.
% D2FA=sign(Ip)*sqrt(d2FA/dr2*d2FA/dz2-d2FA/drdz.^2). LX true if X point.
% RX position of X point. IT=1/T(rh) with T(rh)=rBt (vaccum+plasma). IDTH
% inverse of th grid spacing.
%
% For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [Q0Q,Q1Q,Q2Q,Q3Q,Q4Q,iqQ] = fsgimex(a1q,a2q,rq,irq,rA,FA,FB,BA,lX,rX,iTQ,idoq)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 [Q0Q,Q1Q,Q2Q,Q3Q,Q4Q,iqQ] = fsgimexm(a1q,a2q,rq,irq,rA,FA,FB,BA,lX,rX,iTQ,idoq);
 
end