function LX = fgsxana(t,L)
% FGSXANA - Data loading for FGS anamak
% LX = fgsxana(t,L)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

PP = [fieldnames(L.P),struct2cell(L.P)]'; % pass L parameters as fbt inputs
[Lfbt,~,LXfbt] = fbt('ana',L.P.shot,t,PP{:},'iterq',0); % equilibria from FBT
assert(~isempty(LXfbt) && all(LXfbt.isconverged),'FBT did not converge')
% Convert to target L structure format
LX = meqxconvert(Lfbt,LXfbt,L);
end
