function P = fgspana(shot,varargin)
% defines FGS parameters and append user parameters
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
P = meqpana(shot);
for k = 1:2:length(varargin), P.(varargin{k}) = varargin{k+1}; end

%% defaults
D.insrc = 'fgs';
D.selu = 'v'; % vessel filament description by default

% substitute defaults where necessary
for k = fieldnames(D)'
  if ~isfield(P,k{1}), P.(k{1}) = D.(k{1}); end
end

P.shot = shot;

end
