function [LX] = fgeinit(L,LX)
% function [LX] = fgeinit(L,LX)
% Compute statonary-state initial condition for FGE, and LX.Va 
% (possibly time-varying, when solving CDE) to sustain the initial 
% equilibrium.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%% Find Ia, Iv, Va consistent with initial equilibrium.
LX = meqinit(L,LX);

%% Compute FGS solution to have a converged starting equilibrium
if L.P.debug, fprintf('\nCompute FGE initial condition using FGS\n'); end
Ls = L; Ls.P.cde = []; % no CDE for initial condition
Ls = fgsc(Ls.P,Ls.G);  % re-consolidate for FGS;
LY = fgst(Ls,LX,...
  'kmax',200,'debug',L.P.debug);
if ~LY.isconverged
  error('fgs did not converge for linearization')
end
LY0 = meqxconvert(Ls,LY,L); % convert to FGE format
LX = meqsk(LX,1,LY0); % insert in first time slice
end