function G = fgegtcv(shot, P, xargs)
%FGEGTCV  TCV Forward-LIUQE time evolution geometry and electromagnetic parameters
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin<3, xargs = {};end

switch P.selu
  case {'v','e'}
    xargs = [{'Maa','Ra','Mau','Muu','Mxu'},xargs];
   case {'s','n'}
    error('FGE:INVALIDVESSELMODE','selu=''%s'' not supported for fge',P.selu)
  otherwise
    error('unrecognised vessel option');
end

P.shot = shot;
sels = []; sell = []; self = []; selm = [];
selc = P.izgrid;
G = meqgtcv(P,P.sela,sels,sell,self,selm,P.selx,P.selu,selc,xargs{:});

%% Power supply delays (to discuss a better place to put these)
G.Vadelay = zeros(numel(G.dima),1);
G.Vadelay(startsWith(G.dima,{'E','F','OH'})) = 0.5e-3;
G.Vadelay(startsWith(G.dima,{'G'})) = 0.5e-4;
end
