function G = fgeg(G,P,varargin)
%% G = fgeg(G,P) 
% fge geometry and electromagnetic parameters defines missing fields in the
% structure G using parameters
% See also fgeg, fgsg, meqg
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

xargs = [varargin,{'Maa','Mau','Muu','Ra'}]; % add extra quantities to retrieve

G = meqg(G,P,xargs{:});

if ~isfield(G,'Vadelay')
  G.Vadelay = zeros(G.na,1); % Default Voltage power supply delays
end
end
