function varargout=fbtplot(L,LX,LY)
% fbtplot(L,LX,LY)
%
% Plotting for FBT
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
if L.P.izgrid
  hax = meqplotfancy(L,LY,'fillPlasma',false);
else
  hax = meqplott(L,LY); 
end
hold(hax,'on');
% plot one contour on FBT flux offset value from optimizer
contour(hax,L.rx,L.zx,LY.Fx,LY.Fb*[1 1],'b--','linewidth',2)
fbtxplot(L,LX,'parent',hax);

if nargout>0
  varargout{1}=hax;
end
end