% FBTHELP - Help for FBT
%
% FBT solves the inverse static problem:
% * Given: 
%   * Cost function weights and constraints on flux, field, currents
%   * Internal plasma constraints (e.g. bp, Ip, qA)
%   * Inequality constraints on (combinations of) Ia.
% * Finds: 
%   * Ia and corresponding Equilibrium minimizing cost function while
%     satisfying constraints
%
% Setup of the constrained optimization problem: 
% The fitting parameters on the left hand side are Ia and Fb (coil currents
% and an offset flux).
%
% On the right side are the user-prescribed values and the plasma contribution Iy
% The latter is iterated as it depends on Ia
%
% equals(=) sign means equality constraint if weight=0 (1/weight is infinity)
% Otherwise the equation is solved with the others in the least-squares
% sense
%
% 1./(gpid*gpie) * [ Ia                    = gpia                          ]  % Currents
% 1./(gpdd*gpde) * [ Dda*(gpdw.*Ia)        = 0                             ]  % Dipoles
% 1./(gpfd*gpfe) * [ MSa*Ia   - gpfb*Fb    = gpfa  - MSy*Iy                ]  % Flux
% 1./(gpbd*gpbe) * [ BrSa*Ia               = gpbr  - BrSa*Iy               ]  % Br
% 1./(gpbd*gpbe) * [ BzSa*Ia               = gpbz  - BzSa*Iy               ]  % Bz
% 1./(gpbd*gpbe) * [ Gba*[BSra;BSza]*Ia    = 0     - Gba*[BSry;BSzy]*Iy    ]  % Field angle
% 1./(gpcd*gpce) * [ MrrSa*Ia              = gpcr  - MrrSy*Iy              ]  % Frr constraint 
% 1./(gpcd*gpce) * [ MrzSa*Ia              = gpcz  - MrzSy*Iy              ]  % Frz constraint 
% 1./(gpcd*gpca) * [ Gca*[MrrSa;MrzSa]*Ia  = 0     - Gca*[MrrSy;MrzSy]*Iy  ]  % Hessian angle
% 1./(gpvd*gpve) * [ BrrSa*Ia              = gpvrr                         ]  % Vacuum Brr constraint 
% 1./(gpcd*gpve) * [ BrzSa*Ia              = gpvrz                         ]  % Vacuum Brz constraint 
% 1./(gpcd*gpve) * [ BzzSa*Ia              = gpvzz                         ]  % Vacuum Bzz constraint 
%
% Dda Matrix such that Dda*Ia gives current differences e.g. [Ia(2)-Ia(1);...;Ia(na)-Ia(na-1)];
% Gba = [sin(gpba),-cos(gpba)];
% Gca = [sin(gpca),-cos(gpca)];
%
% Dda is contained in G, while all other matrices are calculated in each time loop by fbtt.m
%
% If one of the Br/Bz or Mrr,Mrz components are constrained, then 
% the corresponding angle constraint is automatically ignored.
%
% Control point constraints gpf* gpb* gpc* gpv* can be supplied using FBTGP()
% See FBTGP for details on the syntax
%
% NOTE: Fb and FB (boundary flux) are not necessarily the same, unless the
% solution has LCFS passing through a point with gpfb=1 and gpfa=0 and gpfe*gpfd=0.
%
% Inequality constraints:
% liml*limm < limc*Ia < limu*limm
% limm is a margin, limu,liml are upper/lower bounds, limc is a matrix.
% All are contained in P
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
