%FBTE  TCV FBTE equilibrium calculation
% [L,LX,LY] = FBTE(SHOT,'PAR',VAL,...) calls FBT('TCV',SHOT,...) and writes
% results in PCS tree. See also FBT.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function varargout = fbte(shot,varargin)
 
 [varargout{1:nargout}] = fbt('TCV',shot,[],'LYall',true,varargin{:});
 if nargout > 2 && (shot == -1 || shot >= 100000)
  L  = varargout{1};
  LY = varargout{3};
  it_psi = 1:numel(LY.t);
  psiwtcv(shot,'PCS','\TOP.MGAMS.EQUIL',L,LY,it_psi)
  meqwtcv(shot,'PCS','\TOP.MGAMS.EQUIL',L,LY,it_psi)
  fbtwtcv(shot,'PCS','\TOP'            ,L,LY) % old style nodes
  % codwtcv(shot,'PCS',,'FBTE.M','Standard FBTE.M run') % No nodes yet for this
 end
 
end
