%FBTC  FBTE ancillary data
% L = FBTC(P,G) returns a structure with FBTE ancillary data. P contains
% the configuration parameters as obtained by FBTP<TOK>. G contains the
% geometry as obtained by FBTG<TOK>. See also FBTP,FBTG.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function L = fbtc(P,G,varargin)
 L = meqc(P,G,'rrx','zzx');
 L.code = 'fbt';
 
 % scaling of boundary flux in optimization problem.
 L.ffb = max(abs(L.G.Mxa(:)));
 
 % Checks
 assert(size(P.limc,2)==G.na,'limc size does not match G.na')

end
