function [A,B,C] = dlstc(drx,dzx,rry)
% DLSTC returns auxiliary parameters for DLST
% [A,B,C] = DLSTC(DRX,DZX,RRY)
% DRX, DZX: R,Z, grid spacing
% RRY: meshgrid of inner R grid
%
% A,B,C: matrices used to evaluate Delta* Grad-Shafranov operator
% by finite differences.
%
% See also DLST
%
% For details, see: [J-M.Moret et al. Fus.Eng.Des 2015] Section 4.2
%              and ﻿[F. Hofmann, Comput. Phys. Commun. 48(2) 1988].
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

A = (dzx/drx)^2*rry./(rry + drx/2);
B = (dzx/drx)^2*rry./(rry - drx/2);
C = 2 + A + B;
end