function D = dlst(F,A,B,C)
%DLST  Evaluate Delta-Star operator of Grad-Shafranov equation
% D = dlst(F,A,B,C) evaluates the Delta* operator of the 
% Grad-Shafranov equation: Delta*(F(z,r))
% F is the flux [Wb].
% A,B,C are pre-computed factors obtained from DLSTC.M
% See also DLSTC.M
%
% For details, see: [J-M.Moret et al. Fus.Eng.Des 2015] Section 4.2
%              and ﻿[F. Hofmann, Comput. Phys. Commun. 48(2) 1988].
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

Fyij   = F(2:end-1,2:end-1);   Fyij1 = F(2:end-1,3:end);
Fyijm1 = F(2:end-1,1:end-2);   Fyi1j = F(3:end,2:end-1);
Fyim1j = F(1:end-2,2:end-1);
D = Fyi1j + Fyim1j + A.*Fyij1  +B.*Fyijm1 - C.*Fyij;

end
