function bool = contains(str,pattern)
% CONTAINS True if pattern is found in text
%
% This is a minimal implementation of the MATLAB built-in function
% for use in `meq` using Octave
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  if ~iscell(str), str = {str}; end
  if ~iscell(pattern), pattern = {pattern}; end

  bool = false(size(str));
  for ii = 1:numel(pattern)
    bool = bool | ~cellfun(@isempty,strfind(str,pattern{ii},'ForceCellOutput',true));
  end
end
