function P = liupwest_IDS(varargin)
%LIUPTCV  TCV LIUQE configuration parameters
% P = LIUPTCV(SHOT,'PAR',VAL,...) returns a structure P with configuration
% parameters from the RESULTS tree for SHOT, optionally replacing or adding
% parameters with specified values. See also LIUP.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

P = struct();
P.stabz = 1;
P.shot = 1;
P.reffl = 0;
P.tokamak = 'west';
P.bfct = @bfabmex;
P.bfp = [1 2];
P.Bmerr= 0.001;
P.Iaerr= 1e2;
P.Iuerr= 1e2;
P.chimax= 2;
P.elomin= 1.1000;
P.Fferr= 0.01;
P.debug= 0;
P.idens= 0;
P.idml= 1;
P.fdz= 1e-5;
P.ifara= 0;
P.iinv= 0;
P.ipolarimetry= 0;
P.ipres= 0;
P.isaddl= 1;
P.itera= 100;
P.itert = 0;
P.iters= 48;
P.nelem= 8;
P.nolim= 0;
P.Iperr= 500000;
P.Ipmin= 15000;
P.psichco= 5.0000e-05;
P.ri = 2.3;
P.rip= 2.3;
P.rop= 2.8;
P.ro = 2.8;
P.zu = 0.35;
P.zlp= -0.35;
P.zup= 0.35;
P.stab= -1.2566;
P.stabint= 0.1000;
P.Ipmeas= 0;
P.wIp= 1;
P.r0 = 2.4;
P.nv = 256; % # vessel filaments
P.n_discr_coils = 1;
P.Fterr      = 0.001;
P.wIa= ones(17,1); % [Ia, Is]
P.wBm= ones(130,1); %bm
P.wFf= ones(17,1); % flux loopli
P.wFf([2,5,7,8,9,10,11,12,13,14,15,16,17]) = 0;
P.pq = (1:40)/40;


% when the connection matrix will be available this will be taken into account
P.active_pfcircuits_considered = { '1'};



if ~isempty(varargin)
% overwrites/adds parameters
for k = 1:2:length(varargin), P.(varargin{k}) = varargin{k+1}; end
end
% TCV specific checks
msge = 'LIUQE=TCVparameterNotSupported=%s %g';
assert(P.idens   ==   0,msge,'IDENS ~= 0'  )
assert(P.ifara   ==   0,msge,'IFARA ~= 0'  )
assert(P.ipres   ==   0,msge,'IPRES ~= 0'  )
assert(P.Ipmeas  ==   0,msge,'IPMEAS ~= 0' )
assert(P.iinv    ==   0,msge,'IINV ~= 0'   )
assert(P.itera   ~= 300,msge,'ITERA = 300' )
assert(P.itera   ~= 888,msge,'ITERA = 888' )
assert(P.itera   >    0,msge,'ITERA < 1'   )
assert(P.nolim   ==   0,msge,'NOLIM ~= 0'  )
