function P = liuptcv_IDS(varargin)
%LIUPTCV  TCV LIUQE configuration parameters
% P = LIUPTCV(SHOT,'PAR',VAL,...) returns a structure P with configuration
% parameters from the RESULTS tree for SHOT, optionally replacing or adding
% parameters with specified values. See also LIUP.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

P = struct();
P.stabz = 1;
P.shot = 1;
P.reffl = 0;
P.tokamak = 'tcv';
P.bfct = @bfabmex;
P.bfp = [1 2];
P.Bmerr= 0.0100;
P.Iaerr= 200.;
P.Iuerr= 200.;
P.chimax= 2;
P.elomin= 1.1000;
P.Fferr= 0.0075;
P.debug= 0;
P.idens= 0;
P.idml= 1;
P.fdz= 1e-5;
P.ifara= 0;
P.iinv= 0;
P.ipolarimetry= 0;
P.ipres= 0;
P.isaddl= 1;
P.itera= 100;
P.itert = 0;
P.iters= 48;
P.nelem= 8;
P.nolim= 0;
P.npsi= 50;
P.Iperr= 24000;
P.Ipmin= 15000;
P.psichco= 5.0000e-05;
P.ri= 0.6140;
P.rip= 0.6191;
P.ro= 1.1470;
P.rop= 1.1210;
P.stab= -1.2566;
P.stabint= 0.1000;
P.Ipmeas= 0;
P.wIp= 1;
P.wIa= ones(20,1);
P.wIu= ones(50,1);
P.wBm= ones(40,1);
P.wBm(22) = 0;
P.wFf= ones(40,1);
P.wFf([10 11 12]) = 0;
P.zlp= -0.7664;
P.zu= 0.7600;
P.zup= 0.82214;
P.r0 = 0.89;
P.nv = 256; % # vessel filaments
P.n_discr_coils = 1;
P.Fterr      = 0.00013;

% when the connection matrix will be available this will be taken into account
P.active_pfcircuits_considered = { 'OH1', 'OH2',...
    'E1' ,'E2','E3','E4','E5','E6','E7','E8', ...
    'F1' ,'F2','F3','F4','F5','F6','F7','F8', ...
    'FPS'};


if ~isempty(varargin)
% overwrites/adds parameters
for k = 1:2:length(varargin), P.(varargin{k}) = varargin{k+1}; end
end
% TCV specific checks
msge = 'LIUQE=TCVparameterNotSupported=%s %g';
assert(P.idens   ==   0,msge,'IDENS ~= 0'  )
assert(P.ifara   ==   0,msge,'IFARA ~= 0'  )
assert(P.ipres   ==   0,msge,'IPRES ~= 0'  )
assert(P.Ipmeas  ==   0,msge,'IPMEAS ~= 0' )
assert(P.iinv    ==   0,msge,'IINV ~= 0'   )
assert(P.itera   ~= 300,msge,'ITERA = 300' )
assert(P.itera   ~= 888,msge,'ITERA = 888' )
assert(P.itera   >    0,msge,'ITERA < 1'   )
assert(P.nolim   ==   0,msge,'NOLIM ~= 0'  )
