function P = liup_IDS(IDS_inputs,varargin)
% The function will get parameters from IDS and store them into P
% Checks are perfomed to decide the behavior of the code depending on the
% available inputs
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% TODO reading the parameters from the IDS structure
P = IDS_inputs.parameters;
%% Reading the measurement errors
% P.Bmerr = IDS_inputs.magdiag(1).bpol_probes.measure.abserror(1); % For now I'm using the same error for each coils
% % TODO P.Iaerr = pf_system(1)...
% P.Fferr = IDS_inputs.magdiag(1).flux_loops.measure.abserror(1);
% P.Iperr = IDS_inputs.magdiag(1).ip.abserror;
% P.Fterr = IDS_inputs.magdiag(1).diamagflux.abserror;

%% Check availables wall type. Check available data. Preference is given to Block description if available.

if IDS_inputs.wall.description_2d{1}.type.index == -999999999
  P.wall_type = 'none';
else

n_units = numel(IDS_inputs.wall.description_2d{1}.vessel.unit); % Number of units
n_elements = numel(IDS_inputs.wall.description_2d{1}.vessel.unit{1}.element) % Element is block description

% Check if blocks description is complete 
ok_elements = 1;
for ii = 1:n_units
for jj = 1:n_elements
  ok_elements = ok_elements*(~isempty(IDS_inputs.wall.description_2d{1}.vessel.unit{ii}.element{jj}.j_tor.data ) ) ;
  ok_elements = ok_elements*(~isempty(IDS_inputs.wall.description_2d{1}.vessel.unit{1}.element{1}.outline.r ) ) ;
  ok_elements = ok_elements*(~isempty(IDS_inputs.wall.description_2d{1}.vessel.unit{1}.element{1}.outline.z ) ) ;
end
end

% Check if anular description is complete
ok_annular = 1; 
for ii = 1:n_units
  ok_annular = ok_annular*( ~isempty( IDS_inputs.wall.description_2d{1}.vessel.unit{ii}.annular.outline_inner.r  ) );
  ok_annular = ok_annular*( ~isempty( IDS_inputs.wall.description_2d{1}.vessel.unit{ii}.annular.outline_inner.z ) );
  ok_annular = ok_annular*( ~isempty( IDS_inputs.wall.description_2d{1}.vessel.unit{ii}.annular.outline_outer.r   ) );
  ok_annular = ok_annular*( ~isempty( IDS_inputs.wall.description_2d{1}.vessel.unit{ii}.annular.outline_outer.z ) );
  ok_annular = ok_annular*( ~isempty( IDS_inputs.wall.description_2d{1}.vessel.unit{ii}.annular.resistivity ) );
end

% Priority is given to blocks description if available
if ok_elements ==1 
  P.wall_type = 'block';
elseif ok_annular ==1
  P.wall_type = 'annular';
else
    error('Consistent wall description not found')  
end


end



%% overwrite/add parameters
if ~isempty(varargin)
for k = 1:2:length(varargin), P.(varargin{k}) = varargin{k+1}; end
end



end
