function t = fft(x)

% TDI/FFT   FFT of a TDI object

n = length(x.data);
t = x;
t.data = fft(t.data);
ns = ceil(n/2);
t.data = 2/n*t.data(1:ns+1);
t.dim{1} = (0:ns)' / ((x.dim{1}(2) - x.dim{1}(1)) * n);
t.dimunits{1} = 'Hz';
