if ~exist('T2pair','var') 
    disp('ERROR: T2pair must be specified')
    return
end

if length(T2pair)~=2
    disp('ERROR: T2pair must contain 2 values')
    return
end


if ~exist('tColours','var')
    tColours = {[66 122 223]/255,[108 158 80]/255,[223 76 76]/255};
end

figure
% set(gcf,'Position',[    50   679   740   409])
set(gcf,'Position',[ 75   306   445   770])

TE_vals = linspace(0,200,1000);
sig = zeros(length(TE_vals),2);
for iT2 = 1:2
    sig(:,iT2) = (exp(-TE_vals/T2pair(iT2)));
end
plot(TE_vals,sig(:,1),'linewidth',2,'color',tColours{1}); hold all
plot(TE_vals,sig(:,2),'linewidth',2,'color',tColours{2}); 
h1 = plot(TE_vals,abs(sig(:,1)-sig(:,2)));
set(h1,'linewidth',2,'color','k')
xlabel('TE (ms)')
ylabel('Relative signal')
grid on
legend(['T2 = ' num2str(T2pair(1)) 'ms'], ['T2 = ' num2str(T2pair(2)) 'ms'], 'Contrast');
fontScale(1.4)