(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1429358,      23820]
NotebookOptionsPosition[   1425847,      23752]
NotebookOutlinePosition[   1426256,      23769]
CellTagsIndexPosition[   1426213,      23766]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solid Physics III (Exercise 2)
Chern number\
\>", "Subchapter",
 CellChangeTimes->{{3.721366592639078*^9, 3.721366656521244*^9}, {
  3.906545505767065*^9, 
  3.906545522907928*^9}},ExpressionUUID->"122b5ecd-05b1-4600-ac93-\
787b31ac41b8"],

Cell[CellGroupData[{

Cell["Winding number in 1 d", "Section",
 CellChangeTimes->{{3.721366698842381*^9, 
  3.721366703661192*^9}},ExpressionUUID->"127e683e-fca7-4c48-b2d0-\
6cab8212cfd8"],

Cell[CellGroupData[{

Cell["Energy bands", "Subsection",
 CellChangeTimes->{{3.7213707856971703`*^9, 
  3.72137079353743*^9}},ExpressionUUID->"3750bade-de4a-4fe8-982e-\
a86d5ba3aea9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Eigenvalues", "[", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "t"}], " ", 
            RowBox[{"Cos", "[", "k", "]"}]}], "+", "\[Mu]"}], ",", " ", 
          RowBox[{"I", " ", "t", " ", 
           RowBox[{"Sin", "[", "k", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "I"}], " ", "t", " ", 
           RowBox[{"Sin", "[", "k", "]"}]}], ",", " ", 
          RowBox[{
           RowBox[{"t", " ", 
            RowBox[{"Cos", "[", "k", "]"}]}], "-", "\[Mu]"}]}], "}"}]}], 
       "}"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", " ", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<k\>\"", ",", "\"\<\[Epsilon](k)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<\[Mu]/t=\>\"", "<>", 
       RowBox[{"ToString", "[", "\[Mu]", "]"}]}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"\[Mu]", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", ".9", ",", "1", ",", "1.1", ",", 
       "20"}], "}"}]}], "}"}]}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQA2IQ/X3BdVOlna8dpx4TCgTRK9QUw0F0orpTIojmTGTI
ANF7ll3LBdH73iiUgtVJadaD6F2T3FpB9IU/Ee0g2r4nZSqIfua5dBqIVvhZ
NhtE97RIzgXRfJyibMpAmuVGLweInrF8rTGILhbytgDREzatcwbRX66EuoDo
LGO9UBB99qYpmP7/OlJfBUinrGsF01p9V8xA9KK718H0O87LViD67v3rdiA6
88n+uR+B9N7882C6wbx6CYhWNUhZCaIbDY+sBdFcjKo3QPSEKOP7IPpWvs5T
EK014cMLEL1v345vIJo5W/4PWF3M3v8gepquTMQnIO3KfzYSRDtJiv9x/AaU
33voL4gGAIBhvQU=
  "],
 CellLabel->"In[16]:=",ExpressionUUID->"940f6eca-c2de-4f46-8071-db066e21db60"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJw12Hk4Vd/XAHDTvefcyEyRITIUkqESyjkpiSIhqWQqKs0ZylRpkBDKHEKE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         "]], 
        LineBox[CompressedData["
1:eJw12Hk0Vd/bAHDTvedcZKYIRaKQDJVQ9k5JFAlJJVNRaZAMZaqkJIQyRAgR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         "]]},
       Annotation[#, "Charting`Private`Tag$265907#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=-2\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-2.9999999220487803`, 
       2.9999999220487803`}}, {{-3.141592653589793, 
      3.141592653589793}, {-2.9999999220487803`, 2.9999999220487803`}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJw12Hc8le/7AHDbIVRoCe1hJORjlvvoUykUSVIpo8iHChmZSUPJyEonoZAt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         "]], LineBox[CompressedData["
1:eJw12Hc8le/7AHBkHEKFllDaRlY+ZrmOPkpFkSSVrCIfKmQkI2mQjKx0Egpl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         "]]},
       Annotation[#, "Charting`Private`Tag$265952#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=-1\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-1.9999999415365852`, 
       1.9999999415365852`}}, {{-3.141592653589793, 
      3.141592653589793}, {-1.9999999415365852`, 1.9999999415365852`}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7eXJ5/xbkfMAAxh82J9+/PaHDYs54PwW15Xz0lQR
/MIrv4QmC7PD+adipV48EWY78B8M3u//u2/VBitJVrj8400fJwZyssDlzRay
XenlZobL2yhd0uv+wQjny1Tz1fa8YoDzL8wxjEi7+38/TP/5jM3PTXf/3Q+T
X6Z50SJg728432DWhYKikz/3/4OqVzSwvSW2+jtc/6tdrqxsG7/C1Utn704s
7/kMl/93Smjph8KPcPlie56QzO/v4PwdxmcPfN36Cs5fL3hsg/jeZwj1VjOZ
7fIfwc2zao33eJF1By7/PuNPf33HFTi/+chsK/sfx+H8a7ttjqxi3gDXH6/j
9jdk4jp7GP+hR0Ro3rwTcP6X9fbrJayvwPm3lsrlfbxwxx5mXnXebo/Q+Y/g
8hEL9MPn9D6Dy6e1n2S6f+EVnH+4RVu75/Q7OD9O8OkhkciPcP5nq+N2D8s+
w/nr83l/JhV8hfNZ6p81Jk35Duc3zlT2FJ/yE26/N0u95pHO33D5dZ65N96t
/AvnW8zaf/Tc0v8I+aRLDmLPGBzg7lUI0Xb8wgjnb3rMvtXtAxOc7yXCqtbN
yALnl3mZmK1iYIXzT674FHT0F4KfUfIrTJ6L3QHmvtmuJr+C2Tng8kXuC+ct
n4LgQ/MLnA8AQat9hg==
         "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7eXJ5/xbkfMAAxh8sE8/fvvDhsUccH6L68p5aaoI
fuGVX0KThdnh/FOxUi+eCLMd+A8G7+3/7lu1wUqSFS7/eNPHiYGcLHB5s4Vs
V3q5meHyNkqX9Lp/MML5MtV8tT2vGOD8C3MMI9Lu/t8P038+Y/Nz091/98Pk
l2letAjY+xvON5h1oaDo5M/9/6DqFQ1sb4mt/g7X/2qXKyvbxq9w9dLZuxPL
ez7D5f+dElr6ofAjXL7Ynick8/s7OH+H8dkDX7e+gvPXCx7bIL73GUK91Uxm
u/xHcPOsWuM9XmTdgcu/z/jTX99xBc5vPjLbyv7HcTj/2m6bI6uYN8D1x+u4
/Q2ZuM4exn/oERGaN+8EnP9lvf16CesrcP6tpXJ5Hy/csYeZV5232yN0/iO4
fMQC/fA5vc/g8mntJ5nuX3gF5x9u0dbuOf0Ozo8TfHpIJPIjnP/Z6rjdw7LP
cP76fN6fSQVf4XyW+meNSVO+w/mNM5U9xaf8hNvvzVKveaTzN1x+nWfujXcr
/8L5FrP2Hz239D9CPumSg9gzBge4exVCtB2/MML5mx6zb3X7wATne4mwqnUz
ssD5ZV4mZqsYWOH8kys+BR39heBnlPwKk+did4C5b7arya9gdg64fJH7wnnL
pyD40PwC5wMAtTVjhg==
         "]]},
       Annotation[#, "Charting`Private`Tag$265997#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=0\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-1., 1.}}, {{-3.141592653589793, 
      3.141592653589793}, {-1., 1.}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJw12Hk0F+37B3B8tvkgIfGkaC8hWVO2uVukXdmSshZREkJlecieXVQUKWRr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         "]], LineBox[CompressedData["
1:eJw12Hk0Fv37B3Dc29xISDwp2ktI1pTt+rRIu7IlZS2iJITK8pA9u6goUsjW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         "]]},
       Annotation[#, "Charting`Private`Tag$266042#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=0.9\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-1.8999999999999961`, 
       1.8999999999999961`}}, {{-3.141592653589793, 
      3.141592653589793}, {-1.8999999999999961`, 1.8999999999999961`}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJw12Hc81V/8B3Djjs+l4iLSoDIaJEUpyj1RVilpkMqoRFNJKrQUSvYoyiZR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         "]], 
        LineBox[CompressedData["
1:eJw12Gk8VV+4B3DDGfZBcRANohIlkqKE8qxUplJoUCpDJRqVUKFJoSRzRRkj
Q5kqodBeiUgTJWlGGTLPs7Pv+t/PvefN7/N9s4e11tnredbcva7WTiJCQkIz
hIWE/ktzs6lrx+fycCfzvz8weOLTQyny8JOrJZz/rDG3PVZuJg8bL501a4J4
9vWdG+bL8bDcfLHVw8RTR8tHlkrzMJMZcqSHmNm/IgWm8vAMvYz0FuKequQt
FmI83GjhMPCDuH6VjPAuDg/PicjYWEVcnXYxy0WE3P9d2KMXxCWyPbs8BRQu
bJBSfUj86IId7/IYhc2qFqXGESd1vM0LG6Jw5tP65YHEkTsM9sf3UXjDD+2P
J4n9StP5mV0Uro9U8dlF7Kk1nX7WRmEPu3ztNcQ7qMEZtY0UPpr24g15QTBz
31f+5xeFffNWZzQLGNCvr3bv/UZhQY/D7VJihYKsDxKfKDxj6714L+Ip82ef
nfmBwuMTlXnWxIKQa4sWvqFw5ceE7wuJ651d/Na+pPDyLc6bPkyS9/tUu8yK
pnDs8T0x8cQlsL7erpDCYQlTR44SJ8vPM/B6TGHVw1l1LGLn8u89OUkUNnkE
QAYcdmibxz2Pp3D/zYPj38cZMI0v2PD2DoU9qUNlt4kXnbqR0hJB4ekhAl9p
4i7VzbsVL1PYJb8juW2Ugd/hxTyNCxTeVIiq7hBXCdTz9XworGwbzNtA/KiW
kt7mTmHbJYtSkkbIePmXlF/bT2Fj08EAMsHg3KflEe1A4cf2Kcq/h8jz2MXP
S91N4V2Pvd+dI9Zf4XO2ZCuFI+LvbygYZGCyabn26DoKW84u65MZYODy+vS4
AyoUlo/O6D3awwC+5mWpNJfCw2633zV1MzBRvUGkToHMn02Twy7ik3ZdTmay
FOYLP8uELgb2ntJerCFKYTnzcw0d7QxAenFhbz0XL7Mdfva1mQGv7uCj939w
cfO0J/zFxHnLHZT21XGx38eLc841MaBZInKp5gMXK/t6HZjxl8zndxPz/Odc
vNzY6oZOAwNjEh/rfGK4WCzHMXDyGwMrtiQFLo/i4iu9Ji4axG7R7qu6Irj4
Sft0ZsdXBv6pyCfYX+NiTka+zYMvDNQZ7nY28uJit9boPJ0acv/jzYPcHVzc
coSj9+0tAydqxqQjZLi46v2j18eLGLhpvdk2UpKLg11D7h0sZKCoKinxhjgX
R30f9Xd4xgDn3UatKFEu9rF+ZmtawEBMWZxFbD8Hr7PAJkK5DFTkGV1J/cTB
/UETxvwHDChGB04WRnDwXZHgnQW3GFgn/3tdcQgHN1pe57ndZODgDe2g59c4
2PyQywu1Gwzkhv2Y+eISBweNi5pFhJP1H6i58tVJDk7ZO+3ZpusMuHt/dKva
wsFtSZornH0ZqNwzs/WvDAfnDcsuVTrMwOb4VTAmycG+M7IyEw8yUFNvd1NS
goNnK7iYznNh4Oe+pHX6LA6uK7tdN9uJ/P8PaiSGDLDxXTG/AwI7BuQ9DW31
P7Ox2piihZM1A/uD974NucnGWdK/eip1yfh+uKx8L5yNL/xb58BfwcAxfqrX
s2A2Do3707NNh4FTke0Lm/zZ+AhP2/OrFgOBt9399E+xMe6lZCvVGMhJ8Tds
smFj03DnXKtZZD0+v5+jP4ONDyf6bhyfEMDbb0skxmXZeK1WcsD3MQHEDOU6
F0qx8dSy0IinIwJYpUkrrqLYeK6yk6LrgAC8Yj8FrR5mYV8jfRZuF8CQ94QL
+szCw5Uy2qNfBdCzctNc4zAWfnTmol5lrgD+POoNs+KxcJD0E7OefeT6nDFf
WzYLu5xSiT7pKIDttiLu+4RZ+J9tn9ignQAqhGW2e4yK4jlRhtv7dgogy1Jn
ZvQ/UTyi0RdSu1kAp7s879a/FsWH/2Q/Wm8gAIlFE49cA0VxYkPNR1pKACsS
OTXXxUWx36+ico28SVg176PmtRFhnLKkSLa7bgIUvKeeDWoTwo+YL8yO3+NQ
FbN0x4GfDL2CY8OO+DYGH1wetywvnKRPT3HYd+buKKSoVa+0LB6nJee3rny5
fwS0blcdd3s9Sp/aVNhcNW0Y5mqt/ib3YJjes+3ui+CwQWh7tp7NeThIv7xZ
VnyEPwCzDhc6ngrqp5Xtpyv32/aBoFL6Xs+JXnrB2VwFwa0eOAkSWw8Od9Gd
XZekHpV1QoH2Ozz4pI0+HWBmqN77D7L5r3Lki5vpOwGZS5zWNsNJ/WhRQ9dG
+qta1/E1mo2g72dv2nroB40OX0o1X/IDul0mQs5fqaFFtErjxk/UwKXSO/ow
Uk5rpmn0mXaXQ+t7vQingnLa/Uu/Sl52OWz6+qX92ulyeqORX/3c4+Uws0sm
tm7kFV3TUTc60PMKcuSDmBOjZfR4IFcjsK8Mfh7yKU0ee0n3729juQ++hGPz
nsXIjtF0e+v1CyUDNOjpDlk4etG0/p79vRYeNLA2LmMyx57TbGd09Mvgc7jj
cd/RZLyYjqzF9/4OFUNFxW1Vr4lC2k2oe7h1pBDmuXrn/Bbk04cXF/MTJvKh
tnBV6X3RHHqrztoURiQHFM7s/dUnkU2rLPnDKxTPhiCvDTqh0lk0xeZ3uPOz
4PDZ2fWVszNom7hntn8UMmDRpRe6SCeNxpHGlzO00yA9mNeyyDGB5vffmjPp
kADL5jSdCX0XR9ceerJn3bs4kFbOV3lTF0MrTa24G1QXA9ULd51F3VH0oTNb
Fad3R4GlTpKGukIYff+lxVxFhTCwP9aW82ZTMD1wSxD6dFMwKLoHU2ucAum3
secllzsFQuz52nz1cF+6geMQtCDcFwrEBhWNrM7SsS9F2YZWZ0FXbvV7jXMe
9Had61rq5zzg8Fqxcc3th2nGylCVJFTl6jymHGzoA6O9YSShxj3DcNlDgDSV
c3r/Zeyp9f8sY/aByLS82/+lZY5t2erEE2A5RaxhFcnqZGm5Le5nYIjTeMCS
ZPpGJ+3cpAtQzw/VfkiyzfjFd8PrlyHtk9ByPZKHDc5obHUIAhNT643rSdbe
PnSoe34oRG9c6fGX5NCtqOe5M8LBsWexxT2SuuEDB0D0Jgj9EktQJlngn5G/
tTYWAl4YXZMkaa9hPLk1LAv07e281UOzYFVUSvBQQjYkZTuMZ8Rng4SvqNTG
HTnAj/k556ZNDvzr3JfY6fwQNloEtPFJ3i2bX6oV8BieV6WeH/N7DLIeKbz8
snzw8+/aFvAyHyb+ba10nIuhUtvJNUURQ4Ppjm3H4iogz+5rTEFkBQxkQ/Z0
gxoQWi92NESlBr7dUzzWW/UDilIED1+H/wDvY4Wm2+IboanPx27H7kbYkbDE
JuZ6Mxi032r8JtcMBwJei/yuaoPM2vDvJbw2eHlZXT3oTRd8Fh9vq43rBDt+
U4nszl7o6m7KzfftgX79csMGz35oSG+yQmZ9kO06ZXTv8UFARq0L23/1A+t8
88W9kcPgnSD/4OWFQbgYrWwmHzkKqpr2dcU9Q7CBdV6t9Oo4fDL+8Ml47Qhk
mR2t60qfhIR5bbqKUaOw8jZd9v4eA3zHuoeaRWOQtfcjkmsWQj/US1MGv43D
gTlb1dcMCKP0c7tDdT9PwKM/3CfGPSKoNOH8LDpxEtzr3ry6NiCCgvwjDwwn
T4Luu5C6qhER5OW4/MbitEkoypOfsBUWRXSLVkxE1iSUXV2w1lVaFOnqPzQ3
LpyEuiUm1bd0RNGbdKfh9TWTIPD272w9LYo0g4RZmSwBmMuyVa8Js5CMbbrE
VHsBKFevvxvAZqH3ra96Qsj3fuK6v+JlHgupG87pk9wvgEwuJX+Wz0IqJ1s2
iB0UgNS4GOU6l4VC+adsWt0E8LlBqs16DQvlj3pkmPkLwCFbIWvmRRa6NH/A
KOGBAPSO7Fkk78dCFq51l5oyBSCtFpcic5WFNP0Nfi7MEcDLu0rxEmEspGXX
VZdO9iPVm/NCBQks1ImUeiKLBdDus9CtEbPQq+DP5yQ/CMDTXGfFfSE2kmHE
F9/oEUD32tS74Sw2igmqZ0f0CcBl9UxJb4qNTr+axgkh++EuLaHWDVJspKKs
5nOR7JdI7m10pxIbLWlNN7AUYkC8cd+kFrDRmovKXZGSDCSciSjNP8tGvSZG
Ns80GJhxkrM04SIbNQdE/fHRZCD8yJnYK35sFHW6KGI12c/97O09d15no/RT
IvZPtRk4tF594XgMGxm7J8Td1mdAh//ymmERG70ZsnggasrA67Q+67IxNmq4
F27m6siQT79IoQjDRnush/Tl9zGg2iKtjEQ5yNxEaaRoPwO+Ktr9z8Q56GyR
+WdhUq+sunsyIkeBg1LsauRPHCP1w52BT3cMOShpJCq5yYuBqOChrW6+HLRd
GCmoknrpVSanONufg0ZzOzYHRDAw+FZOpTOQg2b2D29ojmTAWlx30DmCgz4n
lMfEknpM4sqpG3uSOYg5nRTXG8PAhYsjn01fcZDd0+tTl6Qy4OI+tl1JjItk
WxyFmacMZO4KUJOdykU2q0XNOKQ+7DOSnaCkueiq1Fi8OKkfvfmaiX0zuMjb
Mc1b6jkDwVmO7WVqXDSteHOrSAkDT1orzh8x4yKVoKNXA1+T+vbDNmtHCy7a
fF+ddqtkwDC/cf52Ky66/9VCdOcbUk/6TbyGnVy0V88/T+kdAz/macnKHOSi
QKN15TeqGBDZcyvt6RUuOn19rf98Uu+arJvvnRXERXKf2+90EgepP7RICuWi
Xk0VOreOgWljlX1BUVyUeWmm5mpSPy+8JVjlkMZFo+tKMlb8ZGBTtVM1p4KL
HKsE8942MhBR0Jc0/oaLOqrXS3j+IfV0/HnPng/keR0OiiiSet3xWPSsb1+4
iKM5e5oLqefdxd85ZbZwkcYlpU9/Wxi4s15nbAuXQkF9y9IvdDBwP9Pm1nNx
Cj3Uydo9q5OBgmneOmpSFLIXO574mLi26cUxwXQKPdGN/vWD9BdS/pv/pC2i
kLOrqap0LwNKXW4XZJZQ6HVt8d5oYs3tN2ef06bQrmXztBT7GNig+tNmyyoK
rfQJOTunnwH/V4feTlpQqLWgo4FL+p8bmsEHXawpdPlTRbI3cfLNh5xP2ym0
dK7pSAfxiwMjKM2eQqfGp1hVkP5pguP/xPoEhf7dqqpwJP2XuGu6dbEHhUra
fkmWEM/88rZ7gReF9EIsW5RIv6abKrNo0pdC/XvXmNQQu5kkxqVGUsg8N6ZS
ifR/F7NLDaSjKbToFTfyCHGofGudTyyFZqjd7cwjzmzRlLFOodAXl01W60h/
WbTZOqfoPoVqz2/bFUBcme9hsSCbQmt2ew6WE7cGFAVM5FMo8W/v1zWkPx3u
/j3fuYhCU0zWzvcm5uwQLanGFPr6/Y7gIbHyQvOJlNcU8pS13jed9MPLQo9G
899TiN+e2mlCjEZCV/h8pFDGzkGuB7FdxZfjVt8pdNz1YEc58VGt8SlFvylU
VnY1r5PYJ0rxgepfCrlJ35Dik349UMjINKyVjFfSlbGlxNEuTk3jHRRaPOLo
bkmcVnXF90AvhaqLFM8dIc5bmaFUPUihvvdF8v7EZQkfigzGyPwZ6K+JJa6h
+nemCCj0ffWNsf/OG/4clxuWEuWhVKO3a0uJ++r0Ir25PNTx96dCDbHQmj1L
m8V5KLi7wq+BWDL9wntLKR4a3x10roNYkZ98uFCWh7RtFpDlwIDGmXJKdQYP
lepGk+lhwKCh7V7obB6qDGggr8vA/52/oP8/f/kfuC3gzQ==
         "]]},
       Annotation[#, "Charting`Private`Tag$266087#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=1\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-1.9999999999999958`, 
       1.9999999999999958`}}, {{-3.141592653589793, 
      3.141592653589793}, {-1.9999999999999958`, 1.9999999999999958`}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJw12Hk0Vd/7B/CTOx0phPjkY0g0GEJSCjmbUDQoSSoNkmggCWWKyjxFJIoI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         "]], LineBox[CompressedData["
1:eJw12Hk0Vd/7B/CTOx0ZQ3zyMSQaDCEphexNKBqUJJUGSTSQhDJFZZ4iEkWE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         "]]},
       Annotation[#, "Charting`Private`Tag$266132#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=1.1\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-2.099999999999995, 
       2.099999999999995}}, {{-3.141592653589793, 
      3.141592653589793}, {-2.099999999999995, 2.099999999999995}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJw12Xc8lW/YAHDjjAfJjFKUSiUSzolCnkelISTrJ8kqoyGyyoyUkpEyosgM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         "]], LineBox[CompressedData["
1:eJw12Xc4lX/YAHDjjAfJjFKUSiUSzolCnq9KQ0jWT5JVRkNklRkpJSNlRJEZ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         "]]},
       Annotation[#, "Charting`Private`Tag$266177#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=20\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-20.999999999999993`, 
       20.999999999999993`}}, {{-3.141592653589793, 
      3.141592653589793}, {-20.999999999999993`, 20.999999999999993`}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.721367233726201*^9, {3.721367290320036*^9, 3.7213674032628098`*^9}, 
   3.7213674798525467`*^9, {3.721367527023231*^9, 3.721367551126524*^9}, {
   3.721368260487447*^9, 3.721368271146925*^9}, 3.721372942738017*^9, 
   3.7529885934609537`*^9, {3.752988645905007*^9, 3.752988655365357*^9}},
 CellLabel->"Out[17]=",ExpressionUUID->"f714cd92-c4ec-4402-b6f4-3d8c086998ea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["n(k) along the Brillouin zone", "Subsection",
 CellChangeTimes->{{3.7213708144811907`*^9, 3.7213708583842583`*^9}, 
   3.906545554346279*^9},ExpressionUUID->"3f4ce117-2e0c-4ffa-a21b-\
69910ecfc301"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"n", "[", 
    RowBox[{"k_", ",", "\[Mu]_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"-", "t"}], " ", 
       RowBox[{"Sin", "[", "k", "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "t"}], " ", 
        RowBox[{"Cos", "[", "k", "]"}]}], "+", "\[Mu]"}]}], "}"}], "/", 
    RowBox[{"(", 
     RowBox[{"-", " ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        SuperscriptBox["t", "2"], "+", 
        SuperscriptBox["\[Mu]", "2"], "-", 
        RowBox[{"2", "\[Mu]", " ", "t", " ", 
         RowBox[{"Cos", "[", "k", "]"}]}]}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"k_", ",", "\[Mu]_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Cross", "[", 
     RowBox[{
      RowBox[{"n", "[", 
       RowBox[{"k", ",", "\[Mu]"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"n", "[", 
         RowBox[{"k", ",", "\[Mu]"}], "]"}], ",", "k"}], "]"}]}], "]"}], "[", 
    
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "t"}], " ", 
         RowBox[{"Sin", "[", "k", "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "t"}], " ", 
          RowBox[{"Cos", "[", "k", "]"}]}], "+", "\[Mu]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(E\), \(y\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(E\), \(z\)]\)\>\""}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"\"\<\[Mu]/t=\>\"", "<>", 
        RowBox[{"ToString", "[", "\[Mu]", "]"}]}]}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".9", ",", "1", ",", "1.1"}], "}"}]}], "}"}]}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"n", "[", 
          RowBox[{"k", ",", "\[Mu]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"n", "[", 
          RowBox[{"k", ",", "\[Mu]"}], "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(n\), \(y\)]\)\>\"", ",", 
         "\"\<\!\(\*SubscriptBox[\(n\), \(z\)]\)\>\""}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"\"\<\[Mu]/t=\>\"", "<>", 
        RowBox[{"ToString", "[", "\[Mu]", "]"}]}]}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".9", ",", "1", ",", "1.1"}], "}"}]}], "}"}]}], 
   "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"f", "[", 
       RowBox[{"k", ",", "\[Mu]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<k\>\"", ",", "\"\<f(k)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<\[Mu]/t=\>\"", "<>", 
       RowBox[{"ToString", "[", "\[Mu]", "]"}]}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"\[Mu]", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", ".9", ",", "1", ",", "1.1"}], "}"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.720945881185646*^9, 3.720946092521529*^9}, {
   3.7213692983557158`*^9, 3.72136935905956*^9}, {3.7213693973883743`*^9, 
   3.721369399356037*^9}, {3.721369446763947*^9, 3.721369446943934*^9}, {
   3.7213694829724207`*^9, 3.7213696612044487`*^9}, {3.7213696977576942`*^9, 
   3.721369909133565*^9}, {3.721369966413978*^9, 3.721369991222022*^9}, {
   3.721370063679166*^9, 3.721370067534677*^9}, {3.721370165735217*^9, 
   3.721370180950829*^9}, {3.721370224350827*^9, 3.721370481472062*^9}, {
   3.721370516544353*^9, 3.721370709025133*^9}, {3.721371671933247*^9, 
   3.721371715437793*^9}, 3.721372876675316*^9, {3.721372924059914*^9, 
   3.721372934466755*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"f8af417e-c5d6-4a92-8d37-a219f9501b93"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw1m3dcjf8b/xsopUEIGaU0UBTKykVFGhqijD5piKQdESUKkWgvmko7TS3V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        "]]},
      Annotation[#, "Charting`Private`Tag$3362#1"]& ]},
    Axes->{True, True},
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(E\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(E\\), \\(z\\)]\\)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{"ScalingFunctions" -> None},
    PlotLabel->FormBox["\"\[Mu]/t=0\"", TraditionalForm],
    PlotRange->{{-0.9999998592812047, 
     0.9999998782744886}, {-0.9999998831351729, 1.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw123c4le8fOHBSUTJKRanMsiI0aL5lRKiQkHxkJxklaVFSiVJmRnZmNOwc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        "]]},
      Annotation[#, "Charting`Private`Tag$3388#1"]& ]},
    Axes->{True, True},
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(E\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(E\\), \\(z\\)]\\)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{"ScalingFunctions" -> None},
    PlotLabel->FormBox["\"\[Mu]/t=0.9\"", TraditionalForm],
    PlotRange->{{-0.9999998592812047, 
     0.9999998782744886}, {-0.09999988313517283, 1.9}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw123c8le8bOPATCskoiVIRyoqEpMSlkDIqIyFlJp+ySSmzRKSQERlRRkbJ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        "]]},
      Annotation[#, "Charting`Private`Tag$3411#1"]& ]},
    Axes->{True, True},
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(E\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(E\\), \\(z\\)]\\)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{"ScalingFunctions" -> None},
    PlotLabel->FormBox["\"\[Mu]/t=1\"", TraditionalForm],
    PlotRange->{{-0.9999998592812047, 0.9999998782744886}, {0., 2.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw123c8le//OPCTEdkilEqSjLKl3euEECpKlLyFJJVRSBqyUkIlySgzspXN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        "]]},
      Annotation[#, "Charting`Private`Tag$3434#1"]& ]},
    Axes->{True, True},
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(E\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(E\\), \\(z\\)]\\)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{"ScalingFunctions" -> None},
    PlotLabel->FormBox["\"\[Mu]/t=1.1\"", TraditionalForm],
    PlotRange->{{-0.9999998592812047, 0.9999998782744886}, {0., 2.1}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.721369893337528*^9, 3.721369909600499*^9}, {
   3.721369982790189*^9, 3.721369991620756*^9}, {3.721370228708344*^9, 
   3.721370310291291*^9}, 3.721370359654599*^9, {3.721370392128882*^9, 
   3.721370402069154*^9}, 3.7213704693075743`*^9, 3.721370517606285*^9, {
   3.721370558224698*^9, 3.7213706554923897`*^9}, 3.721370721581498*^9, 
   3.7213717172473707`*^9, 3.721372878238884*^9, {3.721372935454907*^9, 
   3.721372942951585*^9}, 3.752988593864921*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"6b457d11-3c49-4e15-87aa-64ec148951eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw1m3c8lf8b/42KyCiVSoPIqCgq2lehZGSkaPjISEm2kCKloaTsVWZky8wK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        "]]},
      Annotation[#, "Charting`Private`Tag$3469#1"]& ]},
    Axes->{True, True},
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(z\\)]\\)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{"ScalingFunctions" -> None},
    PlotLabel->FormBox["\"\[Mu]/t=0\"", TraditionalForm],
    PlotRange->{{-0.9999998782744886, 0.9999998592812047}, {-1., 
     0.9999998831351729}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw1mnk0VW/Ux0s0qpQSSqUkRYakSdlUhkqGKBKpKCqEpDmiwVCZQpI5s4TM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        "]]},
      Annotation[#, "Charting`Private`Tag$3492#1"]& ]},
    Axes->{True, True},
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(z\\)]\\)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{"ScalingFunctions" -> None},
    PlotLabel->FormBox["\"\[Mu]/t=0.9\"", TraditionalForm],
    PlotRange->{{-0.9999996701544583, 
     0.999999699931083}, {-0.9999999999999999, 0.9999883136955059}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw12Xk0VV/cBnCRJkQiSlJKEVFRodiRKemnyVSGColShqTMVKRBmUJkzjzP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        "]]},
      Annotation[#, "Charting`Private`Tag$3515#1"]& ]},
    Axes->{True, True},
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(z\\)]\\)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{"ScalingFunctions" -> None},
    PlotLabel->FormBox["\"\[Mu]/t=1\"", TraditionalForm],
    PlotRange->{{-0.9999997455120678, 0.9999999706877082}, {-1., 0.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw12Xc8VfH/wHEpiYwkpCg0RJGKkPSRUVQSMisJDcmqJKuiYW8yIhlZKSNl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        "]]},
      Annotation[#, "Charting`Private`Tag$3541#1"]& ]},
    Axes->{True, True},
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(n\\), \\(z\\)]\\)\"", TraditionalForm]},
    AxesOrigin->{0, -1.},
    DisplayFunction->Identity,
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    Method->{"ScalingFunctions" -> None},
    PlotLabel->FormBox["\"\[Mu]/t=1.1\"", TraditionalForm],
    PlotRange->{{-0.9090905803372457, 
     0.9090908336475887}, {-1., -0.4165979550813152}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.721369893337528*^9, 3.721369909600499*^9}, {
   3.721369982790189*^9, 3.721369991620756*^9}, {3.721370228708344*^9, 
   3.721370310291291*^9}, 3.721370359654599*^9, {3.721370392128882*^9, 
   3.721370402069154*^9}, 3.7213704693075743`*^9, 3.721370517606285*^9, {
   3.721370558224698*^9, 3.7213706554923897`*^9}, 3.721370721581498*^9, 
   3.7213717172473707`*^9, 3.721372878238884*^9, {3.721372935454907*^9, 
   3.721372942951585*^9}, 3.752988593992771*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"de9927a0-5f4f-4b22-ab63-39801388a072"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7eXJ5/xbkfMAAxh82J9+/PaHDYs5DvwHg/f7W1xX
zktTRfALr/wSmizMDld/KlbqxRNhNjj/775VG6wkWeH8x5s+TgzkZIHzzRay
XenlZobzbZQu6XX/YITzZar5anteMcD5F+YYRqTd/b8fxj+fsfm56e6/cP4y
zYsWAXt/w/kGsy4UFJ38CecrGtjeElv9fT8jlP9qlysr28avcHnp7N2J5T2f
4fx/p4SWfij8COcX2/OEZH5/B+fvMD574OvWV3D+esFjG8T3PkOot5rJbJf/
CM63ao33eJF1B85/n/Gnv77jCpzffGS2lf2P43D+td02R1Yxb9gPC+94Hbe/
IRPX2cPkH3pEhObNOwHnf1lvv17C+oo9TP2tpXJ5Hy/cgctX5+32CJ3/CM6P
WKAfPqf3GZyf1n6S6f6FV3D+4RZt7Z7T7+D8OMGnh0QiP8L5n62O2z0s+wzn
r8/n/ZlU8BXOZ6l/1pg05TvcPY0zlT3Fp/yE871Z6jWPdP6Gq1/nmXvj3cq/
cHmLWfuPnlv6HyGfdMlB7BmDA9y9CiHajl8Y4fxNj9m3un1ggvO9RFjVuhlZ
HGDmlXmZmK1iYIXLn1zxKejoLwQ/o+RXmDwXO5w/29XkVzA7B5xf5L5w3vIp
HA6w9APNL3B5ANsHWbM=
         "]]},
       Annotation[#, "Charting`Private`Tag$3580#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"f(k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=0\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-2, 2}}, {{-3.141592653589793, 
       3.141592653589793}, {-2, 2}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{0, 0}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwl13k4lN0bB/CxD0lZStFCCgmvkJchCSkleyWvJFooS7KGikJFWSJL2cpe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         "]], LineBox[CompressedData["
1:eJwl1Hk8VN//B/AxlrlaZIvSJvWRpaLShpxDKSollOWjki+tlqK0qCyVLNVH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         "]]},
       Annotation[#, "Charting`Private`Tag$3624#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"f(k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=0.9\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-2, 2}}, {{-3.141592653589793, 
       3.141592653589793}, {-2, 2}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{0, 0}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJxF0g0slHEcwPHHy53zkgkrEiOzhVyqi1JyabbSJqwaqhWL1MlLpULnJdJ1
nJdu3aKrFSHXiyupMP2ftpawysnspnBxYlfLpUzdHfr/n3v8e7bb7bPv7/k9
zz33eCSkRSeaEgSxE37Qd/gu2x16D0uSoA4VUNwreJRsakma0I5hzTgPjLJw
P9b5SSuvZeFeFNZ4K8mLRS5QxwjQ2fQpL0gtcM/o19mLHSxIU9pvn4UKGj4y
yXl63q1KONcuZuL93YdWTKod/nvupUwe5MzAHnvyszLK0hzvD7jD7BdZm+G+
dVUfu+SPCe4rc2z5pRoCu1e6LiZpaAEs+kNy88TG9jmweH69t2JTZIced//q
3vRTXX+xPfyDB5fdn8XzmrYwBvPxDFj8PS689vhzpb9wt3E5ZsbJmwaLz2e+
275Om/ETWND9YGZpQ99ZLdDS/XSIzd7jsz/Ab9qS1hRh08B3oKT9YsM7cqZF
g+ef1nS9KG6dxNdrWvpGvrzjK+DSXlq/dtBHogaqeXp/UJXZtrRRPC/IVTvE
RqsAoTP2oEuHd06e+IztOOv3vTlLCYglxvmpZEN5nqAfECpjv+5VJ9kT2guI
o8Ze+PpGUMifTkCQBqqnrmqTOuoAvF4V5YH2ra9lZnJoO+P/k5UwPG3TBB1j
h1yavZtTYf8IWj6H5g05HKGf00PodGvUeXxXVbfrA2inAOTBXGZAsud9tI+a
D8+fKmF4y6B7HVFvK1B+qWE3QudnoO5T+CqQy7mH9lmhXl0kEw1tboDmOqBu
VSweyw6phyZT5qGzL1/Y7BRWh57XbdQ1gsTylvC7aB8bOU4YMR4dWQt9hLq/
7pLALdp9NWg+jnqeIvdK0YE7yLNoX2OZ5YRP/G3kHzro9e7jWRXvbiFz9dD2
ns+9epRS5G/o/GmvKwqGupqaN0ArVh/gc6euI0dMQ8t9/bxzdBJkcy10BXuh
v4VxDZnlCe8nfZ0iX2snRj7vCHskp3aN78pKZOlJ2A+nauQ9EWXI/iITFXA7
U8banihEVkXpR8Bw1vojz3KKkfMLpkbAzbyB575XL1Lvjwy9j1YzbqFRfKqP
h6hA4LLg92tyM6muhp23w0rP3s+jzCK04Dw/tnk0gEe/fwT5D/R0LTI=
         "]], 
        LineBox[CompressedData["
1:eJxF0w9Qk2UcB/B3c8QIRPQIKc3EOFKg8OZCQ7bn9QwCMuXPELROCE7JldOS
ALUSkxtyIaTNAcoQkP8Nhvw5KDxeTEaCBVS0FpYbGUsWE8RBMra9Pc+7l5fd
7Xaf+35/v/fdu2c+KUdjD7IxDEuAb/QZeDhg0tQiBJjj1TOSrhTyrgOHs6cI
RWbYRHRpKp1PE9HN+9WCig8p68kh4qeqVV5x6Scoa8l7RP2ug1varmVT7iJ1
hDH85l3h+RzkbLlOR/jveD6nP+McZTHM399+IlCUnI/cHLygIzSXxeIp3y8p
f4rpibmi4u62Zy8i89dCe13qW3XSXYbcaYLzWy+aD4FlcuRvl8M8sXBDF+dJ
EXLOGMyz8qNXDEyWID9xhnlx3mephWNXqP1zMO+UKjtEGgXyj7PQ2rOjrs/d
uYr8OvInOKd5SlcOjeex4bwbWLM/drQC5aE2mCsEPE77SCXK9fCJEK+ERjat
HrqGXGaHeXdIcuLJ/ipovRHlu1/LZP95qxo6mY98b2uBEnTXQE/7I0uCq/dW
dtZClytIOG/n38CcWuvQvvUoL9jyS0NaYz3Ku1G+jmcUDdQ2QHsEorxpM4sM
rPwaOuspZGGQd31hqRK60x158OWguBl5I7qfCTSfFBhuE11ogt7mgvLQ4pqC
uXIV+n4sZLfPl3nsSmyGjjCjvqWjVbtWj3xuHnnClFphSrsObUYngujb18sr
zGyB5tpRXqn27d2c2woto/a9rRg3HK9pR/dL9T0/rnHpUHdAp9tQX+q7cY+A
cwP6X2reOiEaeNenB2C4J9WXlGhWPEjqBViyK+WxiMR4SdltmJMk6vOMs5Mv
hQ0D7B3qhBJmFVB5bx8B1GGH/sdf5e4k1QJ4WKn+aPU6yaPhPwBmdbgteZw0
nNUDnOXon5J0RcRf/Qv0kI5cnDs7lCX/G+CYI08sD0ooPW+g/x96QveVVSlQ
PQB6un8ot5+tGzYy9pRa5K8OTgI3un8rJyAg/85DYKVz/WHBB0eSppl9B1aO
f+e57xGw0PlGPw22kDYD2HT+OOR74VjGY8Yx8cY1lcfNzD7V0eXzKcdmmX2c
04YzKbL/AEnnZ0pejFwtmwd22obdMd+YCiyARfff5Jze1Ju3wOyvuhTy6+BK
K7DRfavfXPbvJVam3xR5RPuw3sZcb9tlQj1YTTJuSvkZ9zI4fi3q+awXBeww
s/DFvOW+c3v4NBtf3Bfl6eT3BYvDOCOKH9yAOTHur5uJVVuW/F66Ze8LTzsz
+66E8S1xzlzmeg2NCUXdrlx88ft2PnOKv8mDy8xrxm9K7N5cZt5Duud+nf9S
X9on/sH21lL+0RsVZbWypfkDt387FnOXiy8+n6hI950LPi5M/3+8rYNB
         "]]},
       Annotation[#, "Charting`Private`Tag$3668#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"f(k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=1\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-2, 2}}, {{-3.141592653589793, 
       3.141592653589793}, {-2, 2}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{0, 0}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwl1nk4lN8XAPCxj4hQKfqKdipZIiEvUZGyVyqEbEmRPVooVMiSEmVJlqgs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         "]], LineBox[CompressedData["
1:eJwl1nk4VN8fB/CxzogYS5QoSUJFRVlzDlJoQypJWUpabElSwlCJlK8tWUpI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         "]]},
       Annotation[#, "Charting`Private`Tag$3712#1"]& ]}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"k\"", TraditionalForm], 
      FormBox["\"f(k)\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"\[Mu]/t=1.1\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-2, 2}}, {{-3.141592653589793, 
       3.141592653589793}, {-2, 2}}],
    PlotRangeClipping->True,
    PlotRangePadding->{{0, 0}, {0, 0}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.721369893337528*^9, 3.721369909600499*^9}, {
   3.721369982790189*^9, 3.721369991620756*^9}, {3.721370228708344*^9, 
   3.721370310291291*^9}, 3.721370359654599*^9, {3.721370392128882*^9, 
   3.721370402069154*^9}, 3.7213704693075743`*^9, 3.721370517606285*^9, {
   3.721370558224698*^9, 3.7213706554923897`*^9}, 3.721370721581498*^9, 
   3.7213717172473707`*^9, 3.721372878238884*^9, {3.721372935454907*^9, 
   3.721372942951585*^9}, 3.752988594337042*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"91926606-78e4-43d7-892d-bf1ed242d422"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Winding number", "Subsection",
 CellChangeTimes->{{3.7213708738983307`*^9, 
  3.721370876673236*^9}},ExpressionUUID->"a3a0bc1c-56ae-44bd-aca3-\
564a13f6c086"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "\[IndentingNewLine]", 
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", " ", 
      RowBox[{
       RowBox[{"Integrate", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"k", ",", "\[Mu]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", "Pi"}], ")"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.1"}], ",", 
        RowBox[{"-", "0.9"}], ",", "0", ",", "0.9", ",", "1.1"}], "}"}]}], 
     "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.7213708886410303`*^9, 3.721370915537098*^9}, {
  3.721370995305732*^9, 3.721371019689722*^9}, {3.7213710620100183`*^9, 
  3.721371095145727*^9}, {3.7213711674905853`*^9, 3.721371172834153*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"81b5c362-9305-423a-a5d6-16209aaed684"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-1.1, 
      2.8450903977928797`*^-8}, {-0.9, -1.0000000248106575`}, {0., -1.}, {
      0.9, -1.0000000248106578`}, {1.1, 
      2.8450904402002754`*^-8}}]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-1.1, 1.1}, {-1.0000000248106578`, 2.8450904402002754`*^-8}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.721370991699808*^9, 3.721371056308668*^9, 
  3.721371118359956*^9, 3.721371176912978*^9, 3.721372888525923*^9, 
  3.72137295175667*^9, 3.752988615035534*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"76af01b5-4dfe-476f-8c4e-a39daa47a02a"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chern number in 2d", "Section",
 CellChangeTimes->{{3.721366698842381*^9, 3.721366703661192*^9}, {
  3.7213734095135393`*^9, 3.721373413617391*^9}, {3.721373685842484*^9, 
  3.721373705410512*^9}},ExpressionUUID->"ea3a4f6b-2659-46ef-ae5e-\
5182e53bcdc8"],

Cell[CellGroupData[{

Cell["Dispersion", "Subsection",
 CellChangeTimes->{{3.721377692585959*^9, 
  3.721377695251976*^9}},ExpressionUUID->"5fc0b06d-6fb0-4c90-a511-\
c431edad5739"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Epsilon]", "[", 
    RowBox[{"kx_", ",", "ky_", ",", "m_"}], "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"2", "+", 
     SuperscriptBox["m", "2"], "+", 
     RowBox[{"2", "m", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", "kx", "]"}], "+", 
        RowBox[{"Cos", "[", "ky", "]"}]}], ")"}]}], "+", 
     RowBox[{"2", 
      RowBox[{"Cos", "[", "kx", "]"}], 
      RowBox[{"Cos", "[", "ky", "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"\[Epsilon]", "[", 
         RowBox[{"kx", ",", "ky", ",", "m"}], "]"}]}], ",", 
       RowBox[{"\[Epsilon]", "[", 
        RowBox[{"kx", ",", "ky", ",", "m"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"kx", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ky", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(k\), \(x\)]\)\>\"", ",", 
        "\"\<\!\(\*SubscriptBox[\(k\), \(y\)]\)\>\"", ",", 
        "\"\<\[Epsilon](k)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<m=\>\"", "<>", 
       RowBox[{"ToString", "[", "m", "]"}]}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "2.5"}], 
      "}"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.721373707997457*^9, 3.721373886827743*^9}, {
  3.721376627485723*^9, 3.7213766461596603`*^9}, {3.721376730454825*^9, 
  3.721376731184916*^9}, {3.7213770057120953`*^9, 3.7213770197900257`*^9}, {
  3.7213771503445807`*^9, 3.7213771794877996`*^9}, {3.7213772289208927`*^9, 
  3.721377270039269*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"4c481b83-3f9d-4b38-867b-c3eca5834b98"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx9fXuc19P2fnPrfnUQQnRIcr9ECmuXFHEcUknhpKIjlzgOChFyrXCiknLJ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     "], {{
       {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJw1mwW41cbTxk8OJIfksJcipbi0uJRSKFaoUKPu7tT+dXd3d3d3d6Ol7m60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             "]], Polygon3DBox[CompressedData["
1:eJwtm2egFUUWhOc+mL5O3zcPJAhIDkqOAoIgIJjWnN01R8xiRkRFVAxLUDGC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             "]], 
            Polygon3DBox[CompressedData["
1:eJwt13eUFeUVAPBHeW/Zt4uGjoD0ppRl6W2pgjWaQxQTDaJEDNI1Ih2VJopo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             "]]},
           Annotation[#, "Charting`Private`Tag$33208#1"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
           "Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 0, 2}]}}]}, 
       {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJxFnHXYFdUWxvGb0TPHmW+u3V67rt1xbQQJAUFFQJQSMAhFRUpQQSxQQVIE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             "]], Polygon3DBox[CompressedData["
1:eJwtmnXYVUUXxV/vefHM65l77e7uVkwsEKQbBKRbSgRBxUBCQFSwQAVFMBEM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             "]], 
            Polygon3DBox[CompressedData["
1:eJwl1nmQl3McB/Bflzb7qzBSGSR0ooOSakqlsuWo3a7VsbtduncrHdt9F+kY
FIaYYSYUFelk03ZnOh2JFIWGyjmkocTrM78/PjPfz+t5f7/P89vn+zzPVu9X
kJVfMpFIzFFlVEH5RGJ6WiLxV9lEIq9UInEmPZGon0wk+rAdrAbbyjLkrmbj
2UYL3CfzGv/P+CA/pKbLjFBTjf+UyzH3B5l8No2dZ7nsRzaA5bPvWAb7lA1i
j7MzrBP7krVznj3OMZe96Vh7fZlk6hrGsWWspX6guQXG37MO5n5m7mA2hp1l
ndkxNoSNZedYJvuKVTC/DpvFdll3LHuAHTRewFY4lqF/zNyRxqdZR3OPyLVl
JVl/9qr8PXKt1XI2m+1mbfQT5DayTeoCW2ruXP6Hvkk565T2d9YXyq1nG9SP
cvPknuQX9Cet18555+trqgfZalaBrYq/lbll2RDW3Hrvy1RXD7CVrIzccrkF
qoXjDZz3bcdGm1dRrr7xfLn9zjtZ5irWgD3FDrAp7G42jH3K7rHeYVbM2lnv
GDvv2Dz9ZtWM1XOOpayZ/i411PgTucbmHjL35fTU32MP36umupZn2TZze5i7
lo1lt5ubabze3OvMfU/mdXVF3Af+uZoh11Au13iXXC3Htsk0YDlsJ6vJitkk
2WK2Tf3m/IvYS+mp8fbY+2qyzJ3mdjHeaG4Vc9fLFLIf2D5Wj03Qd5C9hhWy
TdZoxeqqzmwdqyS31txsuYfZVnYzGy9zh8qKe84qs3Vy9Vg2K2I3sQ/YRHaG
7Wf12SR9D+t1YJvZ9WyF3BxWyt+utOrLzrJhbGL8Vrlsdor9rP7Wz+RzXHNb
fUe5KnEf+FY2gD3MqsV9ZXvZkLgW9gFr6Bwt3avnWGXX04plsx3sm9ijclXZ
NHOLze0vN4XtZL3lTsktTk+9J+J9MYWX5LNlypt/q36KuR+amy/Tmddki9hh
Nool5W6J+8W2sBFsofrVuGk8I2pM/K54No13x/vOsWUyS9JT4+Zxn+L9FvdR
rmXco7TUGi/KPMSvj3ecc2xjA1knVoMtZIdYAXuE3ZaWem/E+2MkS4/nkE1i
RWw4y5SrxRazj9lodqXcDXGtbD0bzGqzav4uW9iJeBZiP8a+NF7KvpCbIDc5
mdoTB9i5+Jvpu8o1Ml7GTsnNkKuRTO3j2M/H4tmPd18ytRc/ZN+wcfrT6qx7
k+NefMYK9FPjfSB3UO6nuKf6cqpyHGdrnKOfc9RiD7E1rKL8apbLitgL7Lhc
nj5NXcfy2WrWN55ndi0bzt5muayf3zGIHWetrLePlZWrxEawVbEeu5q1YI1c
c2vXXqT/hf8T7381V66d/mu+zvFn2DvyWfrhzjHJ+Hf2qHN8G98A9YQ5s+P5
UCNlbpRta3xAXXbsVZlH+SP6YnOrm7uG3Z9MvfvnsDcca6svkUz9jeJv9TRr
qr8Yv9m4G3vescx4JlVplsmWsk76P+Nbq++lFrIO8btUGbku7DnWOeZZc0N8
w9iLjrXQT1dN4pvIfo73pH6Wa75k/K/q6dh35g5lE2LPy/VgJ9nl2Jcsh71s
3a76/nKD2QnWWm4/+1eVi2c6vslyXfTd5TLim8eqyq2MZ1Jd1GepeXLt43fF
MyKXx15h3fSlXONVbBB7nfWO72W8J4yb8Pdin1o/R+WlpX5b/MYdsddYX3aE
3cu2s56sazz7rHbsf9aNtWFvsSvZ0Pi/h/WK/2dYQ1YkV5JXZI+x5c7fi/WW
6x7fLFZXbhPbItfGvmps/30Uz0espboZ75GrI7ch3jeqBMtli633oP68SrA+
bBHrmJ7yOD4/vsFqlLXaq2Tsxdi7jmXHPo13ZRxn77Ie8R1Tl/Rdy6b2cOzl
PLl+8a1kTV3LTjZdnXT8br5KPV4+dd/j/hfG90LNZH/EXoi14t0mn6Hvy/vr
j/Jm8rtYFruDLWFH5QrZ/7UxXfY=
             "]]},
           Annotation[#, "Charting`Private`Tag$33208#2"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[
            0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
           "Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}, {}}, {
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k9LlFEUB+A7mjOT+WcgSooo3OeAqzZK4CqaaiFuZkQkwUQDW7RREJcm
fgCH3DuoZVpNX8BpIy3C0lHLUhdBlIJtxUXPRZj7Pr/De+7h3pdpHXjWPZoI
Iby0bteEEPNfj18cvhhChs95i5PMcoadcQ8fcKo+hDp7euU5+YZ8x6wRdQ/b
1RW94+q78ro8LW+yyEOWeMwPPONHfjKroD9nxld1inn1Yp296iVu8RWrfM1t
LnOHn5Mh9OnflTfkfvmhGd/UeT5Wv9H7XT0gr8h78ip/8C1/8h33+Z4HrJr1
RP8jMw7VDRxUX3XeL+o0Kzx1j3L8npznPmfjeb3v0v9CXpA75QNrLO5h1lrT
O6yelstyQS4xxyI74ju2cYI3+dSsf8w6TzNP7D3hdedu4jU2soUNvMJLvExb
w333OqJx4Z78h+tmpHnE38zoTXFE3SQn4/3pF+o9LsT7s5ZJOkrY1jSUOP9/
/Qf1sU2k
         "]]}, 
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k1LVGEYBuDHDxy1foAtXdkvsPZSEFGIjOPkaOYUBFJTqUtbmU5TptbK
2VhtW9SAiLRJpLZqtGijFVFQ4fRhqYEt6jq0eLnum3nOc86cmdb8la5CTUSU
ncf1EeO1EZd5sS6i40DEPf0UHzLLCi9wmVe5xhMHI4rm38iD8rz81I6q/poL
etnsH31Fvi838xEPcYmH+ZxH+IrHOWXXJlft6GaJG/yaisjwG3v4nVn+4Blu
s5d/GyPeMefUNEW857odfdzgB/4028+Pzi/5LHc4wF2e4x4H+Zt5Ntj1mS/t
OM9pfmLVc6f5lseSz9nOFbZxkS0c9b1esMm5Ji8zb8e+9zPGij5ndktv1m/J
m/J1rrLAZ8zzCTN8wKN2jbi24pq7+jCHk92eezb5bTjDAU6zn3eY4xRL3lfB
/G25KF+STyb3T+7JIT1rtqRX5Yx8U06zyC5OspMTPM0bTHlfX+r+/7/+ASsr
Wqs=
         "]]}, 
       {GrayLevel[0.2], 
        Line3DBox[{2409, 2662, 2770, 1460, 2769, 2663, 3462, 2583, 2410, 3463,
          2584, 2411, 3464, 2585, 2412, 3465, 2586, 2413, 3361, 3466, 2587, 
         2771, 3612, 2665, 2812, 2849, 2588, 2866, 2850, 2851, 2813, 3309, 
         3581, 2772, 2666, 3467, 2589, 2414, 3468, 2590, 2415, 3469, 2591, 
         2416, 3470, 2592, 2417, 3362, 3471, 2774, 2593, 2773, 1614, 2775, 
         2594, 2667}], 
        Line3DBox[{2419, 2664, 3310, 3580, 2418, 1471, 2420, 3472, 2595, 2421,
          3473, 2596, 2422, 3474, 2597, 2423, 3582, 2669, 2598, 2776, 3613, 
         2670, 2814, 2852, 2853, 2777, 2854, 2671, 2815, 3311, 3583, 2778, 
         2672, 3312, 3584, 2424, 3475, 2599, 2425, 3476, 2600, 2426, 3477, 
         2601, 2427, 1616, 2602, 2673, 3585, 2668, 2603, 2428}], 
        Line3DBox[{2430, 3313, 3520, 2429, 3314, 3521, 2431, 1482, 2432, 3478,
          2604, 2433, 3479, 2605, 2434, 3586, 2674, 2606, 2779, 3614, 2675, 
         2607, 2780, 2676, 3315, 3587, 2781, 2677, 3316, 3588, 2435, 3317, 
         3522, 2436, 3480, 2608, 2437, 3481, 2609, 2438, 3482, 2610, 2439, 
         3483, 2611, 2440}], 
        Line3DBox[{2442, 3318, 3523, 2441, 3319, 3524, 2443, 3320, 3525, 2444,
          1495, 2445, 3484, 2612, 2446, 3589, 2678, 2679, 2447, 3590, 2680, 
         2681, 2448, 2682, 2683, 3615, 2449, 2684, 2685, 3591, 2450, 3321, 
         3526, 2451, 3322, 3527, 2452, 3485, 2613, 2453, 3486, 2614, 2454, 
         3487, 2615, 2455}], 
        Line3DBox[{2457, 3323, 3528, 2456, 3324, 3529, 2458, 3325, 3530, 2459,
          3326, 3531, 2460, 1508, 2461, 3488, 2616, 2462, 3592, 2686, 2687, 
         2463, 2688, 2689, 3616, 2464, 2690, 2691, 3593, 2465, 3327, 3532, 
         2466, 3328, 3533, 2467, 3329, 3534, 2468, 3489, 2617, 2469, 3490, 
         2618, 2470}], 
        Line3DBox[{2484, 2713, 2712, 3595, 2483, 2710, 3542, 3377, 2482, 2708,
          3541, 3375, 2481, 3373, 3540, 2706, 2480, 3371, 3539, 2704, 2479, 
         1654, 2702, 2478, 3618, 2701, 2856, 2858, 2857, 2477, 2859, 2860, 
         2855, 2878, 2877, 3633, 2476, 2876, 1859, 2475, 3538, 3330, 2474, 
         2699, 3537, 3368, 2473, 3366, 3536, 2697, 2472, 3364, 3535, 2695, 
         2471, 3594, 2693, 2692, 2694}], 
        Line3DBox[{106, 532, 394, 566, 1370, 107, 605, 395, 1840, 568, 108, 
         606, 396, 1371, 109, 1770, 397, 110, 1771, 398, 111, 1772, 399, 570, 
         112, 1830, 538, 400, 572, 113, 541, 401, 574, 1372, 114, 613, 402, 
         579, 1373, 115, 403, 1374, 116, 404, 1375, 117, 1773, 405, 580, 118, 
         614, 1774, 406, 581, 119, 1855, 615, 407, 582, 120}], 
        Line3DBox[{2498, 2840, 2841, 2792, 3621, 3379, 2497, 2711, 2791, 3620,
          3378, 2496, 2709, 2790, 3619, 3376, 2495, 3374, 3550, 2789, 2707, 
         2494, 3372, 3549, 2788, 2705, 2493, 3370, 3548, 2787, 2703, 2492, 
         1819, 2839, 2786, 2825, 2824, 2491, 2837, 2838, 2836, 2864, 1847, 
         2490, 2718, 3547, 3383, 2489, 2717, 3546, 3381, 2488, 2700, 2785, 
         3617, 3369, 2487, 3367, 3545, 2784, 2698, 2486, 3365, 3544, 2783, 
         2696, 2485, 3363, 3543, 2782, 2835, 2834, 2714}], 
        Line3DBox[{2499, 2842, 2843, 2793, 3622, 2619, 2816, 2715, 2794, 3623,
          2620, 2817, 2716, 2795, 3624, 2621, 2500, 3380, 3491, 2796, 2622, 
         2501, 3382, 3492, 2797, 2623, 2867, 3395, 3632, 2874, 2798, 2624, 
         2725, 1821, 2844, 2799, 2845, 2625, 2865, 2846, 2847, 2833, 2863, 
         1534, 2832, 2719, 2882, 3635, 2626, 2861, 2720, 3493, 2627, 2502, 
         2721, 2800, 3625, 2628, 2503, 3384, 3494, 2801, 2629, 2818, 3385, 
         3495, 2802, 2630, 2819, 3386, 3496, 2803, 2848, 2631, 2728}], 
        Line3DBox[{2505, 2722, 3331, 3596, 2504, 2723, 3497, 2632, 2506, 2724,
          3498, 2633, 2507, 3387, 3499, 2634, 2508, 3388, 3500, 2635, 2509, 
         1697, 2636, 2730, 3598, 2726, 2868, 2870, 2875, 2637, 2873, 2871, 
         2872, 2869, 2881, 3332, 3634, 2880, 2879, 1542, 2510, 3501, 2638, 
         2511, 2727, 3502, 2639, 2512, 3389, 3503, 2640, 2513, 3390, 3504, 
         2641, 2514, 3597, 2729, 2642, 2731}], 
        Line3DBox[{2516, 3333, 3551, 2515, 3334, 3552, 2517, 3505, 2643, 2518,
          3506, 2644, 2519, 3507, 2645, 2520, 3599, 2732, 2646, 2804, 3626, 
         2733, 2647, 2805, 2734, 3335, 3600, 2521, 3336, 3553, 2522, 1552, 
         2523, 3508, 2648, 2524, 3509, 2649, 2525, 3510, 2650, 2526, 3511, 
         2651, 2527}], 
        Line3DBox[{2529, 3337, 3554, 2528, 3338, 3555, 2530, 3339, 3556, 2531,
          3512, 2652, 2532, 3513, 2653, 2533, 3601, 2735, 2654, 2806, 3627, 
         2736, 2655, 2807, 2737, 3340, 3602, 2808, 2738, 3341, 3603, 2534, 
         3342, 3557, 2535, 1565, 2536, 3514, 2656, 2537, 3515, 2657, 2538, 
         3516, 2658, 2539}], 
        Line3DBox[{2541, 3343, 3558, 2540, 3344, 3559, 2542, 3345, 3560, 2543,
          3346, 3561, 2544, 3517, 2659, 2545, 3604, 2739, 2740, 2546, 3605, 
         2741, 2742, 2547, 2743, 2744, 3628, 2548, 2745, 2746, 3606, 2549, 
         3347, 3562, 2550, 3348, 3563, 2551, 1578, 2552, 3518, 2660, 2553, 
         3519, 2661, 2554}], 
        Line3DBox[{2556, 2747, 2748, 3629, 2555, 2749, 1726, 2557, 3349, 3564,
          2558, 3350, 3565, 2559, 3351, 3566, 2560, 3607, 2752, 2753, 2561, 
         3608, 2754, 2820, 2755, 2826, 2862, 2827, 2756, 2821, 2757, 3630, 
         2562, 2758, 2759, 3609, 2563, 3352, 3567, 2564, 3353, 3568, 2565, 
         3354, 3569, 2566, 1591, 2567, 3610, 2760, 2761, 2568}], 
        Line3DBox[{2582, 2762, 2811, 1737, 2581, 2768, 3579, 3394, 2580, 3578,
          3360, 2579, 3577, 3359, 2578, 3576, 3358, 2577, 3393, 3575, 2767, 
         2576, 3631, 2766, 2823, 2831, 2830, 2575, 2828, 2829, 2822, 2765, 
         3611, 2574, 2764, 3574, 3392, 2573, 3573, 3357, 2572, 3572, 3356, 
         2571, 3571, 3355, 2570, 3391, 3570, 2810, 2751, 2569, 1727, 2809, 
         2750, 2763}], 
        Line3DBox[{2883, 3124, 3217, 2040, 3216, 3125, 3740, 3053, 2884, 3688,
          3054, 2885, 3689, 3055, 2886, 3690, 3056, 2887, 3440, 3741, 3057, 
         3218, 2182, 3255, 3290, 3058, 3299, 3291, 3292, 3256, 2045, 3219, 
         3127, 3742, 3059, 2888, 3691, 3060, 2889, 3692, 3061, 2890, 3693, 
         3062, 2891, 3441, 3764, 3221, 3063, 3220, 2189, 3222, 3064, 3128}], 
        Line3DBox[{2893, 3126, 3396, 3636, 2892, 2051, 2894, 3694, 3065, 2895,
          3695, 3066, 2896, 3696, 3067, 2897, 2195, 3068, 3223, 3697, 3130, 
         3257, 1169, 1245, 1170, 3258, 3397, 3765, 3224, 3131, 2056, 2898, 
         3698, 3069, 2899, 3699, 3070, 2900, 3700, 3071, 2901, 2191, 3072, 
         3132, 3701, 3129, 3073, 2902}], 
        Line3DBox[{2904, 3398, 3637, 2903, 3399, 3638, 2905, 2062, 2906, 3702,
          3074, 2907, 3703, 3075, 2908, 3704, 3133, 3076, 3225, 3705, 3134, 
         3077, 3226, 3135, 3400, 3766, 3227, 3136, 3401, 3639, 2909, 2067, 
         2910, 3706, 3078, 2911, 3707, 3079, 2912, 3708, 3080, 2913, 3709, 
         3081, 2914}], 
        Line3DBox[{2916, 3402, 3640, 2915, 3403, 3641, 2917, 3404, 3642, 2918,
          2075, 2919, 3710, 3082, 2920, 3711, 894, 1017, 2322, 895, 1018, 896,
          2323, 1019, 897, 3643, 2921, 3405, 3644, 2922, 2080, 2923, 3712, 
         3083, 2924, 3713, 3084, 2925, 3714, 3085, 2926}], 
        Line3DBox[{2928, 3406, 3645, 2927, 3407, 3646, 2929, 3408, 3647, 2930,
          3409, 3648, 2931, 2088, 2932, 3715, 3086, 2933, 3716, 3137, 3138, 
         2934, 3139, 3140, 3649, 2935, 3141, 3142, 3650, 2936, 3410, 3651, 
         2937, 3411, 3652, 2938, 2094, 2939, 3717, 3087, 2940, 3718, 3088, 
         2941}], Line3DBox[{2954, 3168, 3167, 3719, 2953, 3165, 2233, 2952, 
         3163, 3747, 3448, 2951, 3160, 3746, 3159, 2950, 3446, 3745, 3157, 
         2949, 2225, 3155, 2948, 3655, 3154, 3294, 1205, 1207, 1206, 3293, 
         1278, 3778, 2947, 3305, 2399, 2946, 3654, 3412, 2945, 3151, 3744, 
         3150, 2944, 3443, 3743, 3148, 2943, 2219, 3146, 2942, 3653, 3144, 
         3143, 3145}], 
        Line3DBox[{748, 1174, 1036, 1208, 1953, 749, 1247, 1037, 1210, 750, 
         1248, 1038, 1954, 751, 1039, 752, 2329, 1040, 753, 2330, 1041, 1212, 
         754, 2383, 1180, 1042, 1214, 755, 1183, 1043, 1216, 1955, 756, 1255, 
         1044, 1221, 757, 1045, 1956, 758, 1046, 759, 2331, 1047, 1222, 760, 
         1256, 1048, 1223, 761, 2397, 1257, 1049, 1224, 762}], 
        Line3DBox[{2968, 3281, 3282, 3238, 2238, 2967, 3166, 3237, 3749, 3450,
          2966, 3164, 3236, 3748, 3449, 2965, 3162, 3235, 3161, 2964, 3447, 
         3770, 3234, 3158, 2963, 3445, 3769, 3233, 3156, 2962, 2372, 3280, 
         3232, 3268, 3267, 2961, 3278, 3279, 3277, 3297, 2394, 2960, 3174, 
         3753, 3453, 2959, 3173, 3752, 3451, 2958, 3153, 3231, 3152, 2957, 
         3444, 3768, 3230, 3149, 2956, 3442, 3767, 3229, 3147, 2955, 2218, 
         3228, 3276, 3275, 3169}], 
        Line3DBox[{2969, 3283, 3284, 3239, 2108, 3259, 3170, 3240, 3750, 3089,
          3260, 3171, 3241, 3751, 3090, 2970, 3172, 3242, 3091, 2971, 3452, 
         3771, 3243, 3092, 3300, 3303, 3772, 3304, 3244, 3093, 3182, 2374, 
         3285, 3245, 3286, 3094, 3298, 3287, 3288, 3274, 3296, 2111, 3273, 
         3175, 3308, 3754, 3095, 3295, 3176, 3755, 3096, 2972, 3177, 3246, 
         3097, 2973, 3454, 3773, 3247, 3098, 3261, 3455, 3774, 3248, 3099, 
         3262, 2250, 3249, 3289, 3100, 3185}], 
        Line3DBox[{2975, 3178, 3413, 3656, 2974, 3179, 2115, 2976, 3180, 3756,
          3101, 2977, 3181, 3757, 3102, 2978, 3456, 3758, 3103, 2979, 2258, 
         3104, 3187, 3720, 3183, 3301, 1260, 1270, 1261, 3302, 1281, 3779, 
         3307, 3306, 2118, 2980, 3721, 3105, 2981, 3184, 3759, 3106, 2982, 
         3457, 3760, 3107, 2983, 2264, 3108, 2984, 3722, 3186, 3109, 3188}], 
        Line3DBox[{2986, 3414, 3657, 2985, 3415, 3658, 2987, 2122, 2988, 3723,
          3110, 2989, 3724, 3111, 2990, 3725, 3189, 3112, 3250, 3726, 3190, 
         3113, 3251, 3191, 3416, 3659, 2991, 3417, 3660, 2992, 2127, 2993, 
         3727, 3114, 2994, 3728, 3115, 2995, 3729, 3116, 2996, 3730, 3117, 
         2997}], Line3DBox[{2999, 3418, 3661, 2998, 3419, 3662, 3000, 3420, 
         3663, 3001, 2135, 3002, 3731, 3118, 3003, 3732, 968, 1064, 2339, 969,
          1065, 970, 2340, 1066, 971, 3664, 3004, 3421, 3665, 3005, 2140, 
         3006, 3733, 3119, 3007, 3734, 3120, 3008, 3735, 3121, 3009}], 
        Line3DBox[{3011, 3422, 3666, 3010, 3423, 3667, 3012, 3424, 3668, 3013,
          3425, 3669, 3014, 2148, 3015, 3736, 3192, 3193, 3016, 3775, 3194, 
         3195, 3017, 3196, 3197, 3670, 3018, 3198, 3199, 3671, 3019, 3426, 
         3672, 3020, 3427, 3673, 3021, 2153, 3022, 3737, 3122, 3023, 3738, 
         3123, 3024}], 
        Line3DBox[{3026, 3200, 3201, 3674, 3025, 3202, 2286, 3027, 3428, 3675,
          3028, 3429, 3676, 3029, 3430, 3677, 3030, 2289, 3205, 3031, 3777, 
         3206, 3263, 1124, 1228, 1125, 3264, 3207, 3678, 3032, 3208, 2294, 
         3033, 3431, 3679, 3034, 3432, 3680, 3035, 3433, 3681, 3036, 2166, 
         3037, 3739, 3209, 3210, 3038}], 
        Line3DBox[{3052, 3211, 3254, 2297, 3051, 3215, 3763, 3461, 3050, 3687,
          3439, 3049, 3686, 3438, 3048, 3685, 3437, 3047, 3460, 3762, 3214, 
         3046, 2304, 3266, 3272, 3271, 3045, 3269, 3270, 3265, 2302, 3044, 
         3213, 3761, 3459, 3043, 3684, 3436, 3042, 3683, 3435, 3041, 3682, 
         3434, 3040, 3458, 3776, 3253, 3204, 3039, 2287, 3252, 3203, 
         3212}]}, 
       {GrayLevel[0.2], 
        Line3DBox[{1286, 1603, 1461, 3462, 1287, 1471, 1308, 3521, 1481, 1321,
          3524, 1493, 1335, 3529, 1505, 1349, 3535, 1644, 1518, 1362, 3544, 
         1645, 1796, 1808, 1809, 1840, 1810, 1671, 1800, 1532, 3623, 1377, 
         1689, 1539, 3497, 1384, 3552, 1546, 1397, 3555, 1558, 1411, 3559, 
         1570, 1425, 1726, 1582, 1438, 3570, 1728, 1593, 1450}], 
        Line3DBox[{1288, 1462, 3463, 1289, 1472, 3472, 1309, 1482, 1322, 3525,
          1494, 1336, 3530, 1506, 1350, 3536, 1646, 1519, 1363, 3545, 1647, 
         1526, 1371, 1672, 1533, 3624, 1378, 1690, 1540, 3498, 1385, 1547, 
         3505, 1398, 3556, 1559, 1412, 3560, 1571, 1426, 3564, 1583, 1439, 
         3571, 1594, 1451}], 
        Line3DBox[{1290, 1463, 3464, 1291, 1473, 3473, 1310, 1483, 3478, 1323,
          1495, 1337, 3531, 1507, 1351, 3537, 1648, 1649, 1765, 3617, 1650, 
         1651, 1770, 1673, 1674, 3491, 1775, 1691, 1692, 3499, 1386, 1548, 
         3506, 1399, 1560, 3512, 1413, 3561, 1572, 1427, 3565, 1584, 1440, 
         3572, 1595, 1452}], 
        Line3DBox[{1292, 1464, 3465, 1293, 1474, 3474, 1311, 1484, 3479, 1324,
          1496, 3484, 1338, 1508, 1352, 3538, 1520, 1364, 3546, 1675, 1676, 
         1771, 1677, 1678, 3492, 1776, 1693, 1694, 3500, 1387, 1549, 3507, 
         1400, 1561, 3513, 1414, 1573, 3517, 1428, 3566, 1585, 1441, 3573, 
         1596, 1453}], 
        Line3DBox[{1294, 1605, 1606, 3466, 1295, 1619, 3582, 1620, 1312, 1626,
          3586, 1627, 1325, 1632, 3589, 1633, 1339, 1509, 3488, 1353, 1859, 
         1860, 1365, 3547, 1679, 1849, 1851, 1850, 1772, 1853, 1854, 1852, 
         1858, 1857, 3632, 1777, 1696, 1697, 1388, 1708, 3599, 1709, 1401, 
         1713, 3601, 1714, 1415, 1719, 3604, 1720, 1429, 1729, 3607, 1730, 
         1442, 3574, 1740, 1741, 1743}], 
        Line3DBox[{1296, 1813, 1814, 1753, 3612, 1607, 1793, 1621, 1758, 3613,
          1622, 1794, 1628, 1760, 3614, 1629, 1326, 1634, 3590, 1762, 1635, 
         1340, 1638, 3592, 1639, 1839, 1862, 3633, 1863, 1861, 1652, 1817, 
         1847, 1848, 1818, 1829, 1828, 1830, 1823, 1824, 1695, 1822, 1821, 
         1778, 1698, 1707, 3598, 1699, 1856, 1710, 1782, 3626, 1711, 1402, 
         1715, 1783, 3627, 1716, 1416, 1721, 3605, 1785, 1722, 1803, 1731, 
         3608, 1788, 1732, 1804, 1742, 3611, 1791, 1826, 1825, 1745}], 
        Line3DBox[{8, 557, 364, 602, 2866, 23, 559, 370, 2777, 603, 38, 560, 
         373, 2780, 53, 2448, 376, 68, 2463, 378, 83, 2477, 565, 384, 604, 98,
          2491, 571, 293, 595, 113, 583, 312, 598, 2865, 128, 585, 419, 628, 
         2873, 143, 421, 2805, 158, 423, 2807, 173, 2547, 426, 620, 188, 586, 
         2862, 432, 621, 203, 2575, 588, 436, 555, 218}], 
        Line3DBox[{1299, 1467, 3468, 1300, 1477, 3475, 1315, 3522, 1487, 1329,
          3526, 1499, 1343, 3532, 1512, 1356, 3539, 1656, 1523, 1368, 3549, 
         1657, 1529, 1374, 1681, 1536, 3493, 1381, 1543, 3501, 1391, 1552, 
         1405, 3557, 1564, 1419, 3562, 1576, 1432, 3567, 1588, 1445, 3576, 
         1599, 1456}], 
        Line3DBox[{1301, 1468, 3469, 1302, 1478, 3476, 1316, 1488, 3480, 1330,
          3527, 1500, 1344, 3533, 1513, 1357, 3540, 1658, 1524, 1369, 3550, 
         1659, 1530, 1375, 1682, 1537, 3625, 1382, 1700, 1544, 3502, 1392, 
         1553, 3508, 1406, 1565, 1420, 3563, 1577, 1433, 3568, 1589, 1446, 
         3577, 1600, 1457}], 
        Line3DBox[{1303, 1469, 3470, 1304, 1479, 3477, 1317, 1489, 3481, 1331,
          1501, 3485, 1345, 3534, 1514, 1358, 3541, 1660, 1661, 1767, 3619, 
         1662, 1663, 1773, 1683, 1684, 3494, 1779, 1701, 1702, 3503, 1393, 
         1554, 3509, 1407, 1566, 3514, 1421, 1578, 1434, 3569, 1590, 1447, 
         3578, 1601, 1458}], 
        Line3DBox[{1305, 1611, 1612, 3471, 1756, 1615, 1616, 1318, 1490, 3482,
          1332, 1502, 3486, 1346, 1515, 3489, 1359, 3542, 1664, 1665, 1768, 
         3620, 1666, 1797, 1667, 1833, 1774, 1834, 1685, 1801, 1686, 3495, 
         1780, 1703, 1704, 3504, 1394, 1555, 3510, 1408, 1567, 3515, 1422, 
         1579, 3518, 1435, 1591, 1448, 3579, 1747, 1748, 1459}], 
        Line3DBox[{1306, 1613, 1755, 1614, 1757, 1617, 1625, 3585, 1618, 1319,
          1491, 3483, 1333, 1503, 3487, 1347, 1516, 3490, 1360, 1668, 3595, 
         1669, 1769, 3621, 1670, 1798, 1836, 1835, 1855, 1837, 1838, 1802, 
         1687, 3496, 1781, 1705, 3597, 1706, 1395, 1556, 3511, 1409, 1568, 
         3516, 1423, 1580, 3519, 1436, 1735, 3610, 1736, 1790, 1737, 1749, 
         1738, 1750}], 
        Line3DBox[{1449, 1592, 1739, 1727, 1437, 1581, 1787, 3629, 1725, 1424,
          1569, 3558, 1410, 1557, 3554, 1396, 1545, 3551, 1383, 1538, 3596, 
         1688, 1376, 3622, 1531, 1799, 1807, 1806, 1370, 1525, 1805, 1795, 
         1643, 3543, 1361, 1517, 3594, 1642, 1348, 1504, 3528, 1334, 1492, 
         3523, 1320, 1480, 3520, 1307, 1470, 3580, 1604, 1285, 1460, 1752, 
         1602, 1751}], Line3DBox[CompressedData["
1:eJwVzTFLQgEYRuEvwpoUsyCpwEwoh0hwaHMvc3LQJRqqoaWamvwFbk39gXZp
cZDGcAxccwkp2p2K4KZPw+F8573ce4vnt82bhYhooJeKqC1FlJYFKpmIkX60
VznBgW3ID7Zd/sW+7Zm7tg3O6R/uo2PLcNb2xNc6xVVd949jNHCCC8/+cOhe
Qxl7OLV9Y9V9790t3kTLNsWXbcf37rj+3/h0b9uuuKbf8OEu2C65ol+xqCf6
DEX9glk64l23saIHSGxjnfffdRy55wY3JXk=
         "]], 
        Line3DBox[{1455, 1598, 1746, 3575, 1444, 1587, 3609, 1734, 1431, 1575,
          3606, 1724, 1418, 1563, 3603, 1718, 1404, 1551, 3553, 1390, 1542, 
         1864, 1380, 3635, 1535, 1843, 1845, 1844, 1373, 1528, 1842, 1841, 
         1655, 3548, 1367, 1522, 1654, 1355, 1511, 3593, 1641, 1342, 1498, 
         3591, 1637, 1328, 1486, 3588, 1631, 1314, 1476, 3584, 1624, 1298, 
         3467, 1466, 1609, 1610}], 
        Line3DBox[{1870, 2178, 2041, 3740, 1871, 2051, 1892, 3638, 2061, 1905,
          3641, 2073, 1919, 3646, 2085, 1933, 2219, 2098, 1946, 3767, 2220, 
         2352, 1108, 1210, 1109, 2356, 2109, 3750, 1958, 2252, 2115, 1964, 
         3658, 2121, 1977, 3662, 2133, 1991, 3667, 2145, 2005, 2286, 2157, 
         2018, 3776, 2288, 2168, 2030}], 
        Line3DBox[{1872, 2042, 3688, 1873, 2052, 3694, 1893, 2062, 1906, 3642,
          2074, 1920, 3647, 2086, 1934, 3743, 2221, 2099, 1947, 3768, 2222, 
         2105, 1954, 2239, 2110, 3751, 1959, 2253, 2116, 3756, 1965, 2122, 
         1978, 3663, 2134, 1992, 3668, 2146, 2006, 3675, 2158, 2019, 3682, 
         2169, 2031}], 
        Line3DBox[{1874, 2043, 3689, 1875, 2053, 3695, 1894, 2063, 3702, 1907,
          2075, 1921, 3648, 2087, 1935, 3744, 908, 1025, 3231, 909, 1039, 929,
          3242, 1053, 950, 3757, 1966, 2123, 3723, 1979, 2135, 1993, 3669, 
         2147, 2007, 3676, 2159, 2020, 3683, 2170, 2032}], 
        Line3DBox[{1876, 2044, 3690, 1877, 2054, 3696, 1895, 2064, 3703, 1908,
          2076, 3710, 1922, 2088, 1936, 3654, 2100, 1948, 3752, 2240, 2241, 
         2329, 2242, 2243, 3771, 2332, 2254, 2255, 3758, 1967, 2124, 3724, 
         1980, 2136, 3731, 1994, 2148, 2008, 3677, 2160, 2021, 3684, 2171, 
         2033}], Line3DBox[{1878, 2180, 2181, 3741, 1879, 2194, 2195, 1896, 
         2201, 3704, 2202, 1909, 2207, 3711, 2208, 1923, 2089, 3715, 1937, 
         2399, 2400, 1949, 3753, 2244, 2396, 1250, 2330, 1252, 1273, 1272, 
         3772, 2333, 2257, 2258, 1968, 2268, 3725, 2269, 1981, 2273, 3732, 
         2274, 1995, 2279, 3736, 2280, 2009, 2289, 2290, 2022, 3761, 2300, 
         2301, 2303}], 
        Line3DBox[{1880, 2366, 2367, 2313, 2182, 2349, 2196, 2318, 3697, 2197,
          2350, 2203, 2320, 3705, 2204, 1910, 2209, 2322, 2210, 1924, 2213, 
         3716, 2214, 2390, 2402, 3778, 2403, 2401, 2223, 2370, 2394, 2395, 
         2371, 2382, 2381, 2383, 2376, 2377, 2256, 2375, 2374, 2334, 2259, 
         2267, 3720, 2260, 2398, 2270, 2338, 3726, 2271, 1982, 2275, 2339, 
         2276, 1996, 2281, 3775, 2341, 2282, 2359, 2291, 3777, 2344, 2292, 
         2360, 2302, 2347, 2379, 2378, 2305}], 
        Line3DBox[{650, 1199, 1006, 1244, 3299, 665, 1201, 1012, 1245, 680, 
         1202, 1015, 3226, 695, 1018, 710, 2934, 1020, 725, 1207, 1026, 1246, 
         740, 2961, 1213, 935, 1237, 755, 1225, 954, 1240, 3298, 770, 1227, 
         1061, 1270, 785, 1063, 3251, 800, 1065, 815, 3017, 1068, 1262, 830, 
         1228, 1074, 1263, 845, 3045, 1230, 1078, 1197, 860}], 
        Line3DBox[{1883, 2047, 3691, 1884, 2057, 3698, 1899, 2067, 1913, 3644,
          2079, 1927, 3651, 2092, 1940, 3745, 2227, 2103, 1952, 3770, 2228, 
         2107, 1956, 2246, 2113, 3755, 1962, 2119, 3721, 1971, 2127, 1985, 
         3665, 2139, 1999, 3672, 2151, 2012, 3679, 2163, 2025, 3685, 2174, 
         2036}], Line3DBox[{1885, 2048, 3692, 1886, 2058, 3699, 1900, 2068, 
         3706, 1914, 2080, 1928, 3652, 2093, 1941, 3746, 917, 1031, 3235, 918,
          1046, 941, 3246, 1057, 956, 3759, 1972, 2128, 3727, 1986, 2140, 
         2000, 3673, 2152, 2013, 3680, 2164, 2026, 3686, 2175, 2037}], 
        Line3DBox[{1887, 2049, 3693, 1888, 2059, 3700, 1901, 2069, 3707, 1915,
          2081, 3712, 1929, 2094, 1942, 3747, 2229, 2230, 2326, 3748, 2231, 
         2232, 2331, 2247, 2248, 3773, 2335, 2261, 2262, 3760, 1973, 2129, 
         3728, 1987, 2141, 3733, 2001, 2153, 2014, 3681, 2165, 2027, 3687, 
         2176, 2038}], 
        Line3DBox[{1889, 2186, 2187, 3764, 2316, 2190, 2191, 1902, 2070, 3708,
          1916, 2082, 3713, 1930, 2095, 3717, 1943, 2233, 2234, 2327, 3749, 
         2235, 2353, 1188, 1256, 1189, 2357, 2249, 3774, 2336, 2263, 2264, 
         1974, 2130, 3729, 1988, 2142, 3734, 2002, 2154, 3737, 2015, 2166, 
         2028, 3763, 2307, 2308, 2039}], 
        Line3DBox[{1890, 2188, 2315, 2189, 2317, 2192, 2200, 3701, 2193, 1903,
          2071, 3709, 1917, 2083, 3714, 1931, 2096, 3718, 1944, 2236, 3719, 
         2237, 2328, 2238, 2354, 2387, 2386, 2397, 2388, 2389, 2358, 2250, 
         2337, 2265, 3722, 2266, 1975, 2131, 3730, 1989, 2143, 3735, 2003, 
         2155, 3738, 2016, 2295, 3739, 2296, 2346, 2297, 2309, 2298, 2310}], 
        Line3DBox[{2029, 2167, 2299, 2287, 2017, 2156, 2343, 3674, 2285, 2004,
          2144, 3666, 1990, 2132, 3661, 1976, 2120, 3657, 1963, 2114, 3656, 
         2251, 1957, 2108, 2355, 2363, 2362, 1953, 2104, 2361, 2351, 2218, 
         1945, 2097, 3653, 2217, 1932, 2084, 3645, 1918, 2072, 3640, 1904, 
         2060, 3637, 1891, 2050, 3636, 2179, 1869, 2040, 2312, 2177, 2311}], 
        Line3DBox[{2034, 2172, 2380, 2348, 2304, 2023, 2161, 2345, 3678, 2293,
          2010, 2149, 2342, 3670, 2283, 1997, 2137, 2340, 2277, 1983, 2125, 
         3659, 2272, 1969, 2117, 3779, 2406, 2405, 2408, 2407, 1960, 2111, 
         2393, 2365, 2385, 2384, 1955, 2106, 2364, 2245, 2373, 2372, 1950, 
         2101, 2325, 3655, 2224, 1938, 2090, 2324, 3649, 2215, 1925, 2077, 
         2323, 2211, 1911, 2065, 3766, 2321, 2205, 1897, 2055, 3765, 2319, 
         2198, 1881, 2045, 2314, 2369, 2368, 2183}], 
        Line3DBox[{2035, 2173, 2306, 3762, 2024, 2162, 2294, 2011, 2150, 3671,
          2284, 1998, 2138, 3664, 2278, 1984, 2126, 3660, 1970, 2118, 2404, 
         1961, 3754, 2112, 2392, 1220, 1221, 1218, 2391, 2226, 3769, 1951, 
         2102, 2225, 1939, 2091, 3650, 2216, 1926, 2078, 3643, 2212, 1912, 
         2066, 3639, 2206, 1898, 2056, 2199, 1882, 3742, 2046, 2184, 
         2185}]}, {}, {}, {}, {}, {}}},
     VertexNormals->CompressedData["
1:eJzsvVdYVM/yBYoYUDEiBowYMKFgTsi0AmZFMWHEiCiYxYABEFFREMVEMucs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      "]],
    Axes->True,
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(x\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{Automatic, Automatic, Automatic},
    BoxRatios->{1, 1, 0.4},
    DisplayFunction->Identity,
    FaceGrids->None,
    FaceGridsStyle->Automatic,
    Method->{"DefaultBoundaryStyle" -> Directive[
        GrayLevel[0.3]], "RotationControl" -> "Globe"},
    PlotLabel->FormBox["\"m=-2.5\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-Pi, Pi}, {-4.499999999999844, 
       4.5}}, {{-3.141592653589793, 3.141592653589793}, {-3.141592653589793, 
      3.141592653589793}, {-4.499999999999844, 4.5}}],
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    Ticks->{Automatic, Automatic, Automatic}], ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1XXmcz9X6H2Mny02Lum20iaJFm+g5oZL2hUqhIkuLtCktqGhT3VISqeRW
Ei1UpCbnq6tuMoUs+WqUJTGM3WAY/OZ75/N+zu+8fR//zGvec5zlfZ7zLOec
z3Ma3HbPNbfn5uTkrKydk1Ox7Od//1W1/u4G1VP4OXHvvrJ/dVJP12py7m/P
V1b83EvOWH1fjzqpC4de0enzrRUUX3DO7OM+HVcrVe3Av7YfNa3UA//57zeW
HLuxRlJPseIP9vrolqdfqJqUL1J87sPNv/6yYqUEL1C88tQuX006vkIqJ/kH
/Mh9//vnk/LC5ZP6hetP+iPZ+1Mq3P9kvI7Hm/DjmJ/kd8d84nfwivL4HT8/
7HbnN0fPqa0869+rFHz93SGBZ+DNTi4at75n4Bl49+YdZFbdwDPwX/eMfWLZ
sIrKM/B78yuc0zcvR3kGfuqALhvePD3wzOXBM9cPnrP3p1S4/+CZxwuemR/w
zHyCZ/BH8xV4TerH7/j5brf5H87qW1N5Bj5iQO6bs5dWU56Bv//aTd/dNq6y
8gz87QMPfbN1u1zlGfjrV//YvEetfR48A59x7IOD8xaUKs9cHjxz/eA5e39K
hfsPnnm84Jn5Ac/MJ3gGT/F61/Y9za/i6A9+x8+nfhkwaOoDVZRn4G/fV3XQ
7j4VlWfgf1/V/arLW+Yoz8B/G/HTaf1O2a08A6/43WHt/1OpRHnm8uCZ6wfP
2ftTKtx/8MzjBc/MD3hmPmO9Ueyhr2K9UeyxvmK9UexJHjxw9D/WG8X+wLsm
vn/MmBzSG8X++IdP6tDxbPBToPjpqTa/3Fh/u4/1RrFvsemUr8ds3Up6I5SP
9UaoP9Yb3J9S4f7HeiOMN9YbgZ9YbwQ+Y3ku8rG9COsb+i2W5yIfr3fIcxHL
j+Ixn0X6c9Ouko979Cz2sTwX+eF/fdvxzOabSJ6LfO/ud9ZJzVxH8hzKx/Ic
6o/lmftTKtz/WJ7DeGN5DvzE8hz4jHku8LDXMc8FHvYl5rnAx/pQ9aWu35jn
ApY3xWN+CvTnwivnvVZ57F/Ec4FvPeyvd15+tIB4DuVjnkP9Mc/cn1Lh/sc8
h/HGPAd+Yp4Dn+AZ44C/BJ6Bw76DZ+CxPSpVPqA/wTPweL0XKU7yqTj4zDH+
gWcuD565fvCcvT+liqP/4JnHC56ZH/DMfJI8iyHPYsizGPIshjyLIc9iyLMY
8iyGPIshz2LIsxjyLIY8iyHPYsizsDyjX4Z+FkM/i6GfxdDPYuhnMfSzGPpZ
DP0shn4WQz+LoZ/F0M9i6Gcx9LOwfkb7hr8hhr8hhr8hhr8hhr8hhr8hhr8h
hr/B60W4fvI3xPA3xPA3xPA3xPA3JLu/USqG/yyG/yyG/yyG/yyG/yyG/yyG
/yyG/yyG/8zrS7L3R/1nMfxnMfxnMfxnYf8Z9RnxoDPiQWfEg86IB50RDzoj
HnRGPOiMeNAZ8aAz4kFnxIPOiAedEQ86Ix50HA/i/xn7G87Y33DG/oYz9jec
sb/hjP0NZ+xvOGN/wxn7G87Y33DG/oYz9jecsb/hjP0Nx/sb+LuxX+eM/Tpn
7Nc5Y7/OGft1ztivc8Z+nTP265yxX+eM/Tpn7Nc5Y7+O17tjfmi/Tvksrz/f
4+ejD42fWdx9AX4XA9e/G+UV/+CKkY16d6yaws/j+3xRfdPkOqke+XmXXOgr
Kv7V6Qcf3G1wbf0dfwcOecDfJzRru/H2NORhlbZzR5PtD717ba6OC/hx2y6Z
1/30HMVR36yuRz955WWKi1FeuHzSrnC7wFH+6K01zvm9Ty7G44zxOoMfBx4G
/OPO0Q91qaXlUT94wLwyPyjPfII34Fc88fRTPR+roPwA3/PngH1Nftqr88s4
xsv1QA6BT75s8LaGB4d2j2u/7I4GjXJSJ+bMHDhj6j6VK+DrO7/d466Pdmu7
jKNdrgf1l/NR4j9Y8erTlx6l9Sg+99XjGtQ7dYeP5zfg8TzuX0/5+tvsNyy6
9I3Kb27WehhHPcBv+7XXkYf/q1jlEv2F/ABXPhI5jO3OKk9ypTj4B456MF/g
C+XBG3CUB88Yv66zhAfgKE98avmRi/dt+/CVv5UfxsEP8LHHfLrqqkc3kj4p
8KlhV729+rBlWh7toJ6EX60HPANHecxL0n8xxiU8roQfZ/DmmDesX2NeHM8L
1qkhD47lgeREWE5QHvqK5EFYHoDzvAMHD5Bj5pNwIfn3PF+EC/DYD8/3J382
c8Pn44N9wt9jvEDnC3KCerk8yY+w/HD/SR6E5YF5o/lVnmO/PcwLza/w/KK/
kAeaX+H5RXnIG613gdzSuhbIP+YRONZRHDflC61HLY/1S/MoPI8oD/5pPWp/
aN1p/2l96XiJZ2GeLT6BQ6/GfvUque/xbsfdcf1a1mPU/+qO6wE/kK+YT7Uj
YtiR/dYReDLsmhh2TQy7pvWQXXaGXXaGXXaGXdZ6yK9z8EMgt8DJz9F5M/xG
Z/gzzvBnnOHPOMOf0XrIj3KG/6b9RJwCfNsRi3v3cuqPqZyS/6blDf/WGf6t
g96I5aS6i+VZ/Vtn+MPO8G+5XbHKc7vk99J8VXbMD/mxjv1Y5o34pLhA+U8x
//g7cOItxXoA/29a7sg2l9QMcR/wJqOWDnw8P8R9XJ7Gq+3Geqyy+smxvgr9
RH+wDgqPrzvl4hYh3gfebPZhk9o336v94fKoB/ah1ZH3fD213R7V28CXVkw3
61xf9yeFy8dxcYk/7Yh2H3aZuVPrAS5nrT7v7THbtR6rPOxP9y6f7+lZZbOW
B5666a1O15291cf+T4EHz7GfU+Ax3tjPKfDof+znFOzXH8jF4mkfj2x/7Crt
D3DYhdivKFA89isKtP+xXxHajf2K0M/YrwjjIrujcUHsVwR+wBvGB7kFb8Ah
P+ANOOQBvAHH/GKegGMe0T/g4BO8MQ7euB7wxu2CN+4neONxgR/mgeRKDLkS
Q67EkCvB/MZ+coFAHmJ/uID9jVA+8btIfsSQHzHkR/tPciKs3zA/JP86P+g/
rV+h9av9NfSDGPpBy5O+coa+coa+0vLQp+CD9K3qadLPiqM86WFn6GFn6GHH
/HO7ZHecYXecYXe0fOxvV06d2viu8dtn7SM/dj9cz8kvabjqh5m99pBfuh+u
57o/+vrXHT48xI2Mx+c++R7txuc++T6uv1TbievHeUrA4/OUUE98nhLapf6I
0R8x+iNGf8Tojxj9EeYf9Rl8Mq7tGPPFuLZvyAPhefozf86fo5ddNxO/i4Hr
343yikOe8f/6bX312zZfhv+PvwM/656rjjm9ZbUUfh51+4TunxRhvYS/H/HF
H4fNOwB6OU8sHP5e06/rX3VhvRzU66z6txfdf0Ht9yulGtb6pfVfq/ZqPw3c
f3HHiNvW1qqQurVqlxWlJ5RqecYPabri1DF9q2g7LYb9teatyfsYF+DoH8pj
XIsmVL7msXSu4pMan3NJnSl7POECvNG11/z92eDQ344vP9dvZqtdjAvwcnla
rnjPF+4ZNa3BCv29XH4W+u92NRnxzMRFWi/PY1JO5QflE14ccPBDuABPeNfy
4J9wAY75Zd4IF+Akn4L+x/sMeQL5Qb0JT8wPeFU+8f8NHPPmMF8ozzitC8dy
m8iRg/ygHgNXnpif7PXr/pvw/hv7LeTP0H6d7i/52M+pruu95TUr63TcHsbF
6xfyh/KHzm5xTtexIc4F/uLfvv/8C7W8cHmME/WjXZRDOyiP31meCRfgJD+e
9Q/XH8tnvkf/SQ8IzZeOj+pRu4Z60A+Up/UrjFM/96sf4wNvNC8unhfVzypv
NC9UPl9x9B/tAWc5gR415J9x1ZfGumNc9aWxrhlXPcr6k3HwCT20e3WLmUds
3ad2yNB7yitw2BtDr2p54NBfKI/+EK76DfrLsCNaHjj0l2GnVK8Ch54y7KOW
53mE3TDsL+NqNwz7rjjmA/KGeSH5V71B5VMoT3K7X3nMZ++NI15d6EO7mLe6
dZvevqBCKenVIn/szyf0611xPelhxuH/FPolFToce/mCNcoD43G8Vuj/8WfV
e1Y8vkbXFf5+w4ZfrrjgBb4vGvQb1g/Kf/f12xPvfDn4IcAPWNR084GH7edv
sBxq+Xf2/rvBxKmhHPshKAf8vnbDF//WdyH7IUJ6W/1PlE941LgDfCa8qPzH
fGp5McoLygNHu+AZ8goc8w65BA45gVyy3iA9o+sX5YCDT+BYx5gX4FivmEey
147lGesVckJ23LEdNOyI2qOHn55RYej0P3S+8RM42YtUdrsZ7Cn+P887ybP6
eyRXgvJkr8nOqh/iyP4K80C8pcAb8Z8C/zRfnucL6wbzC/3C8gP9wvIGPWLI
vzfk3xvy71n+IX+8riF/wDEuyB9w8AA5Ax7Lm+pJMfQk4aoPhfSkMI72sF7B
G3CsV/Ac66tVvlKXXW/3e2IV7QfmCXDUg3ahH2I/bZWWB8+Qz/7dL/lxyE3r
iP98eWTCpZPy5oT5K9832yTnzN67pkqbjYqDnxUtU3fvPbhI+5n9/oaen9I+
+UJtH/2heyBC9ShO9Sj/cT0LVb8te+OpH45uEPaZUV+8P79cy79y5Lg+H+0r
9PVPaXtdZr3jZ7IK3Kav8u/K7BcB//iDa3be16OO+7FthyGZ/SLgD06u5D4d
V8u5d7857+hppVrf0SsH7jx2Y42knmLFF26/6pGnX6ialC9S/K161//0ZcVK
CV6g+N1Pv/HtpOODPYj7mYPywuWT+oXrT/oj2ftTKtz/ZLyOx5vw45if5HfH
fOJ38Iry+B0/P+rSZOnRc2orz8D33V6w6rtDAs/A7643aMH6noFn4Ke981CP
WXUDz8BPGnPa28uGVVSegTeuva1d37xwrgC8d+ENlUefvk/AM5cHz1w/eM7e
n1Lh/oNnHi94Zn7AM/MJnsEfzZfiqB+/4+c7/25XMKtvTeUZ+Ielt82ZvbSa
8gz8lem/bbptXGXlGXiz9/Knt26XqzwDrzWjpHuPWvtUvwPve/Ps8XkLSpVn
Lg+euX7wnL0/pcL9B888XvDM/IBn5hM8g6d4vVdWnOZXcfQHv+Pnk5vHfjn1
gSrKM/Cqj43+dHefisoz8N5vrnzw8paqBxTvNqe0R79TdivPwC/9o/KD/6lU
ojxzefDM9YPn7P0pFe4/eObxgmfmBzwzn7HeKPbQV7HeKPZYX7HeKPYkDx44
+h/rjWK/5uCv5x4zJof0RrFv+0ilUR3PBj8Fildau3HfjfW3S6w3iv2v64eu
GLN1K+mNUD7WG6H+WG9wf0qF+x/rjTDeWG8EfmK9EfiM5bnIx/aisuLQb7E8
F/l4vUOei1h+FI/5LFL8gbU3rerRs1hieS7ytfvVH3Bm800kz0X+PxPuvTw1
cx3Jcygfy3OoP5Zn7k+pcP9jeQ7jjeU58BPLc+Az5rnAw17HPBd42JeY5wIf
60PwXKDrN+a5gOVN8ZifgoDv/vq/lcf+RTyX+XcX5q58+dEC4jmUj3kO9cc8
c39U32v/Y57DeGOeAz8xz4FP8pN0OOAZAOw7eAYe26Pg10N/gmfg8XoP3wuT
fIb9iYTPHOMfeOby4JnrB8/Z+xO+F0b/wTOPFzwzP+CZu0nyLIY8iyHPYsiz
GPIshjyLIc9iyLMY8iyGPIshz2LIsxjyLIY8iyHPwvKMfhn6WQz9LIZ+FkM/
i6GfxdDPYuhnMfSzGPpZDP0shn4WQz+LoZ/F0M/C+hntG/6GGP6GGP6GGP6G
GP6GGP6GGP6GGP4Grxfh+snfEMPfEMPfEMPfEMPfkOz+RqkY/rMY/rMY/rMY
/rMY/rMY/rMY/rMY/rMY/jOvL8neH7UzYvjPYvjPYvjPwv4z6jPiQWfEg86I
B50RDzojHnRGPOiMeNAZ8aAz4kFnxIPOiAedEQ86Ix50RjzoOB7E/zP2N5yx
v+GM/Q1n7G84Y3/DGfsbztjfcMb+hjP2N5yxv+GM/Q1n7G84Y3/DGfsbjvc3
Yn9kv/06Z+zXOWO/zhn7dc7Yr3PGfp0z9uvwO+/XOWO/zhn7dc7Yr3PGfh2v
d8f80H6d8llef77Hz4aDNhUXd1+QyEm+GDjKi1Fe8Ur3P3tL5h4mfnbY3v2I
TZPruIK9dftn7mECn3T2yWd2G1zb4Xf8HTjkAX9/veX7O29PY92t8sCHVKn2
3LvX5uq4gLfptG9x99NzFEd9j17+7FNXXqa4GOWFyyftCrcLHOXX3Tuk9e99
cjFeZ4zXGfwoTyNnHzvroS61tDzqBw+YV+YH5ZlP8Ab81SVnvd3zsQrKD/D5
b3/e4OSf9uq8Mo7xcj2QQ+B5i5f889iDQ7tfPD/ylf/ds97Tc/qMqftUroAf
feonw+76aLe2yzja5XpQfzkfJb7z7UtnXnqU1qP4yJu6X1Hv1B0Sz2/A43nc
v57y9bfZ3/9yQ1/5zc1aD+OoB/hLW0+69vB/FavcoL+QH+BoB3IY251VnuRK
cfAPHPVgvsAXyoM34CgPnjF+lAcPwFGe+NTyg/f2aDz+lb+VH8bBD/BLv+l5
5tWPbiR9UuBH1vzn96sPW6bl0Q7qSfjVesAzcJTHvCT9F2NcwuNK+HEGb455
w/o15sXxvGCdGvLgWB5IToTlBOWhr0gehOUBOM87cPAAOWY+CReSf8/zRbgA
j/3wfH/vPaec8cX4YIfw9xgvCPOVyAnq5fIkP8Lyw/0neRCWB+aN5ld5jv32
MC80v8Lzi/5CHmh+hecX5SFvtN4FckvrWiD/mEfgWEdx3FTGQ7wetTzWL82j
8DyiPPin9aj9oXWn/af1peMlnoV5tvgEDr0a+9Wr5IHmD99+x/VrWY9R/6s7
rgf8QL5iPtWOiGFH9ltH4Mmwa2LYNTHsmtZDdtkZdtkZdtkZdlnrIb/OwQ+B
3AInPwf+njP8Rmf4M87wZ5zhzzjDn9F6yI9yhv+m/UScAvytyccP7uXUH9M4
hfw3LW/4t87wbx30Riwn1V0sz+rfOsMfdoZ/y+2KVZ7bJb+X5quyY37Ij3Xs
xzJvxCfFBcp/ivnH34ETbynWA/h/V3U878pLaoa4D3jXet1feDw/xNdcnsar
7cZ6rLL6ybG+Cv1Ef7AOXt/SZPbFLUK8D/xp6Ty3ffO92h8uj3pgH9p+0GbD
1HZ7VG8r3qnWjZ3r6/6kcPk4Li7xZ78+uaDLzJ1aD/CfzxvY4+0x27Ueqzzs
z/M/N2jYq8pmLQ/8jj7zn7nu7K0S+z8FHjzHfk6Bx3hjP6fAo/+xn1OwX38g
F6Xje//U/thV2h/gsAuxX1GgeOxXFGj/Y78itBv7FaGfsV8RxkV2R+OC2K8I
/IA3jA9yC96AQ37AG3DIA3gDjvnFPAHHPKJ/wMEneGMcvHE94I3bBW/cT/DG
4wI/zAPJlRhyJYZciSFXgvmN/eQCgTzE/nAB+xuKw+8i+RFDfsSQH+0/yYmw
fsP8kPyr34L+0/oVWr/qnxj6QQz9oOVJXzlDXzlDX2l56FPwQfpW92lJPyuO
8qSHnaGHnaGHHfPP7ZLdcYbdcYbd0fKxv105tWhCh/9sn7WP/Nj9cL3HdUGl
EzbO7LWH/NL9cJyn+AmDZj1x+PAQLzEen/vke7Qbn/vk+7h+nPvkU/2lwnh8
nhLqic9TQrvUHzH6I0Z/xOiPGP0Roz/C/KM+g0/G9ZzFmC/G9bzAkAfC8zx+
XjL0i5+XXTcTuBg4yotRXnHIM/7fuh+vzG37ZSiHvwOvfVWPTpl7/vh5Tc+7
+3xShPWS54HnzXr8yHkHQA+G/8c4/L32Pz2QuZ/vknLOqv/v3zfcl7lfP+uK
rV3+WrVX+2ngfnrPh4Zm7t2vX/l+jT0nlGp5xncN/6hH5nsA/L/qj47b/dbk
fYwLcPQP5TGuXxucMTDz/QDwWjcNvavOlD1CuAC/7qaHmk0avFfn96uc4e/O
bLWLcQFeLk/LFX+icq3vpzVYoeMql5+F/rpzOv38zMRFygPPY1JO/47yCS/K
N/ghXIAnvGt58E+4AMf8Mm+EC3CST0H/432GPIH8oN6EJ+bHJ7wqn/j/Bu6T
eXOYL5RnnNaFY7lN5MhBflCPgWMdOeYne/26/ya8/8Z+C/kztF+n+0s+9nOq
63of2P/7gzpuD+Pi9Qv5Q/k6R4w6v+vYEOcCf/yDewbMv1DLC5fHOFE/2kU5
tIPy+J3lmXABTvLjWf9w/bF85nv0n/SA0Hyhn0L1qF1DPegHytP6Fcapn/vV
j/GBN5oXF8+L6meVN5oXKp+vOPqP9oCznECPGvLPONZdylh3jGNde2NdMw79
4Fl/Mg4+oYcu6zP9pyO27lN7Y+g9lQfgsDeGXtXywKG/UB79IVz1G/SXYUe0
PHDoL8NOqVwAh54y7KOW53mE3TDsL+Ow786w74pjPiBvmBeSf9UbVD6F8iS3
+5XHfHZyez5Z6EO7mLdu10x7YUGFUtKrRf7Sa+d91bvietLDjMOOFfp/P3jK
zZcvWKM8MB7Ha4W++/hPPljx+BpdP/j77UPm33LBCzoulTfoN6wflL/oxdPn
3Ply8EOAz+z/5D/rHbafv8FyqOVzW5a2nzg1yCv7ISgHvM0Zj9Vc3Hch+yFC
elv/H8onPCrf4DPhRduP+dTyYpQXlAeOdsEz5BU45h1yCRxyArlkvUF6Rtcv
ygEHn8CxjjEvwLFeMY9krx3LM9Yr5ITsuGM7aNgRnZ8fvs27bOj0P9TO4idw
shep7HYz2FP8f553kmf190iuBOXJXpOdVT/Ekf0V5oF4S4E34j8F/mm+PM8X
1g3mF/qF5Qf6heUNesSQf2/Ivzfk37P8Q/54XUP+gGNckD/g4AFyBjyWN9WT
YuhJwlUfCulJYRztYb2CN+BYr+A51ler/PuHrJ/b74lVtB+YJ8BRD9qFfoj9
tFVaHjxDPv8emF/96ZvWEf/58tmdL6/PmxP0V/m+2Sb5/r49p1Rts1Fx8FP8
3s6Jew8u0n5mv7+h56e0T75Q7Qv6Q/dAhOpRnOpR/uN6FqoczTit8q6jG4R6
UV+8P79cfy6v/t6nH+0rlAfHfVP4zZ7wvu2vIyttu3dd7RTWG/IHrF3Uqckt
hwYc5R9Y917dJYNrpbqc0+GkR+4I+TNOemXr6Tdsq6k4yufXazTh8d41U9g3
RvnpN1ZtsbBVdcVR/rHjPvjXTXnVkna3aPm7Zz1yzjnnVlEc5V/v3Lj2sBm4
N1mo5R/6o9vT7c6tqDjKHz2ywaNtl+YmeFrLnziuS9MbN+YA13yDt/9rSu6r
TwMvFK4n6Y8Y/ZTs/SwRgwdhHhI+xeBZmGfoDZ7HZN4V79K3x5RmT9UBru/S
XN+791XLGtXSeQc+6PR6ue2WhPkFvntp091rF4R5BL55zbuXjGhdVecLeOMz
F/84pVslnRfgJ3zS/4c/RlRQ/oE/8sMZy1q9t1f1FJcHz9nrLxHuD3jj/oM3
Hi94Y37AW/l3+qX+3E9y+y14uIbyBrzfBaNPu85VV96A3/D1lGOPvrmq8gY8
75O3RqY3V1LegLfZ0a71rvNylTfgg3JavTnv+H0evAH/o7D2BV3/u0t54/Lg
LXv9JcL9AW/cf/DG4wVvzE+sf4p92xvfWOuOqUp6pthPf6Dz/XkVqpA+KfZ5
xza7qmHbSqQ3iv3kY3o1fqlqLumHYj+3YO91haUqP4pfM3VtuxEbS8Cb4u/9
Vz77bn6xj/UA44XC9cTrndstEe5nvH7DuMAn8wA+mbdYDov8CcNOabZ7TEWS
wyI//+Rdx60dlUtyWOa/3L/01lk5FUgOi/zsHbXG7fxtj4/lsMj33VLtzZur
l/hYDov8n7ftunvU4dtIDot89d4r7278r40kh6F8LIdcf4lwf2I5DP2P5TCM
N5bDwE/MW4EfPXzLUyfMzSHeCvxJf323dVdqn495K/BLc+4fvHpGKfFT4N/Z
8cRF+Su2Ej8FvumDX7wxr9964qfAb8g9o/HegSuJnwJ/a+P5b67tup74KfAl
C1K/D9+4lfgp8BefPm1uJv8wxgV/Ks+f8HmfrkE/AO9/wZUPNd++WNsFfv8X
FTJ+l7YLfHeP96+eMmOztgv80ssqd8/kQyY+xeBTDD4FfBI/YvAjBj8yJuI/
5J1mfpAfxlgvYqwXMdaLGOtFjPUixnoRY72IsV7EWC9irBcx1osY60V4vST6
Rwy9LYbeFkNvi6G3xdDbYuhtMfS2GHpbDL0tht4WQ2+LobfF0NuSXW+XiuE/
iOE/iOE/iOE/iOE/iOE/iOE/iOE/iOE/iOE/iOE/iOE/CPsPyBdt+KvO8Fed
4a86w191hr/qDH/VGf6qM/xVZ/irzvBXneGvOsNfdeyvIm82x33Ad347adOW
4bU4jnMcxwHneA04x2XAKf7SPN5GnOU4zspev8ZNjuMm7n+8Tis7xLPgB3nt
EB9RXOwQT1H86xCXUZzrEN9RPOsQJ4IH4HEcWqg44lmKN6kejSu1XYoftZ8U
JzqKE/Vnk/ZHFdarFng48L06XTL7ddv+Lqz56s9BTiaN6fbr4JVVUqle825Y
9E7g4cq3pl6UuX/0w/Q7Pt6+L8jJ+pE1v7l8VtXU3UfWuGhN7cDDcTUGfpxp
97VFr9+yfmTg4bsq8xtk2s0f3brqBVuDPNxS8cTXM+2+Xv3NnBXrgjzs3fdI
jUy7D/jWR7TYFeRhdOkvAzLtntmy/ZB93+p6STU//s8ab/TITV3a6Mbdje8L
+gQ/7zm04Pqu7Q7Q8fY96pmtt1xWMXXa3Bb3N7q/ho639j9/75m5V1V7V07n
D6uG8U48tFnBSadXSh1SvPDP1y+srONd+czYX0aUtVtzw78+HBHsnTwxeHvr
TLsH/156cIcVQW8c/UT7qZl2P3rr5B2T/gx649vH326SafeWehc/1n5H0Bs3
PbLlnUy7rzc44gw3O+jPvy+sfMOat/f4r9q1qPr3nGB3GsrHLrO/esyww9+o
XhTsDn7mHbbyqfOvrabj/fmNvc9m7glWKj70m24nhP2ZO4dfs6fymzmpG8Z+
mW7xTkUdb9uaL/y5uqzdSb225n1+2W4d76BKzX/M5IEcV/mymocekKPjzdvz
+2f9y9o9+Pk7T+uXU1HH+9juGZdl2v1o7ImNatVWf0MO33nwjEy7eE8Zcv7V
tt5nZvZ9Fy1/7c1hTYOe7Lj52/G/DKqQWvzLaf6XeQcoP90vuGzUmL7b/Yxj
np392gvBzxnTYtuTvTvu8HtuGTp1yG/Bzyk4Y/Sdp7fc6d+55sj/PPewyqHe
H5578942dz2v69dfd0JRy5lVd/mndowd/K0EO1Iu59v9rC97HNWuy3blp1ye
d/gT/Wcb5jberfa3RUnDraeVtduoz/G9Jj2So/z02/LT77vK2sW73uBn8rr7
Zv6nrN0Hh/742dQTqyg/G/46/OMX1u/yZ3fos/75O6opP43/+G54h/m7fd7f
Bw4fdECQn5n9T5g2afAG/1XtPx86+ED1f1JHnXXe9w0abSrrf8dB3R/Rdn2n
Zis/Xltrs39kwuZXH2yrfoJ/vdHQ1zP3Rucce/LT1w7ReVc/+ojr/xi18ZdS
9QPL19dWf1HB9DYv9dupfku5/GzwtXq5Wwtf3KS8lcvJJv9q5+7d3aPFylu5
PGz2eHcevG1b/4+jMv35ced3O87qk6O8nbp6WpVMf55cd/hRGTkEb3ctu3Vj
27L+/Lgup37rhqo33Yfp6otrvb/NTyr4+90TPlU/MJXq+0Wrho2W+TpHTp7S
sqH64amzu1Wq88XW5f7t4y8e9OIT2q6f3OG6ZRf6lf6crx+r2Wz4XuWlXA5X
++tfqn5e40N2KA/l413mBx4yvfuGI1cpD+XjWu4LenSat3TzRuWhvP8rffOh
XereMalYefjr10mpRZnvAa8f9kzm3T30/8dHTzju5GkTfaWme6u9dV/wGwed
uO+gI8vwDX1aX3bAa+mwrv+H5/nZFd6/LpN3FO2O6eznLHz+e78g75IBJ5+2
RdstL5/vLyz4XTLvAKLdf7Xuel9JWTvLFgy4ImMXwNvY/9WzUD78zzP1Zq3b
q3rq44ePPmXy1nkyo84HK5sO3a39xM/mPXZNeT9nhfazUbv3Jv0vX+8nPxxb
4/F12s9z/jcv86TftIv/6PR16OfLpT8uPmZavhw8+qDu/7+fl330bvMX1q+V
1yeOGlW3TYgrF069utuusnZGvd5293Vl+lzXxfcVhvXquFq+XXTOVztWBz5f
Pvq1418sq+eMk93tO5ev137i5weHrfXPDNsS+CyXB4nloSQZ1yr5+fdbl/3/
eUzkUyYn8ol+JvIskGf0M5F/gfxj/SbrRbBeIJ/J+pJ4faWl/UFPXVW7rN23
e42aX6lkm44rWdeCdY1x4WesB0ok0RsCvYF1mugZgZ7BOk30kkAvYZ0mekyg
x8BPovcEeg/8JHpSoCd1nZbrVYFeBT+JHhboYfCT6G2J9XZa8uu3rN2xrN3V
9TsPOLJpiL/K5WGX5J8/3N0/W/cZJLEjEtuREr1nDrsDfhI7JbBT4CexawK7
Bn4SOyiwg+AnsZsOdhP8JHbWwc6Cn8QuO9hl8JPYcQc7Dn4Suy+x3U/LuJd2
rcq0W3rqfXPGNQ/+UvVhH9ybaffiT+bO+MeBwV9K/BAX+yElkvgtDn4L+MFP
+DngJ/GLBH4R+En8KIEfBX5G3D/q2S2HVnaXvdTmub55Ic7a1e+igzLnpEce
/tnpb7UI/nPipzn4aeAn8esc/Drwk/iBLvYD07Km7m8zM+226vDKpyN7BP+5
fN1Vctta1D/ovWeC/5z4pS72S0uS9VjRwY8FL4nf6+D3gh/8hJ8MHhYX9+t5
yKfV3EmXjjxnWP8QR5TLfzX3+K1jT69+SIinEv/cwT8HD4k/7+DPg4fE/3ex
/5+Wk179/N+Zdgd3HvVYtb8CD0Nf79oscz/hmKWtxk1oEuKpJB5xcTxSIkn8
4hC/gIck3nFxvKP2xXe5e0e9Y6vAvqRV/wEnflIGPynwQ3KVglzBL0rGlcK4
gHPchP5kj7M0Dk1xHGrUL3zeCjng/gPn+BHriHkAbsShLllHKawjksPU9oNO
nD+mp8qhY96Ac9wH3pL1ksJ6Ac5xGfhM1l0qXndpnz2+03WaMtaptot+4n2/
QUvuqL711DDvid5LQe8B53gK/Un0ZyrWn2mfPS5TfZsy9O1+7SZ2ysNOAef4
Be0m9s7H9i7ts8dBah+9YR+p3XQyj9t87G+kffZ4Qf0Tb/gn/uT53/Y6p9tO
9vc8/D3yVz37q4kf6OEHkh/r2Y9N/EMP/5D8Wx/7tyU+8fc8/D3g7M8DT/xY
Dz8WOPvh4C17fKH+ql983ru9vt6yn7/q4a+Sv+3Z30Zc81nOs/edVLKd/XDP
frgxXuFxqX+YnU/hOAs48wx8yunPvZoui19m+Gs+qr9tl37PYMyv4/gOOM87
8GfnDRt9XFnc1OrGJwZm3hWCHjDkzXFcCdySw6R+Qf2Qq2RcgnGRPEgsDyo/
GgfBLvN8adxKcR/hwnj2+KvQs/zE5xf5/rZdJ9U9zC3leFOMeFPHRfOrPJA8
aFxJ86V80vxqfErzovEs7Q+IsT8gxv6AQG5pvQuvd44HwXOyDyDYB6B9BsF6
hB7Aexy3JjxjXpJ9BsE+A3COW0mfCOkTj/g31ie6L6HjovUrvH45vqb1KLwe
OU6n9SW8vjjeR//xjscQ6bym5HYdfzLeTYL9KNrXEtgXslNCdspnj6N1H4zK
q/2V2P6qvRa2m4n9FbK/Pnt8qvuWYuxb7tdu4p9I7J+oP+Niv0L9EyH/xGeP
B3WfWYx9Zm2X9v+dsf/vyJ/U+TfORxz8W/IbXew3qp/pYj9T/UZHfqPPHt/p
OYIzzhG0XfJ7dbzkJzv2k3m85Lc78tv1vejLf97cpUbnOhyPuDge0fjFxfGF
ximOzoM8n4uBh+zl9Z7nfudr3B+KU3QeKa5xFJc5Hi/dt3R839K6h4n3vWPe
0vre+5DiYY3rLgzzzjj1R+uhc88Uznnj+wnhPjDaRdyxu8muS3dXCu0aON49
Tz03qm3RccvDfR4D1/fn39t+1M+Xdg37+RaOd+lfu+anz9xcteN6zwr3fFAe
7zpBD8f3EPgeF+4hhHtf8T2EcE8M7fI9KNjN7PemChWftqzJC5UfWKP9AV7r
letbfPVG8CeBrx67KD/zXhiNV+810T00ie+J6T00vTcV2/Fwz4r4EYMfMfiR
mJ90cl9is8TzpfMuxrwzDrlyhlwpjnWE9+vjeFnl2RnyrDitC8frAuvdWI+M
6/3z+J5D2me/54x5Cfd44/tC+X7mjIf6T9ik/ozi7T/bOOThw/bS/bp8v/mJ
j2vVP343yU++L3r06kv+nz8vjMfyEOqJ5SG0G8tD6Cf1X4z+i9F/MfovRv/F
6L8Y/Rej/9pPmhe6H6Xz6Hge+X4LeDjk/iXr55fFQf7en9u0n76Pz9cE52tU
XlCe4jhPcUfq2WvOvPqwMvzFsdVvy4ILcIr7PMU7vt3jd7548LSJ/upVFXbU
nbAfLsAh/+Xxxff+ya8XTGvS93eOy+S2KF5Q/UP3YDW+8LdS+WRfNxXv65b5
h5euH5251zG09MYLFiwK69EoL0Z5n/0cM+2NcaG8GOWFy2ffl9b+O+4/45Bn
Y16E50Xj0+zy4FgeIP98zgvckFtnyK1juY3nN9wPh3yyvYO8sX3UeCc7/5Kd
/0LVYzPuG3vncz+FuLR8HyPPT2zzTO/MOTWVFy6fnGsLzrWpHonrSSfn7/Pk
9yF3NTml/598LuDj8+h0EkfP81zeuL/tjXF5Pn/XuC/7eFWv/vfZiqsz72xS
PTxez+PFvBv3z/X+M91zxn6OtPpXpSOfvmmd4uXx/kKZVu8ffw35f7ixr+j5
ngPF4z6Ox3Wfwcfn7OkkXl7tLxw4d/1D6bU6v9n3N9TPpHg/ncS/qyWuR+9p
yEnnDxo/bPlfipfvA6yUEbed3ODCvNWq/5HPadzWwir3raut5xzl/6966qlm
9ZvecmjAUb7xcZ8du2RwLYd1hPJ/fnb1GTdsq6k4ynefnPvN471rOthZlN91
V69zF7aqrjjKX5l+9K2b8qo5+J8oP+aCazP3EhVH+Ze6dv7nsBnI4x/eL53Z
uk8mjlMc5ceft+LZtkuRzzat5U99+KBmZXEccM13dXiqQZ0yO4t6hOvBfqDR
T8nezxIxeBDmAXrY4FmYZ+hhnkesI+AnXtbzq7I4Uc/DkMfrpXsa3LusUS2d
d+Bnv/bxUe2WhPkFfuE/zz1o3YIwj8BHdz7ylhGtq+p8AZ/4Wr0/pnSrpPOi
9Xz+1e9/jKig/ANfMm9w1fPfQ17oQuHy4Dl7/ZpXTPsD3rj/4I3Hq/aI+AFv
5d/JlvputXJGLni4BuWVKvU3tv7oqutcdeUN+GfF7eXom6sqb8BnTnlncnpz
JeUNeP6JO27cdV6u8gZ8++jXfpp3POQjrXnXvtz96d1l/qTyxuXBW/b6NU+b
9ge8cf/BG48XvDE/sf4p9if8tKXaBcdUJT1T7KdNkZfyKlQhfVLsd39xYK+G
bSuR3ij2O9s1cS9VzSX9UOxbXvLRgMJSlR/Fm3cceP+IjViHacUH3NGm4Lv5
xRLrAcYLheuJ1zu3G97HQz/j9RvGBT6ZB/DJvMVyWOTfuGJKm91jKpIcFvmm
K98/a+2oXJLDIv/53hb3zsqpQHJY5IcuXvXdzt+QZ2aL4h3bXjjl5uolEsth
ke9Ua+jQUYdvIzks8msq3zihzC6THIbysRxy/SXC/YnlMPQ/lsMw3lgOAz8x
bwW++bIhz58wl/PCFfgj5n+4Z1dK7/FoPq4XNt37wuoZpcRPgX/2KLkyf8VW
4qfAL76n3qfz+q0nfgr8afsOvLgsTiF+Cny7lxd8trbreuKnwF/14pJVwzdu
1e/u4Rf1PPuQjF+k9QPv3lIyfp3WA3x0h5bXTJmxWYgHMXgQgwcBDzQuMcYl
xrgEvJE8iyHPYsizGPIshjyLIc9iyLMY8iyGPIshz2LIsxjyLIY8C8tzoh/E
0Kti6FUx9KoYelUMvSqGXhVDr4qhV8XQq2LoVTH0qhh6VQy9Ktn1aqkY9l0M
+y6GfRfDvoth38Ww72LYdzHsuxj2XQz7LoZ9F8O+C9t35FM1/Eln+JPO8Ced
4U86w590hj/pDH/SGf6kM/xJZ/iTzvAnneFPOvYnkVeW4zLgXd75PWfr8Foc
ZzmOs4BzPAWc4ybgFB9pnlsjDnIcB2WvX+Max3EN9z9ep5Ud4k3wk8QvDvEL
xa0O8Q7Fpw5xE8WhDvEXxZsOcRx4AB7HiYWKI96keJDq0bhP26X4TvtJcZyj
OE73fYfPLCmqVy3wgPxXi68YXOvVn4OcDBw8cmXmu7a6c+bdvOidwAPyeTea
8ein2/cFOXnu1oeWZvYzrzvr+4vX1A48oN1Tl2+/a/3IwAPavX7+6HoXbA3y
gHaX3LGu5op1QR7QboMhvU5ssSvIA9o947UnX9n3ra6X1OVntM3N3Ku8q9Nn
JY3vC/oEP2+75ombu7Y7QMd7fd2GpZnv2k4aPPehRvfX0PEiT/m+NRNu+7Bq
GO+t6/cVZ75rq/vEiNWvX1hZx4t2B5zTaMGIYO80v+Wt/ommHVYEvYF2G9+f
/sfkP4PeQLtFl68f1X5H0Btod9Ald17vZgf92X7AyDMz39NdMW5Thb/nBLuD
fGV7O1YYXr0o2B38vPygBoPPv7aajhd592/IG+i7nRD2T87t/2ztKm/mpG47
LW9Fi3cq6njR7rATCzd/ftluHS/a3Z4/tPGhmj95i/qDhwy9okO/nIo6XrRb
44ZW19aqrf6GoF28Nwo5Rx61YQM7LhnWNOjJNh17VJszqELq3wtPrTZn3gHK
T7m8bfefjvvqq9deCH5OuVzt8D/OnzF+yG/BzynPI7fTtyl6+pvnHq5MeqDE
f/lU08x3DcpPwxoNr8h8T3fve2Of/1aCHUG7vau8eG27LtuVH7Q7d2PfZvMa
71b7i3Z3jhv/0qRHckgPlHi8ewt+0G6v6YvWTT2xivJz8up9F2fuo7Y/vtGZ
Q++opvycNXPpBZn7q0uatSgcdECQn/L52uD3Pv/ljQcfqP5PKslX5jfdNrVX
90e03ST/52b/RqN9Tz3YNpfs72b/2s1XDrh2iM67ng9fUW9d5jsa9QPL5Xyr
P6t/9Wtf6rdT/Rb0Z1xpp5cKX9ykvKE/FTa2Hu0eLVbe0B+8yxzb383+w8VX
HHt2nxzlDf2BHII39GfHWU1vbt0w3Dspzy+3zU9/ceuWEz5VPzDhZ5m/4ICS
N1o2rEB+y3L/4tIbe734hLabjHelf+e0F9c0Hb5X+1EuD6v9ZzuHNmt8yA7l
AfUX7b59zIYjV5Efstx/cW1+/T82b1QeUP/J9950/h2Tiik+mujPPX1Qzlv3
sX840a8/v+kNB7yWJv/5ez97dekzJ5+2RWJ7mhbo89jfWCibPu3YZta6vRL7
afNk028zqjYbulvbxc+dEw+Y+n7OCvLnF8pVxZfWq/H4Ou0P6vnt7w5zOn0d
+lMu52slde7qxXXbVCT7XijQt+hPwrM8MttX37k68IB6KkzZ++TO5SGPKH7W
+qtq6plh4Xsw1IP50u+ay+VEICfoTyJXArlCf1Af6UN9BwRyCzlJ5FxiOU8L
2h3zat7GSiXbtN9oF+sL7eFnvB51vQjWL9YL2sV6x3pBPkPoB6yXZP0K9An4
SfSPQP+An0RfCfQV+En0m0C/kR7Wd8DBT6I/JdafaUG7fScvGnNk0xAHod36
V1xzw/2zNd6HXpVYn4e4HPof/KBd2Avwk+h5gX0BP4ldENgj8JPYLwf7BX6Q
9xL2Dvwk9lHf4yY77mBPwQ/6G8tbWtDurwU9No1rHvwWtNvp6pw5/zgw+C1o
N/YH1I47+A/8XRv8DfCD/KPwT8BP4lcI/Bnwc+dPSzdm7gcWvdbk8755Id5B
/s/8+oOuf6tF8GMTf8nBXyK/zsG/Aj+JP+ZifywtaPeRAeu/Htkj+LFot0ur
5ke990zwY9Fu7B+qX+fgT4IXtAv/E/zgJ/xV8PDq+R1+y5zjj2hx/QXD+gd/
Hvlv6z34Rovqh4S4JvGTHfxk8ucd/GrwkPjhLvbD04J2z7/6sAHV/go8oN1/
vPjp+AlNQlyDduO4QP15hzgCPKDdOO4I37VdednzBx1bZYX+jr8DJ35SBj8p
8ENylYJcwT9BeYwLOMcv6E/2eEfjwRTHg0b9Wj6OE3Md9x84x3FYR8wDf9dG
8aBD3mKsI5LD1Oizp/w6pqfKoWPegHP8Bd5QP9YLcI6PwCfqj9dd2mePs3Sd
pox1qu2in4iz+p/arOHWU8O8I76A3gPOcQ36g7gj1p9pnz0+Un2bMvTtfu3C
n4edAs5xBNqFnx/bu7TPHo+offSGfaR20x7+cOxvpH12v139E2/4J77wrBH9
zum2k/06D7+O/E/P/if4iONr9Us9+6Xwt+EHkr/qyV/12f1w9Rv9lL7Tn/l6
y35+o4ffSP6tZ/8W/Wk5fFn3k0q2s9/r4fdCTxr9F44v4v3GMK54P+17f9cb
DUbV3xbyfht8Oo5r4v23wDPWlzGPjuOm+L5BmN943/J7ifu5xTM/8b5liF8I
F8Y5voj3OcN8xXFTvu8z6bjjD3NLOW7S+oln7T/Ni8ZHxKcwnxx/URwqRhwq
RhwqHIcCR/xI8alAPjFPyHMOHuJ99eWC+BQ4x1O0voTWl0dchvVFci4s5xzf
kdwKyy3HiSSfwvLJ8Sb6iTzoO//+/JBdt4f1j/gI+xW07yHQe6Q/hfSnzx7f
6T4JlVe7ILFdUDsirM8Rj5Bd8NnjJt3XEmNfa7924efHdlPtrIvtndpNIbvp
s8cpug8pxj6ktkv7w87YH3bk5+h9fGP/3MHvIn/Gxf6M+j8u9n/Un3Hkz/js
cYfuMztjn9mxPPN4yX9z7L/xeMmfdORP6vvaQ586844aneuwn+xiP1n9ahf7
veo/Ozov0HOW+J6eni9Qeb2nt9/5C/eH/GedR/K3HcULjsdL9+Uc35eDP884
zjVi3tJ6znL59RNPq7swzDvj1B+th87FUjgHjM+vw31OtAt/eHbvETfvrhTa
NXA9L/imXZdDj18e7nUYuO6fv1z16JJLu4b9XgvH/m3RWeMWurlqL/R9DOjb
+Dya79uE98ZxLyU+j+b7POH7Kdx7gRwCX/bR+qGVH1ij7QKvtPbizP1wvucj
uIeDevh+S2xPw30YGpcY4xJjXHo/B/Vjf4/41P00Y14Y1/0lY94Vh5xj3yOO
s1TenCFvipPcOpZbrEdjvTCu93vjc+q03i+Nz/0xL+GeZLyvnu9zN+wbMGGT
+huKPz/vrmcfPmwv3YPK960rPVi7/vG7aX4DHs9vqCee39Au9UeM/ojRHzH6
I0Z/xOiPtku80f0T5dkxz3x/IL7n8L3v++qAru2n83gnCs41qLygPMURnvxw
j3OQAadcvafuhP1wAR7rn+/9f078cUKTvr9zXED+sK5rur+n/rPn8ti3iffZ
0nrOfuq0tRctWBTk3CgvRnnP5z4x//uNS3kwyguXz75PqP133H/GYzncb16E
5yWWw3DOFeuN/eTHGfLjWH5iHsI9Vf4+CPo/lof9eJPsvBWqHljTaPS9z/1U
yLjEeFrjx8fu6H/nKf3/5H1RH5+vpTVe5vJ8/zO2U6E//H0N3SPV+5B07xFx
H++HeD7HpHjKx/GUxoM+PqdL637OKZ3Gnv1wei2fk1Icqv4DxWtpjR/jevQc
VnodsmzZsOV/KY449PDPpze7MG+15iODHsL39fjOFjjyouM7W+DIM493VoAj
bz++WwOO9xHwXRPjyPufvZ5gn9EuviPlfur3+Yk9Qd5yjBc48nhjvMCRHx7j
BY58+xivnncl7xdgvMDxTgTGyzjGm70e9Zu0XYyX+4m8CTwu8IB1j7zumk8h
wZHnHDwAR/588AAc7xGAB813nbzvAB7ULiXvaIAHxsFD9npKhdsFD9xPfD9s
jNfxeMEP/Hnkwwc/wJEfHvwAx7sD4Ac43nEAP8DxLgb4AY73R/B9L3DkK4D+
Ao78CcgjwOXBM9cPnrP3R8/Vtf/gmccLng3eHPMWr8ctHu8RxOtxi0d+/ng9
bvF49yFej1v0Ha54PW7R96Ti9bhF30sCz8DxDhF4Bo58FOAZOPJFxOs61B+v
a+5P+K4C/Y/XdRiv5lPIzptj3mJ5LvR4DyKW20KP9zViuS3U985iuS3Ud7ti
uS3Ud6liuS3U95hiuS30eC8plttQPpbbUH8st9yfcD8L/Y/lNow3ltvATyy3
hR55cmI+0x55CWI+0x55DGI+05qPIuYzre+jxXym9fvumM+0fu8f85n2+K45
5jOUj/kM9cd8cn/C/gf6H/MZxhvzGfiJ+Ux75BGK9WpagBM/+g4R9ZNwlXOh
eVQc80jyL4b8iyH/Ysi/xPKvciuG3Ioht2LIrRhyq+MlvSqGXhVDr4qhV8XQ
q2LoVSG9qudLeF+M9KQYelIMPSmGnhRDTzIPjnkguy+G3RfD7oth98Ww+2LY
fYntvtprMey1GPZaDHsthr3m8ToeL/mNYviNYviNYviNYviNYviNEvuNBYoj
zxLkLTteJFwP+Zli+Jli+Jli+JnMj2N+KB7Rd6MoHnFGPOKMeMQZ8Ygz4hEX
xyMFiiM/Vbx+Gdf4xRnxizPiF2fELzqueP3mOorXHPMDPhHfI98Uxa3OiFud
Ebc6I251cdxaoDjyd8EuA0ceD/DJ5Sn+dUb864z41xnxr6P41zE/4BM44n3k
9UYcjTyHePcIOPL2470f4HjvAO/caPnknQjk2wWOvKDIm6PnS0k+HOQJBY58
oXiHAzje48D7E8DxDgXeXQCO9xeQtxE48jciPyNw5GnEO0+Ir/GuAd43Ao73
IPCuD3C8o4G8xsCRTxXviGj55D0RvJ8BHO9o4N0I4Hg/Au8lAEe+d+RhBI58
jHiHCXEx3rnA+0PA8T4I8j4DR/5YvOcBHO964B0L4HjPAu83AMc7DnjPADje
NcC7R4gr8Y4J3sMAjncx8A4EcLwHgXcRgON9BOTR1nu1ybsweDcC+Pjk/Qi8
owB8ePKeAt4JgL86PMmribz2wJF3FHnkgSP/KvK5A0eeWORhB468tcgzDhz5
gZGfCzjyPiFfMHDkDUaeXODIl4s8tsD/TvLZIp8scOSVRd5V4Mi/inxewJHX
C+8EwL9F/tWBSV5+4MhDi/z4wJEvF+9XAUfeYOQ5Ao58RMj3BBz5mpBfGDje
2UH+X+DIA4w8vMCRjxf5aoEjby3ytwJHHle836bfWSTvueDdMuB4BwfvcgHH
+0F4pwo48lQjnzhw5PfGuzjA8T4O3oMBjndh8A6K9jN5DwXvgqi/nbwPgvfV
4GfifR+8HwYc7yIh/z5w5K9Gnn3gyEOO92mA450avMsCHO+z4J0S4HivBO+W
wX97Inm/Ce+4AMd7LnjXBDjeN8H7HGxH8K4G2x28/8H6+eUkHz3K/5nkP0d+
bbanZN91P79ekp8X9SNP74Ik/z5w5PF+N8mzDxz52JG3HTjyKCI/ONs18us0
j+5NybsC0PPIN473A4Ajbzzyyyue5F1EHnO2R3jnAHoe+dtJrvR9B7x/ABz5
+Une9H0H5MFnHPn9uR7kYed2kV+e+4n3AGBfkM+f1q++C4B8/YzjPQCuB/nr
gat+SPLXA0cee7xng/0x6Cu8lwMceaFpH0b30/BeC3DoQ7zvgv0i2Au8m4Ly
0Kt4ZwXlYXfILuj7KWRP9Z0U5NFDebyPgLx1wGEvkO8P9SDfJvLTAYf9Rf56
1AN7hLzzKA87jvzvRv+F+092h/lxzA/ZI+bfMf/I983zS/ZL5YH293Tfj+ZX
/QGaR/UfyM/xhp9DPCv/wf+JeVZ/ifhU/4rkXO0yya3acZJPtfu0f6v5ovEO
B8pD3mje1Z+hfVTdL6V5EcwL7cNr/mra39Z9UfJ79d0K0j9C+kfYfyB9q+9l
kF4V0qu6fwX9SXpS7T7ZC32fguIRfc+C7IiQHQl4YkfIviiO90u4HrI72m7S
T+F+kn3XfPiJXVYcdhnvdQFHHEd+hTP8Cn2PgOy7g32nONTBXpPdd2T3FYfd
J39A8aQe4XrIT9B2k34K95P8FuWH4lnlk+J35YfuOei+B+1LOPhR5Hc5+F0J
LoyTP6b10D6DzgvtX+k7AniHQO99J+8R0L5TKt5H0v0lxWn/R+tH3nbgyPeO
POxWu/DfsB8Yn5PmppB/mPYPU7SvqH4d9mlRD3DkK6Z9XS0PfqD/kTce7ysA
R156vKMAHHnv8V6Cnn8l+fORl1brT/LTIi8/cOTnR/59rgd59rld8M/9BP88
LhqvGOMVY7xijFffC8D7EMAxLuT/1XYTHpA3GTjykxMPYvAgBg9i8KDjpfN6
fa+BzuuFzuvV7hj3KMS4R6HlaT3qeyXgH7ixjly8jvJ1/SJPPvxJA9d1h3z7
KG/gur6Qtz+erxJ9pwD1GOWFy9M5uBjn4GKcg2v+fzpfFuN8WYzzZW2XxiU0
LrXvxri4vBjl1d4Z/DOu9sKYX8WRhx3rHftyyMMOHPnYkb8e/US+euSvZxz5
69FP5KtH/nrGaR/eYR8e+euBIy898tcb5YXL0/0Eie8naDyl+oT0jMZZeJ8A
OPYP8T4BcOT/p/1GLu+M8irPRv2C8njnADjmi+ZXjPnV8tQfrZ/4Txn8pwz+
tTz5b7pvQ3KSMuREcfKfdR+G5NMb8ql4PL+Fmoc/loeAI58+cOzTIp8+cOTV
p31dLu+zl9d9cl6Pntcj3avR/Pzkzwj8GfKXHPwlvHOAevB+Ad4zQLvA6f6P
4P4PnT+m4vNHvV8k8f0i5V8M/hUn3oR41vLGvGh5ug8muA+G9wPQT+T/L+9P
aPeVA3bemKmH9vN1f4bia98qeR8heRdBcbyPQPs8Eu/z6P00jaPxvgJw1EN+
I71rEO5X43s6fLcDHHky8d0OcOQdRV5svS+d5HHF/X7gyJeLe+2MIw9s9nrC
/Wq0i+9euJ/4Hgn6AXksMV7gyOuI8eo5ZpIvFOMFjvyrGC9w5LPFeIEjbzDG
yzjGm72ecL8a7WK83M9kXI7Hpd8rJvotzlMa7lcj7yV4AI58quABOPLTgge9
55zk+wUPwJFXGTwwDh6y1xPuV6Nd8MD91Dyt2cfreLzgB/4k8qOCH+DIFwp+
gCMPLfgBjry+4Ac48iSDH+DIRw1+GAc/2esJ96LRLvjhfoIfY7yOxxuvoy0+
zisb7kUjz2q8jrZ45O+N19EWfe8gXkdbNG9/vI62aF56fPcFHHnL+V40vjPF
d5vA8d1ovB5D/fF65P6Ee9Hof7wew3jBs8GbY95iOSz0yOsby1tZnJ/kSY7l
rVDflYjlrVDfR4jlrVDz/4NP4Ph+Frxlx8P9Z9QTyye3G+4/o5+xfIZxxfIZ
eIjls9Dju/WYt7THd44xb2mP7yJj3tL6/WnMW1rfm4h5S+t3ajFvaf0Oke8/
4/uvmM9QPuYz1B/zyf0J95/R/5jPMN6Yz8BPzGfax9/1h/vPwIkfzRtP/SQ8
3H+meVQc80hyLoaciyHnYsi5xHIe7j8bciuG3Ioht2LIrY6X9KcY+lMM/SmG
/hRDf4qhP4X0p56PQH+SPhRDH4qhD8XQh2LoQ+bBMQ9kl8Wwy2LYZTHsshh2
WQy7LIZdFsMui2GXxbDLYthlHq/j8ZJfJ4ZfJ4ZfJ4ZfJ4ZfJ4ZfJ7FfF+4/
I68C5C07Hu4/G36gGH6gGH6gGH4g8+OYH4oXNM8/xQvOiBecES84I15wRrzg
4ngh3H9GPop4/TIe7j8b8YUz4gtnxBc6rnj95jqKpxzzAz6xz4b8EhRXOiOu
dEZc6Yy40sVxZbj/jHwdfP8Z31mDTy5P8akz4lNnxKfOiE8dxaeO+QGfwBGP
Iz8j4lzkHUI+RODI74q8hMCRFxf5BIEjnzDyxwFHni58/6/fNSff9SNvF3Dk
70JeLd3fS/I2I+8VcOQrRv4p4MjTizxKwJFPCXkQgCNvEvJIIv5F/lvkcwSO
vMHIew58Y5JvGd/P675ikt8M+cWAI+808n/peUeSbxl5uIC/muQZRr4q4MgL
irxIwJEfCfnrEbe2TfIhIz87cOSRRr5CvS+d5HND/mXgyP+MvMPAkfcY+XaB
I98v8koAR/5b5BVC/Ih818hfAxz5k5GPBjjyBiO/DHDk0UU+AsRNnyZ5wpHn
FzjyDCPvLfB0kncX60j91STfF9YRcOQ9wzoCjvxsWEfAkS8O6wg48u9hHQFH
/gqsI+DIy4d1BBx56rCOgCOPHNYRcORzwzoCjrxnWEfAkVcE60j93iTPG9YR
cOSjwzoCjrx8WEfAkS8C6wj42Ukedc2jl+DIp4d1pH57ktcO6wg48r9hHQFH
PjSsI/iZyGeOdQQceeCxjoAjfyPyngBHXkqsL+DIc471BRz5vbG+gCOvNdYX
cOR5pvWleexpfcn1SZ5wWl+C/Ni0vgT5orGO9LuwJG821hFw5JFGfhzWw8gX
zHobeZZZvyEPCNsdsoO6L428cqgH+eWQVxQ48nwiXwnrc/JnNJ8b9Ix+V5Lk
vUSeF817lOQXRd4Z4MiDhDwmrIdRD/QS8qOSXGmeVdTPOPLUcD1oFzjkFnlY
dF8ryTuKecG+CtYL8l8Dj/MNhnuziN+RDxo41iPkAfsM0D/Iy6z7SMm6Rh5n
lIce07zJSXnoB9JLmrcZ+ZdRD/Qk6XPN24z8sKgH+WkhP8Chx5A/CPUg3xTk
GTj0P/KWoh7oSeQbRXnYEeT95HGRnlQekD+Ux0X2Qnkgvcr8O+af9C3Pr+P5
xTpl+SH97ON8leFeLvadSH7UfpGcqL2jeVf7SPbaG/aa5ivc1wVO86V2n/hX
P4HWl9ojWi9qv2hdqL0j+Vf7SPuQmucQ+hDlIc8kV5RXNtzjBf80j4J5pH1j
yrsY7vFCP5D/pnmPSR8K6UNhO0v6WfMSk98rrG81b3SstxWH3iZ9rjj0LddD
el7bhb7lfpId1Dyo0LfAYdcgJ8ARL5D9dYb91Ty0FNe42A6G+7Swm9CHjJM9
1XrILmv/Ka7R8VIcp/2HHuD4l+JTBz+B/AfFKX5UHmhfQvO1It8rcOR9pf2E
VLw/EO61Aqe4XuuHPwYceTvhj1ntwj8x9n8YV/8E+2x8fxX59GhfTsuDB+hD
5PlEvlrgyCOKvLTA4/yl4f4q8p0iTxxw5ItDHlXVw1E+1XB/FfXEfm9oN/Z7
Qz9jvzeMi8YrxnjFGK8Y49X8rrHfntY8scjHBxw8ID8g8DiPZbi/avAgBg9i
8KDjpXNVza/L91dxrkrrRfM2gzfghpy7WM7DvVPkO4V/ZeC6LpA3FeUNXNcF
8q+iPON0nijGeaIY54mal5XO6cQ4pxPjnE7bpf6L0X/GVZ8b/DCuetXgn/Bw
LxT7GLCbwJGHE/se6Cfyi6IeAw95MJL9Rthr4MgjinqM8pK9fLjnGZ/Dhnue
WHe0HtXPh/0Fjv0T5IdVPzbJv0r7LVzeGeVV3oz6BeXBD3DiX8dlzJeWp/7s
Vz/Wo8F/yuBfy5PfpfEyyYk35ITwcD8T+VTjeWQ83J8kHnx2uQ33J3Euz/cn
YU/hH6I88sHC/0T9wPmeJO4J8D3J+Jwi3JOM7yGEe5IGD4oj3yvqQd5X+NXA
ka+V9vE0/qW4WOK4ONxLRFxAdl/tHX2vpN+P03dn+j04fbel333T91n6nXjy
/bveZ8P378n38orje3n6nk6/76bv5vR78OR7fMXxPX7y/b7eE8P3+8n3/orj
e/8kP4DiyA+Q5B9Q/wL5B5J8BYojX0GS3yDkq0zyGyT5EBRHPoQkf4LiyJ+Q
5FvQ/SjkW0jyOeg+EvI5JPkfFEf+hyRfhOLIF5Hkr1C5Qv4K+l5bvxul76Cl
VXJvNslzEvLLJXlOkrwoin+U5EWh783Dd6Pxd+WC/CpJPha9V4B8LEn+FsWR
vyXJ96I48r3Qd/f6nSl9X6/fpSb5ZBRHPpkk/4ye4yP/TJKvRnHkq0ny2yiO
/DZJPhy1y8iHk+TVCXFrklcnycMT4twkD0+S50fjU+T5SfICqR+CvEBJHiHF
kUcoyUek/gnyESX5ixRH/qIk35HiyHeU5FNS/xP5lJL8S+o/IP9Skq9JceRr
SvJEqf+APFFJXinFkVcqyUMVyid5qJI8UWo3kScqyWelcR/yWVF+Ho/8PJR/
xiP/DOXt8cjbQ3lpPPLSUD4fj3w+Sd4YLY+8MUleHS2PvDqUn8cjPw/lpfEn
z/+21znddnLeHo+8PZSvhtsVbjcZlxjjEh5XwpszeHPMW8K/Y/6JB80vlIzL
87gIl3i8an+VN+q/5lmiforRT83jRPOo+X9I3wrmhfjU/EXEm+Y7ojxsDnJL
cu4g55QnzRnyr/UQP9L8ZHd7mX/iaX+Mz33U7mOfKjm3UvuOc6vknCvkFU/O
uWh/T893aB9Pz4PifYMSj3O0eN+gxOPcLd43KPE4p4v3PUr0XXX4+bCbOAdM
zg0Vx7lhcs6oOM4Z8Z49cJxL4v1p4Dj3xLvLwHFOinclsY5wbkvnRLo/DP5h
T3H+Dv6B47yezrN0H5jOrfR9cOJfcE+A+BfcKyD+BfcQiH99pxv8w97hngP4
B457EeAfOO5RgH/guHcB/oHj/gb4Bx7f9wh2FvdJcC4AHPdPMF/AcV8F51DA
ce8F5wLAcU8G770Bx70anL9g/eLeDs5fgOOeD94r1e8uk3tBOE8BjvtIOE8B
jvtLeJcOOO47Ia7h+0h4p43vTdE9EI97IHT/Qd+lpfsh+v4s3d/Qd0vpnoO+
x0r3OvT9VvBstCvcLsbF/QfPXD/hep+E4kHtP7UrRrt6f4b0g77DSOPS+yR0
n03f0aN5dJhHum/mjPnd7/1BzPv4V+aMOGt8LdX7mo+i35fuzUdrql4G/swH
eZ1b/1xN9Snwfk/ePa36vPCdBvC5bxT/0HpNyA/IOPQX8LWbv/hm4pxwvxn4
zZcUtpg/u5rqEeCLhp/fv/sjNXX9A//vpW9U/s+kMC6M+/eJfa7rfX4NHRfw
uRPOW3b0+8GuAG9z8JL+daerXVF7esuV31zTZUol7SfwGrP+vWvT6KAfgS8Z
8+Mr958d2kW/Xhm1sOUF6fAdEfBbP+x7YIN/BH0N/Peu3/fO+W+43wz85A82
/PB0m3B+BhztQg6Ax7xt0ftp1Y49r9mKVUFfA0e7qB84xov6gWO+IA9op2un
6je9nKf3DvUeWteET9QDvDCWB12nXx/wcnEmT0Xc/7T8PHv9aU8+C/0e3vEb
9mKfX3YP3OrjcaXlpAHtplzXKdxL1v3/Ta8ffVtHXQ+K93q26I6MP4l5hVyP
+XRck4wfCH5V3v/5ya/DL8+h/pf5n4VT2zR8tJT6XygXXl1tUIvxO6j/hQLe
IA9cTzyu0G48rv37iXZaz5zQMbP/EK+Lsnj//fFFLyzIoXWxRR5b/l6XV/7f
9wPAWX6AQ55p3qVtsr5o3iXWJyH/ZPFLeZMz+zkkt9pPkluJ15fKrWC9k9wK
6zfUd0HCD60vgT6h9SXQn9BH4Bu43q/Cuk7qwfiBo13UAz7ifuYqjnHFcljC
ekbXNXiL5arEg2e0Cz4wL2hX/eRkHkmuWI8pDjmJ9eoWb8iV5/kF3jqeF9U3
xnr0xnr0xnokfRXeE8M6pfXojfXojfWo/YznN+2z65m0h16Kx5X2sR5Tfehf
SfQe2gO+5JVWf6zvH74HA/5AUX7XR/oUsf700KvxeNMeepjkRGDHSU6ka2Q3
C1U/gGeSc4EdITkXsrParyWRnQrn5JA3Wo9C/oPisJuoHzjsLNlx+Z3aBW7Y
cdVL5J849hOAY7zknzj4IeSfOPgt5J840g+Kx/on+J/sRwEHb+Qfuni+1D90
sV+n/qEz/ENn+IeO7ILi0IfkHzrSt+oPw++N5TZX/WHYez1vStZj7M/kprB+
UR441mks56F8bO9yUz8kPKN+5TvSV2m1C1jvqD97+ULV/9BLWLfAsX5jPbB/
ecznsFifqB6GPozXb6HHPMZ2dj9c598oL7GcpLV96CvyMyXWz2nVM8Oy6sMS
ofGq3jD4ofKF4bwgni/FG2WfL+H5gpySXCluyJUz5MqRPOu6i+U55KlmPLs8
67hIDsP72jFvyj/bEa2Py4MPzC/57d7w273ht6s9JTtr+PPB/yc7K/F4w70j
6r/KYTze8P41j5flhPSSi/WD6hmSh5DfkvUV/j6n4M6bv+pcRP0p9IRrHBHj
4f1SzAvrzyfOHfVGmbw59nu3fnPxRWV6OHxXkOBLa77dsczu6DoHXmfDh/PL
1oVjv/fC+btvLdPzLp6vEn/Fv7svL7Nrjv3eLV9fnLGzLu5/id/29vLM+lW9
ADxv25C1ZX6mY7/3qecXf1tmd7Rd4AteePTRMjvr2O9N3XJ3xu5rPAz84+t/
aFrmh7h4Hrf4+R0+OaNMTpR34BuPy83oMe0n8HE9lt30yv/7jho49x/zO+gZ
+aVMf2pcDbxVzwduLvO7hObd57eue1vZ/ArrZ9TD/l5prRWpMvvO/MiE+UUd
yvwTHq+MnXLRnDI9zOOVlkl/2A9sW2mHlPkVPO8ys8OQPWV+Ec+7TNt48J1l
/hjPuxjzLpgX9g87TXxyYJmfw3Ir228ZNLzMT3PsH/5RsuXHMv9Q5x34V1F/
wnqv+OoLX5atdyH5F8g/+5MkV4pvTeSc9cY/dzSrWqY3HPuZ6D/7meCT/czs
85jrnp4x8Jgy/UPymeuwLtj/pHWqOPQA+5ngn/3MWB6Cn7knksPgNz6ZrF/2
G6FP2G+EvuJ9UeDUn1Ssl8K+6JOR3gj7nOgn9SeFcfE+J3jg/cxYf4b9TPBM
85iK5yXYd2MeU/G8h31OWneKQ67Yv4Uc0rrwkFvabyH9GfxhrAv2Q+J1FPZL
se54vxTrlPZzPPcfeKwHwn5prM+Dvw09w/uo0Eu0H+XBJ++jQh7Iv/UtY72t
OPQq7bN5zCPvr0Jvs38OPc/+NuwC7YdIq1hvq96N6wn7irBTsXxukdiuBX8e
dpD9q9huhn1IzAvvQ0KuiB/BuuB9yNjuh/1G9J/jCGPeZUsk52EfEuuU9yGh
Tzi+iO1C2IeEHuB9SOgrjgvgp1G8r/4b2gUez2M4xwHO+2zxOg37bNntb6GP
5zfsp2XnM9TPcQH0AMcFsX4Lfj5w9vPjesJ+Gvktir82udny9f1DHiXUk329
pNX/4fMCgzf2WxQ3eDPkkOsP+zDG/LrYbwz7JyQ/6nfEej7sh4Bn8n94vlI8
X7zPyf4ScINn/2uiH2ge5dfY31b80Gev6lwW7xBvLA/hnIjGpeuUxwXeiB/1
r7ge9Av94bgM+P8BrilvRg==
     "], {{
       {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJxFmwXUVcUXxd99cu/jzvM+SunuBgGlUUFCQkRSsLu7A7G7u7u7CwtbFGz/
BthiYWBhoP/9Y4/Ltb5Z53zz5tbcmXP22efcdtvtvdle5VKpdERaKq0h+XZW
Kn0huYHkc0mp9JXaQfo/16BvpbdWu0DtG7W+at+rLVc7RGMmxDHo94VS6RzJ
JXmptGVRKp0rfan0QRqzn1p9jXs+nudg/faZ5P7qP1ty57L1LtJbxvHHSh8v
+XUc/1RivaXahfEe+qlN0pgfJOdpzBWJ9WFq58dn6aN2mtpStTZqG2v8l/EZ
e0nfV21hyefj2TZQe1Fthdrt6n9V8ju1oWqbaOyPsf+12L+v9HZVj39Gc/C0
2ibSm6ivRaVUKqTXkeypY/dRu0X/94j6fB37beb57asxXdS3W9n39k3mZ+it
/msleWk81+56b2fp9zv0+6HqO0RtD7XxGneG+q/O3MdvZ+r/serfW/Jr9XdX
3+5lz98e8dixzEnFc7yO5CTd91zerZ7j4LLfDe+lk+SuagfqtzEat5P0cZxb
8oCy7/H6xOfkulOrlpsHjzlQbSOeJ875XbyDsq/B+SfGMZyng+QurAMdP7Hi
cRMkO8b+czRmSvW/60yven641iSNm6L+cZqn4er7RGP31P/N1f+x9OM1D5uq
/xfpb7BuJVeqba22i9rvarPVtkg8ZqraZmWPeU/jO1a9XlrqWl2k/6b+zpJv
Sf6jVle/jdD4VdL3kf6m5N9qSbwW47dVe0l7Y1v2ne5rW93r0dKnS29bcf9+
us+pZd/Px6w3jd+F59Xeqq/rHca7Dd4TT8U9wrp+Mq7tVzV+Z8nNNL5rxfcy
UrKBjj2c+dGxrXX+wJoreW7/SDznbaUvYK1J71r1vf2he2xS8T5qLDlUYz5M
fCzX5NrN1bqppcy7+uuWbUewIT+lPvdsyUX6/4s4ln2PLWANvBr72VODE/dz
3610vU+ln6A5eSaxzjt9OvE73YP7lPyc36QP0zk/iv3sfe6zrlpTnacquYZk
m6rHt5acrPE/Jd6Pr2peZvAs6u+pVke/9ZBsr2P0V6qv+59Zdj/n7KXfdlX/
65rvLhU/e+eK7WKlbNtYkkzUvpHaSb+VpXeUXKgxP8frsn4Y8630GWWPWS69
Q9VjXtN9/Y97V3899bcv+/n3iO/9/Dj/rIcLop38SsccIjlc56hp/Oyy7Vgr
yW2jjW0Z9e10nhf1DNtIztSamVC1TZ2kc2T6fVbZ74s9wf7ZEnvKcWWvk5Vx
n2yXeG+wR9gXv7JXy177beP406W3k9y+7PtvH/Uz1N+Qc5e915pIbqW2N/ZB
52qivm7BtgK7z/2NrdqmtpUcV7VdaS/ZQL9vEe8H2z6nbH/RXHIbtXV1bL2y
+7H5X+i8B0oOqfpZOBab0BTJOy3Zt0yKNmpF9Af4AvYoe3VXyT8yr58Fmedq
y2hD+un/VzX2Oq2fXtJfxF9Jz3Xd+6W/INlD/c9Lv0z9PaW/IP1y6QOlvyP9
Zun9pb8m/Xrp60l/W/pN0m9j/tWe1f9zJKepvYlN15jFktemtr3Mz0y1vupf
pP5rUu+PmXE9s+5Yf9+VvMbpb5t4/2MHsFUjoz1hnbM2J0df9nbiY5f/a9dK
tmd3q3+W2ssl25vNo81hHTZKvPa+1/OvJf0yyem6xvbYUd3jyeprkdj2YQ/W
L/va+IqJ0adsp/HHYOt0raPVd0zZ9zo36keq/alx8+J49iY+ELuUZPan+NUZ
FY/BDo9QGyt9eMXnmBvP2VHH7FC2Tx0dfRH3PVrjduT8kodJHl7282+q/zeT
XJd9r2udLX0PXesHtR3Za+h65sY6xxWSv6b2sVvyTBq/ufTJ0k/S780S2/Re
kmN0/v2l/6LfDpDcQvJHHd9Uv10V4hzEZz+VPZ/YTjH/2ESw0I86Zif1zUqN
w7j/zon9F/NMH8/HPPSUfEX2YYeS7/Mx6VN5z9ovS9g35f9s7dC4ZjZPbRsa
R/uNP8Zur4rX6Bzf54j4Tjeqei0s1LkHVmwPWkpuoN83LNvGD9b/I6UPqngc
47Hh61VsV5pFPz8s2pYeicd/XvIamBjtBjZhQrTP2E9wITb059TzOif1+x0X
3/GYqtfYJsG/MYa1gb0Fp2Jzl6mNKvua38bzs85mR9/HPX8Vr7Ua48Vj8d34
ROwrfrOhrnWE5Ma6VkMdc5v0e6I9qV82bmkkuVbZWGKwfntffbfqOgOqtmtT
g21bvWj3qpJrlv3eQ9QHYJeincfec76G8ZwN4/l3SOwzCumfYU+q1vELPSq2
s90l+8RjsdvYzgbRfuLjwL6TE9seMDf2EfzbM9oN7G2feOxLifHx/Lhn2Ds7
6vlejsfiV15JbMuwY6dHP4Rffyz6Fd47fqZt9E3gzd7x2AXRD7WLz9gn+iZs
+NplY62/ol9kbW1U9t7kfW+s+Z0mub/up4/m4VDpb2gNLsq9l9l3YNfu0SZU
KvbJR2p8v4pxWi65OPFaBqscrmN+l6zqfDcF4zrwHe+nGt9R3Yr9+dE6z7Cq
fdjQqv1i47JxBT6qWfRTvN/WcT/Oj/PDPGBrsbkNEvv8VvEZibd4XmK0das+
J36Wvdw62mp8Zouy/eZD0S9yrXka97dkTccNrrp/kOQjie+T8etF340Px05i
P0dVjI37cn7JD9QGxHMOqmmu8Fs697rSH5S+QHpf6UF6F+GTgdKfkP6K+tsy
Xu+mvvrbSH9Sej3pqWQDnW+kxnVW/zaSx2n8AOn3S39SeifpW0k/RnpH6Qt1
zFpgZuk7qP8U9feT3lh6T/X3l95Eei/pQ6W/LP09jele9boZLXmR/q8n/Tt8
Ws3+e5jGt5D+mvTtpDeq2X8Pld6y6vXdSfK64Hf9k+TPwba7t/qHaPyzGv+W
+q4JXlcrJI9XS9ifGjNCbV3mVvJx9U/gPUl/T7J/2e+glc7zgJ6x4LrSH5Ve
KxxXEQNgp7B3rGPWMBgTfNY+8bruEMf0jzEjseO/MS1xLxhgnbLjoPfjOwWD
PpE4hsS3vRvvB7wFpu0n/ZeIgTmWdQ0ebB/38hlxXxNLE6N0jP7o7Mzxfb2K
Y5Au0a7eGxwrbwKG1zP+rWfsoGfsUbNPvV6/vxMc51Wqjms7x3s7NzPPUV/n
7FXxPbN/+8T4nD2ITe9WNn5gX6MTOxO7d433sLbOewKYJBhDsZfaxr3InqzG
uWGOWPPMBe8JW8CeYG/or/Rg7G8S9x3jV5U8p+wZ9t7DUec8X5V8LJwOHMUb
if3RzyXP9QrJBxK/g5Ulv4d34/kXx/HEX2vpeV4qGcdiO7G5C6Ofej2OYexr
UR8adfwsvy+O/fg04rrVvqPsd1w3Xuv1aAevSo0NF+la50p/TPrTmWPBRfE8
XaOOfyRWw0/gI/AhC6P+XbwW45N4LWzj3nFdLo9r8qE4V3ADjyfGJA103aaS
03VdAr1OEtOkr4gYBizzvOz8Vqx5raXFubHTpoXfOdzZQXFtPxDns5HWwHGM
CV5fzyZeY2up/3jJKer/R9doDJaUbBU8Dx8E2/KH432eoGvfwXvOzD+9kDju
4JneSYzVG+meH2WNZN5PvGvixHfiszPn2O9HE9tk4mP8Jfurnc7fBb/Nuyau
wH9KT3TOAWAhuEF4PekX6N6elb6F9POCY17wXLuK19ni6NfwXyHiDWLPoXFt
XJ55LayfmduBR4JPui0YX8M33B6MtcBcC3StWcxV4X3Ofj9Hxz6h/umcL3iv
smfPw6arf4b6r1T/HWrHYlfU95TaTOmTdZ4GFWOi8zX+To05iXnS71fq/9NZ
I9JvDuZJ4EsKje+g8SdltkPMG7YordjO70uspmO2Zv3o/O9qDsfxjMQU+v9I
9qR+nyP9VNZI7vgFXoxY8m5d6xT2Z27bBYfXW7bqLukn856Zbx17mvT3cmNL
eJV1sJ+6xlj1j5BcqrYJmEXyQY2bhD3TOSZX7NvhlI6TbJg4vsqxf2pzpB/J
8yTG9HMls8RY5/PU8zlBcvOqY6XZVWMH+AOwxLLU72iS5Bep53mi5Mepubix
ko/m1uHnHsp9n+fr3pan5hymSm6o8w4sO6bg3AMjVvkos4/bVvIIyTXURoOd
JMtqG0lfkvp5R0m+rrY+uEPyTc4LppB8WNedLH2c5vIN/b+B9IGSH6ltynoj
Fk49ZnTq+Viv7DlZW+9jkK4/vDB3BJa6NBjz94hr/n79f2LJ2Pti9lliPHcJ
50m8nm7M7Bd+yowj7pR+Ymo8cqv041NjjTvivgf7gP+JA/BjrIcd8Wfqf5w9
yHjdz3idf/dgP4xtxBdvHvcgGPIitf6JMevfwfsF33SVznOU+n6QvDazvfoR
jrRqjhgfek/wmInBNhY7z35+Xv9vKvmc5JWSwxPvt0szr/nvMnNgrFfW6vWZ
7d6KzHHKNer7h7nKHO8sjxw1/pX9eUVmLvp7yWZVxxBw7Hfr/8vxganjCJ4Z
DDJJ7ebEdvA8yd6JY+N2kSOCK0qC55Z7nqi+m9SuLBkr3cg18R1Vy+015kW1
KYn5mTWqtrvM87jEfDccdLnqd7Sb+lcF2yhs+8NqY6RvJ3lbZn4env7BYH2W
5ANqG2rMVpHXIkaFo5iv/zdOfM47dexlGn+wnrd9Zv+In+R9jozv9CGNu6Dk
8zwSzOtz/3N0b3sSf0U5Lt7zLdHW7ZYaUzMHh6Z+1tuZ55L5wiLa7tGJ75P1
/YrGdZPsKPkqXJX0LpInBvuN9bVXFuv/HurvDN+r1l16J8lP4I+kD4n2gb05
WPJ9tSHS+0seG+x3rtR+fU//D5beT/LU4L1+p/pPl76TrrVBzRgYn3aV+t/S
uH7Se8a9v470HqmxHPE9eRVyIN3iOtsy8i1nZY7FicmJ5YnRidU55gONGaox
A1LH9HAHHLt16j19oY69T3od6QF7lno9X6T+w3RPDZkr3eNWqe3BBeofXLZ9
w87hd4YkXg8fZsZ0+OKD1fdXyVjkNJ2nF3ZMY15gHUhvLfkitkB6G8k/sStq
rdSe0f8tJJumxiTgS/DekswYE5yzH76T965zP69x7ThW8t7UucG6kgvUmklf
S/JptebSG8M56Xy/lYxdniBmkiwkH1drJL0qOT/GXxUwXep5yFNjE/A+WHRf
6T9K6jWWHtFva0o2SY3TwLhg3Yf1fxUbjJ3ELktfMzW+A9uB8ebmvs/uwRz7
PvhGPeNDrG/1N5LcS31fl8zjg+d5z+Tf6gXvqTd4R+q7V+3dkvM74N5Wkosz
98F1wG/AWcAtw5HAxcCTwCHAARNX3IP9VXu95LhtgeTF3HvVfPBCXesV9f9P
/Quxh5n52hs0Jquav32ZdU3Mh99IHWuCycHm8EDwQeSpGgfzvox/VuP6SO+a
+p2y/ruDCzLvx1NzvxfedUvJQ7Dh4JoYTz+i/nPU/5xaX+ndWMvB+HAZOYhg
28D9HxaMkYcTWyeeO+YIjoJ3R/7hy7iXh2Ln5DvXln5k7vgeOw1ufTOYH149
/2XzD7xX1vJ+idczscPb8X2/qWM/Ut8LzE22Or2yOn8Nf8M7II+3k9rOicct
w2YnHgdHwV6A7/8oeP12lVwavFbvZm8Fc+zPZ46P3ov75w/1HZQ4TthecsfE
vNsQjftA8rbUuYuGcT3AVxHXw3f1zoztiXVaVM1dkdPpA4eh/qtTX4/r/gWf
l/m5J0p+HmwD+kuO1ByOBzdI/qq+/XWe1vjIkte8prb0SfCxvYPPxTmfy5xP
Yf6Igw4MjjmG1RxPE/MTU5+bmF+G7yK+WxzxDXk6csFwwiOihL+FS1udz8F/
BmNJ8mW/c8+J88j7x7lljk/MHG99mTlvvFfEwMT6xPnwDC/nxqfkAv4IMT8c
zAGTsyMWhNNjfuEUyXvckXgPXJJaPqbz18W/Sn8pOI/GWHJEp+q3vdT/leR0
9d2ZeF9hZMAV+Gti00XxWltrrh/X2IY158HI8RHXkguaGO+fWJXYk/75me+J
656VOGdAvqBb9t893pUbw54RjMGPSjx3V+eOv04K9nP4u9Ok10mM0cGiRwXH
ZCNq5hA+iLbyoOC1+XGwL8QnniD9ALU20o9V37uZ7S7rirXUUvrR6v8HP5B4
n0M8HKY2qmTcDc7mPl7TfY+QXJeYQ8fuiS8pzCW2jL4M/hu+nTXTnbhR4y/V
+JXBMdR4yU8zx9F7Sx4d/LxfS47SuXZV32+Sa2rs0YljziA5L3HM+bLONUiy
r+Rojdtd41eyJyL/Bg83rXCs9nTh+Os06c8Uzk1hQ4iXx2X2C2MlPw32QewX
cvj4FfKwcKHE8nXBwpJfluwv4czaSrZIzTNgWBi/sc6ly5SagRMy+7TmqfP/
cDJwM6PUD8VQS83D8b7gHn6Ie5j9OyazJEf8Xeq9QE7sGJ2jljjO/D51LmZG
jJuIU9aXPCBzfHdJ8LqAQwBPfJN6LqdIfpt6/jfD31btY+GTvw3mpYjrX0r9
XuADzgGbSj+LeC049oUHODNx/Mte+ix4XfUJ5mK7Sm+fGkPBjYCJwVbUABF7
kBOmFgLufU7EVORhiYGJhacFx8nEy9Ol1yrG8+A08oDUB2AXqC8aHNcecT7x
x+Tg/B05smGRY+gU9+ChwbgFWzo1ci9wMJMy74X3JGepdZTeNjWXzJ6AI5md
2Q4DII4Mxr0DJecG4zR8HH72p9iP34C/A2+tETkZeLgpmf1gPbBJ1bgMzhxf
jE0H4x0cbNeZz8nRF+ATyH/BgbapeM+x5ontycHB95PDrWrcVRp/GO9X+tXS
D5d+a+J4DazTQP03Ss5T/6Phv7iH2OF2sDC8uBbzeer/UPM6smrbQ96vI/yL
9PPBdNJvwoaAbaRfhM8Gw0i/GP8kvRO8jPQLwNHSl0i/Xfow6Uul3yH9jcy4
CZ/eLjhXDk+eRVv7b+6JGq8/g2NQbMzn7Luq46ZuksN1/IfquxOsGpxn30bn
6az+p6RfmDqOB3fdAp5M7Mvx4+SzwH6rMvtw1ia5sFmRV4dfb6TfbtbYY7AB
0h9mX6TOFWAvh0r/LDU3NV7y69R2a1PJd9TGSB8ueXIwj4GdJ+cwkHedOhfR
X3ov6fWq5jew4WdHP8EefDu17xiWOqcBvoKro14FP/INezOYw8G/cO91ou/4
NDWvQy6rVWb/eDr4PDjHOKFmTpV4mXi7tfoexE9pzG+ZeQU4xjZga/WfmTrX
QFxMfNxU/Xfhv1LHaHAo+K8nguPuOlVjLPAA+ZlmGn+39JNT20hyQV+wfyQv
Tcwj4FeHxjUA/wUPNiM4R9Au4gb4fLB2h+AaNGJzYuBWMY9MPrl5zBGTKyZf
vTTuGXKFbSKOIQ/SIeKhlrq36/C3qbECdu6UzDmxD+OxX0Y8AwfYQu1a6XNZ
e9KvkX5kfEb2IDWX9TLvqX2k15d+Psem5h7gcNiHNySO/cEia2vMpZIHpfaf
Z0Z7y76mlmBP9ReZay/3AvsE88QT9R5rmesw9wbvS79F+nHSf83Md9zLngjm
LnCGa+n/S6QemDovj50F51E7iO2ktoE49fLEfND2hevyNq2ZP6IPXneQfr8s
MXezQ2pO6RrwivquSswBwSXA/8AnrC95dWJejBob9vg86ZsX5nSfl5xVmPd9
TnJ2Ye72hcL1DnA9/9ZAIM/MnLMFy4Jj1+bcif0lvvH4xD51vI4/UGP/Kpzn
HxvfO7USpySul8BvnBV9x+O59w6+daKOOVjHrpL8PHMu4HDJZZlrVY6V/CJz
vcZR7BuNO1Tyb8kmPHfinDG8MGscXNQ57oVTUmNOsFMT9U8qzKnCYePfsS3w
3+RtB0XfN6EwTwv/fXUwHwt3PqPqHPp86RcG85yPSL82uLbkaekXB+e0R+o9
blSYm4Wj/Ur3MV76SOxWYV4UDpU6QPLogXq6irE/dZVrVozfqdOrZPbjO6fm
0+GaZuo6dTP79F3UPyrxemLd9IkxNTb3Bo2brb5ndNxHuffIlsFrA6xNbu+D
3OufmhrqjFnnc7CpmXMH26f2W+y1LYJre6jhmVpxTRrXoT6hXLHPBHfyTnkn
5PPnR7sXgjnAR8EImp+ukveq/zRwgfR7pJ+aui4L/3KR9Bczx/jEINsWju9a
g2eC44wWkouC49+a5PvBua/JOv+SGHsSg76t9jTrF9sWnBPbRGOuS8wrwiF+
qettzH6SHFJxzpY1fUZmTpoaKnLKrElqSMkdsyapDyWHUDfmEbKK9xJrlHob
4h5ybdQug/fA+nlm27tr6hpKsCL4+9bgWidqWsl9g0/Jh9wSzO1TV9hY9/1S
Zl/coWZ82agwZ4iPw9fxjMTFxMfMD7EZ+X04brjuZzLPCbwKefDH4jzDqawV
5433wHzit+FtmP9X1ddE1/w8ty3dJhirg/mJpR9Mjb2JBd7JzBN1qBhjgbXW
r3g+yX+3lv5Zbju5dTCe3AyfUDOGBPuBAcFsYLmZmXNj5Mg2rDguACcTh8Fz
EmtRe3BFbl50A2K4mnHSiMJ8DbzNeuo/ITfXtw5xdG6M2k/6Kbn51XWDMTfY
e0sdf0FuTnW4+s/JjSuGgCVyc6SDiU9zc0RwReTmwNXddJ8NU/NpM/BRuTnY
YRp/o/QJ0kcF4xVwy/Yac3luLhfO9eTc/PAAjblI+jBsvPQb8mhPpF+fx3Ur
/cLc/OoIcETME8ENH5ebp4KvAjOAC/he4Z7UnM6GYDGNGc6e0lzdlDs+bSn9
7txYq4302+K9cc57c+fm2hXGamA28kq35s4HtVb/LbnzR62kX5P7GZtJvzZ3
7Nlc+j25825tpR+TG89wn8TaxInUVBA/8I5YH8fn5mz76vfL4pwzV9hibHL7
wpw4a2DrzH4UvAPWnZZ6H22i9/JPbo5ub/X/Lv0+6XtJX5nbLu0p/dvcuGUn
6V/kzh1sK/2b3PhkR+lf5cYk4Ijl0q/HVqv/p9x5qF2D8wHkBcAJ4D/sIXZx
RW4ssUtwPPu19I2QuTHPDsQxuX0Z2If8FnmuRyLeIE9D7c1vue3nHsGxylXS
78uMR8Gl2FzwDDiU/E8l2sN9wZXB9hafmQXzq/uAMXP7u42C8TE4mTzBiGgP
ydm9qLn+J3WM+az0v1LHjC8RvGeON18r7MPY44uk18nsX14v7MOwIa8U9jez
pb9R2D4yz0sL+wbuZ0lh7MX7+rCw/+D+3y+MF3lf7xXGi8zD24UxIu/us8K5
zCaSHxTGo7zrTwrzIGtLflqYl2ks+VFh/reB5MeFOdyGhb9JoW6AGmnq26mf
oEa6Y6zPpu5oY9mcValrFcZKX5n6G4Fx0n9PXYv4ReF8M3thqvr/TF0POVr6
cZm/TRgj/bfU3yZsKH2fzPUSo6Qfkble4s3CmJV18nnMxTYtHGOCZ6hf4vsO
8uObVV0Xik+itoq8JJwh33xQO0edBDXb1DFSZ9C/6pp8/Bp1U9TpUUfXt+pa
NWogqIdfXZNGDkbyrcJYmX3xTmFczl74X2FMzDp/oHDeBZsJpqLGl1w2WAW8
SE0ROIp8NTzM/YVzMNjt+wrnTrDP9xbOqWAbHyycv8Em31M4j4I9f6hwjg17
Oz7GkuA+cOAhkj9LPpAbI40JzosR31GrxvdXxAKsSTDhQfgkyftz473RwfEn
tnHnzPly8ua7ZMZ4e0j+UBgH7ib9+8I8PxwFXMXjhXN12PD5hfNt+KybCufA
Okt/onDODB9xa2H/Sl7mtsL5mB7Sby6cy+nCPi6MY7i3JwvnCNm/7xaOf7BF
CwrjUZ73scJ5QXzH7YXzQz3xTYVzV53AVoVzk/idhwvnIPGDjxTOTeJr7iic
c+ol/e7CuSt862Y114V3VN9dhXNX2O0bCvsecnlTaq7tnsn6lD4v87c2E6N/
hw+DYyc3BX9Irhz7t17NuQBwzp+Z8783SfaqOf9OjHRd5r0I3wXvRc4XG7gy
2jFiFzhy7BZcPfEO3DK5298z867wz9jqAREjgUnJmxNj/oKNzczfU4cJH06c
A0/KniYPAG9GDvou9a1TM24GP0+rOK99q/r71JyfIlcFP06Om5j758w1NnB9
Ayq2tdRCkCfFjlInQDxIjQ3xwm/BPD9x5bSqeRz4HPbyv3lr7AD1scQavwbz
vdPL/s7gl+D6BvY43zqt5owq/mYHbhYsd3JmHp74nVojnnELjc+r5uiwA/hc
YhHqHag9IDYhN0uNBDHHzZlringvfwXXOayOdTP7DWo8yPlS50BMe0PmuG+n
kuvFqHOA17gkc50hdWN89we3w/7rXnN+hDifmiP4cLgj6q2or4XHBTNT6wkv
Ty0rdcPwi9S7kkcDIw+umRuH76Vui28EiIeJV6n5J/7EjsDhwwNT18Y8LC+5
LpSaSLg48lFgdvJ65CjJc8GVgaf/zsyd9az4m4WmMYYAkz9bck6SWlfycK9n
PhfnhOf7MBjLgenYL3Cb5Kz4JoJYHZsFv02sjt0jrqEOe2jFXOvm6mtfMx8L
d700MydGHPExPjIzT05+AZ4NfNqlZt6bvAI2Dh4MbuqTzDEgNZlrV8yTk2/A
9sGhYSO7RT8G103NF76O2k9quedm/j6FGP+wzN9owAPA2+MLPstcf8X3IFMq
9qWseWJl/CF1vNSJ429Z28TT2BJqgKn7xpe2ibE29a7UEfJNKJzntLK/y6H+
nxw07+Ko3Dl6bCx5VnhmbCw8wnMl1xsfnjtHj508InfuHrs9L3fNALa0TjB+
A181iliL2IpcETw5NjNLXScADm8a/O0Sdc6rcnOk/cBWufnhdcAkueuXOoOb
gnnCAeDk4G+UNsDepuZvWTNtgr9RWl/9zYK/h6L+iliamJr4qByMLfsXzluD
jR/IHLeDV9ctnGMiv0VdN7kz1gx5DzhWYiLW0xm5c2Rgp4tz59DBXefmjqfA
WpdI710y1iInTj6YmvNLc+fKwTB/5ObV+xaufSF2Ix48PXfOCDzWIJg/Hyy9
YTA3PkR6NZhTXa9wPQ35BXLz9YPj30HqvzI1p/2k+tcM5p8Hqv/MGCsRx1HT
SG0QNc/UDIH/sdfUS8Epwu/D+VMLRC09OAY8Q3wB131E2X6N2tclcV/w/eay
GP9SU3RU2f5xv7iX2dNwMXxvxHdYcGvwbXwzBE8IF8i3xXxfMzruZb7HpA6V
b3aogYePoZYefu+Ekmuo+Y4azpn6f2rOqQ/Dp/BtNfW7fB9EjTt8JvX55P6o
veEbGvhDuEbqbfmekzw83xTAJcJJUp9LTQKxyy2FfQk+hTidfcX+Ivan9hIb
/3LhGkiekWflO3d89WLJZblrI7sWrvPExi8snEPBD7xauNbq9JJ9yie56047
FeZ/4bjAAXyvTZ6db6u/jBwXMdovMV4jnvoud56lu479IXeepUfhfBY47QMw
Yu54qrf6v4f7k96tMA9P3RvfL1BrSKyHj4f/BxtQS/inxt+g/j4a82dhrMA3
oV8TXyaun/m6cK0kMXJecy6E/f5l4VpM4vE1a/6mkT24Rs25Iu65XHP+ifup
1JxjYL/Ur/l7RfbFssJ1tMTaJFLJJ2E3lheuMSXurltzHgLb8kth+0t9b7Oa
c0vYjV8L22jqh5Oac2O8o+8K163CAzSvOW+E/WlQ87ea7Me05nwGc1iv5m8m
2YM/FvYx1JHWav6ekz0Yas6NYYuqNee9sG9ZzbkW5rOo+dtO9vi3hetr4Sjq
1Jxb4j3+UziXxtr4ozB2oa74q8I1vvAbKwrXzsIbfFO4hhXu4v+LJq+C
             "]], 
            Polygon3DBox[CompressedData["
1:eJwtm3XAVdXSxvc5uNfxrOM+gAIKiJKSSkiD8tIISpcY2F3XaxeI3XXtwu7u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             "]], 
            Polygon3DBox[CompressedData["
1:eJwl1neYVsUVx/GXsi/suyyw1KVIUZoUQWQXhUWkh04QRCGKAlKUZmyIgIAo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             "]]},
           Annotation[#, "Charting`Private`Tag$33244#1"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
           "Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 0, 2}]}}]}, 
       {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJxFnHXYFlXXxR+ZwXvGmWfs7u7u147XLuzCQAVECUFQERtECZVSpLtRUQQB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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtm2W4HUXWhS/nXOi+nDoXBh3cXWZwBhvc3d0luCe4Q5AEgidAIMHdLbgE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             "]], 
            Polygon3DBox[CompressedData["
1:eJwl1nmUjlUcB/BHlpnMaEUkpLJWTh1FoRjZ0qLoZCf7UsaWPVsYS7YIlSUq
qnNCG0khZcs6EsLoREUnTtEipejz6/3jd85zP/d7l/ede593ynXq0yz7kiRJ
xquCakqRJBmTniTn0pKkVf4k+SuDs58LJEn2pUmSpy8nM0kms1Gez8q1kPtT
rgcrwUaze+S/lJvKxrHzrL3cBbnn2Gj2J2vJzrHpLIf9y55gibE3qiqxHltn
kxPlyrPqbBbbweawrsZexgawWtbNlblHNWMfssvNt1luqaqj/26f4wN9M41L
k8vvub3cRPN1lCnJirO+bAkbyMqxSmwc+4TlsBtYZTaerWUTWA32EHuPFbTu
WlaEpbOebLpcV/aGqmsvNe1llb4X7OW83Go2T24166G9TG4z6ya3hs2WG68G
ej4pd781TsrksEHsFGvCTrFixl8Z87AF1s1mV7JM1o7NYb1YbfYoW8UuM3YT
K82uY4PZMrlhbJw1nmY/scZyP7Fr5a5h/dhSuUGsLCvDhrIV7BlWnF3FerGF
rA+7ihVhHdhc9iQryq5g3dh81psVYpewtmwCe4JdwTJYGzab9WRd7O9S1pst
Zg/KXB/niI1kK9mzchmsEOvKprLOrKexJdmY+O7Z4zLT4rtm/7AOPu9FuZv4
bWwK2yQ3nU2SG85+ZY/K/cqukyvFBrG35YayCXJD2WnWVO503C25fKw1y5Hr
wCbKDWNn2CNyZ1gZudJsCFsuN5wNk2vNdrFKcrtZYbmCbEbsUa4T6y5XVHu4
3LusHyuRmfrbxN/oJX1NM1NnP+7AFO2pMYdxr6kCzl5B1doaf2ek7nrc+ZHx
nlCvyixRGTKZqqO+fJmpcx7nfWbcV/W8TCu+mU2LsxGfW7s3rxDrsa36xhq3
nzdy7rPMl6tvYZxv9bDnT+VKWuMzuX6sKnuR7Ym9s77sVjaX5bLnWB92C5vD
drNJrJ01dnmeHd9LvAO0s+VuTk9Z9E3OSL2z4t01lhe2n9dlSsmu0j9K7lXe
XLuN2hJngr0T51V7sGxTzxvYtebYYK6h7DG2lZVjW9gB2cY+bz3z79H3SryH
VU/P38jVlDsiN4J1ZPvZ7ewrNpr1YEfY3SyPzTVfDc+H2R/x/WjXifsQ70J2
Iv7G2veqsnHn2Q9xZrRnxxln+9jv8Z1pV1T3ea5jfw3s8yvtUdbtzvLk7pI/
ZN2RrFt6at3/12cvsfWslrFZxq5gL7PPWW1Wj73DnmFtWa6xVYzNZQvYDvaU
3HG5t9it1m7IurOt7IJ2hfi88R41dqe/wVy5Sqw+qyvXUG6f9nDztWG75Spb
Y5fcGnXRmP38gFok8wE7zbZpb1fz2Ty11fMX6am+N2UaxTnX3mm+iuY7yOqz
9mwjK8P2soasC9vBKrCv2VjzZbPvWRb7Ln4T5B5nn7BibBurx1qydewatoNl
sRZsLSvOtrMGrHPsl5VnB1gBlrDJ8Ttlz+1ZLVZC/3q5Y3ySdjd7udrzsDi7
cv3lBrLG7H1WWH6M3Mv8W/01+cq41zKL2Al2r/bHcV7YcnaWZcVnibsY99f4
jZ4Xmy9P32DtaqoJ26cusI+Mqxp3P95r6ak5VrL7WKv01J5j7zvZEHM2Z1vS
Uud6msyzrDf7jtVlx+QO8QfizLLf4oxo95er5nkBOxDvKLmnWLn4PtiGuNvs
SXY9m8g+ZSNYL1aWTWDr2UiWF7/71jjK/o33lfaLcmvj76Z+lFssty5+z+Iu
x72O70KmRfzOx31MS70bW2rvUbXNVyPeN/oe035atpbnJXJH5ebF+5X/wvay
quadof28OsPqG9vEHAe171f92CG56nInjG3M+rKD7E52nC1iF9kJ1oAt1t6t
apqnuvkW6HtEe4C93BGfU+5re5kVd5WfZw3kHpQ/HP9rqLS4q3LT5LrI/QcY
KmR6
             "]]},
           Annotation[#, "Charting`Private`Tag$33244#2"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[
            0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
           "Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}, {}}, {
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0j1IlWEUB/Bjfl6/ISRsMMNZsWgzIQJF0CF0yhJEElQwR3VuKEQaGlLb
s9Kshox2XUPwo+tHmrUJlg41hKD+HoL7vL//uZznvM9773u1b6TzYU5EzFiN
FyJSPnU54HgmopKPeIVP2cAXbOYbdvBZcUTGnnvyK7lWbjJrSH2XN9RresfV
t+Ws/ET+ySkecZYnXGTGjGVuskf/HTPW1JW8r57Nj1hP9+IGX/NrOg+znOMm
vxRE9OrfklfkPrnTjG11Dx+o5/XuqPvlt/I3eYG7fMc9vud3fuA+180a1N9l
xg91FQfUdc67mmousZAf+c9zveQvPudn37fofywvyrfkI2ss7THrmryqd1A9
IS/L3fIntqfn5k1Os56TrOGoWX953YwK5vIPLzt3OatZxkssTedkCS/S1mjz
XMfp97da5d/Mun8Rz3iY/gO9hRxWl8vaopQ+UeySxyLmsoCOEBuahnL+v1/n
wOZL+w==
         "]]}, 
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0ktLVWEUBuBVJzBTcqrDRvoL6hfksIGkeTteTkSEYtagHIgoeTle6qQT
cealeaGhIwskaGRB1ECsBJHCCzixvIvPxsHH877w7cVi730j87ii7VJETDiz
VyJeXI7oZksqIl0QMaY/5BSf8h27+JFD/MLGwohh93/JHfK0vGjGjr7KeX3O
3WP9k7wgX+MSS/iVZVzlLW6ynDNmrfGbGZUc42/u5UVU8R/v8T+ruc8aHrCW
efkR66xz8uUNfjejnmv8w0N30/zrHMkNPGYjT9jEUzbzjBleN2ubP8y4z3Fu
MWXfu8le9r+dzORNrrCUyyzmsHufk52crLzEJ2YceT+DnNNn3d3WC/U38k95
nMvM8gM7+ZbtnOQds5579r1nRvU+PtNb7f1ab2GOj/gq+a58yQcc4ehV3zjZ
T87J7XKNGUN6D9v0jLuD+q7cJGflBg6wnv2sZR+r2csi72sndfF/nQM58l0w

         "]]}, 
       {GrayLevel[0.2], 
        Line3DBox[{2425, 2674, 2783, 1457, 2782, 2675, 3494, 2596, 2426, 3495,
          2597, 2427, 3496, 2598, 2428, 3497, 2599, 2429, 3393, 3498, 2600, 
         2784, 3644, 2677, 2824, 2869, 2601, 2892, 2870, 2871, 2825, 3341, 
         3613, 2785, 2678, 3499, 2602, 2430, 3500, 2603, 2431, 3501, 2604, 
         2432, 3502, 2605, 2433, 3394, 3503, 2787, 2606, 2786, 1612, 2788, 
         2607, 2679}], 
        Line3DBox[{2435, 2676, 3342, 3612, 2434, 1468, 2436, 3504, 2608, 2437,
          3505, 2609, 2438, 3506, 2610, 2439, 3614, 2681, 2611, 2789, 3645, 
         2682, 2826, 2872, 2873, 2790, 2874, 2683, 2827, 3343, 3615, 2791, 
         2684, 3344, 3616, 2440, 3507, 2612, 2441, 3508, 2613, 2442, 3509, 
         2614, 2443, 1614, 2615, 2685, 3617, 2680, 2616, 2444}], 
        Line3DBox[{2446, 3345, 3552, 2445, 3346, 3553, 2447, 1479, 2448, 3510,
          2617, 2449, 3511, 2618, 2450, 3618, 2686, 2619, 2792, 3646, 2687, 
         2828, 2875, 2876, 2793, 2877, 2688, 2830, 3347, 3619, 2794, 2689, 
         3348, 3620, 2451, 3349, 3554, 2452, 3512, 2620, 2453, 3513, 2621, 
         2454, 3514, 2622, 2455, 3515, 2623, 2456}], 
        Line3DBox[{2458, 3350, 3555, 2457, 3351, 3556, 2459, 3352, 3557, 2460,
          1492, 2461, 3516, 2624, 2462, 3621, 2690, 2691, 2463, 3622, 2692, 
         2829, 2693, 2464, 2694, 2831, 2695, 3647, 2465, 2696, 2697, 3623, 
         2466, 3353, 3558, 2467, 3354, 3559, 2468, 3517, 2625, 2469, 3518, 
         2626, 2470, 3519, 2627, 2471}], 
        Line3DBox[{2473, 3355, 3560, 2472, 3356, 3561, 2474, 3357, 3562, 2475,
          3358, 3563, 2476, 1505, 2477, 3520, 2628, 2478, 3624, 2698, 2699, 
         2479, 2700, 2701, 3648, 2480, 2702, 2703, 3625, 2481, 3359, 3564, 
         2482, 3360, 3565, 2483, 3361, 3566, 2484, 3521, 2629, 2485, 3522, 
         2630, 2486}], 
        Line3DBox[{2500, 2726, 2725, 3627, 2499, 2723, 3574, 3409, 2498, 2721,
          3573, 3407, 2497, 3405, 3572, 2719, 2496, 3403, 3571, 2717, 2495, 
         1652, 2714, 2494, 3650, 2713, 2879, 2881, 2880, 2493, 2882, 2883, 
         2878, 2904, 2903, 3665, 2492, 2902, 1869, 2491, 3570, 3362, 2490, 
         2711, 3569, 3400, 2489, 3398, 3568, 2709, 2488, 3396, 3567, 2707, 
         2487, 3626, 2705, 2704, 2706}], 
        Line3DBox[{106, 542, 396, 570, 1369, 107, 610, 397, 1846, 572, 108, 
         611, 398, 1847, 573, 109, 1768, 399, 110, 1769, 400, 111, 1770, 401, 
         575, 112, 1858, 600, 297, 486, 113, 467, 299, 579, 1370, 114, 616, 
         402, 584, 1371, 115, 403, 1372, 116, 404, 1373, 117, 617, 1771, 405, 
         585, 118, 618, 1772, 406, 586, 119, 1865, 619, 407, 587, 120}], 
        Line3DBox[{2514, 2861, 2862, 2804, 3653, 3411, 2513, 2724, 2803, 3652,
          3410, 2512, 2722, 2802, 3651, 3408, 2511, 3406, 3582, 2801, 2720, 
         2510, 3404, 3581, 2800, 2718, 2509, 3402, 3580, 2799, 2716, 2508, 
         1598, 2715, 2847, 2846, 2507, 2884, 2885, 2858, 2890, 1856, 2506, 
         2731, 3579, 3415, 2505, 2730, 3578, 3413, 2504, 2712, 2798, 3649, 
         3401, 2503, 3399, 3577, 2797, 2710, 2502, 3397, 3576, 2796, 2708, 
         2501, 3395, 3575, 2795, 2860, 2859, 2727}], 
        Line3DBox[{2515, 2863, 2864, 2805, 3654, 2631, 2832, 2728, 2806, 3655,
          2632, 2833, 2729, 2807, 3656, 2633, 2834, 3412, 3523, 2808, 2634, 
         2516, 3414, 3524, 2809, 2635, 2893, 3427, 3664, 2900, 2810, 2636, 
         2738, 1599, 2811, 2865, 2637, 2891, 2866, 2867, 2857, 2889, 1530, 
         2856, 2732, 2908, 3667, 2638, 2886, 2733, 3525, 2639, 2517, 2734, 
         2812, 3657, 2640, 2835, 3416, 3526, 2813, 2641, 2836, 3417, 3527, 
         2814, 2642, 2837, 3418, 3528, 2815, 2868, 2643, 2741}], 
        Line3DBox[{2519, 2735, 3363, 3628, 2518, 2736, 3529, 2644, 2520, 2737,
          3530, 2645, 2521, 3419, 3531, 2646, 2522, 3420, 3532, 2647, 2523, 
         1695, 2648, 2743, 3630, 2739, 2894, 2896, 2901, 2649, 2899, 2897, 
         2898, 2895, 2907, 3364, 3666, 2906, 2905, 1538, 2524, 3533, 2650, 
         2525, 2740, 3534, 2651, 2526, 3421, 3535, 2652, 2527, 3422, 3536, 
         2653, 2528, 3629, 2742, 2654, 2744}], 
        Line3DBox[{2530, 3365, 3583, 2529, 3366, 3584, 2531, 3537, 2655, 2532,
          3538, 2656, 2533, 3539, 2657, 2534, 3631, 2745, 2658, 2816, 3658, 
         2746, 2659, 2817, 2747, 3367, 3632, 2535, 3368, 3585, 2536, 1548, 
         2537, 3540, 2660, 2538, 3541, 2661, 2539, 3542, 2662, 2540, 3543, 
         2663, 2541}], 
        Line3DBox[{2543, 3369, 3586, 2542, 3370, 3587, 2544, 3371, 3588, 2545,
          3544, 2664, 2546, 3545, 2665, 2547, 3633, 2748, 2666, 2818, 3659, 
         2749, 2838, 2667, 2819, 2750, 2840, 3372, 3634, 2820, 2751, 3373, 
         3635, 2548, 3374, 3589, 2549, 1561, 2550, 3546, 2668, 2551, 3547, 
         2669, 2552, 3548, 2670, 2553}], 
        Line3DBox[{2555, 3375, 3590, 2554, 3376, 3591, 2556, 3377, 3592, 2557,
          3378, 3593, 2558, 3549, 2671, 2559, 3636, 2752, 2753, 2560, 3637, 
         2754, 2839, 2755, 2848, 2887, 2849, 2756, 2841, 2757, 3660, 2561, 
         2758, 2759, 3638, 2562, 3379, 3594, 2563, 3380, 3595, 2564, 1574, 
         2565, 3550, 2672, 2566, 3551, 2673, 2567}], 
        Line3DBox[{2569, 2760, 2761, 3661, 2568, 2762, 1724, 2570, 3381, 3596,
          2571, 3382, 3597, 2572, 3383, 3598, 2573, 3639, 2765, 2766, 2574, 
         3640, 2767, 2842, 2768, 2850, 2888, 2851, 2769, 2843, 2770, 3662, 
         2575, 2771, 2772, 3641, 2576, 3384, 3599, 2577, 3385, 3600, 2578, 
         3386, 3601, 2579, 1587, 2580, 3642, 2773, 2774, 2581}], 
        Line3DBox[{2595, 2775, 2823, 1735, 2594, 2781, 3611, 3426, 2593, 3610,
          3392, 2592, 3609, 3391, 2591, 3608, 3390, 2590, 3425, 3607, 2780, 
         2589, 3663, 2779, 2845, 2855, 2854, 2588, 2852, 2853, 2844, 2778, 
         3643, 2587, 2777, 3606, 3424, 2586, 3605, 3389, 2585, 3604, 3388, 
         2584, 3603, 3387, 2583, 3423, 3602, 2822, 2764, 2582, 1725, 2821, 
         2763, 2776}], 
        Line3DBox[{2909, 3146, 3240, 2047, 3239, 3147, 3772, 3076, 2910, 3720,
          3077, 2911, 3721, 3078, 2912, 3722, 3079, 2913, 3472, 3773, 3080, 
         3241, 2190, 3277, 3316, 3081, 3331, 3317, 3318, 3278, 2052, 3242, 
         3149, 3774, 3082, 2914, 3723, 3083, 2915, 3724, 3084, 2916, 3725, 
         3085, 2917, 3473, 3796, 3244, 3086, 3243, 2197, 3245, 3087, 3150}], 
        Line3DBox[{2919, 3148, 3428, 3668, 2918, 2058, 2920, 3726, 3088, 2921,
          3727, 3089, 2922, 3728, 3090, 2923, 2203, 3091, 3246, 3729, 3152, 
         3279, 1178, 1249, 1179, 3280, 3429, 3797, 3247, 3153, 2063, 2924, 
         3730, 3092, 2925, 3731, 3093, 2926, 3732, 3094, 2927, 2199, 3095, 
         3154, 3733, 3151, 3096, 2928}], 
        Line3DBox[{2930, 3430, 3669, 2929, 3431, 3670, 2931, 2069, 2932, 3734,
          3097, 2933, 3735, 3098, 2934, 3736, 3155, 3099, 3248, 3737, 3156, 
         3281, 3319, 3320, 3249, 3321, 3157, 3282, 3432, 3798, 3250, 3158, 
         3433, 3671, 2935, 2074, 2936, 3738, 3100, 2937, 3739, 3101, 2938, 
         3740, 3102, 2939, 3741, 3103, 2940}], 
        Line3DBox[{2942, 3434, 3672, 2941, 3435, 3673, 2943, 3436, 3674, 2944,
          2082, 2945, 3742, 3104, 2946, 3743, 898, 1020, 2330, 899, 1021, 900,
          2331, 1022, 901, 3675, 2947, 3437, 3676, 2948, 2087, 2949, 3744, 
         3105, 2950, 3745, 3106, 2951, 3746, 3107, 2952}], 
        Line3DBox[{2954, 3438, 3677, 2953, 3439, 3678, 2955, 3440, 3679, 2956,
          3441, 3680, 2957, 2095, 2958, 3747, 3108, 2959, 3748, 3159, 3160, 
         2960, 3161, 3162, 3681, 2961, 3163, 3164, 3682, 2962, 3442, 3683, 
         2963, 3443, 3684, 2964, 2101, 2965, 3749, 3109, 2966, 3750, 3110, 
         2967}], Line3DBox[{2980, 3191, 3190, 3751, 2979, 3188, 2241, 2978, 
         3186, 3779, 3480, 2977, 3183, 3778, 3182, 2976, 3478, 3777, 3180, 
         2975, 2233, 3177, 2974, 3687, 3176, 3323, 1209, 1211, 1210, 3322, 
         1278, 3810, 2973, 3337, 2415, 2972, 3686, 3444, 2971, 3173, 3776, 
         3172, 2970, 3475, 3775, 3170, 2969, 2227, 3168, 2968, 3685, 3166, 
         3165, 3167}], 
        Line3DBox[{748, 1184, 1038, 1212, 1962, 749, 1252, 1039, 1214, 750, 
         1253, 1040, 2403, 1215, 751, 1041, 752, 2337, 1042, 753, 2338, 1043, 
         1217, 754, 2411, 1242, 939, 1128, 755, 1109, 941, 1221, 1963, 756, 
         1258, 1044, 1226, 757, 1045, 1964, 758, 1046, 759, 1259, 2339, 1047, 
         1227, 760, 1260, 1048, 1228, 761, 2413, 1261, 1049, 1229, 762}], 
        Line3DBox[{2994, 3308, 3309, 3260, 2246, 2993, 3189, 3259, 3781, 3482,
          2992, 3187, 3258, 3780, 3481, 2991, 3185, 3257, 3184, 2990, 3479, 
         3802, 3256, 3181, 2989, 3477, 3801, 3255, 3179, 2988, 2183, 3178, 
         3296, 3295, 2987, 3324, 3325, 3305, 3329, 2409, 2986, 3197, 3785, 
         3485, 2985, 3196, 3784, 3483, 2984, 3175, 3254, 3174, 2983, 3476, 
         3800, 3253, 3171, 2982, 3474, 3799, 3252, 3169, 2981, 2226, 3251, 
         3307, 3306, 3192}], 
        Line3DBox[{2995, 3310, 3311, 3261, 2114, 3283, 3193, 3262, 3782, 3111,
          3284, 3194, 3263, 3783, 3112, 3285, 3195, 3264, 3113, 2996, 3484, 
         3803, 3265, 3114, 3332, 3335, 3804, 3336, 3266, 3115, 3205, 2184, 
         3267, 3312, 3116, 3330, 3313, 3314, 3304, 3328, 2117, 3303, 3198, 
         3340, 3786, 3117, 3326, 3199, 3787, 3118, 2997, 3200, 3268, 3119, 
         3286, 3486, 3805, 3269, 3120, 3287, 3487, 3806, 3270, 3121, 3288, 
         2258, 3271, 3315, 3122, 3208}], 
        Line3DBox[{2999, 3201, 3445, 3688, 2998, 3202, 2121, 3000, 3203, 3788,
          3123, 3001, 3204, 3789, 3124, 3002, 3488, 3790, 3125, 3003, 2266, 
         3126, 3210, 3752, 3206, 3333, 1264, 1270, 1265, 3334, 1281, 3811, 
         3339, 3338, 2124, 3004, 3753, 3127, 3005, 3207, 3791, 3128, 3006, 
         3489, 3792, 3129, 3007, 2272, 3130, 3008, 3754, 3209, 3131, 3211}], 
        Line3DBox[{3010, 3446, 3689, 3009, 3447, 3690, 3011, 2128, 3012, 3755,
          3132, 3013, 3756, 3133, 3014, 3757, 3212, 3134, 3272, 3758, 3213, 
         3135, 3273, 3214, 3448, 3691, 3015, 3449, 3692, 3016, 2133, 3017, 
         3759, 3136, 3018, 3760, 3137, 3019, 3761, 3138, 3020, 3762, 3139, 
         3021}], Line3DBox[{3023, 3450, 3693, 3022, 3451, 3694, 3024, 3452, 
         3695, 3025, 2141, 3026, 3763, 3140, 3027, 3764, 971, 1064, 2347, 972,
          1065, 973, 2348, 1066, 974, 3696, 3028, 3453, 3697, 3029, 2146, 
         3030, 3765, 3141, 3031, 3766, 3142, 3032, 3767, 3143, 3033}], 
        Line3DBox[{3035, 3454, 3698, 3034, 3455, 3699, 3036, 3456, 3700, 3037,
          3457, 3701, 3038, 2154, 3039, 3768, 3215, 3216, 3040, 3807, 3217, 
         3289, 3218, 3297, 3327, 3298, 3219, 3290, 3220, 3702, 3041, 3221, 
         3222, 3703, 3042, 3458, 3704, 3043, 3459, 3705, 3044, 2159, 3045, 
         3769, 3144, 3046, 3770, 3145, 3047}], 
        Line3DBox[{3049, 3223, 3224, 3706, 3048, 3225, 2294, 3050, 3460, 3707,
          3051, 3461, 3708, 3052, 3462, 3709, 3053, 2297, 3228, 3054, 3809, 
         3229, 3291, 1141, 1233, 1142, 3292, 3230, 3710, 3055, 3231, 2302, 
         3056, 3463, 3711, 3057, 3464, 3712, 3058, 3465, 3713, 3059, 2172, 
         3060, 3771, 3232, 3233, 3061}], 
        Line3DBox[{3075, 3234, 3276, 2305, 3074, 3238, 3795, 3493, 3073, 3719,
          3471, 3072, 3718, 3470, 3071, 3717, 3469, 3070, 3492, 3794, 3237, 
         3069, 2312, 3294, 3302, 3301, 3068, 3299, 3300, 3293, 2310, 3067, 
         3236, 3793, 3491, 3066, 3716, 3468, 3065, 3715, 3467, 3064, 3714, 
         3466, 3063, 3490, 3808, 3275, 3227, 3062, 2295, 3274, 3226, 
         3235}]}, 
       {GrayLevel[0.2], 
        Line3DBox[{1286, 1601, 1458, 3494, 1287, 1468, 1308, 3553, 1478, 1321,
          3556, 1490, 1334, 3561, 1502, 1348, 3567, 1642, 1515, 1361, 3576, 
         1643, 1795, 1816, 1817, 1846, 1818, 1669, 1803, 1528, 3655, 1375, 
         1687, 1535, 3529, 1382, 3584, 1542, 1395, 3587, 1554, 1409, 3591, 
         1566, 1422, 1724, 1578, 1435, 3602, 1726, 1589, 1447}], 
        Line3DBox[{1288, 1459, 3495, 1289, 1469, 3504, 1309, 1479, 1322, 3557,
          1491, 1335, 3562, 1503, 1349, 3568, 1644, 1516, 1362, 3577, 1645, 
         1796, 1819, 1820, 1847, 1821, 1670, 1804, 1529, 3656, 1376, 1688, 
         1536, 3530, 1383, 1543, 3537, 1396, 3588, 1555, 1410, 3592, 1567, 
         1423, 3596, 1579, 1436, 3603, 1590, 1448}], 
        Line3DBox[{1290, 1460, 3496, 1291, 1470, 3505, 1310, 1480, 3510, 1323,
          1492, 1336, 3563, 1504, 1350, 3569, 1646, 1647, 1763, 3649, 1648, 
         1797, 1649, 1768, 1671, 1805, 1672, 3523, 1773, 1689, 1690, 3531, 
         1384, 1544, 3538, 1397, 1556, 3544, 1411, 3593, 1568, 1424, 3597, 
         1580, 1437, 3604, 1591, 1449}], 
        Line3DBox[{1292, 1461, 3497, 1293, 1471, 3506, 1311, 1481, 3511, 1324,
          1493, 3516, 1337, 1505, 1351, 3570, 1517, 1363, 3578, 1673, 1674, 
         1769, 1675, 1676, 3524, 1774, 1691, 1692, 3532, 1385, 1545, 3539, 
         1398, 1557, 3545, 1412, 1569, 3549, 1425, 3598, 1581, 1438, 3605, 
         1592, 1450}], 
        Line3DBox[{1294, 1603, 1604, 3498, 1295, 1617, 3614, 1618, 1312, 1624,
          3618, 1625, 1325, 1630, 3621, 1631, 1338, 1506, 3520, 1352, 1869, 
         1870, 1364, 3579, 1677, 1859, 1861, 1860, 1770, 1863, 1864, 1862, 
         1868, 1867, 3664, 1775, 1694, 1695, 1386, 1706, 3631, 1707, 1399, 
         1711, 3633, 1712, 1413, 1717, 3636, 1718, 1426, 1727, 3639, 1728, 
         1439, 3606, 1738, 1739, 1741}], 
        Line3DBox[{1296, 1826, 1827, 1751, 3644, 1605, 1791, 1619, 1756, 3645,
          1620, 1792, 1626, 1758, 3646, 1627, 1793, 1632, 3622, 1760, 1633, 
         1339, 1636, 3624, 1637, 1845, 1872, 3665, 1873, 1871, 1650, 1824, 
         1856, 1857, 1825, 1831, 1830, 1858, 1832, 1833, 1693, 1599, 1776, 
         1696, 1705, 3630, 1697, 1866, 1708, 1780, 3658, 1709, 1400, 1713, 
         1781, 3659, 1714, 1810, 1719, 3637, 1783, 1720, 1811, 1729, 3640, 
         1786, 1730, 1812, 1740, 3643, 1789, 1835, 1834, 1743}], 
        Line3DBox[{8, 561, 367, 606, 2892, 23, 563, 373, 2790, 607, 38, 564, 
         376, 2793, 608, 53, 2464, 379, 68, 2479, 381, 83, 2493, 569, 387, 
         609, 98, 2507, 577, 296, 466, 113, 494, 315, 602, 2891, 128, 589, 
         419, 628, 2899, 143, 421, 2817, 158, 423, 2819, 173, 590, 2887, 426, 
         624, 188, 591, 2888, 432, 625, 203, 2588, 593, 436, 559, 218}], 
        Line3DBox[{1299, 1464, 3500, 1300, 1474, 3507, 1315, 3554, 1484, 1328,
          3558, 1496, 1342, 3564, 1509, 1355, 3571, 1654, 1520, 1367, 3581, 
         1655, 1525, 1372, 1679, 1532, 3525, 1379, 1539, 3533, 1389, 1548, 
         1403, 3589, 1560, 1416, 3594, 1572, 1429, 3599, 1584, 1442, 3608, 
         1595, 1453}], 
        Line3DBox[{1301, 1465, 3501, 1302, 1475, 3508, 1316, 1485, 3512, 1329,
          3559, 1497, 1343, 3565, 1510, 1356, 3572, 1656, 1521, 1368, 3582, 
         1657, 1798, 1526, 1373, 1680, 1806, 1533, 3657, 1380, 1698, 1540, 
         3534, 1390, 1549, 3540, 1404, 1561, 1417, 3595, 1573, 1430, 3600, 
         1585, 1443, 3609, 1596, 1454}], 
        Line3DBox[{1303, 1466, 3502, 1304, 1476, 3509, 1317, 1486, 3513, 1330,
          1498, 3517, 1344, 3566, 1511, 1357, 3573, 1658, 1659, 1765, 3651, 
         1660, 1799, 1661, 1837, 1771, 1838, 1681, 1807, 1682, 3526, 1777, 
         1699, 1700, 3535, 1391, 1550, 3541, 1405, 1562, 3546, 1418, 1574, 
         1431, 3601, 1586, 1444, 3610, 1597, 1455}], 
        Line3DBox[{1305, 1609, 1610, 3503, 1754, 1613, 1614, 1318, 1487, 3514,
          1331, 1499, 3518, 1345, 1512, 3521, 1358, 3574, 1662, 1663, 1766, 
         3652, 1664, 1800, 1665, 1839, 1772, 1840, 1683, 1808, 1684, 3527, 
         1778, 1701, 1702, 3536, 1392, 1551, 3542, 1406, 1563, 3547, 1419, 
         1575, 3550, 1432, 1587, 1445, 3611, 1745, 1746, 1456}], 
        Line3DBox[{1306, 1611, 1753, 1612, 1755, 1615, 1623, 3617, 1616, 1319,
          1488, 3515, 1332, 1500, 3519, 1346, 1513, 3522, 1359, 1666, 3627, 
         1667, 1767, 3653, 1668, 1801, 1842, 1841, 1865, 1843, 1844, 1809, 
         1685, 3528, 1779, 1703, 3629, 1704, 1393, 1552, 3543, 1407, 1564, 
         3548, 1420, 1576, 3551, 1433, 1733, 3642, 1734, 1788, 1735, 1747, 
         1736, 1748}], 
        Line3DBox[{1446, 1588, 1737, 1725, 1434, 1577, 1785, 3661, 1723, 1421,
          1565, 3590, 1408, 1553, 3586, 1394, 1541, 3583, 1381, 1534, 3628, 
         1686, 1374, 3654, 1527, 1802, 1815, 1814, 1369, 1522, 1813, 1794, 
         1641, 3575, 1360, 1514, 3626, 1640, 1347, 1501, 3560, 1333, 1489, 
         3555, 1320, 1477, 3552, 1307, 1467, 3612, 1602, 1285, 1457, 1750, 
         1600, 1749}], 
        Line3DBox[{1451, 1593, 1836, 1790, 3663, 1742, 1440, 1582, 1787, 3662,
          1731, 1427, 1570, 1784, 3660, 1721, 1414, 1558, 3634, 1782, 1715, 
         1401, 1546, 3632, 1710, 1387, 1537, 3666, 1876, 1875, 1878, 1877, 
         1377, 1530, 1855, 1823, 1849, 1848, 1370, 1523, 1822, 1678, 1598, 
         1365, 1518, 1764, 3650, 1651, 1353, 1507, 1762, 3648, 1638, 1340, 
         1494, 1761, 3647, 1634, 1326, 1482, 3619, 1759, 1628, 1313, 1472, 
         3615, 1757, 1621, 1297, 1462, 3613, 1752, 1829, 1828, 1606}], 
        Line3DBox[{1452, 1594, 1744, 3607, 1441, 1583, 3641, 1732, 1428, 1571,
          3638, 1722, 1415, 1559, 3635, 1716, 1402, 1547, 3585, 1388, 1538, 
         1874, 1378, 3667, 1531, 1852, 1854, 1853, 1371, 1524, 1851, 1850, 
         1653, 3580, 1366, 1519, 1652, 1354, 1508, 3625, 1639, 1341, 1495, 
         3623, 1635, 1327, 1483, 3620, 1629, 1314, 1473, 3616, 1622, 1298, 
         3499, 1463, 1607, 1608}], 
        Line3DBox[{1880, 2186, 2048, 3772, 1881, 2058, 1902, 3670, 2068, 1915,
          3673, 2080, 1928, 3678, 2092, 1942, 2227, 2105, 1955, 3799, 2228, 
         2361, 1122, 1214, 1123, 2367, 2115, 3782, 1966, 2260, 2121, 1972, 
         3690, 2127, 1985, 3694, 2139, 1999, 3699, 2151, 2012, 2294, 2163, 
         2025, 3808, 2296, 2174, 2037}], 
        Line3DBox[{1882, 2049, 3720, 1883, 2059, 3726, 1903, 2069, 1916, 3674,
          2081, 1929, 3679, 2093, 1943, 3775, 2229, 2106, 1956, 3800, 2230, 
         2362, 2378, 2379, 2403, 2380, 2247, 2368, 2116, 3783, 1967, 2261, 
         2122, 3788, 1973, 2128, 1986, 3695, 2140, 2000, 3700, 2152, 2013, 
         3707, 2164, 2026, 3714, 2175, 2038}], 
        Line3DBox[{1884, 2050, 3721, 1885, 2060, 3727, 1904, 2070, 3734, 1917,
          2082, 1930, 3680, 2094, 1944, 3776, 912, 1028, 3254, 913, 1041, 933,
          3264, 1053, 953, 3789, 1974, 2129, 3755, 1987, 2141, 2001, 3701, 
         2153, 2014, 3708, 2165, 2027, 3715, 2176, 2039}], 
        Line3DBox[{1886, 2051, 3722, 1887, 2061, 3728, 1905, 2071, 3735, 1918,
          2083, 3742, 1931, 2095, 1945, 3686, 2107, 1957, 3784, 2248, 2249, 
         2337, 2250, 2251, 3803, 2340, 2262, 2263, 3790, 1975, 2130, 3756, 
         1988, 2142, 3763, 2002, 2154, 2015, 3709, 2166, 2028, 3716, 2177, 
         2040}], Line3DBox[{1888, 2188, 2189, 3773, 1889, 2202, 2203, 1906, 
         2209, 3736, 2210, 1919, 2215, 3743, 2216, 1932, 2096, 3747, 1946, 
         2415, 2416, 1958, 3785, 2252, 2412, 1255, 2338, 1257, 1273, 1272, 
         3804, 2341, 2265, 2266, 1976, 2276, 3757, 2277, 1989, 2281, 3764, 
         2282, 2003, 2287, 3768, 2288, 2016, 2297, 2298, 2029, 3793, 2308, 
         2309, 2311}], 
        Line3DBox[{1890, 2385, 2386, 2321, 2190, 2357, 2204, 2326, 3729, 2205,
          2358, 2211, 2328, 3737, 2212, 2359, 2217, 2330, 2218, 1933, 2221, 
         3748, 2222, 2402, 2418, 3810, 2419, 2417, 2231, 2383, 2409, 2410, 
         2384, 2390, 2389, 2411, 2391, 2392, 2264, 2184, 2342, 2267, 2275, 
         3752, 2268, 2414, 2278, 2346, 3758, 2279, 1990, 2283, 2347, 2284, 
         2372, 2289, 3807, 2349, 2290, 2373, 2299, 3809, 2352, 2300, 2374, 
         2310, 2355, 2394, 2393, 2313}], 
        Line3DBox[{650, 1203, 1009, 1248, 3331, 665, 1205, 1015, 1249, 680, 
         1206, 1018, 3249, 1250, 695, 1021, 710, 2960, 1023, 725, 1211, 1029, 
         1251, 740, 2987, 1219, 938, 1108, 755, 1136, 957, 1244, 3330, 770, 
         1231, 1061, 1270, 785, 1063, 3273, 800, 1065, 815, 1232, 3327, 1068, 
         1266, 830, 1233, 1074, 1267, 845, 3068, 1235, 1078, 1201, 860}], 
        Line3DBox[{1893, 2054, 3723, 1894, 2064, 3730, 1909, 2074, 1922, 3676,
          2086, 1936, 3683, 2099, 1949, 3777, 2235, 2110, 1961, 3802, 2236, 
         2113, 1964, 2254, 2119, 3787, 1970, 2125, 3753, 1979, 2133, 1993, 
         3697, 2145, 2006, 3704, 2157, 2019, 3711, 2169, 2032, 3717, 2180, 
         2043}], Line3DBox[{1895, 2055, 3724, 1896, 2065, 3731, 1910, 2075, 
         3738, 1923, 2087, 1937, 3684, 2100, 1950, 3778, 921, 1033, 3257, 922,
          1046, 944, 3268, 1057, 959, 3791, 1980, 2134, 3759, 1994, 2146, 
         2007, 3705, 2158, 2020, 3712, 2170, 2033, 3718, 2181, 2044}], 
        Line3DBox[{1897, 2056, 3725, 1898, 2066, 3732, 1911, 2076, 3739, 1924,
          2088, 3744, 1938, 2101, 1951, 3779, 2237, 2238, 2334, 3780, 2239, 
         2363, 2240, 2396, 2339, 2397, 2255, 2369, 2256, 3805, 2343, 2269, 
         2270, 3792, 1981, 2135, 3760, 1995, 2147, 3765, 2008, 2159, 2021, 
         3713, 2171, 2034, 3719, 2182, 2045}], 
        Line3DBox[{1899, 2194, 2195, 3796, 2324, 2198, 2199, 1912, 2077, 3740,
          1925, 2089, 3745, 1939, 2102, 3749, 1952, 2241, 2242, 2335, 3781, 
         2243, 2364, 1193, 1260, 1194, 2370, 2257, 3806, 2344, 2271, 2272, 
         1982, 2136, 3761, 1996, 2148, 3766, 2009, 2160, 3769, 2022, 2172, 
         2035, 3795, 2315, 2316, 2046}], 
        Line3DBox[{1900, 2196, 2323, 2197, 2325, 2200, 2208, 3733, 2201, 1913,
          2078, 3741, 1926, 2090, 3746, 1940, 2103, 3750, 1953, 2244, 3751, 
         2245, 2336, 2246, 2365, 2399, 2398, 2413, 2400, 2401, 2371, 2258, 
         2345, 2273, 3754, 2274, 1983, 2137, 3762, 1997, 2149, 3767, 2010, 
         2161, 3770, 2023, 2303, 3771, 2304, 2354, 2305, 2317, 2306, 2318}], 
        Line3DBox[{2036, 2173, 2307, 2295, 2024, 2162, 2351, 3706, 2293, 2011,
          2150, 3698, 1998, 2138, 3693, 1984, 2126, 3689, 1971, 2120, 3688, 
         2259, 1965, 2114, 2366, 2377, 2376, 1962, 2111, 2375, 2360, 2226, 
         1954, 2104, 3685, 2225, 1941, 2091, 3677, 1927, 2079, 3672, 1914, 
         2067, 3669, 1901, 2057, 3668, 2187, 1879, 2047, 2320, 2185, 2319}], 
        Line3DBox[{2041, 2178, 2395, 2356, 2312, 2030, 2167, 2353, 3710, 2301,
          2017, 2155, 2350, 3702, 2291, 2004, 2143, 2348, 2285, 1991, 2131, 
         3691, 2280, 1977, 2123, 3811, 2422, 2421, 2424, 2423, 1968, 2117, 
         2408, 2382, 2405, 2404, 1963, 2112, 2381, 2253, 2183, 1959, 2108, 
         2333, 3687, 2232, 1947, 2097, 2332, 3681, 2223, 1934, 2084, 2331, 
         2219, 1920, 2072, 3798, 2329, 2213, 1907, 2062, 3797, 2327, 2206, 
         1891, 2052, 2322, 2388, 2387, 2191}], 
        Line3DBox[{2042, 2179, 2314, 3794, 2031, 2168, 2302, 2018, 2156, 3703,
          2292, 2005, 2144, 3696, 2286, 1992, 2132, 3692, 1978, 2124, 2420, 
         1969, 3786, 2118, 2407, 1225, 1226, 1223, 2406, 2234, 3801, 1960, 
         2109, 2233, 1948, 2098, 3682, 2224, 1935, 2085, 3675, 2220, 1921, 
         2073, 3671, 2214, 1908, 2063, 2207, 1892, 3774, 2053, 2192, 
         2193}]}, {}, {}, {}, {}, {}}},
     VertexNormals->CompressedData["
1:eJzsvHlcjd33BmweEzKUIXOKJAmZOjtNZpEylDJGZUgqhQxlJpIhQ2YyJGOJ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      "]],
    Axes->True,
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(x\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{Automatic, Automatic, Automatic},
    BoxRatios->{1, 1, 0.4},
    DisplayFunction->Identity,
    FaceGrids->None,
    FaceGridsStyle->Automatic,
    Method->{"DefaultBoundaryStyle" -> Directive[
        GrayLevel[0.3]], "RotationControl" -> "Globe"},
    PlotLabel->FormBox["\"m=-2\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-Pi, Pi}, {-3.999999999999849, 
       4.}}, {{-3.141592653589793, 3.141592653589793}, {-3.141592653589793, 
      3.141592653589793}, {-3.999999999999849, 4.}}],
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    Ticks->{Automatic, Automatic, Automatic}], ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFfXmg1sP+/2lfXJUtWVtQUbYWW3iPW1yEK1spS4pKthRRkaXsurLvlfWK
kuIixTwhXI5dODxKEk5OnKVTnTrV9zz3zOs95vWc9+/nn+ee153mM/Oa9zqf
mfen/ZDLTrmgfkFBwdFbFxQ0qPl9/64mbTa2b5bB7+ebt9T81yRz89ZdDv3m
9kaKH7654K4+VzXJHH3HSQNfrqin+C2/bD34ol8aZZpu+/Pa3edXe+Bnv9Z/
8PkjG4R+KhX33U4+aOXBBaF9ieIHn/Ri+d6nVflaPKt4duILg9/8tdwXhP+A
1/5VivbC7UP/wv2H8Ujd46kWHn+Yr+P5Bn4c8xP+dswn/gavaI+/8dvnCd93
UHlj5Rn45L12/vXziyPPwK/9ff/VnRpEnoEX/L7d0W99sQU8KP5ej20/ryxf
rzwDr57c7fTpiyPP2g/xzO3BM/cPnuseT7Xw+MEzzxc8Mz/gmfkEz+CP1ktx
9I+/8TtqcP1li5s2VJ6BF/z50ZDxS+opz8Db/fvhI59utll5Bt64Tas5Z3+3
TnkG3mL1Nzu+en7kWfsnnrk9eOb+wXPd46kWHj945vmCZ+YHPDOf4Bk8pfoe
5ZTWV3GMB3/jd8XAAb2/XbMF81K88bnV9w9zG5Vn4P6U4vqju65VnnXdtl8/
s9mSMuVZn0s8c3vwzP2D57rHUy08fvDM8wXPzA94Zj5Tu1HpYa9Su1HpoV+p
3aj0JA/KK8af2o1K3+3EEZ+99P46shuVftgrN/w4bq81ZDcq/TPn77PbDgeU
kd2ozOOZ26d2I/af2g0eT7Xw+FO7Eeeb2o3IT2o3Ip+pPJf41F80Uhz2LZXn
Ep/qe7XyR/KjeMpnif4+17VXn7HtykmeS/wuF99y/Yb7S0meSwx5ju1TeY79
p/LM46kWHn8qz3G+qTxHflJ5jnymPGc9/HXKc9bDv6Q8Z31qD6uVJ+hvynOW
5U3xlJ+s/v4+8pTHqzoxz1mD59g+5Tn2n/LM46kWHn/Kc5xvynPkJ+U58pnG
SfivNMYHhKd+KOKp3eR+KvPwVC4Zz+bhBXX+F3k2+s/DwbMx/jwcPNfdT6M8
HDwbOORTDHkWQ57FkGcx5FkMeRZDnsWQZ2GeuT3JsxjyLIY8iyHPYsizGPIs
LM8Yl2GfxbDPYthnMeyzGPZZDPsshn02eC4Rwz6LYZ/FsM9i2Gcx7LMY9lnY
PuP5RrwhRrwhRrwhRrwhRrwhRrwhRryRxzO3p3hDjHhDjHhDjHhDjHhDjHhD
6o43qsWIn8WIn8WIn8WIn8WIn8WIn8WInw15ju0pfmb9krrHo/GzGPGzGPGz
GPGzcPyM/ox80Bn5oDPyQWfkg87IB52RDzojH3TMM7cHz9w/5YPOyAedkQ86
Ix90Rj7oOB/EvzP2N5yxv+GM/Q1n7G84Y3/DGfsbztjfyOOZ26d2I/ZP+xvO
2N9wxv6GM/Y3nLG/4Xh/A/+/sV/njP06Z+zXOWO/zhn7dc7Yr3PGfl0ez9we
PHP/tF/njP06Z+zXsb475of265TP2n4Qv5T523bbesqWiWvwt+AX+LMnPdz5
wjOaZPDr+9837f4Fcb2A73fJ+NazfsB6rdR/t+yri0Z8/BXsdaHiP7Trf0aT
90oVR397XL3bbxM+UFyM9sLtw3OFnzuscOFxR/sGDviVQ9eWnfliY4zb8byA
o3/MCzzyfNE+PEf7Bw/Ap2ce9MtOizwA3/vZr3pt+3KcF+OYF/eD/vc8/seR
7TsXZHoWzewzZtga7R/4267jhHlTY/+Mo5/a+VX5Zm8c8WpZ1wpalyrfZfs3
Ro66gPmPOPqBXF12zyc7FSwt036A7zt376YLDi1VOcC/w3oBx7/DumP+aA8e
gKM9eMM80R78AEd78ID5oD14AI72mC/mg/aYL3C0x3whh8b4HY8fcmXw45gf
4k2Ap/FYoYe+EG/CvAFnfoCDh4AL80O4tg/9O+afcH0u8aPjTOOiOC/iR5gf
6BP4JH6E+UF7rBfsI9pjfYGjPeQBPACHXGG+wCGfJCf6XJqv8Hx5XmiHcWGc
aAec9RTjNfRdSN8VZ7uB+Rn2x5H9URw8YL3AB9lttbuw22RvnWFvnWFvnWFv
HdsZPJfHg/Uhf6HtDf/oDP/o2N8ZuMqF4Qe5f+H25Aed4Qcd+bsM+0fES/j/
px3VuqrtshgvAed4idsjngF+4/NtP1l5ehwP4kHgeC7W56xN33Q86rH4XOD8
XG6PfmD/Zgy6+ZlT28d+gFM/ahfPO2f2tH6Tyig+rOL9VfUP+/zY9Y9bl7Hd
znrwkNrnrMc4U/uc9Rhnap+zOp7UH2X1ualdjf2n9jOOJ10//BftJOMpXxFP
ecnD8/YzYReM5+bhGL+B6/6kwbOAh9TOZwW8pX4tK+A59V9ZwboQz2LwrONJ
8+IyfS7JVd5+BXCWw5S/2B44xpn6x0bO0C9n6Fde/9weeot5c//ADbuR1z+3
p/jcpXapUJ9/ymtHtnj/rWhXDVz3/87qn71h7FOl5E8jnu5rFXr0k+5rFXq0
T/d/Ip7u/8R+qH8x+hejfzH6F2O+zpgv49qfwafiB112crtuhzfN4HfR+Dvd
kj8gZ0v0/2/5z7u/3+tl2KmFip86rf/jTbqj/4Vi4fBHgyvuvuuA7vpcx89F
/2tLxhzV4pmGmeP+PnLjcfvHfgzcvzLywSGrtq6XWbxXvW/6dIrtGW+9308H
zBjVWJ/z9bEbt33nwDxcgGN8aI95ff1Co1OuKaqv+HUdp9y9oEseLsDDOBza
YzyEC/AwT22P+RIuwMEn1g3rBZzHT7gQjvUX9JPGtwsF66g81s7bYb7KI+Ek
b47XPayDA//ox8B1Hhg/xg2ceeDnQi4xrstX7PTKiHVxPCy30C+032PzMScu
fT/vuaQvhcLtMQ70j+cS/7yOMU8M/dC6eNYvbk/ynLfumr/QOFkeqH9ur/E2
5kX2xBE/iqMfsicutSfKJ7dXPTbkh3HVV0NuMyy3HLfAHhl6mmE9hT0y7ECG
7QD0x7Azqo/AoSeGfdP2zAPskGE/GVc7ZNhnxcEU1iuNJ5upPrL8s15AfoB3
umrno694pYz7zxj9az9oj/VBe+BYB+CQG173dF8i6h3khtvXtqtWeV9/6oTG
L04o9Z1PPeWXlyZvVl6fPPzZ0bt3yGsvRntBe+D8XKyfIbd5eLr/v8SD53T9
8nmAfUB7zDPMQ8eP+dSNL5QwD0l5WOgZxwiA8zpCP3icLG9oD/1I10vtv8P6
Yp7AmR/D7gnLLfHmGWc/S+uiPJNeuJR/jbt0/DRflXPiLZPyoOvojXUkXNeL
5FnXV/FUD/PkNg+H3Bh6JIYeiaFHwnqUyk18biofEcf/SvUs4qmeRX6Q3x3f
/ajZ7+yZJ8+0L7FQ3wugfZrPLhTg6P+3z65sMmX1Br/fKztuuG3XOF/Iz+Q3
223s0KmMeKjJR7Y/88oRN8d+sL47t1zy6NltS/m9hkvfa+j+jOatkE88B8+l
fUV6P6L5b4b6UflJ+1micf6BY79+bb9TymgftV5mZuseb79UjPdoy7W9qzyp
+e0XVPg2+/Y5Lad3+K3lv6krfb3w4lx+B3zGSf+Y1ueqJu6DPqfflOsXeKMb
nrj6ol8aOffEgl5ta/gCPqv3lgnnj2wQ+qlU/OyH9vznyoMLQvsSxdfu9+L2
+5xWJbV4VvHfjvznJW/+Wq77L+k4S9FeuH3oX7j/MB6pezzVwuMP83U838CP
Y37C3475xN/gFe3xN35bdrv8wkHljZVn4Pudctffvrg48gz87HembNe5QeQZ
+HOvv3zzW19sAQ+Kf3rDvOrK8vXKM/B+Tba/YPriyDNw5pnbg2fuHzzXPZ5q
4fGDZ54veGZ+wDPzCZ7BH62X4ugff+N3py3Tm7/XtKHyDPyKVnOmjF9ST3kG
/t+um296utlm5Rn4f84664ezv1unPAMv67d/51fPjzwDZ565PXjm/sFz3eOp
Fh4/eOb5gmfmBzwzn+AZPKX63khxWl/FMR78jd8zNt5w/7drtmBeir/0dubb
YW6j8gz8q3//1HV017XKM/A/X2z7erMlZcozcOaZ24Nn7h881z2eauHxg2ee
L3hmfsAz85najUoPe5XajUoP/UrtRqUnefDAMf7UblT6F47ettHc99eR3aj0
m77vWjB+rzVkNyr9Az/37LTDAWVkNyrzeOb2qd2I/ad2g8dTLTz+1G7E+aZ2
I/KT2o3IZyrPJT71F40Uh31L5bnEp/oOeS5h+VE85bNEcd939zPGtisneS7x
nYo/vWnD/aUkzyWGPMf2qTzH/lN55vFUC48/lec431SeIz+pPEc+U56zHv46
5Tnr4V9SnrM+tYfgOav6m/KcZXlTPOUnq3jFef+dVtWJec4aPMf2Kc+x/5Rn
Hk+18PhTnuN8U54jPynPkc80/lDtVJ4ZT/1QxFO7yf3k3UdQnuvG8+4j0Hu1
vPb83k15NsZjtM+7j6A8191P3n0E5dnAIZ9iyLMY8iyGPIshz2LIsxjyLIY8
Y9+A5VkMeRZDnsWQZzHkWQx5FkOeheUZ4zLssxj2WQz7LIZ9FsM+i2GfxbDP
Bs8lYthnMeyzGPZZDPsshn0Wwz4L22c834g3xIg3xIg3xIg3xIg3xIg3xIg3
8njm9hRviBFviBFviBFviBFviBFvSN3xRrUY8bMY8bMY8bMY8bMY8bMY8bMY
8bMhz7E9xc+sX1L3eDR+FiN+FiN+FiN+Fo6f0Z+RDzojH3RGPuiMfNAZ+aAz
8kFn5IOOeeb24Jn7p3zQGfmgM/JBZ+SDzsgHHeeD+HfG/oYz9jecsb/hjP0N
Z+xvOGN/wxn7G3k8c/vUbsT+aX/DGfsbztjfcMb+hjP2Nxzvb6TxSN5+nTP2
65yxX+eM/Tpn7Nc5Y7/OGft1eTxze/DM/dN+nTP265yxX8f67pgf2q9TPmv7
KfP43eu6k+dsmbgm6E+Z/gJvOObWwblzSvi9982Oc+5fENcL+Jn3fLH7rB+g
Fys98J9+mTfp469gHwsV36vgjoFN3itVHP193Pbd3yd8oLgY7YXbh+cKPze7
udW43Lko4G/36N9i4IuN8bfjeQFH/5gXeOT5on14jvYPHoB/ve87S5edFnkA
vvqKyW7bl+O8GMe8uB/0/8rtD9+d21e/begrQ8YMW6P9Ax/51rXXzZsa+2cc
/dTOr8rv1uypT8q6VtC6VPnrXtvm0lEXMP8RRz+Qq9Wn3r53wdIy7Qf4nS8f
0HzBoaW6Tvh3WC/g+HdYd8wf7cEDcLQHb5gn2oMf4GgPHjAftAcPwNEe88V8
0B7zBY72mC/k0Bi/4/FDrgx+HPNDvAnwNB4r9NAX4k2YN+DMD3DwEHBhfgjX
9qF/x/wTrs8lfnScaVwU50X8CPMDfQKfxI8wP2iP9YJ9RHusL3C0hzyAB+CQ
K8wXOOST5ESfS/MVni/PC+0wLowT7YCznmK8hr4L6bvibDcwP8P+OLI/ioMH
rBf4ILsNv+Ngt8neOsPeOsPeOsPeOrYzeC6PB+tD/kLbG/7RGf7Rsb8zcI1P
DD/I/Qu3Jz/oDD/oyN9l2D8iXsL/v7rbi03aLYvxEnCOl7g94hnge281fOXK
0+N4EA8Cx3OxPms+Pungox6LzwXOz+X26Af2772bt/3Pqe1jP8CpH/WPv25d
8Xy/SWUUH1bx/qr6wTkFX1beuoztdtaDh9Q+Zz3GmdrnrMc4U/uc1fGk/iir
z03tauw/tZ9xPOn6abYhKb8RT/mKeMpLHp63nwm7YDw3D8f4DVz3Jw2eBTyk
dj4r4C31a1kBz6n/ygrWhXgWg2cdT5oXl+lzSa7y9iuAsxym/MX2wDHO1D82
coZ+OUO/8vrn9tBbzJv7B27Yjbz+uT3F5y61S4V6HuD1Hz/a9v23ol01cH2v
/fyKq28e+1Qp+dOIp/tahR79pPtahR7t0/2fiKf7P7Ef6l+M/sXoX4z+xZiv
M+bLuO4/GHwq3uLkYQNz5zXx+8bdBx+35A/Y8SUeePvOxSv2ehn6tlDxBh3P
ndakO/pfKBYOf1T4r5umHtBdn+v4uej/l+//GJ07p/buAdOrj9s/9mPg/q3h
V92RO1/0/r/3+bZPp9ie8Q33Pz8sdw4P/+6kp9pt/86BebgAx/jQHvP6on33
63Ln9oA/edA79yzokocL8DAOnR/GQ7gAD/PU9pgv4QIcfGLdsF7AefyEC+HB
ziwR9JPGtwsF64h+w7wd5ot2jJO8OV73sA4O/KMfA4ccOowf4wbOPPBzIZcY
V8vzLn99xLo4HpZb6Bfa33T5Yf2Wvp/3XNKXQuH2GAf6x3OJf15HtVfoh9bF
s35xe5LnvHXHeHmcLA/UP7fXeBvzInviiB/F0Q/ZE5faE+WT20N+Mob8MA65
zRhym2G55bgF9sjQ0wzrKeyRYQcybAegP4adUX0EDj0x7Ju2Zx5ghwz7yTjs
szPss+JgCuuVxpPNVB9Z/lkvID/AuzT79IQrXinj/jNG/9oP2mN90B441gE4
5IbXPd2XiHoHueH2te3wvqzQl3cb2vzFCaVy2qCr9p87ebNHP906vTZm9w55
7cVoL2gPnJ+L9TPkNg9P9/+XePCcrl8+D7APaI95hnno+DGfuvGFmIekPCz0
jGMEwHkdoR88TpY3tId+pOul9t9hfTFP4MyPYfeE5ZZ484yzn6V1UZ5JL1zK
v8ZdOn6ar8o58ZZJedB19MY6Eq7rRfKs66t4qod5cpuHQ24MPRJDj8TQI2E9
SuUmPjeVj4jjf6V6FvFUzyI/yO8O+uDcF9/ZM0+eaV9ioebraJ/mswsFOPrv
+uuWf+TuI0wf0XjjbbvG+UJ+tuvctOEencqIh0I5YvK140bcHPvB+h65cslj
Z7ct5fcaLn2vofszmrdCPvEcPJf2Fen9iOa/GepH5SftZ4nKy023XLlov1PK
aB+1Xuaqlpcsf6kY79GWa/uqfje3v/2CCrny3wuKF2yK9QI3l703YX39Jhno
A+4JzZg00T9xfGPF0b5j4wtP7fFJo8w5h5y+9/iRWg8ys3+f43b+dUBDxdH+
vkt7vPv+qgYZ7Leg/cx6HX/Z8/N6iqP9k3OWPdF7bL3w3Fgn9bzXHr/o0sWb
PHC0b/jjF32+PHJTsAvF2n7q57sXt5i/TnHtf2X9E2YMB16k7b+bvSbb5qRy
4Fof4G/vVPYt7g28WIz+hfsP4xRj/FL3+KvE4EeYn8CzGPwL8w99N9bX8foG
OdH2gysfv2bp1CbAtQ7foFcO3K3RNY1UToDfesmt5R+cF+UB+M8loz949bn6
uu7AD5s7c0DHSwp03YG/tu+cP4tf26jrCDxzROcfK65Zq+sFfPzJ/zl02Joy
XRfgyzf17ddkyFrlH/jrSf9VwuMBnzx+8MbzBW/MD3jDvaezR1x/Q8tWui6K
v7fqkK9WtquvvAFvM2LKlLtnFShvwHtVtb9v+iNRL4Cf/837m1cNqFLegLd/
6KfND7auVN6A33bJovfmTYy8cXvwVnf/VcLjAW88fvDG8wVvzE9qryp9ZVnj
L8/9ZYtP7VLN+FbM+XrVhM0+tT+Vfvahl37xQ1+cw9D6i37W4H6fbTW5iuxJ
pX+w10knZkeuJbtR6Rc/vv3CdiMq1G4Ab/dx/Wu2bV5GdoPxYsXfDf2kdoCf
WyU8zlSva/Awr1R/Iw/gk3lL5bDEPzPr24G7blnvUzks8f7kQYsntVvvUzks
8d1/2+7K5z/WcSr+Ttmr9dd2riQ5LPG7NXnsnoeGVpAclvh1n7975jdvKm+K
v9po7oG9JpWSfDJeLNxPKp/83CrhcabyGeeVymfkIZXPyFvKZ9b/1LPNDVs+
Kic+s/4B//HTE64vJz6zvs+cn7oe1aKc+Mn6jnfdctz48aXET9YXVGy8cEMH
5ofxYuF+Un5qnvv5QR37ri0lfrK+98b1I+66sYz4yfpz72xx5qrm5Tpfig91
3RnHvOrGiyw8rx4U5mU812ifX1eK1kuM9RJjvQQ8pPKfFfCWyn9WUp51fcVY
XzHWV4z1FWN95R/vL9/0QkXe+sotQ5o+nasTRXZADDsghh0Qww6IYQfEsANi
2AEx7IAYdkAMOyCGHRDDDohhB8SwA8J2APV9DT8lhp8Sw0+J4afE8FNi+Ckx
/JQYfkoMPyWGnxLDT4nhp8TwU1K3n6oWI14SI14SI14SI14SI14SI14SI14S
I14SI14SI14SI14SI14SjpdQv8uIz50RnzsjPndGfO6M+NwZ8bkz4nNtT/G5
M+JzZ8TnzojPnRGfO47PUcfson3fXnfEVk04/3Wc/wLnPBc457PAOW/V9ml+
qnXVOA/l9pRXOs4reTyUJzrOE3m+qZ42ctg3AG9aDyTkibSf4JBv0r6BQ95K
+wMO+S/tAzjk0ZTvuzQfL9L6JGler/m7tqc8nfrXfFzHQ3m3jp/ya50v+MHv
4T/dum7mnpGf7Z5ueU5uf/KM9xY9f+mfUa7mzhj6xeQVjTP7/3r7Gee1ifz8
8/HXjvlffdQHlyxdPjPys/rhrRac+N8mmX8sGLZ8w4xNysOeza+bnXvu9DE/
nD3/6MjD242/bJ977uYxv7y6fGjkYXCDTg/knrt7ttmnxwyNPGzeMr557rn/
3emAmTc/Hnl4rPqTibnn3vdR+S0ndlH9yvTYa1nzh4bVzwy6528D270Y7Q9+
9znpm3O6vBPtz6jdb6kYfEKDTL/e2wzstV/Uoxa7fD88dy7mt/5vddrUIM53
1o77Z/fu1jBTcOm6Ix9ZUq3zXXHLk588WPPcn0rKOp24PtqZGyav/XvuuStf
Hl847cFoZ9recPxruecumH57ZYf26n/lzWundfnfuaymH31x8bJoZwaNL5+e
e26nNg90631B1Jeqscdsn9vfxXcQwMMvRzca8Nu0Tf6ZnUtvmnpu9F8dZLbL
7e+Nv6bl5ScviP4Lv9UX9Kj4+Lq4P/bxQ5tvze0Tzv1m6JrZV25R/3XR/ads
avRoQebiq+Y+PLf1RuWhz1Z3Lvu15rlvdJMBrf/ip65v2OODXJ2TjlUz540+
LvqphZu+f2lczXNfmrL4tD02RD91zcZFJ+Seu3nSNv2O3KJxi+y8fodFuefi
uxvg4fU1F/bM7Td+9f3c0895X/2RO6PszZmfXF8vs139t9tM7hr5Of+oEx6Z
MWqtn7bl5U3Xnan+LjPjsDU3XnjGOr/bvxotHt5Q+ffZ7o9d1O3w9X73r1u7
s0Zs1ngJv8s3jP2kz9KNys9pHUsOf7fJBv9ciyc3n/jAeuWnVv7X+m69f6y4
aFOMJ2vlfJ0/Zp/7smffHeOfw6o6VBxY89zTGl5x4rh91yk/Y8s//H5DzXPx
/RfwM+/30e++U/Nc33307KcP1zjQ/fHzzrPvXL3B33PSHePHDKyn/Oyz9O37
T/9yo39j+T8v8TPVv2feHddx/tzJf/jn9r3si6k/VWk8uftBvRa371zqC8q+
O2Tstxp3+YH7r5i9ausyP73/oi4XtI28PND5jgdy5++6H1c0tnRetJO18vBH
Xn5du+6l/uAewzef/XOMq2vXt0y/rwce1qzeZvdc/0c02/+sbTasVR4O+HV+
49w6HPVhZpecXIGHi388788+vsJP7X3A0PXvVGsc+FxRs2+3fmaNLx81atDv
9WMcmBn1yhEdOv/ob9jty+4X3VahPBw8tGHLVyqW+9VPPtfzo2yF8jDv9NN+
PNqv8Fuf+e12O70d8w781q98t0P/J2PeMbXtfXtNWb0qb/+hlocf8/Lr2vku
1+/igZ/aea3wJ535202H3l6m/Pz8xdzM17ev9Dd3/nLuUZs0r5SzFte7Z8QZ
v/pV57QdeseiNTrfDyZ03LPr/Fn+kBd/vW95m5g/dj726bm59wz9pn/304RR
MX/UfJryx+s7bdl+t5p+OI+uxRf6JX/OGra5WRz/jLP9p0tuX+z37z6p5IhD
Yv5Y277Qn3PQ9ufn6sBjnHf9/dzRVTXP6XvQpzvn/IueJ/hfP0uk7+CeW1bc
ofsJfvbVbfedV/G5HPPRsV0/WB73DcJzJX1usQ/jFIwT8wzzknReRaL7B7Re
gTcBb5jvIf+Tn89l97k3PdzvqjjfqdUffNtufqGMOevzG/863xOef6LHnatX
ySsPnjPooi4xX17yWr+hG2qe88j9y67K+RfMN6yvYH2hj0EeBPIAHoL8SCo/
xT7Im35nDTwE+czbNwjynJcv4xfyr+v+P3v7q5Ttu/dzSy/T/Y3A20r54++3
/5ar8w8egp4K9BQ8BL0W6DV4CHZAYAfAQ7AbArsBHoKdkdTOFIf5lgrskspD
rR3L2zc4fvtJJ7eoGeceEysenVgeeaiNKyqkzUvHtHqzXrTzaueOPqhJ136V
ykOwnwL7Cf0N9lZgb2Hfgn0W2GfYt2DPBfYcfAb7L7D/4DP4C4G/UPtW618E
/gV8Bn+k3yMDn8F/Seq/in3wdwJ/B94K2xze4oya8Zw8bL/Be4yL8UOtXG2Q
rz+cXzl31hrlLfhZSf0s7rtXCfwyeAt+XODHwVvw+wK/D95CnCCPhzgBvIW4
wiGuAG8hDnGIQ8BbiFv0e2HgLcQ5DnEOeAtxkaRxUZH8+18bVuaeO/j6Mw75
z5+Rn2b3PHt57rnnfPTlAyPaxTgzxGkujdOqJMR1DnEd+MEv4kDwE+JGQdwI
fkKcKYgzwc+DYx65tXzHRm7DrOtXD1we3+eGeFW/2wV+QnzrEN+CnxAPO8TD
4CfEzy6Nn4vkt1bfvJt7bv8Bd+5Y7WLeUauPDd3aKbN/WbVHzDtCPO/SeL4q
6GkDh/gfvIR8wSFfAD/4RX4BfkI+4pCPgJ9vK8cObz2nqcs8vuC7AbfGvKxW
X5q6+Q/NXDjkL3lryHcc8h3wE/Ijh/wI/IR8yqX5VJHsfe/LT+We27Jlr+cu
PzHyc8cD5+6fO1+z7tcVH064L/IT8juX5ndVEvJBh3wQ/IT80SF/BC8h33TI
NzFOtbvB7pEd9h0+m7TbtBFrOA4U4MRnBnzCzoR5ZTAv4JyHwp5beSv3g3mF
9cpgvYBvG/LrTsv2+NsDW2s+7nicwDlPBx70KAM9IrnKjLlwbosebzbS+QY5
z0DOgXMeivkGfcmk+lLk685nVb8yhn7lPTfYpQzsksZXlA/iucG+ZVL7VuSR
V15V774VFZNifBL8godfIP/ix02Z/GXPmXFfOvgX3y/xL0W+7rxM/ZEnfxT2
B2r6DX6c4gS/4PxuB/baEvsP8YBP4wGNH3zRr+VPrZqYF+95xHsU93qOe0Mc
6BEHUjzsOR4eGOL/mb7pp+XfrOE42SNOhp0J8ZhHPEbxpC/54+Xpf8VDHOsR
xwLneF7j8No40CMOpLjU79Bhp1Numhffc4X42SN+pnjeP1x0bO8TupSqnhr8
OM7j9Dw98Qb81s/veWzPmvzl+rWdZ+Xqk0MfjfVynD8Ct9Yx9C/oH+vyarfb
7i2qyVO+7tXwthFn5vEp4JP4F+JfjHUR7gf2nOUBeBiPx3gIF8aRf93/6LVP
rvq+lPnU+RL/mscRb5r3UZ4uRp4u6fpqvimpnGgeLZA3yqMFcq77LbX5viDf
1/g85F/QL5I3YXnjPI7kR1h+OB+kfRWBPaF9FWG7FOyekN2DnRSyk1J3e92/
Era3dceruk8oZM+xTyjwC7Sv6+DvaH/bwW+Sv3Opv1P/6FI/pf7Okb/zdceT
ut/rjP1el+731s+EeMAhHqA4xKVxiMYtLo1bND5xaXyi++3O2G/X/inecBxv
cFxK5/Ecn8fjc3oYJ77v1P2Q7kVFA+I4GUf/wE8995eP+13WhN/7ZPBeDP3j
O1r7lu58RWX72L+B6/fBZs+deF6Xv7z3x/fBso+de0ZRr4jjO2ajJw29aodX
o13FuRScZ6BzFx7nH9L3p/EcTvr+NJ7bQf98bgT2pO7zJ/Wd1V7PgYRzPjQe
McYj6XiK9LtgKQ94z1UlxJt+54t5xve5jPVSHHKF72pBHkiunCFXjOv5262S
95hFns9tpu/9C/15r+7U/sGM8hy/63X8eYP7vMDrG/GUz9gP9S9G/2L0L0b/
2g/Ni953Kw+OeQj5YCbNB2vi7b6rH8u9X9u7a+c1HY6L69J6zHerv6zx+9Nv
6VPa5+pS3jcW7BtTe0F7inM8+f3Mraf07LdTDV7QYM2tdeACXP1I7Tgdxkl5
Ls9LeF7EgzN40P41bql7nI7HifXifXXgBp/O4NNZfBp2QL93UXzcK+defgfb
sUK//cH7X/yXeM8bcZ0/9tqLpuxQM/71rRZ2b7lNXv9i9C/cf+hHuB/jPJ6v
+9yLvmfn8/O+7vfv2g+dN47fEaZxCvMGnHmgfni+wvPFOv6/7fZCqTd7SKvL
94j4uU8edHR1zbxfPrbfuF5P8znJQpl46J/jptzxl/cXFEdRPu7SfFz9Y57d
RpyWvs8t8n97tM3q3P5kYd+bB+TGQ/uQlO+rX2D/K6Efn/aj+5yZr3f5etTo
7/8Sfx7TY1nu/e/Sllf3XDQ/2m3UCXiicqup6+s3wX6c3nO8eE3zt584vrHi
aN/xw/eH9vikkYMcov3snRfmzlcojva/D/jjs/dXof5klbZv+MfdK/f8vJ7i
aP/tp2Ne6D22nkOcgPatWs0ZeeniTdj31/Y79qk45csjN+F9ibYvH/31qhbz
1ymO9ges+PCMGcOBF2n75nu2/KFG/oFrHYUXNt1wco391/cxRv/C/SM/Msav
7Vsn4491Z4kfYX4gzwb/wvzD3hrr63h9oXdo/6+2IyfWxKu674Z7TM0e2uaw
Rtc0UjkBvvTLXbb673lRHoCXX3hb9tXn6uu6A794u/4jOl5SoOsO/O2Jixqv
em2jriPwhjtvU1pxzVpdL+DnvrpIavy4rgvw1q+ef26TIWuV/7r7rxIeD/jk
8YM3nq/6I+IHvOH+2vCKR2e0bKXrovh+b3b8c2W7+sob8Ff7fPfU3bMKlDfg
Dc5t/9r0R6JeAJ929Yltfh9QpbwBf7R4bsuHWlcqb8BL73qpsMbOK2/cHrzV
3X+V8HjAG48fvPF8wRvzk9qrSv/88GebDf5li6R2qdIvuqtL498nbJbU/lT6
cR++VvVDX9THrFJ8v8nFf2w1uYrsSaVvfuThQ7Mj15LdqPR77P7nf9uNqFC7
AbxB53/euG3zMrIbjBcL95PaAX6u1vvUcaZ6HeeV6m/kAXwyb6kclvgr1s29
btct66lOSImvXnngyknt1ksqhyX+ub6t7nr+Yx2n4r8tuqX12s6VJIcl/pcL
hs94aGgFyWGJ3+nl5kO+eVN5U7x+yQ49e00qJflkvFi4n1Q++blVwuNM5TPO
K5XPyEMqn5G3lM+sP+SeN6bU5IPEZ9aXt/RzavJH4jPrP/tsSc+afJP4yfqB
/2hxwvjxpcRP1v+nZ+nIDR2YH8aLhftJ+cn6E56ds0/ftXn1qfzb/33+srtu
LCN+sr7VnXsNWdW8XOdL8ZiuO+OYV9143r0SnZfRTx6OeTFO6yLGuoixLoL5
pnKeFfCTynlWUj51HcVYRzHWUYx1FGMdZeb8LvVnVfB8S8TQazH0Wgy9FkOv
xdBrMfRaDL0WQ6/F0Gsx9FoMvRZDr8XQa2G9Rt1lw++I4XfE8Dti+B0x/I4Y
fkcMvyOG3xHD74jhd8TwO2L4HTH8jtTtd6rFiH/EiH/EiH/EiH/EiH/EiH/E
iH/EiH/EiH/EiH/EiH/EiH+E4x/UVTPibWfE286It50Rbzsj3nZGvO2MeFvb
U7ztjHjbGfG2M+JtZ8TbjuNt1Jc747lLmx65VRPOZx3ns8A5bwXO+SlwzkOB
U76p9e44r+T2lCc6zhN5PJT3Oc77eL6pnjZy2AcAbyHvc8j7aH/AIX+kfQCH
PJTyfYd8lvJ6h7yY8neX5tc4L9rMpXm65uPanvJu6l/zax0P5dE6fsqXdb58
T6T0vqUbZu4Z+UEdm+P7bXrp0j+jXF03+eEVufsa1+xz5ZnntYn8aJ3UqbOW
LZ8Z+bntvKt+yO27dpjzUu4ckfKg958WXz5k/tGRBzx3wCvdMsuHRh7w3EbP
lH1/zNDIA577w75nzr358cgDnrvbcT3vObGL6lfmxO596ufOzyzs99457V6M
9ge/X/c9bUiXd6L96d+qQ3XuvsbOe/c+u9d+UY9QP3X5xcd02dQgzve81Vsq
c/c19l3b7R+PLKnW+eK5Lz3SZ78T10c7g+ces7jl0mkPRjuD575QeMO2e7RX
/6t1W88fO/m3i5dFO4Pnvvtwj5N7XxD1BXWA8H0K8HD8xId75u6JbNvrgOun
nhv9F+rA/NRu+CUnL4j+C789pr1S/vF1cb8L9WQKL2+5YfaVW9R/HTru1haN
Hy3IrP7u3qfntt6oPOC5N/y+3Tmt/+Kn8NwXb/ro/dHHRT+F547edcL4PTZE
P4Xntto+M+XILRq3CJ6L76GAB9Sl2WfU93ee8776I9f7jGFNP72+Xuack68d
OLlr5KdWDtd6ue3SVdedqf4u1HFd559a1OG14Q2V/1Bnb71v9N6CA88asVlS
u1Hlr293/Md9lm5Ufjo073BS7p7Ivifc1uSkB9YrP3juyUUl6y/aFONJPPeN
qXv/cfbdMf7Bc8ePLLhi3L7ryD5U6XcVwQ+eu3zKSy2fOVzjQIe6Rhe/s9OC
MQPrKT8HvfvDUblzUJseL1jgZ6p/D3Lyh5/Vf+XUqT9VqRzXrkupn9d9XpOx
32rcFerglfmXqk5ocUHbOD7UaT7j07EXl86LdhL9c1yN/isPPL/5OT/HuBr9
4ztQqV8u85mxGx7aZsNa5QHrALkCD7X6VeGb//2FFevfqdY4sFaP1vjRTcas
/71+jANrx/Oj7+kXlIy8rUJ5CPWQ/M8yrsFH2Qrlobb/FX7IQS3Xt3m7gvxF
sT9hm+M6938y5h2167Iqbz8Bz+U8C8/F98jAD5579FYfP3To7Xn1+f3Yoztm
j9qk+hbk7Vc/fXjbF+5YtIbi3ln+3/1a3b68TcwTUY/qhz8G/TxhVMwT8Vt3
nqj3RCheXeivHTBv+OZmpRQ/LPaXrdu3/IhDYp6I/uBH0rhoiVy24sweP9+h
+wBB3j6XOw579sQPlpdS/rJY0H8aby8UjCfNB/U+CPn3orz8F+MBP2k8+bl8
suXyu/tdFecV1l22f3T00ou6xPwX/cFfYF5hvQTrlcZ7KwXri/kGeZBUHhAn
L9fv2WG+Qd7y8n2Mk/UUv5BnzBfjLKvsNn3pZXEfJuiXQL8w36CPAn3EfNEf
+QXYE4G+Y77BPkhqH4rDvEoF9gTzDfYnL9/HOE97aM30ieVxvhhn5YPfb/9m
vWif8fteaaZh136VbJcEdg96h3HCTsIuYZywq7BLGCfsMPgMdltgt8FnsPMC
Ow8+g18Q+AXyX/p9N/AZ/I6kfqc4yOE6gZ8CbxjPdgc+dsEe46Lfx3iu/vbt
TXNnrVG+MJ7UP0b/D38K3jAe+F/whvHAX4O34GcF/h28hXjAIR4Ab6hDiPgB
vIV4Q7+/RnGRQ3wC3jDeVG6LBM9tubr+kf/5M/KD57Yd3HTGiHYxPsRz0/hK
4yKHeIzvdyB+Az+oH4h4D/yEOE0QH4Kfiz784c/cubiF857fdtDy+F4V9RgR
Z4KfEJc6xKUUPzvEseAnxL0ujXuLBM99vUPpLtUu5gt47hffvLF61R4xX8Bz
0zhc42eHuB284LmI88EPfpEXgJ8QzzvkEeDn3iNP/yZ3nuTsfa77acCtMZ9C
HdOfB17zzpC/5JshT3HIUyifcshrwE/Ig1yaBxUJnju5+2O5cyzKD55bcvsB
hRPui/zguWleVhW/IxHyOPCD5yLvAy+o34k8EePEL+we2WE/6IFbek8bsYbj
NwFOfGbAJ+wM6g9jXsA5f4Q9t/JN7gfzAo71ovlmru49ZusHttY82vE4+X4H
8mvgQZ4z0COSq8yXx9fbusebjXS+yOMg58A5f8R80X+qL0W+7jxU9Stj6Ffe
c5FPwS4B5zwOz0Weldq3Io988JNu64orJsU4BPkI/AL5Fz+lfPivPWfG/WTk
Kal/KfJ151Pqj6h9sUf8Dz9OcYL/+p9fSa8tsX/kBWk8oPGDz+zy27OrJubF
dR5xHcWxnuNYPD/dH9D41nN8i7j9sTWyQ8U3azju9Rz3oj3iMYoP/Y6HVI64
aV58T4R+EK9S/Oxn3vz0P074Sx11Y/yO86N0fy/OC3ph8OY4/0rPe0Q+033R
xfLJ6EfGjTizVP0i85PuQy723P7/048cWfH2olXfl/K8hOfF+QvllWLklZLy
pvmRpPxr3idYR70PG3DkoZT3CeSH1kt4vTgfoXURXhfOayjfF+gL5fvCeof4
jfTa1x1n6r6KGPsqwvak7nhM96+E7JXWe4bdo/1GB3vO9xfgF8ieu9Seq/13
qR1We+7Invu64yXdh3TGPqRjOwP/Dn9Hftalflb9skv9svpfl/pf3Qd2xj6w
9s/3F9ifctxF574cn/sKuJ4Hwzixn9xr2AXZogFxnIyjf+Dvrvv6m36XNeH3
ERm8r0H/2L+dd/Bj4yrbx/4NXPdX55w2e3iXv7yPRpx44utvDCrqFXHsdw27
ZNX4HV6N9hnnH/CePX1/F891pO/v4jkQ4z4Cn68QnAOh/sXoX88zgAfkxRh/
uq9SJTRfzXeYH8T5Bs+KQx4Q92IdSR6cIQ+M6/nM9L1YkZ73w3vGdD+t0N/7
3II9H8zwd44K/QmzJg7t8wKvV8RTPmM/1L8Y/YvRvxj9az80L3p/qjw45gFx
cpqnFOl7oltmf1TZ4bi4LvC/Df4+drujr+Z5zRLsQ1J7QXusF/Id9E95E49H
eDw0fmeM39H4He+XpvYhb17OmJfjeaXnCgr9nbscPOTyO0o5zuG4BfuW/uF7
vz+05TZ5/Qj3g/Fwe+scVN3nEPS9J59P9rDPjPN5ztTO5M1XjHkJj984h0/t
F8orV221zeV7RBzzuLj/lLN6PZ03HjntiWuvmXJH3DfmeIDyJpfmTWrn8+wY
4o30fVmR7iNhPLRfRHmZ2kn2I7qeaT+6H5VZcPEXV4z+PuJ4v9axSZ9ei+aX
ad1/6B/qNOKeBnDcE8T9K+Coh4l7GsBRXxT1xIGjXivqYgNHXVzUyWUc9V7r
7kff8+hzcZ+Kx4n5wo6iXiXmCxz1GDFf4KgLivkCR51VrauO99Khbi3mCxz1
gTFfxrXubZ396LknfS7my+PE/TFjvo7nC34gV6jzCX6Ao44l+AGOeqrgR89l
hPq04EfrFoR6v+AHOOoqgx/GwU/d/cT3DHgu+OFxgh9jvo7nC34Qv6E+KvgB
jvqf4Ac46tDqdw4Cjrq+4Ac46iSDH+CoR437qMBxvxWWEXiwk1o3HDjqkINn
7h881z2eeK4Q4wfPPF/wbPDmmLdUT8s96tOmelruUX811dNyjzrDqZ6W63co
Uj0t1+8ppHpart8FAM/AcV8YPANnnoGjrnuq77H/VN95PNXC40/1Pc431fc8
3hzzlspzsUd94FSeiz3q36byXOxRhzmV52L9Dkgqz8X6XYxUnov1uwypPBfr
9whSeS425Dm2T+U59p/KM4+nWnj8qTzH+abynMebY95Snos87vOmfBZ53P9N
+SzS+48pn0X63ZCUzyKtS5nyGes9pnwWGXzG9imfsf+UTx6Pvv/R8ad8xvmm
fEZ+Uj6LPO6HpvJZJMCJHzH4EYMfMfgRgx8x+BGDHx0P6Z0YeieG3omhd2Lo
ndbnJ70TQ+/E0DuDh9ie9E4MvaPxqN6JoXdi6B3z5pg38iNi+BEx/Ii8Xrcf
EcOPiOFHxPAj+r0P8iPEs/oLMfyFGP5CDH+h8yJ/wfw45ofiHzHiHzHiHzHi
HzHiHzHiHzHiHzHiGTHiGTHiGTHiGTHiGebBMQ8UV4sRV4sRV4sRV4sRV+t3
NCiuljSuziqOeiPQ67pxjcPFiMPpudXC46Q4XIw4nPlxzA/lcc7I45yRxzkj
j3NGHueMPM6leVxWcdRpSeNAxjXvc0be54y8zxl5nzPyPubHMT+0D6Dfs6B8
3xn5vjPyfWfk+y7N97OKo44N7GG63xP9DrenfQNn7Bs4Y9/AGfsGjvYNFKd9
EsWxT4I6j9h/GBjqiKK+v+5vhPqrqGsPHHVrUc8dOOoAoz4dcNQZQ70S4KhD
grpjwP8T6o+hLjNw1GdGfWHgqDOM+rnAUUcXdWP1/HWoe4m6VMBRnwrfM8D+
A+rToo4/cNT1Rf164KiTjDqAwFGfDXWlgaO+NOojA0edZNT/BY46wKh7Cxz1
b1HvFTjqiOJ7A9g32C3UK0adfeCo/4y688BRjw71moGjbjPqEes+bqhLjDq8
wFGPF/VndX8j1KFFfX/k3ahTjbrGwFHfGPV8gaOuL+rYAkc9W9T5Rb6Jer+o
bwscdW5Rpx55E+quo64r4mfUSUOdU+Co54Z6o8BRpw51QoGjDh7qeHLcjjr+
HOejPj7nBaifzv2gnjhw1BFFnT7gqFOKunvAUX8P9eyAo64d6h8BRx0k1I1F
PIy6dqjfqvF8+ZYdJx1WqXVXgaO+N+qiAkcddXzPADjqzOM7AcBRh1/rpwcc
9VdRHxw46sGi3g1w1KVBHUDgqAeIunuad4T6e/hOCeJY1OXG9zmAo8456hcD
Rz151DMFjnr700PdUuD4HgHqmwNHnXPU9QaO+t6oZ63xf6hrjTrOwFHPGd8R
QZyJ+u34rgZw1MlHvVfg+I4A6roCRx1R1BkHPi/UG0d9beCos4260sBRXxrf
80D8hnr+qMcNHHW5UYda471Qjxp1qBG39A/1qGm9tO406k3reeSAo44z+6Op
oa4rcNQpRR1P9rPk9/X9CI0z0znUjfwq1LEFjnqhT4R6tcBRNxX1VYGj3hrq
kLK/GxTqAsPOo34p6sACRz1Y1HsFjrphqBcMe466wSQ/WjcYdWmBoz4tyZW/
YU2X8/6C674x5A11b7kf1BfG+qLOMOmj1hlGfWH1L6HO8IxUT7XOMOqD6z5h
sBuoMw58U6jDiXrZwGF/UF8b+1Swz6irhfawY6iThfaw82SHtQ42+S+td032
WetXk1/TOtVkP3n8jsePOqTMA9lb5Y14UD9F81W/hrq0PC/C1V+Tf1TeaB3V
/tN6qb9AvV30D35QbxftwSfq5AJP10X5EfCDOsWwP5A31CkGDrklPRLSI92X
gL6grjFw6CPpu9ZtRn1A4NB3sgOKo+4zcNgN1E0Gjng12B/FYX9QZx92G3Ey
vmMHHHaS7LPWsyX76R4O9pPifwd7SHbVkV1VHHaV7K3ioR/hfsgO63PDOIXH
ie8B6P2VkB/Re3bNHym/c/A75Kcc/FTAhXHyX9oP5WXKM+XjmTS/1rxbccqL
td4v6roCRz1Y2ifJYD8k3f9EXUx+jxbb0/6Vfhcb/aTnXEq1rjHsBurNou4w
cNSzRd1D4Kh/iLrDwFFHF3WHgaPuLurkcv/gh8dD4xRjnIJ+UOcXOJ6LOr/A
MU7UiwSOedE4xRinjofebwq/D4VdMt4763elMV/IYSonhSqHqJeLupkGrnKF
urtozzi9j5O/1f0+TvB+it5bifHeSvuh8ThjPIyrXhvzVZzyPo+8D3VvgaP+
Lerqcp6IurrA0R51cjFO1MVFnVzGad/JYd8JdXKBo/4t6uQa7YXb0/h5vhme
L/Gg86LxZIzxZIzxaHvyIxqfE28ZgzfF6T2v1suFPEBfUJ8WOPws6txCToz2
wu1R3xY46tyiTi7jZFdVr8lu6z4tvZ/l97a6LsBpv5fsv87X03w1vzDmy+2F
21NcpHkQ8eCJH2Gc3nfTOi5UPlEfGPWC0Q/wgoLrnztp93+9hXGWPfpmgxwP
qOeL/lHXF/V8gaMeL+WDGo/RfqPGbxTX6T4kvQ9SP0vxoUecWWsPV6qc33Ls
ZX2PbVup56qxvqjzUzvueM4Q5/lx3ho46inhXClw1KdCfUngqPeFOonAUVcN
ddYYR72wuvuJ5wzxXJyf5nFivnruLtQ7wnyBo54P5gscdaUwX+Co04X5Akfd
M8wXOOrLYb6MY7519xPPGeK5mC+PE+fFjfk6ni/4gfykda7iOUPUQQI/wFGP
C/wAR30z8AMc9eLAD3DU5QM/jIOfuvuJ5wzxXPDD4wQ/xnwdzxf8wA6gvhb4
AY76UeAHOOqYgR/gqAsHfoCjzh74AY56hrjvARz1J8Ebtwdvdfcfzw1iPOCN
xw/eDB4c85DqXblP66HFc4Oox5XqXblHXbhU78q1znCqd+VaLzfVu3Kt+4p7
OMBxf4fOe2gdFfAMHPU8U/2N/af6y+OJ5wYx/lR/43xT/c3jzTFvqXwW+7S+
XDw3iHpoqXwWe9TlS+WzWOs8p/JZrPWKU/ks1rq74Bk46pTS+aU8nrl9Ks+x
/1SeeTzx3CDGn8pznG8qz3m8OeYt5bnI4z5OymeRx/2dlM8ivX+R8lmkdaFT
Pou0TlHKZ6z/k/JZZPAZ26d8xv5TPnk88dwgxp/yGeeb8hn5Sfks8un9lHhu
EDjxIwY/YvAjBj9i8CMGP2Lwo+MhvRND78TQOzH0Tgy9E0PvxNA7MfTO4CG2
J70TQ+/E0Dsx9E4MvWPeHPNGfkRa1+1HxPAjYvgRMfyIGH5EDD+idZ7JjxDP
8dyg4S/E8Bdi+Asx/AXz45gfimfEiGfEiGfEiGfEiGfEiGeE4hnFjXhGjHhG
jHhGjHhGjHiGeXDMA8XJYsTJYsTJYsTJYsTJYsTJksbJ8dwg7gtDr+vG47lB
I64WI64WI64WI65mfhzzQ3mZM/IyZ+RlzsjLnJGXOSMvc2leFs8N4p51Ggcy
Hs8NGnmcM/I4Z+RxzsjjmB/H/FBer/WNKX93Rv7ujPzdGfm7S/P3eG4Q99Bp
H8mx3+H2tA/gjH0AZ+wDOGMfwNE+gOK076E49j1Q3wf7CahPhTo7wFHXC/Vx
gKMeGurXAEd9OdRbAY76Hrh/Cxz3l1HvAzjqfqCOHnDU/UP9DuCoX4d6HMBR
nw11LnS+oZ4S7mnrvc5QFwL1ibCfsCLUPUNdIeCoF4e6P8BRfw/1a4CjLgrq
AAJH3ULUudN9jFB/D/eBgaO+nNb7wP5JqKuG+hr63FCfCnVgsQ+AOniotwUc
dQVR3wc46sCg7h7wn0I9QNSbA456d6izBhx13nAfXs8xhvpmqE+BvLt/qH+I
+8/AW4a6eajXABz14lB/ATjqpKGOG/JN1JFD/TLgqJ+GekPIm1CfE3qE+Bn1
UqBHwFEHBnoEHHVmoEccn0OP6o7n884Hqh5xP9Aj4KeGOlTQI+CohwM9Ao76
NtAj4KgbAz0CjroH0CPEvYO++E+XSYdVap1i4KgDCT0Cjnqb0CPgqDuKOrDA
UX8V+qX9hDpd0C/gqBsG/QKOe/HQL+CoqwP9Ao46NtAvxKUTQt1L6Bdw1BeF
fgE/JtRZRV0G4Kg3C70D3jXUvYTeAUe9R+gdcNQ5hN7pubVQ34/0Tnyoj4r6
v8BRJ5b0UVBPkvRRUEeR9FFQPxD6iDhqp1BfEfoIHHUFUfcHcQLqChLPWj8Q
dQMxX+Co68H2H3Wp2H+RP9X3CDQerfsHuwEcdb1QJ4v9AuqswR6ivhbqjgFH
/THU+wCOOh7oR8+zhbptJG9atw39A/801G0jOdS6bah7CHsI+UfdQ+BnhrpM
qA8IHHqEeoLYP4E9QX0KtIc+ot4E2sMuoQ4g2kOvyc5oPUDU9UM/sHtkn7Ue
INklre9Hdlvr+JHd4Pk6ni/kh3kjO6M8E29qh4kftds0X6H5Cs+X/ALzE8+T
h/bkL3RdSE7UTpI8qF1FfTf0Dz5R3w3twT/qsgHH+hKfAj6hL7ADkGfUuQPO
egH7g3p90Avg0DvSR8VR7w849BfPBY74CvX1gMMOgE/YPcR10DvgsD9k37Tu
GcWlDvaH7JWDvUJdQsbJjmk/kE88F/E28l/ORyhfcLC3ZIcVp7hd50X5WibN
v+K5MuCUN2kdNvgp4Kj3RXl0xsijGVe7jf0KOueg+9uoEwc9Qt0w1H0Djrpk
qNcDPK3bE8+PoR5a6t+LtP5b6q9j/6m/juOhcYoxTkE/qNcGPK3bFs+PYZxp
XFEkmBeNU4xx6njoPZd+Pw7jh/yk6xvPg6GOGeo3GbjKA+qhoT3j9J5FjPcs
gvcO9D5CjPcR2g+NxxnjYVz1zpiv4hTne8T5iCeBo74Z7A/nBaibBhztaX/A
YX8A9hY46puhbpfRXrg9jYfHn+Hx07x0nDSejDGejDEeah/PZeE9FNYF9h91
zLAudePxnBXqmIFPxo1zVvzeit9nKQ/AjfNUPH5vjF9x8qcax9L4Pc1L6sbj
+aiUz3g+CnXbUMcN/QBHPTX0g7pqFJ+rX6Z9EvXj5N91/4T2sdUvUJzg03gj
nnd6dvc2g49tWyl0HlvvE9G59wzuMdE5c70HROfJ9d5QuCcV63GFe1LhXpXi
uFdF5/P1flC4n6U47meF+1x6ngT3ucL9L8Vx/yvcF1Mc98XonoLHvbNwT01x
3FML99oUx722cA9Oz2ngHly4N6c47s2Fe3aK455duJeneRPu5dF9DY97fHRf
w+PeH90v87gnGO4VKo57heEeouK4h3hD7X1JPT+A+5LhfqXiuF9J91M87mPS
/RSP+5vhvqfiuO8Z7qtqvIH7qrXjmaX5Bc5hhvuwEcd92PQejfZD96f0Xky4
56t5Ae75hnvB+v4U94LDPWLFcY843PPS+EHvedXeF1Mc98XCPWV9n4h7yuFe
s+K41xzuQSuOe9B0T03v6YR7c4rj3ly4Z6047lmHe9mxHki4lx3ucSuOe9zh
3rfiuPcd7omrfcM98XDfXP0O7puH++mK4356uOeueQruuYd78YrjXny4R6/x
DO7Rh3v3iuPefbi/H8+Nh/v74b6/4rjvH+oDKI76AKH+gMaHqD8Q6hVoHIJ6
BaG+geKobxDqKmgcgroKoQ6D4qjDEOo2xPoSoW5DqPOg+Q7qPIR6CxqHoN4C
tc+MuXBuix5vNsrQPXePe+50j9vjHjfdf/e4/35der/bd6yaOW/0cZV8L97j
Xny4fx33T8L963A/Pe63hPvp4R63tsc97nDPXdvjnnsYvzPG73j8gQfHPNB4
9L483aPXcdJ5aZ0vPVeM52qdgetS+yngk+al9+up7ofD+pI8OMgD1eVQfPCT
Bx1d/Zc6sS8f229c7lx3wNVfA6d9Bv3uJ+0P6D4nvseJfrB/i+9WAsd+L+17
6P5nmm9Weewbp/lmlcc+c5oXV3nsSyOOAo597DQ/rfLY90ZeAH+KfXJ8RxM4
9tVR9xY49uHxPUXg2Len/Sj9bh3tR3m8F6B9bP2OIb5rBRzvHRDfQi/wfgT7
NsDxPoX22fT7ibTPpt+XRP1i4Hi/g+9wQC/S82x5fl/3eYDjPRftB2o/tM9M
+3vR7+M9HeQQ/rpxeK8HOQSO94CIw4FjPxzyqX4/7KuTfAreM5J8Ct5LknwK
3mOSHAree0IO1Z+G96SQQ+B4rwo5BI73sJBD4HhvC7kCjve/kCvgeF+s3/vB
eY/w3hn79sDxnhr783quI7zXxnd0gOM9OOQQON6nQw6B4/075BA43tdjPxx2
D+cBsB8OHOcH8J0e4DhvADkEjnMO2A8HjnMRyB+B4xwFvquh+6Lh3AX0hc8/
UHv93hO9d/Z470zvW/2cUFec3kfrd5TAv+p7eE8KHtAe74sxHn4u5cvaP7UX
GqfqKcZJ51L0eyjEjwM/dG7E8XcwwduPZ4ya9PnSeA9E7xFv6rthQ1X0H8Bv
7HrAQV0mxfP6wKt+WfzFFadsUr6AnzV0XMGiC+L7bMZhL4Cv6P/wJ1XHo5/4
PcZduxeN2P76eK5O7w39PnnAnHUNVK+Ar993h0NWro7zwryrq9Z/P79enBfw
gtmtP7z79eifgF84cvEtB+wTz48Cv3zYhkatNm/UcQK/99NXnj7u2WhfgD//
27JDO6zR72THut/jWzQufKOhjgfjveXSny9atXmz+kXgW807tNeQ8zfoc/Wc
yZf3ftb62c1qv4C/9eSlVa+eE+0OcIxH9R/nUhI+8X32Kr/tPw8+8eBOej5G
44Hl4bnoHzh4QP/AsY4pD+V+VOAT7YGn8lCk8tVrxwNbT7iyVHmBHj1RuEvj
Zf+O52OA37XdZXP+0Su+/wbuD21507GfxfeXwBd1nrvhjeGl9Nwi2WHCMwdt
3C2ewwB+eDoexWcsaXluLj5M+SmSYfNale/fWPVH8au69jwvF/dCPvCcY/ou
zX1XiOZbLKu37vqsG1VJ8y2WvQ5+afMu262h+RbLhNL9LpVny2m+Nf1fddJl
hwwqY56VB8g/8IL2G2bsukjlQ/EBj8yorNhnDfFQLNvt8LU74LpK4iF/XnhO
n8ykSbn9mVRPy2Wrol0PnfqY2g3Fq/fu8WGTFvG+CvBrkvkWKZ6ue5XGLduQ
nOtzg96R3ArsA8mtrE/sYawTde+Dv/+c208j/dJ5petSpetIeie3JvZB9U5g
x0jvhO02+gPPZB8EdpLsg8AvpPOt7+BHYH8hv4xjndEP2gHHc8Gj3nsN40Q/
ui+azKt+zIMCD6m+VHnwlupvle+Y6ovi6brEfVGsYzrfcg8/iPEAh5yQnLM9
VxxyCLsAnOxVzGuCnKd+qtyneqFyrvMiOfckD7rvYdgfD70m++NhB8j++NRu
4Ls2xT61t/r9aw+7RPbHp3ZM7Y+vW1+KPewk2R+dVypXRb5uO1zkYbfJ7/h+
jb7/rc3zZaS/RR5+IZ1vkTf8iK/b3hZ5tlfA4dfI7/jUDyrPAr9JcivwsyS3
Qn5Z8zLy44pT/KPj/SmJE1S/BHEF2QehuE5xxC3oHzjiHIqj8p4L3IijJI27
YryGOI3iSYfxUDzpwAPFkw58UjzpYB8onnRkx+K9g8ROxjiO4149Vx/4pHje
pesY45E07tJ43hnxvDPieZfmBfG767DbFM878guaD8KPQJ4hL9BT8kca/6fx
QP0M9D21q/Uz0OvUrnL7YtX71O7F/UDEe+TH1R6m8VWVr//E/851kJ5WqV5T
PMP2U/G7Rra55ZAPS0lPi/2gsC5pPJCHa5xptFec/JHgueSPhMeJ9U/nFb9L
mPKgflmYN8gL8az6i3WhOMQZ8uBIHhQ35CGvPXiCHBKeYbxuedN5kR+J55TA
D+Uvuu6UX3gjv/CkL6pPhr/TPIX8Ea17PKfE8ox1Seelekc8x/ppKW+qd5Lq
na67N9Y98/qUIbfX2A3H8ed700ZtrrEzai+Av3Zkox9q7Krj/o9f+N0RNf0L
x58/bbnhkBo75lLeqnynzCf/rbHbjuPPnVefemGNfxGSf9/tpj45vRCSf/9S
g/5VNfGMpPxX+V0OG7tfTfwmHH/uVLFySY29VfsF/I3lf9xc41+E48/h1/c5
tMYPar/A77xmu5xflnS9yv384g9ycYikelHu//bc3iNr4jEdp8a9Bw1bVBN/
qj4D35XGj3V+96OJW9XYGeKn2Pc8/rSNNXER8VPsx+y87pKa+JD4KdbxcHw4
J/DJ8eG6poufqIkP9W/oy6679GxTEy/ReGr0qNmOB9fEbzSeIh0nx2/gje2t
MV/BczlOWzi/fEmNX+b1laZNH2xRE1fwusjqxQ9Pr7HDLLcysNPqi2v8Psut
/PbuJc/VxC0st1I4rM23NXEUy6fceMH95TX2meVTID8c11XeWn12TRzCeiez
Wtc7siaOchzXvX1HRXVNXKf7R8A/TsYT7cz8aaNydkbHCRz6y3Egyb/i0FP2
I5/e/HjOj7iU//ruqece3KomPnQcH2JeHB+CZ44P03WMdnLuuL/l7CTpV30H
vea4sWNqfxSHfeP4EOvC8eGZiZxEf5LKYYz32gT7w/Ee7CTHe2SHNd6D3ab4
Vu0571ejHxp/JrXP0e+ldjLqx4IwLxp/Bjzw/jN4433m1I/EfBrrQuueSdcx
xgnGumdSOYn7z6S/ikMO0/2r+hnILcfPkHPSO/VftI9EfiTGydA7jnNSPY37
2NBr3seGHaB9Ko958T52amfiPnbq12J8DjvG+9uwe7TP5sEz72/DrnLcDjtM
+4ce68j73gsTOYz73uQX9DnwIxQfCvlrxVN/Gve3Db+m/oj3n1O/Gfef56Rx
i+KpX477z/DjNF8dJ+cjqd+M+8OIK1L9Kpc0Don7w+l44v5wylvcH4b88P4w
5J/WV6DXvD/cJrU/6mcR15F8CuJAzqcQN/L+cKqncX8YcSnvD8NOcryd+s24
Pwz7xvvDsMO8Pwy7jf71/kiyjvH9YCrP8b0e7BLvQ/ZN7Ezch6T4RPFUH2M+
Nbhj71xeQ7wV+ZcSO/yXe80B5/dQ/9plY6Nl/867byIHJnF+3Mc7sM51LPLo
h/OvdJzxvQzmRXGv1G3fiqVvur66j5Ta/7j/Y6yX4ziW/RfpF/OcYZ55fxX+
gtZF+ac8Rfkhf6px1P8B4CNyPg==
     "], {{
       {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJw1mwfcT9Ufx+/VvU/n9vyUpCElI1REhdCS0pTshpHRQvZOoUI2SYOKhMiu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             "]], Polygon3DBox[CompressedData["
1:eJw1m3XcF8X3xXdh53HXD1ioCIq0gEEIJtIiYCKCKA2SIqGA0kgLqCCCIoKg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             "]], 
            Polygon3DBox[CompressedData["
1:eJwt1weQleUVBuCL7uIuTaqGJhBAiii99xaJ1AjE0GHpvYpIF0HpnaWLdASl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             "]]},
           Annotation[#, "Charting`Private`Tag$33280#1"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
           "Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 0, 2}]}}]}, 
       {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJxFm3XYFlXXxR+fwZnnPjNjAiKCggkodjfY3d36qq/d3a/dndjdCaiAWFio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             "]], Polygon3DBox[CompressedData["
1:eJwtmneA1sQWxT/zYWY32VWaiBQBCwICSlFEBaTaAJUighXsXez12Ts+K9an
YsMOogiCohQLKoIUAVFAqhSpSgd95+eZP2Z3Tu4k+ZLM3HvuuVNvwJU9rkgK
hcJW/amg/x3LC4XFoVB4WHhzXih0Fv5d+JJioTAwKxS+VP8rtWmyXyV8jOy/
CneTfXfhyiWFQj/1/1Grqv5KHcvVf0ljDtXYWrpmmfAQ4WbCS9JC4Sf1O+pY
Jdk66Nj1Onaerr9BuL3wdcLnCq8Tbpf5t32sc0ap1daxPXTu6+o319h2aj+r
f5yO7ZX7WierH9Sq6/gmnV9d/bfVb6Wx64WrCjcQbincSW2p+ufpWH2dP13t
v7rfo7rOD2WFwgkaP1S4Pe9A+A/9v7ro93e/+idr3JHq/805wjN0/qPqP6bj
UzW+j87/WLi7bDOFm+h+d6i/Uccel+1g4VuF/xB+WHhPvcO1vE/sOv40Y9Tv
qOvdJ1xd4z/R/xd07BjZ1qh/rcbvFH5E/R/VpqstF75X9h/UX6V2hcb8R7ip
zv9f8PtZIjw39/MN1fVn6ffVFa4i20Ea00JjfxS+T/ZBsk+RfZHO6Sl8ofDz
3Fv/u2t8Ua1a8O/k9+7geYQP0jWq65nGCw/QufsLf6bjHwqfmvlbn8RcUtub
OSNcS7Yt/H7mnvDFsh2ido7wHLXO6m+W/W7Gq32gdqfwYbreDI0/XPZD1S7T
8S+EJ8nWVLif8M/Ci4SPFr5a+GbeD+9SeKb6qX7fY8wnfkOp32Vb2dqpzVB/
idq5zBW10cFrZ4D6BxQ9R/nGnwe/U779a7rf6+o3lP1THR8h/Kv6jdS68R6E
R8p+cNFz5HPh29VvotZXeJ6uNyF4Dp2v65Xrexwh2/c61ka/dZH+9xfeX+0j
nk/jlwefv5vGztT15vFuhC/X8e+F71S/hdr5wlOEZ8jeUvgC4bt1j6XC1/Je
dK27hJcIXyO8UniW3kkuvFjnrRe+R/ZlwtfJvrrMc465dz1zWniBxtcQ/kPj
NwvPEC4V/k14rfCPwiXCC4XXlHmNjdW5zyRee7Nlr6j+Mtk3yHaDbDeqnapj
Rdl76RkrVPAcY66drGPvy3Ysa0Hj5+r8ysK/6/w/hecIVxJeLrxRONM5gzW2
D/5Q5/4qe3X1V8n+l+yvyvaa2uU6VkP2PTR+KOtJuKbwg+pv4/3o/TXXOR2E
b1J7VsdOlH2+rjFR+DPhS4UP0ZjyxOv9lrg2W+vcEXwvPcNMjdkg21KNa6x7
HaX/VRP7i9s1Nss9n5nX3wpfrPFjhM9WvyHj1UYGz4dxsn2e2Ve8kNp/1tP5
dWVrqv4RGnuR7J/IfpZwA+Ev9H+C8O56p/vo9/wte+Oi+zXVvuG9Jo4PxIlz
M6/lGtF+g/BknlW2RrpefXwd60zjG+veR+vYd8HzMRduw3vW+D/V7mStyT4t
eH3uIfub6m/gnQo31LWHEwPUP1Pt3tTfYk/1e6ktVL9Gbv9PHCC2zBQ+qGgf
j6/fpmvUEz6C9x6fl+f7Dz4l+Pmaq3+H2hb198ntn/BTxKaS3HaenVhZR8+c
6V1dp2OdNOY3Hb9Fz7KJ+CbbfN0vKTpmEjs/zj1fiFnELnxXHdnPUrtP538Y
/PvOVvuv8DU6f2bitcn3PiC3v8HvELtz3eMn4VlqmfovB8ffHmrz8U+afyuC
13tp7rlcrn5PtQX4gzK/0zt0jxbM19y+5iPd+5cyxyjmXieNryzbkcTIxD7k
KPVb5O7jV6by+zT+Rtn3V3+yzt9P+Hrherxb4X2ELxPeF98u3IgYpPMHq7XU
tQ4Wnqf+s2qHC++lZ3qP74CPE56l1qBoH4GvGEOMTBy/+ca36/zF6r/IN9bY
ipm5BLGFeMUaZi3XUf9rnX+g8E3CB/B+hUcK19C5txFzmK9q/RPHuDbqD5K9
dmIO0E74reB3P5P3q986Lff8HB7fbX2Nv1njDxT+TnixcMr8VKudeW1UUv8R
Yjh+XsceSRxj2upaS4VL1L9BbV/1P8r8Lm5lDcs+Qdd8Njgm7yFbJ7WX1T8y
mH90EH5JuHUwn8mEzxSuLDxe+EO1WvrdTfFJ8n0LUsdEfDK+uVTjz1C/ErFU
Y9fK/hBzFh+O75b9dPUrErtk3w2fLFwmPLbMPhpfvQc+UDgR7i1cLvypcBDu
J7yn8Djhf0r9LLnwGOHtwt2EU+FPhLcJd8U/CY8W/kTvIFTwM/Ase+t6l8he
S/ZJwtWFLxWuLfyl8FGZ58vhwXymmvDF+HLhicIbdf1Owv/oOT8S/ku4M4RZ
9pHCm4S7CO/GtxKurfvuSuwD6qp/kn7PBn2bXfAZfJHaZny77D3VX6HzD9f4
v3T9EcRq4cPwf8IfCHfLzeVOgA/E+fax+n+onSDchzkp+1aN37fE8WffxPwX
nzJP16svvEL24brekzpWkG2d2impG/3SCr5GocSxZxX+Vv0ytV/UTyvYp+Pf
muh6JfH5qqkl6m/RmHd17XeC+XW/6O9YqzwrYxjLd+H75Gqddb+/8deJ+f8/
wfdfmJifEv8StdsS+/tiidcXfL1P9G+p2nS4mFpQf0fw2pmKD9f1S0pswyfi
G+GacC+eiWerorZN/QlqFdQfqfdZTferH98X1xuYOF6xHslV1gm/EX8v9+Be
g9TqCs8VXqr+ELWBwc/H2OVq5br+V7nn74DU643nG1/0b+C3fC57R9lPSz3f
R+f+fu3i/PhQ33/voucQcwn/MEz9lWrHC49SO1Dj28b5g39+qWgfiC/Ef71F
vFI7Lvcab6Px21Kvl7G551/X1PN7jHBLuEuc/5/mnq/dUs/3rrnnD3N8XuY5
ydwcpXaM+r/rWFb0N6qj/oTc6+X01Ot/q+5/IlxL72mU8GdxPvdIvZ7H5f59
PVOv9y9yr8e+qf1Jx9zfcgHfQ9eflPt656T2P1/m9g/9U/urLrnHLlQ7Vv1m
8Cb171bbyvzLzZUvVOus/vjc671fav80UfgE+FVq/zQqrql/16CeZbnsU9T/
Rvblsv0u/IPwZOHfhVPh7xLnMAflvt/8onOATrlz5EtS88+VMd8el5qDBdl/
VntP/XfJm3W9qbn92y2p4wnxkRzgocT+BU7wfnAMgyvAF+H2l6ldresfmDu2
kMcMIybk9n83p45/vwgPE35feA7PqnMakB9FPvyUcEPh9sKbYjwbkJgj7RP5
GjwMPrZvbn+2vuic9sQYz4jHcDS4Gjk8PAQ+Qm4P375a1z5bY1bHfPWi1DFj
veyHCF+cOqYsz/xOebfkiZN07mAdayRbh5hvoDnAg+BDteL8RGs4Rbgmub5w
XeJBzC+m6NhF+J/U/IU5w9yZH+cHOTrcvb1wxTzm2xo7lxjGt84dXwem5hdw
KvSAQyIfgN+Sc8HptmvsT2ovqv9i6nyFmEHsWB/9/5zc8fxl8rQy6wHkxl1k
r8paz5xrHy9cTXh27nj/ksZPLzPf/jr1HN0q27e54/lVqfkX85NcuRX+Meox
LwZzDr7PN7nj8xWp42mSO5e+SO28zJz4hWBOw/evnpsroQs8F6w/wKPh081z
cxTmC1oB3AX+eGTRPgs++b3aBbLfkJovkuN+lzrnIPf9Wq2v+penjteTc/OP
K1PH9yq59QF0gruC+Qpxh/jTV7ZH4f8af0TM/8ipv0ysDZBrz8udP74n+2zh
w3T/B9S/S8c2ZNaM7k+tN6AlLdX4r9SfQBzQ+MPRc1Jz3D/jeqtVtM+Gzy3A
Z8s2Eh1A438VHi48jDlUZj0D7Yg5syWzBkNeQH6ANkM8YK2fI7yf8Mrcc+mH
1Pn5Kjiy8NTU+fsy3pnwROFlZc6pyK2uUruDtZ2by6Jr3aa2Qniqxn+r8SvK
nKP9qx2o3YQWkPt9jZd9SZn5KPpc/8jPVzOnhael1gPIR59nLvA8xArmKNwy
tT6AJndbak6OVgf/HpRETUVjHxPeDz4b83dytmdT6wPkcos05nP1PyX3Il/X
sQ7CfYQrlHs+Vig6BsLfH5K9puxNo37xCnNY+FThosavLrX/QLv6R/YhaJ7C
vWVPZD8tN3ciBhILnyGnZz3KvhUuLnyo8LHC24SfE24GPxPeLvyycDvhXsK7
8W6Em7N+hXfIvlT33z+xtrWzzPkzeS75bp3cGsL3ibUwtIWFubWFMRqzQPg3
4XHCY4UXCt+fWc9oEPWVB8gfhBtF/eXBzPpMY3ih8P+EjxDuLryrzPk/XJCY
S+xdrPaF7J/Jvgi+oWd4LrXesV1jX1RrTTyA65VZYyCPJZ9Fe5ip58tkXxTv
11rj7xU+TM+zd7nHMPYB/JVsbdBY1N+v6Oujf6K7ob/tEP4r99whhhBL9lJ7
Utd+QsdayV5N+CnhJ1nz8KHM1ybHZv58F/WPjzXmgHL/hsHqP5X4t01RG6v+
aB2rL9v3UW8ZJXxguTXM1xJre2ibVdWekO1xYopsv+j4iUVrxOi5zWK+iQbD
880L9t1opui3aNjw7TWp9YETgn0DPqKnxh8VHAuICeR6xBdydzQE/AUxjdh2
vo6twF+p3Z44J93MXIv5KJzyL/Vb6XrPpM6JyI3Q9I9X/+moV1RRe1z2xxLr
q+TE5MabIn/YFhwL0bTgU99GPegDnbOfzv1K+G3ht8hXWD/Bc4c51B/fq/aW
+m/qWO1y6+FowKzRNbrXB/F7PaJjlWX7IbO+NCm1XjUszp+HhCuW+5vwbfim
/WSrkFs7hoNdJvy+2j3qP6gxe2rs8Mz69sPClcr9jfnWfOPTM2vWI3hfUV9E
30MrR9+dnjlfJncgh5ghfHKwb8fHnyb8jdq76r+jY3V1/uR4veHC9co955h7
o3Wsb2bNDD4xJ7GWdkmwr8RnXp9Z/zwjtT79o/BUtW/V/zK1/ve18DvCbwvX
Kbd/X5M4h0SvQFNsmTpnRGukHoNuiX7ZMPc1uBbvGG2Ra3AtvmG3zN+Ub8sz
9M7MCeAGxGByb2IwsRiOQe4NR4WrkoOjhRCzid1wCnJvOBZcCw6KdgTHhmvD
6dEG4PRwezg9WgOcHG5OToGWQE5BbnFsYq2B+Uttajc4Nr4rM19Ag1ug/mG5
uemVifUmOC/cF06NFkSMJdayptYJ18o8Fo1xbWZOB7c7K7GWhAaMFoymBl+F
U8Gt4IBoXfXUrktcA1vF+9P3uzE1x9w/s6ZJrktN6w/4LD4NLlc0f6Am9YbG
HhOsX8KJ4EYXJtbWGqjdWHQOTvxslTtWsObRz5hjzLUPiDmyL9N1Lii65tAt
ajrkSuSoaD3Hqw1OrJnuVH9uMNekJkO9izXKWn0zsb5dU/hV4VeJefH3osWh
0e0itsj+iuyvECMzc3C4OByP98GaYG0wZ7tn9hH4CnxCV2KV8BDhIcKdOb/c
NRV87nGZawRwgZVxPc4O1irRzNGT4ej4p1mR31RRO1fnnyR7nrlWApdFU+8b
NTFy9e6JtbL5pY6Xq1PnO3AuuBcxCf+5j865VLbThKsKV8n8bGiw5HPEOGIr
1yD2UWMg11sR1y85D7kPc4jvXzmz7y4tOr+BI8OVqa/9ltkH4gvv15hDhc8M
5nZwvAsz+0R84zeJtf0y4WtS51NlwgszXwtNc8/M9Txqb3ByuDn5Dd8aH4wv
/k9wPQLNpgU8utz52Vnx/eEz8Z344KZx/qHdVop8hbVM/owGRc5PTQ1+QK2U
WhvfY2BcL7zvRzJri/gofFWp2vnqn6xju3RuKPf34/vsEG6ie9xStEYEH++Q
W4vdq2i+jo/H19+t8Y2Fp2XO1fCx+NqNmdfazdE/UaNA+6EGui5+X9Yb35Rv
W6JzzovzZ2ep699oYWj+aP/o5fC3o1PXepdl/pbknJUy11ypvZIDo01TK2Lu
MofhtbuCtSRyotXq715irapWjLnY4e7UMNGbeuj3/l20BokeQw2eWjwaMfrc
KbLvLLrGgV7SPrevR8NGr9kerGXBkdcG+0e0+Ioxf2+dO3dD80dPJ96jnRBT
WFPU3ai/oVegW5BjkWvBYeZknu/EqqeCa23sKWDs18H1E2oTaBPUIKlH8nvQ
xtHg0Nfezuwr8Znl5f79aE1ocsSrNzPP7avj3KwZ8RvBtTreH3wFTRG97y3Z
z0m8JlgbK4NzG2qk1It5XmoHrWO+OlTjT0k8B5mLr2f+9sxB5uIbmecmc4K5
QW2Stc0aR9fB39+ZugaCv+YZboz+G38BR4Yrw7lXaT6Nycw94axw108yc1c4
LdwWTg43b4XP0/ix0V/DWeGu5CzkLmgCczPnGOQabYXXlLq2zV4FON6Z+OXg
2ESMuj3mQORC5DzrNH5Tau0PDRDtugCfD+az6A3bU2t1aHZoi+xJIH+Do8PV
R2XmwnBIuGTj4L0EcK5DMudg5GLkINSW4XBwOThak8x6N9ozGvKp6o/OzO3h
2HBt9Ha0ctYAa2FS5no7MYJYsXu5+RL8YLOuPzFz7CBmEbvGZ45NxBhizYTM
sYyYRexKgvkFfAPtnxyQXJAcbq3wE8F7NfBxZ+n4n7n9N5oT2hM5H7kfOeFi
jd+YW7tibqD9oVejbaO3oGcTY9DW0NyIPeSQ5JLkmItKnR+g9W+P6ysExyvi
N7USckhySXLOJaXOSclNqe9Qr9lCDhicb6Af4Y+o16CxobVRk7o++gL0GzQ0
tDQ0P2r5+DO0ODQ4tDhqgsTb2VFvIWcld2V/xk+Zc3BycXLs9Tp/ZWptG42b
WgW1JJ5l3+jzyfHJ9dFoqN2jyaHNERPYC4Bmg3aDZkctH00SbfKgxLX7Z4K5
HpzvstR7jKg1EMPgu9T64YbEa+J2XR27NrFmTb5Efo8vpa5DfYX9FOOD+RJ6
FxoLWgsaC3sjWMNcq0bw2ibHJtfeO3H9DA0OLY58rYfGTtex1Yn3nJAvsCeH
2gd7OtC37hMeWPSeE/RENJqrYiygvoqmMi3mA+y9WJOZmw6N/g4NakLkA9dl
jvn4p72C/R17fIZG/kZ+Qn4xKfJ98g00oomRP5BvoDm+HPkX+Sf1HmrbcNSK
Jc5Ph0R+B78k/3kz8jfyGTQj/Ct+Fn0WTQptCo2IvSZXZNbLBwTrFWhgwyJf
JT9Eg0aLJv89J/PeGvbKwInf0PFxwXtpWPOvp84vh8f8hNyN/QnsZSBG9c6t
uZGfkW/Bl6hxU+smX7tA+MrM+te5wXoSmiDaIJpnMXc9gVoBMZXYyp449sad
F6yHoGmRr5G/sRcGjQytDI3wWnxPjIf4JHwT9fnJwfwTff7yzFpt/2A9p3f0
R12Dcy/iJ3svmhVdH0AzRjtG82XvC5od2h2/6bbMNQlqE7zjWzJzdrSajpHL
k9M9L9w5ONeDU1K/bxLMNeHk7B/pEszV0VTgUi2C4xEcHW2vUzB3x2cTSxoF
+3L8/V2pr8m1G8f11jCYm6EpoKU2C44Px8X41y7YfzOHmEunBOfK5PTkoj2C
c31ydHKHnsG5Oz6eWFoMfr/HxvjZNtjfo8mg5TYPjh+dY3w6Otj/94rx4MTg
3CmP8b5qML9gLwrciBoe9Un0E/g4GgXaUpcYn9oExw9qNtRu0JTPzKwpoy1T
Yzk7M4cllpQE8wk4JbG3NJhPwHnxnVkw/0DDIja2DOYH1JioNTFnb83MweEa
Bwdzc/b/sDeNmExs/iyzloaG3Jb5n9kfDo78DP+JPyOHZs8KewjQo9F/0JvY
Q8DeSPRp9hZQQx8U8xH0I+Ih3ALNC+2LPUjsRUIjZi/nF5m1O/Y4tM+cv6B/
oNeQr6BvwRX4Jnwb9neQi8JxniZPjPMFTRxtHB/G2j0p2Le9G78vGj1aPT6X
d31csC8m5pHPktcSC0cEa3Focvek9nH4muODfR81z26RbxH/4VzE5s2puRjx
t1fkA3xLfAhr/fRg34J/wleRc5N7U2PtGvkUewuo2baN8ZC9APCN7pEPMpf5
pvPVvzL4WxNf7wnWjNGKP43rmdwBbZw1v0D4qmBf8F5cr9QwqGXA546J/IJn
+denqn9qsK8dF/0Bmj3aPT4Yra5PsG9mzqIv9w6ey9So28X4Cz9kjqNH9wqe
+3AQ9PuNqbkJMZR8m7yb2ErNt0fkj9siPyB+Vo/xHM5DrF+fmgttyl1boWZA
7QBOAzdYl5rrkM+hNVGDoRZDDbln5L/woxGZc3c0abRpOBlcY0Nqrraw1Noj
e0/Zb0uMIJaeERw74LtdIh+DT7M3Gl9MfYo6FfUVchlqfNT64Mjou+i8cOdt
uX0zY6ltERPgEhcGxwp89K/CVwT7bs7hXPaE/Jw5RpAvkTcRO9gzwN6Bf/es
lLomQG0AzXP33DEJvZX9t8Qq9k2hzaD3ovtS46fWzx4A9r4Q86il8M2JhcQg
agt8c2ITNXhq8dTI2etDzKbWwBwilpPDwBW3pM5tyIHJhZkDa3NzZrjwztRc
mvlJrk5MIDbAEZnbf6fmjuQzg4I1A2ozL2TmlgeoLSu1PyP+UIOgFgHngVtc
FMyF4DBwpYuDuQ31LOon1ESpjfIN+ZY7UudK5Dxw510xF5oSzM3YozJHx57I
fG9qjNQawexd3KQ2K7NPwbewP3x25j0l9SMfhO9Sc2kU5zd7Yf8P5aIiYw==

             "]], Polygon3DBox[CompressedData["
1:eJwt1nm0D2UYB/AfcrmXEqVNJclRZJdwSlmylBKFrEnKVnSyRIlCRQsdUdkl
KmvIvoXsa9nlXpQ1st9Ioj7PufeP7znv85lnfvObmXfmnUKtOzfolDWRSAyW
7PJuSiLxO3g9RyKxRf7JlUgsZw8bf5YkttVSl+F9siUSS9la25LVG3gD40ls
sr5m6j3JicQNxn34O3JK31w5r+cJKW/bUT3FWFe/d1LPANlp37XsDuO39HXQ
d3OYPMG+YuNZQ/UyfdeyduxZloX9yHKztuwZ9p9j/MQfYcPYMFZHXUNfquPO
ZMtsy6LeLEWM+7Oe+oroW86uY+1ZQ5aVDZAD6vskhW1zjDWspr5RbBSrp15h
3zzsVdaEJbGf2PWsE2vKcrBV8X/YCDaCPaleqi8Xe5k1iBvFvpP87CVWn12r
XinV2XA2nNWN40oVNpQNZbWjz+/lZZ1ZM5YzjsvysddYc5bM1rOC7G32Crs1
rjs75VrlyZlIDLJtD1vCkoxf0FdX3yXXYDHLzlrFPWZ/s0V6K7JZMpA9rN6g
r1DMC33dWCG2Q29u47d4LzmpZ53cGbW+jrbdom81K8B6snYsP9vICrO+7A1W
OM5D6rPv2CTWVL1J3z2sH+vB7mHrpC4bz75mjeIY8hgbyUayp9Rr7Hs7e5O1
ZzexO+UN1+V09MppPZ+wQ3p6q6/Xt9N5zWfl4vx5f1ZRPU7+VdeWMuy0vq/Y
FXUdKcvOsPHsqvpxKcfOsjmOc1JdI66f4xdXj9V3WV1LSus7pW8Cy+m4Ddmj
7F82ml1UV5Ni7AT7lt2orw17muVWfyD71UUlmW3VN50Vy7xv3VlJ9WZ5ns1j
C1mHuM7Sks1lC1h7dZp8zlrGubB96pMykXVhreI/q0s6l17OKZ1PkwvqvXyo
cYu4NvpS1b/wSmw0G82qs++lOHs3cx6UUu/UV5tNZdPY0zHXWC02hU1l9dku
VieOyaazBmya3Mf6ZM7TEuqt+iqzMWwMqxbPmnxo/AOfLRf1TGK3Gb+S+ezH
PM3JV8c5SW/nWFo9gp/T85AU1nfIdR7KTqjvl9viWrFh7E91SSnA9rMv2Rl1
RSnEfmcz4xr6/ZkxV1lZ9RdyWk8FuYv9pu8blqKnccwFdpUNZ2fVleVudpB9
xo7HXJFbWRobxA6rH5C8bBcbyH5TF5dcbDsbxS6oq8a7kh1n+1My3mfxXvvS
8Q/EHJBk40bRa9sVfSNTMuZ7zPv+tu1QX4q1xnij7LPtbTZGKsd91fcx3x33
ItYydYmkjHdKvFsGsyPqByUf280+ZUfVlZIy1qpYs75m2fxOvXB2kf3suBXY
55nrR2U9W1gpNpgNYhfYNvYom8AmxPPGsrLZxrPYctuyqX9MyVgjYq2Yzy7H
O0yeMZ7MptjWXH1e77hY86Qru4tdwxYZz9e3gmdXH5DWxmvYRttejWeXvcBW
sw2sY9wf9iJbyzaxTqxgPEvmYpJ3+2jbzupZyB4w/kjf+5nnu0weYkPYEFZT
PUNKZL5PY70so55t/2PqKlKE7XX9FvDy+j5k77FK6nlSNtZ81o89GGbf9FhP
Ym6xI/ZdyBL6msT7jp2L32P/qZ+T6uw8y2v/NrFGxBosZ+J7g5Ux/kBfX9sq
qBfxLKwpe4yl23cfa86Ws1UxN/XNZ5di7Y1nM9YF9bNys+s0g82KbxB1mjSz
7zK2kr1k3z9YF/ZrUsY3VXxbHWOvxfcNS2O94rmKbx+2lx1kfdkUuTe+qxxn
m/tSTc9kVpSdj28iVoL9Fe+YWGP0pbOierazqmyi35sYzxHbzeqxH9gc1pil
swlxjaSHfe+N54B1judMX2qsw+xN2Rvzia+Xv/UckU7G25MytkXPCdaNpbJD
rF/sxxqxhWwJe579yhqyBWwxa8H2xHXNkTGfY163jGdLOrKVbB3roU7V15gt
YktZq3jGWRu2jm1mneMdybqzNHaY9Y/1mLVjm9l21pUdZG3ZJraNdYl3GmvP
trAdrFu8m9kYNja+u1g+9j8cs49m
             "]]},
           Annotation[#, "Charting`Private`Tag$33280#2"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[
            0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
           "Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}, {}}, {
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0rsvn1EYB/BD0dadqDQibjGqtINLhaXpVovaWMSGhHRjIN3YiaZJDYQO
XaQJi1upS0I39/u1kqYD/4LPieH7fs45v+c5Oe95f6XtPR+7E0IIX+W3QRx/
87hl2bMQslnBYtayku/ZwGY2sp2tnHsewpXedNmUTmvXfCm7MqCuz9oghzjK
L5zkd/7kLH9xjZ/s90bfieyY/+BrmU+yn/kC97jIfS7xIPbzkMs8Yk5KCH/1
VcmZHFu7ZY2cy4q6k/j+POUqz7jGc67zghu85FZyCG/1XciV+Qq75Mi5t83/
cDWeizOc5hQnOMoRDnLe+93oK5Zh6Y13wReyLf3qOqz1sIVt/MAm1vMdX7Ga
Ray03308r94sjvOO5c6dGb8nM1jCdBYxjYVMZQFtEbLd16Xe/8afafswxn/x
buL3VPfUOJ9KQx5dSchlUuz3eMJMJsb78GNdwuP/6wHAE0/a
         "]]}, 
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0s1LVGEUB+BTQn6Mo2XWpgiCRFIkxC9EJHM2tYqZdYS2jEjdubLd7HIv
1KYWQrpwrX9AWYtwym+nmnQ0FcJQt9JzcfHjue+559z73nfm9rOR3MsLETEl
nyoiKi9GvOMhl6ojrnOTTdxjJ4+ZYdRE5FjPYT5M6THbIF9lVO0Pb8mGtOp7
pdbJSWb4llnO8ikX+IKfWet5PeZKsm49x24pXPI862/c5HducZlFrvAHV/mT
dVURB+b6ZFt+qR2yX3ZkTV9JbZ2/ucHt5Lu5wy2WWeQuC5UR982VZc/6I8ck
b99r1uNc5HPO8wln+Jhv+ICv+cj37ZtrkimZUPvAG8mepEXfiNpNDjHNLM+c
/yD/sYNl3knOwf1TfjF7jdM8Yb99N7KPV9nLBvbwCrt4mR2sT97jvHbNHrnO
s47v+ZeLbNeXdn2PtWxjiq2s4V1Ws5lVye/kvAYqzv9f/wHbMVQ1
         "]]}, 
       {GrayLevel[0.2], 
        Line3DBox[{2082, 2347, 1223, 2081, 3067, 2266, 2083, 3068, 2267, 2084,
          3069, 2268, 2085, 3070, 2269, 2086, 2970, 3071, 2270, 2423, 3231, 
         2348, 2450, 2475, 2271, 2492, 2476, 2477, 2451, 2906, 3203, 2424, 
         2349, 3072, 2272, 2087, 3073, 2273, 2088, 3074, 2274, 2089, 3075, 
         2275, 2090, 2971, 3076, 2276, 2425, 1390, 2426, 2277, 2350}], 
        Line3DBox[{2092, 2907, 3135, 2091, 1234, 2093, 3077, 2278, 2094, 3078,
          2279, 2095, 3079, 2280, 2096, 3205, 2352, 2281, 2427, 3232, 2353, 
         2452, 2478, 2479, 2428, 2480, 2354, 2453, 2908, 3206, 2429, 2355, 
         2511, 2909, 3207, 2097, 3080, 2282, 2098, 3081, 2283, 2099, 3082, 
         2284, 2100, 3083, 2285, 2101, 3204, 2351, 2286, 2102}], 
        Line3DBox[{2104, 2910, 3136, 2103, 2911, 3137, 2105, 1246, 2106, 3084,
          2287, 2107, 3085, 2288, 2108, 3208, 2356, 2289, 2430, 3233, 2357, 
         2493, 2497, 2498, 2431, 2499, 2502, 2358, 2495, 2510, 3209, 2995, 
         2509, 2508, 2912, 3246, 2109, 2913, 3138, 2110, 3086, 2290, 2111, 
         3087, 2291, 2112, 3088, 2292, 2113, 3089, 2293, 2114}], 
        Line3DBox[{2116, 2914, 3139, 2115, 2915, 3140, 2117, 2916, 3141, 2118,
          1259, 2119, 3090, 2294, 2120, 3210, 2359, 2360, 2121, 3211, 2361, 
         2494, 2362, 2503, 2122, 2363, 2496, 2364, 3212, 2123, 2917, 3142, 
         2124, 2918, 3143, 2125, 2919, 3144, 2126, 3091, 2295, 2127, 3092, 
         2296, 2128, 3093, 2297, 2129}], 
        Line3DBox[{2131, 2920, 3145, 2130, 2921, 3146, 2132, 2922, 3147, 2133,
          2923, 3148, 2134, 1379, 2345, 2135, 3213, 2365, 2366, 2136, 3214, 
         2367, 2368, 2137, 2924, 3149, 2138, 2925, 3150, 2139, 2926, 3151, 
         2140, 2927, 3152, 2141, 2928, 3153, 2142, 3094, 2298, 2143, 3095, 
         2299, 2144}], 
        Line3DBox[{2146, 2369, 2370, 3215, 2145, 2371, 3154, 2973, 2147, 2373,
          3155, 2975, 2148, 2977, 3156, 2375, 2149, 2979, 3157, 2377, 2150, 
         1282, 2151, 3096, 2300, 2152, 2929, 3158, 2153, 2930, 3159, 2154, 
         2931, 3160, 2155, 2932, 3161, 2156, 2933, 3162, 2157, 2981, 3163, 
         2379, 2158, 3216, 2381, 2382, 2159}], 
        Line3DBox[{106, 435, 335, 456, 1125, 107, 492, 336, 1542, 458, 108, 
         493, 337, 1550, 463, 109, 1497, 338, 110, 1126, 111, 1127, 112, 1128,
          113, 1129, 114, 1130, 115, 1131, 116, 339, 1132, 117, 1498, 340, 
         464, 118, 498, 1499, 341, 465, 119, 1560, 499, 342, 467, 120}], 
        Line3DBox[{2173, 2462, 2463, 2438, 3237, 2983, 2172, 2380, 2437, 3236,
          2982, 2171, 2387, 3172, 2986, 2170, 2985, 3171, 2385, 2169, 3170, 
         2937, 2168, 3169, 2936, 2167, 3168, 2935, 2166, 1291, 2165, 3167, 
         2934, 2164, 2378, 2436, 3235, 2980, 2163, 2376, 2435, 3234, 2978, 
         2162, 2976, 3166, 2434, 2374, 2161, 2974, 3165, 2433, 2372, 2160, 
         2972, 3164, 2432, 2473, 2472, 2490}], 
        Line3DBox[{2174, 2464, 2465, 2439, 3238, 2301, 2454, 2383, 2440, 3239,
          2302, 2455, 2384, 3097, 2303, 2481, 2984, 3098, 2304, 2175, 3099, 
         2305, 2176, 3100, 2306, 2177, 3101, 2307, 2178, 1302, 2179, 3102, 
         2308, 2180, 2390, 2441, 3240, 2309, 2181, 2386, 2442, 3241, 2310, 
         2500, 2504, 2505, 3103, 2443, 2311, 2456, 2987, 3104, 2444, 2312, 
         2457, 2988, 3105, 2445, 2474, 2313, 2491}], 
        Line3DBox[{2183, 2388, 2938, 3217, 2182, 2389, 3106, 2314, 2184, 3107,
          2315, 2185, 3108, 2316, 2186, 3109, 2317, 2187, 3110, 2318, 2188, 
         3111, 2319, 2189, 2939, 3173, 2190, 1314, 2191, 2391, 3112, 2320, 
         2192, 2392, 3113, 2321, 2193, 2989, 3114, 2322, 2194, 2990, 3115, 
         2323, 2195, 3218, 2393, 2324, 2196}], 
        Line3DBox[{2198, 2940, 3174, 2197, 2941, 3175, 2199, 3116, 2325, 2200,
          3117, 2326, 2201, 3118, 2327, 2202, 3119, 2328, 2203, 3120, 2329, 
         2204, 2394, 2942, 3219, 2446, 2395, 2943, 3220, 2205, 2346, 1326, 
         2206, 3121, 2330, 2207, 3122, 2331, 2208, 3123, 2332, 2209, 3124, 
         2333, 2210}], 
        Line3DBox[{2212, 2944, 3176, 2211, 2945, 3177, 2213, 2946, 3178, 2214,
          3125, 2334, 2215, 3126, 2335, 2216, 3127, 2336, 2217, 3221, 2396, 
         2482, 2337, 2447, 2397, 2484, 2947, 3222, 2448, 2398, 2948, 3223, 
         2218, 2949, 3179, 2219, 1340, 2220, 3128, 2338, 2221, 3129, 2339, 
         2222, 3130, 2340, 2223}], 
        Line3DBox[{2225, 2950, 3180, 2224, 2951, 3181, 2226, 2952, 3182, 2227,
          2953, 3183, 2228, 3131, 2341, 2229, 3245, 2506, 2507, 2230, 2994, 
         3224, 2399, 2483, 2400, 2501, 2487, 2488, 2486, 2401, 2485, 2402, 
         3242, 2231, 2403, 2404, 3225, 2232, 2954, 3184, 2233, 2955, 3185, 
         2234, 1353, 2235, 3132, 2342, 2236, 3133, 2343, 2237}], 
        Line3DBox[{2239, 2405, 2406, 3226, 2238, 2956, 3186, 2240, 2957, 3187,
          2241, 2958, 3188, 2242, 2959, 3189, 2243, 3227, 2408, 2409, 2244, 
         3228, 2410, 2458, 2411, 2466, 2489, 2467, 2412, 2459, 2413, 3243, 
         2245, 2414, 2415, 3229, 2246, 2960, 3190, 2247, 2961, 3191, 2248, 
         2962, 3192, 2249, 1366, 2250, 3134, 2344, 2251}], 
        Line3DBox[{2265, 2422, 1480, 2264, 3202, 2969, 2263, 3201, 2968, 2262,
          3200, 2967, 2261, 3199, 2966, 2260, 2993, 3198, 2421, 2259, 3244, 
         2420, 2461, 2471, 2470, 2258, 2468, 2469, 2460, 2419, 3230, 2257, 
         2418, 3197, 2992, 2256, 3196, 2965, 2255, 3195, 2964, 2254, 3194, 
         2963, 2253, 2991, 3193, 2416, 2252, 1467, 2449, 2407, 2417}], 
        Line3DBox[{2513, 2770, 1758, 2512, 3309, 2695, 2514, 3310, 2696, 2515,
          3311, 2697, 2516, 3312, 2698, 2517, 3053, 3371, 2699, 2832, 1917, 
         2856, 2879, 2700, 2890, 2880, 2881, 2857, 1763, 2833, 2771, 3372, 
         2701, 2518, 3313, 2702, 2519, 3314, 2703, 2520, 3315, 2704, 2521, 
         3054, 3373, 2705, 2834, 1922, 2835, 2706, 2772}], 
        Line3DBox[{2523, 2996, 3247, 2522, 1769, 2524, 3316, 2707, 2525, 3317,
          2708, 2526, 3318, 2709, 2527, 1926, 2710, 2836, 3319, 2774, 2858, 
         951, 1005, 952, 2859, 2997, 3391, 2837, 2775, 2905, 1774, 2528, 3320,
          2711, 2529, 3321, 2712, 2530, 3322, 2713, 2531, 3323, 2714, 2532, 
         3324, 2773, 2715, 2533}], 
        Line3DBox[{2535, 2998, 3248, 2534, 2999, 3249, 2536, 1781, 2537, 3325,
          2716, 2538, 3326, 2717, 2539, 3327, 2776, 2718, 2838, 3328, 2777, 
         2891, 2893, 2894, 2839, 2895, 2898, 2778, 2892, 2904, 2078, 2903, 
         2902, 3000, 3250, 2540, 1786, 2541, 3329, 2719, 2542, 3330, 2720, 
         2543, 3331, 2721, 2544, 3332, 2722, 2545}], 
        Line3DBox[{2547, 3001, 3251, 2546, 3002, 3252, 2548, 3003, 3253, 2549,
          1794, 2550, 3333, 2723, 2551, 3334, 766, 843, 2011, 767, 844, 768, 
         3254, 2552, 3004, 3255, 2553, 3005, 3256, 2554, 1799, 2555, 3335, 
         2724, 2556, 3336, 2725, 2557, 3337, 2726, 2558}], 
        Line3DBox[{2560, 3006, 3257, 2559, 3007, 3258, 2561, 3008, 3259, 2562,
          3009, 3260, 2563, 1911, 2768, 2564, 3338, 2779, 2780, 2565, 3392, 
         2781, 2782, 2566, 3010, 3261, 2567, 3011, 3262, 2568, 3012, 3263, 
         2569, 3013, 3264, 2570, 1811, 2571, 3339, 2727, 2572, 3340, 2728, 
         2573}], Line3DBox[{2575, 2783, 2784, 3265, 2574, 2785, 1946, 2576, 
         2787, 3374, 3056, 2577, 2789, 3375, 2790, 2578, 3058, 3376, 2793, 
         2579, 1817, 2580, 3341, 2729, 2581, 3014, 3266, 2582, 3015, 3267, 
         2583, 3016, 3268, 2584, 3017, 3269, 2585, 3018, 3270, 2586, 1954, 
         2795, 2587, 3342, 2797, 2798, 2588}], 
        Line3DBox[{624, 953, 853, 974, 1662, 625, 1010, 854, 976, 626, 1011, 
         855, 2059, 981, 627, 856, 628, 1663, 629, 1664, 630, 1665, 631, 1666,
          632, 1667, 633, 1668, 634, 857, 635, 2016, 858, 982, 636, 1016, 859,
          983, 637, 2067, 1017, 860, 985, 638}], 
        Line3DBox[{2602, 2868, 2869, 2846, 1959, 2601, 2796, 2845, 3378, 3060,
          2600, 2805, 3383, 3061, 2599, 2803, 3382, 2802, 2598, 3274, 3022, 
         2597, 3273, 3021, 2596, 3272, 3020, 2595, 1826, 2594, 3271, 3019, 
         2593, 2794, 2844, 3377, 3059, 2592, 2792, 2843, 2791, 2591, 3057, 
         3394, 2842, 2788, 2590, 3055, 3393, 2841, 2786, 2589, 1945, 2840, 
         2877, 2876, 2888}], 
        Line3DBox[{2603, 2870, 2871, 2847, 1830, 2860, 2799, 2848, 3379, 2730,
          2861, 2800, 3380, 2731, 2882, 2801, 3381, 2732, 2604, 3343, 2733, 
         2605, 3344, 2734, 2606, 3345, 2735, 2607, 1836, 2608, 3346, 2736, 
         2609, 2808, 2849, 3384, 2737, 2610, 2804, 2850, 2738, 2896, 2899, 
         2069, 2851, 2739, 2862, 3062, 3395, 2852, 2740, 2863, 1966, 2853, 
         2878, 2741, 2889}], 
        Line3DBox[{2612, 2806, 3023, 3275, 2611, 2807, 1840, 2613, 3347, 2742,
          2614, 3348, 2743, 2615, 3349, 2744, 2616, 3350, 2745, 2617, 3351, 
         2746, 2618, 3024, 3276, 2619, 1847, 2620, 2809, 3385, 2747, 2621, 
         2810, 3386, 2748, 2622, 3063, 3387, 2749, 2623, 1974, 2750, 2624, 
         3352, 2811, 2751, 2625}], 
        Line3DBox[{2627, 3025, 3277, 2626, 3026, 3278, 2628, 1851, 2629, 3353,
          2752, 2630, 3354, 2753, 2631, 3355, 2754, 2632, 3356, 2755, 2633, 
         2812, 3027, 3396, 2854, 2813, 3028, 3279, 2634, 2769, 1858, 2635, 
         3357, 2756, 2636, 3358, 2757, 2637, 3359, 2758, 2638, 3360, 2759, 
         2639}], Line3DBox[{2641, 3029, 3280, 2640, 3030, 3281, 2642, 3031, 
         3282, 2643, 1866, 2644, 3361, 2760, 2645, 3362, 2761, 2646, 3363, 
         809, 869, 810, 2021, 870, 811, 3283, 2647, 3032, 3284, 2648, 1872, 
         2649, 3364, 2762, 2650, 3365, 2763, 2651, 3366, 2764, 2652}], 
        Line3DBox[{2654, 3033, 3285, 2653, 3034, 3286, 2655, 3035, 3287, 2656,
          3036, 3288, 2657, 1880, 2658, 3367, 2900, 2901, 2659, 2075, 2814, 
         2883, 2815, 2897, 2886, 2887, 2885, 2816, 2884, 2817, 3289, 2660, 
         2818, 2819, 3290, 2661, 3037, 3291, 2662, 3038, 3292, 2663, 1885, 
         2664, 3368, 2765, 2665, 3369, 2766, 2666}], 
        Line3DBox[{2668, 2820, 2821, 3293, 2667, 3039, 3294, 2669, 3040, 3295,
          2670, 3041, 3296, 2671, 3042, 3297, 2672, 1988, 2823, 2673, 3397, 
         2824, 2864, 922, 992, 923, 2865, 2825, 3298, 2674, 2826, 1993, 2675, 
         3043, 3299, 2676, 3044, 3300, 2677, 3045, 3301, 2678, 1898, 2679, 
         3370, 2767, 2680}], 
        Line3DBox[{2694, 2831, 2000, 2693, 3308, 3052, 2692, 3307, 3051, 2691,
          3306, 3050, 2690, 3305, 3049, 2689, 3066, 3390, 2830, 2688, 1998, 
         2867, 2875, 2874, 2687, 2872, 2873, 2866, 1997, 2686, 2829, 3389, 
         3065, 2685, 3304, 3048, 2684, 3303, 3047, 2683, 3302, 3046, 2682, 
         3064, 3388, 2827, 2681, 1987, 2855, 2822, 2828}]}, 
       {GrayLevel[0.2], 
        Line3DBox[{1038, 1224, 3067, 1039, 1234, 1062, 3137, 1245, 1075, 3140,
          1257, 1088, 3146, 1269, 1102, 3154, 1414, 1280, 1116, 3165, 1415, 
         1514, 1528, 1529, 1542, 1530, 1433, 1518, 1297, 3239, 1134, 1447, 
         1307, 3106, 1145, 3175, 1318, 1159, 3177, 1332, 1173, 3181, 1345, 
         1186, 3186, 1357, 1199, 3193, 1474, 1369, 1212}], 
        Line3DBox[{1040, 1225, 3068, 1041, 1235, 3077, 1063, 1246, 1076, 3141,
          1258, 1089, 3147, 1270, 1103, 3155, 1416, 1281, 1117, 3166, 1417, 
         1543, 1545, 1546, 1550, 1549, 1434, 1547, 1298, 3097, 1135, 1308, 
         3107, 1146, 1319, 3116, 1160, 3178, 1333, 1174, 3182, 1346, 1187, 
         3187, 1358, 1200, 3194, 1370, 1213}], 
        Line3DBox[{1042, 1226, 3069, 1043, 1236, 3078, 1064, 1247, 3084, 1077,
          1259, 1090, 3148, 1271, 1104, 3156, 1418, 1419, 1493, 3234, 1420, 
         1544, 1421, 1497, 1435, 1548, 1436, 3098, 1136, 1309, 3108, 1147, 
         1320, 3117, 1161, 1334, 3125, 1175, 3183, 1347, 1188, 3188, 1359, 
         1201, 3195, 1371, 1214}], 
        Line3DBox[{1044, 1227, 3070, 1045, 1237, 3079, 1065, 1248, 3085, 1078,
          1260, 3090, 1091, 1379, 1380, 1105, 3157, 1422, 1423, 1494, 3235, 
         1424, 1425, 1126, 1299, 3099, 1137, 1310, 3109, 1148, 1321, 3118, 
         1162, 1335, 3126, 1176, 1348, 3131, 1189, 3189, 1360, 1202, 3196, 
         1372, 1215}], 
        Line3DBox[{1046, 1383, 1384, 3071, 1047, 1393, 3205, 1394, 1066, 1399,
          3208, 1400, 1079, 1403, 3210, 1404, 1092, 1408, 3213, 1409, 1106, 
         1282, 1118, 3167, 1290, 1127, 1300, 3100, 1138, 1311, 3110, 1149, 
         1322, 3119, 1163, 1336, 3127, 1177, 1564, 3245, 1565, 1190, 1468, 
         3227, 1469, 1203, 3197, 1475, 1476, 1216}], 
        Line3DBox[{1048, 1523, 1524, 1484, 3231, 1385, 1511, 1395, 1488, 3232,
          1396, 1512, 1401, 1490, 3233, 1402, 1554, 1405, 3211, 1491, 1406, 
         1093, 1410, 3214, 1492, 1411, 1107, 1283, 3096, 1119, 1291, 1128, 
         1301, 3101, 1139, 1312, 3111, 1150, 1323, 3120, 1164, 1459, 3221, 
         1460, 1551, 1567, 1568, 3224, 1566, 1463, 1521, 1470, 3228, 1506, 
         1471, 1522, 1477, 3230, 1509, 1535, 1534, 1553}], 
        Line3DBox[{8, 452, 316, 486, 2492, 23, 454, 321, 2428, 487, 38, 455, 
         324, 2431, 503, 53, 2122, 326, 68, 2137, 83, 2152, 98, 2166, 113, 
         2178, 128, 2189, 143, 2204, 158, 351, 2447, 173, 473, 2488, 353, 500,
          188, 474, 2489, 357, 501, 203, 2258, 476, 361, 448, 218}], 
        Line3DBox[{1050, 1386, 1229, 3072, 1051, 1398, 3207, 1239, 1068, 1569,
          3246, 1250, 1081, 3142, 1262, 1095, 3150, 1273, 1109, 3159, 1285, 
         1121, 3169, 1293, 1130, 1303, 3102, 1141, 1314, 1152, 1458, 3220, 
         1325, 1166, 1462, 3223, 1338, 1179, 1465, 3225, 1350, 1192, 1473, 
         3229, 1362, 1205, 3198, 1479, 1374, 1218}], 
        Line3DBox[{1052, 1230, 3073, 1053, 1240, 3080, 1069, 3138, 1251, 1082,
          3143, 1263, 1096, 3151, 1274, 1110, 3160, 1286, 1122, 3170, 1294, 
         1131, 1448, 1304, 3240, 1142, 1449, 1315, 3112, 1153, 1381, 1326, 
         1167, 3179, 1339, 1180, 3184, 1351, 1193, 3190, 1363, 1206, 3199, 
         1375, 1219}], 
        Line3DBox[{1054, 1231, 3074, 1055, 1241, 3081, 1070, 1252, 3086, 1083,
          3144, 1264, 1097, 3152, 1275, 1111, 3161, 1287, 1123, 3171, 1437, 
         1555, 1295, 1132, 1438, 1558, 1305, 3241, 1143, 1450, 1316, 3113, 
         1154, 1327, 3121, 1168, 1340, 1181, 3185, 1352, 1194, 3191, 1364, 
         1207, 3200, 1376, 1220}], 
        Line3DBox[{1056, 1232, 3075, 1057, 1242, 3082, 1071, 1253, 3087, 1084,
          1265, 3091, 1098, 3153, 1276, 1112, 3162, 1288, 1124, 3172, 1439, 
         1556, 1440, 1557, 1498, 1559, 1561, 1441, 1563, 1442, 3103, 1562, 
         1500, 1451, 1452, 3114, 1155, 1328, 3122, 1169, 1341, 3128, 1182, 
         1353, 1195, 3192, 1365, 1208, 3201, 1377, 1221}], 
        Line3DBox[{1058, 1387, 1388, 3076, 1059, 1243, 3083, 1072, 1254, 3088,
          1085, 1266, 3092, 1099, 1277, 3094, 1113, 3163, 1426, 1427, 1495, 
         3236, 1428, 1515, 1429, 1536, 1499, 1537, 1443, 1519, 1444, 3104, 
         1501, 1453, 1454, 3115, 1156, 1329, 3123, 1170, 1342, 3129, 1183, 
         1354, 3132, 1196, 1366, 1209, 3202, 1378, 1222}], 
        Line3DBox[{1060, 1389, 1486, 1390, 1487, 1391, 3204, 1392, 1073, 1255,
          3089, 1086, 1267, 3093, 1100, 1278, 3095, 1114, 1430, 3216, 1431, 
         1496, 3237, 1432, 1516, 1539, 1538, 1560, 1540, 1541, 1520, 1445, 
         3105, 1502, 1455, 3218, 1456, 1157, 1330, 3124, 1171, 1343, 3130, 
         1184, 1355, 3133, 1197, 1367, 3134, 1210, 1480, 1481, 1482}], 
        Line3DBox[{1211, 1368, 1508, 1467, 1198, 1356, 3226, 1466, 1185, 1344,
          3180, 1172, 1331, 3176, 1158, 1317, 3174, 1144, 1306, 3217, 1446, 
         1133, 3238, 1296, 1517, 1527, 1526, 1125, 1289, 1525, 1513, 1413, 
         3164, 1115, 1279, 3215, 1412, 1101, 1268, 3145, 1087, 1256, 3139, 
         1074, 1244, 3136, 1061, 1233, 3135, 1037, 1223, 1382, 1483}], 
        Line3DBox[{1217, 1373, 1531, 1510, 3244, 1478, 1204, 1361, 1507, 3243,
          1472, 1191, 1349, 1505, 3242, 1464, 1178, 1337, 3222, 1504, 1461, 
         1165, 1324, 3219, 1503, 1457, 1151, 1313, 3173, 1140, 1302, 1129, 
         1292, 3168, 1120, 1284, 3158, 1108, 1272, 3149, 1094, 1261, 3212, 
         1407, 1080, 1249, 1571, 3209, 1570, 1573, 1572, 1067, 1238, 3206, 
         1489, 1397, 1049, 1228, 3203, 1485, 1533, 1532, 1552}], 
        Line3DBox[{1575, 1759, 3309, 1576, 1769, 1599, 3249, 1780, 1612, 3252,
          1792, 1625, 3258, 1804, 1639, 1946, 1815, 1653, 3393, 1947, 2031, 
         911, 976, 912, 2035, 1831, 3379, 1670, 1968, 1840, 1680, 3278, 1850, 
         1694, 3281, 1864, 1708, 3286, 1877, 1721, 3294, 1889, 1734, 3388, 
         1994, 1901, 1747}], 
        Line3DBox[{1577, 1760, 3310, 1578, 1770, 3316, 1600, 1781, 1613, 3253,
          1793, 1626, 3259, 1805, 1640, 3374, 1948, 1816, 1654, 3394, 1949, 
         2054, 2055, 2056, 2059, 2058, 1960, 2057, 1832, 3380, 1671, 1841, 
         3347, 1681, 1851, 1695, 3282, 1865, 1709, 3287, 1878, 1722, 3295, 
         1890, 1735, 3302, 1902, 1748}], 
        Line3DBox[{1579, 1761, 3311, 1580, 1771, 3317, 1601, 1782, 3325, 1614,
          1794, 1627, 3260, 1806, 1641, 3375, 777, 849, 2843, 778, 856, 789, 
         3381, 1672, 1842, 3348, 1682, 1852, 3353, 1696, 1866, 1710, 3288, 
         1879, 1723, 3296, 1891, 1736, 3303, 1903, 1749}], 
        Line3DBox[{1581, 1762, 3312, 1582, 1772, 3318, 1602, 1783, 3326, 1615,
          1795, 3333, 1628, 1911, 1912, 1642, 3376, 1950, 1951, 2013, 3377, 
         1952, 1953, 1663, 1833, 3343, 1673, 1843, 3349, 1683, 1853, 3354, 
         1697, 1867, 3361, 1711, 1880, 1724, 3297, 1892, 1737, 3304, 1904, 
         1750}], Line3DBox[{1583, 1915, 1916, 3371, 1584, 1925, 1926, 1603, 
         1931, 3327, 1932, 1616, 1935, 3334, 1936, 1629, 1940, 3338, 1941, 
         1643, 1817, 1655, 3271, 1825, 1664, 1834, 3344, 1674, 1844, 3350, 
         1684, 1854, 3355, 1698, 1868, 3362, 1712, 2071, 3367, 2072, 1725, 
         1988, 1989, 1738, 3389, 1995, 1996, 1751}], 
        Line3DBox[{1585, 2040, 2041, 2004, 1917, 2028, 1927, 2008, 3319, 1928,
          2029, 1933, 2010, 3328, 1934, 2063, 1937, 2011, 1938, 1630, 1942, 
         3392, 2012, 1943, 1644, 1818, 3341, 1656, 1826, 1665, 1835, 3345, 
         1675, 1845, 3351, 1685, 1855, 3356, 1699, 1979, 3363, 1980, 2060, 
         2074, 2075, 2073, 1983, 2038, 1990, 3397, 2023, 1991, 2039, 1997, 
         2026, 2049, 2048, 2062}], 
        Line3DBox[{526, 970, 834, 1004, 2890, 541, 972, 839, 1005, 556, 973, 
         842, 2839, 1021, 571, 844, 586, 2566, 601, 2581, 616, 2595, 631, 
         2607, 646, 2618, 661, 2633, 676, 869, 691, 991, 2887, 871, 1018, 706,
          992, 875, 1019, 721, 2687, 994, 879, 966, 736}], 
        Line3DBox[{1587, 1918, 1764, 3372, 1588, 1930, 1774, 1605, 2076, 3250,
          1785, 1618, 3255, 1797, 1632, 3262, 1808, 1646, 3267, 1820, 1658, 
         3273, 1828, 1667, 1837, 3346, 1677, 1847, 1687, 1978, 3279, 1857, 
         1701, 1982, 3283, 1870, 1714, 1985, 3290, 1882, 1727, 1993, 1894, 
         1740, 3390, 1999, 1906, 1753}], 
        Line3DBox[{1589, 1765, 3313, 1590, 1775, 3320, 1606, 1786, 1619, 3256,
          1798, 1633, 3263, 1809, 1647, 3268, 1821, 1659, 3274, 1829, 1668, 
         1969, 1838, 3384, 1678, 1970, 1848, 3385, 1688, 1913, 1858, 1702, 
         3284, 1871, 1715, 3291, 1883, 1728, 3299, 1895, 1741, 3305, 1907, 
         1754}], Line3DBox[{1591, 1766, 3314, 1592, 1776, 3321, 1607, 1787, 
         3329, 1620, 1799, 1634, 3264, 1810, 1648, 3269, 1822, 1660, 3382, 
         790, 857, 791, 2850, 864, 802, 3386, 1689, 1859, 3357, 1703, 1872, 
         1716, 3292, 1884, 1729, 3300, 1896, 1742, 3306, 1908, 1755}], 
        Line3DBox[{1593, 1767, 3315, 1594, 1777, 3322, 1608, 1788, 3330, 1621,
          1800, 3335, 1635, 1811, 1649, 3270, 1823, 1661, 3383, 1961, 2064, 
         1962, 2065, 2016, 2066, 2068, 1963, 2070, 1964, 2069, 2017, 1971, 
         1972, 3387, 1690, 1860, 3358, 1704, 1873, 3364, 1717, 1885, 1730, 
         3301, 1897, 1743, 3307, 1909, 1756}], 
        Line3DBox[{1595, 1919, 1920, 3373, 1596, 1778, 3323, 1609, 1789, 3331,
          1622, 1801, 3336, 1636, 1812, 3339, 1650, 1954, 1955, 2014, 3378, 
         1956, 2032, 958, 1016, 959, 2036, 1965, 3395, 2018, 1973, 1974, 1691,
          1861, 3359, 1705, 1874, 3365, 1718, 1886, 3368, 1731, 1898, 1744, 
         3308, 1910, 1757}], 
        Line3DBox[{1597, 1921, 2006, 1922, 2007, 1923, 3324, 1924, 1610, 1790,
          3332, 1623, 1802, 3337, 1637, 1813, 3340, 1651, 1957, 3342, 1958, 
         2015, 1959, 2033, 2051, 2050, 2067, 2052, 2053, 2037, 1966, 2019, 
         1975, 3352, 1976, 1692, 1862, 3360, 1706, 1875, 3366, 1719, 1887, 
         3369, 1732, 1899, 3370, 1745, 2000, 2001, 2002}], 
        Line3DBox[{1746, 1900, 2025, 1987, 1733, 1888, 3293, 1986, 1720, 1876,
          3285, 1707, 1863, 3280, 1693, 1849, 3277, 1679, 1839, 3275, 1967, 
         1669, 1830, 2034, 2044, 2043, 1662, 1824, 2042, 2030, 1945, 1652, 
         1814, 3265, 1944, 1638, 1803, 3257, 1624, 1791, 3251, 1611, 1779, 
         3248, 1598, 1768, 3247, 1574, 1758, 1914, 2003}], 
        Line3DBox[{1752, 1905, 2045, 2027, 1998, 1739, 1893, 2024, 3298, 1992,
          1726, 1881, 2022, 3289, 1984, 1713, 1869, 2021, 1981, 1700, 1856, 
         3396, 2020, 1977, 1686, 1846, 3276, 1676, 1836, 1666, 1827, 3272, 
         1657, 1819, 3266, 1645, 1807, 3261, 1631, 1796, 3254, 1939, 1617, 
         1784, 2078, 2077, 2080, 2079, 1604, 1773, 3391, 2009, 1929, 1586, 
         1763, 2005, 2047, 2046, 2061}]}, {}, {}, {}, {}, {}}},
     VertexNormals->CompressedData["
1:eJzsvXlYjuv3N5wxY6bMQ5QkEilT0pIhUwhlLGxjkRSRSCghIhqFUIYoQxoQ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      "]],
    Axes->True,
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(x\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{Automatic, Automatic, Automatic},
    BoxRatios->{1, 1, 0.4},
    DisplayFunction->Identity,
    FaceGrids->None,
    FaceGridsStyle->Automatic,
    Method->{"DefaultBoundaryStyle" -> Directive[
        GrayLevel[0.3]], "RotationControl" -> "Globe"},
    PlotLabel->FormBox["\"m=-1\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-Pi, Pi}, {-2.9999999999998654`, 
       3.}}, {{-3.141592653589793, 3.141592653589793}, {-3.141592653589793, 
      3.141592653589793}, {-2.9999999999998654`, 3.}}],
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    Ticks->{Automatic, Automatic, Automatic}], ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFnXm83sP1x5NIYle7UrXE0lDE3lrqTEtKI9ZfKVrUUoqqpYral1JCNVU7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     "], {{
       {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJxFmwnYF9P7xmd6Z97OvE07KWTft+z7vu9++MkWKmshOyH7kiVt2mmVpUJC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             "]], Polygon3DBox[CompressedData["
1:eJwtm3XAFVUTxvfC7mXPey8pICgqmKhYYOtnFxZ2odKlhICi2IVYiLStiIFd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             "]], 
            Polygon3DBox[CompressedData["
1:eJwt1wm0VWUZxvEN91y4By5wmUdRZlAmETFIoDCyBAQBgyjBECusGAoxU5GA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             "]]},
           Annotation[#, "Charting`Private`Tag$33316#1"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
           "Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 0, 2}]}}]}, 
       {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJw1m3XcFsXbxR93cfd291kVUURAOgWDlu5WQToFAREBAwNEsUEElbZFQCRU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             "]], Polygon3DBox[CompressedData["
1:eJwtmnWgFdX3xR9zYeY65z4UREAUpKWlO6VEQrpLkJQUUUKkpQQEO1CxA1AM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             "]], Polygon3DBox[CompressedData["
1:eJwt1nWQVWUYB+ADwl7cBVtQR5QSWERA2lh6kRLcFQlhQUIaFsEATDAIcZAQ
sVDQMUddULEoFR0VR8JkdOzAThRUwOedc/74zdz3ue93Yu8XW3dkeemUykmS
3CRVZX1BkrSrliTX5iVJf19sUHeRipzP7EHWVV2WnySDfD6R3ybnVU+StnK2
zw/om+O7F/QtkCqu9yZbx25Wbzf2J3VHOVApSeqr35Nf1a31VtHXUJ2nt5vr
reZXx1hW2z32qQdKHTZAz2f8H/VVeo9hp6s76DtfvYk/xO5hb8j7Pk/j1dxn
aPTIOvWz8rLv1uk5hdVQl8czsu4xTn5T95CqrJF6h/ys7iwHvUcD9Ufyt7qT
1NDXTP2x7FV3kcNYc/VXckBdIsexNuovZb+6n9RireOecoxnmcSKWIm6keer
xa5kfdn5rCGryWaxc1kp+0L+i1pqslbqz+VfdW85lrVU1zX2EGNHsxasjr/p
B/x3dS/JY43Vu+TPuKdUY03id5R8Y0ewZqxbvIOcxW5n5Wy2urJrdmB3syvY
jfG3kwI2kjVnxeof43dnZawR66j+Qaqyoawh66Bu4JmrsymsQza2kJ3EbmCD
2TD2ofyh7iM5Vqj+RQ7XN4a1YT3VjY2tza7PS+d1zO9f5Qg2lrVlvdR99F3K
drMP2Jvxe0trdisbx2bF313OZMtZLLDr1OcYO559zN6ItcV6sMnsM/Y2e4n1
ZFPY52wbe5l1ZoPZa6yC3c86sUHsVfYke4Cdyy5j37EP2db4LVgfto7dwZax
3mwq+5LtYFtYL1bOvmDb2SusiPVjL7JVbEW8F+vNnmEr2FJ2NuvLXmD3sTtY
dzaOfcReZ+tZMRvN3mMvsWfYaebGUnYJ6xZrRr2Xt2GL2Xh2ZaxxaceWsons
avU+acuWsAnsqpjfckbsS2wyu1b9l7Rii9hYNlN9gvtMZDvYBraZ9fV8l7Pv
2S72VqwDOZZNzuZarK1u+kaxd9lm9nTck53D1rAlrH3snWwE28k2sqdiDUkd
NjNbqyPUXfWNZO+wTWwtO8T4juweNoPdxE7Wl7DhrJC1ZSexg+ph0pi1YxPz
0/dsFPNIBlVP//7xO4xVPy/9WYksj7UqF/nuYj0TZEzswTEvZaCeSp6lyOc7
5XLf3aBnj7SMOZRL+2fkp3tb7HEz4v2kn7GnsIRtUm+WAWxMnDNsXMzTWGMF
6f4Z++j6OGvkgurp+op1Nl19qD27jHWU/nEtYx/23Uo99Y1v7/N4ttB3DdTj
pXuMZZ+wCerd+eleE3vONjaEzWFT2Tfqb+VC1/82P93PYl+bzU4uSPex2M92
x/qKsfoWsmvYXbG3SWmsU/nK569z6XUv1bMt9rbYw2W/d6ynXliQnolbY4/1
breoj5J72fNsr/Gz4wwsSN8z3nctK1bPLUjPtTjfEmPnqY+Uley5OKf1Fanz
5Vb2JPuZXab+ND87O9mWeGY2LM5u1ymSnb57VU9NPjCXPks80+o4i1gpezpb
+3Gutje2O6tgi9kidry+i9gW9gRbw45jw9kr7HFWEevZ2C7sMTafzWMnsj3q
UjmeNY09gjXQt4ANZ6PZqawem8fK4jeN92KV2ajsTDmT1XDfnuwRNo8tifmi
r1ounS8xbzqxJqwum8uGZuuyHsvl0nka87VzzG/X68UezZ459r8W+ppk+1Ds
V5PZ6awpW5btV+XsaGNL2FPsdnZ3nB36mmfnZZwV01gtfUPYxuz/l0djP9TX
gq3IztXprCmrz+bH+mejYq8ydkAunQcxH1axHCtm9+el8zXmbUtjT8v2yUls
aqwNVpjtu3GWTYp9kzXLzrLYTy+JtcEaZ2de7DOx31R1j87sXjYr+y2rsE5s
JZvJ5sZ5HPODTWPFbLD6fwP5Rmk=
             "]]},
           Annotation[#, "Charting`Private`Tag$33316#2"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[
            0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
           "Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[
            0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
            ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}, {}}, {
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0ksvHmEYBuDn86F1KP0Fbay6Io2Vhf4BrCQiIRWxwoJl+QNFhEgTunFq
nRIhRHyR0F3Ftg51ap333XSBqIprYnHPNXfe93kzM5mSls7ajlREfJIjN8n9
tssbqXoe8VKv42s2s4ztfMdu1rCXjczkRdSby0i7vsj3Mm29W19mL7/xM7c4
yx1meMFNXjmnx9yJ7OkHHE2SHfFTH+M+x3nACR5ykkf8wmP+zYnoM7cuv/Ql
9stX67/1KZ5wmqec4Rlnec45XvDaOQPmzuVSP+SY/PO8u/offucZV/mDM9zk
CNfZww3v1WJuTbr0BTbKlPU2fZgN/MhqfmAlW1nKJr5K9jmn3NyxFOv7HJI8
z1ukP+ML5rCQaRYwxXxW5EbcJPuTb+jd3rpfEcfHPEvlIe0c/T9tj3vaGnd0
TNwynXwblyzeWBxMPf1Dj+ZHVFY=
         "]]}, 
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0ksoZmEcB+CXz92CJUsrmmyxkjQ+aZrkmiZWMxZWFGJtJFJiLGhWJJES
aWxpNjaacb9buDPsZu36fFn8es6v9/zf857OyfnaVtMaF0IYlZ1ICI/KOnNi
SQshLT6EfGaziHksZRE/s5yNrGdregjV5halWZ9lg3Rb79B7+Z3D/MGfnOQ0
F/mLqxy1T4+5A/mrb3FMzpJC2NDPuckLbvGS27ziDq+5y/QUzzS3LHv6HPvk
xvq+fssD3vGQ/3jEex7zgSfMsE+/uWM51bc5LhvO+0f/zRUucYFTnOA4RzjE
HnZ6ryZzS9Kuz7Beuqx/01tYxy+M8hMLWcJcFjCLtfbJN7crqfomB6XKeVP0
SibHvg+TYvswkRVMYNT7/Hd/xPVacggfXM9LfOxbMFei7o3Tyxj4ka/+jVK+
sITPLOYTM+05EHn/h94AKXpQ0g==
         "]]}, 
       {GrayLevel[0.2], 
        Line3DBox[{2122, 2448, 1192, 2121, 3167, 2300, 2123, 3168, 2301, 2124,
          3169, 2302, 2125, 3083, 3170, 2449, 2303, 2126, 3084, 3171, 2451, 
         2304, 2450, 3301, 2541, 2542, 2532, 2564, 2305, 2589, 2565, 2566, 
         2549, 2571, 3013, 3331, 2570, 2569, 3172, 2306, 2127, 3173, 2307, 
         2128, 3174, 2308, 2129, 3175, 2309, 2130, 3176, 2310, 2131, 1440, 
         2311, 2453}], 
        Line3DBox[{2133, 3014, 3228, 2132, 1203, 2134, 3177, 2312, 2135, 3178,
          2313, 2136, 3068, 3179, 2454, 2314, 2555, 3095, 3335, 2382, 2556, 
         2315, 2455, 3302, 2452, 2316, 2533, 2456, 3015, 3303, 2137, 2383, 
         2551, 2572, 3289, 3094, 2550, 2384, 3180, 2317, 2138, 3181, 2318, 
         2139, 3182, 2319, 2140, 3183, 2320, 2141, 3184, 2321, 2142}], 
        Line3DBox[{2144, 3016, 3229, 2143, 3017, 3230, 2145, 2385, 1215, 2146,
          3069, 3185, 2458, 2322, 2457, 3304, 2386, 2461, 2323, 2460, 3305, 
         2387, 2324, 2534, 3327, 2463, 2325, 2147, 3018, 3231, 2148, 2388, 
         3019, 3290, 2149, 2389, 2465, 3020, 3291, 2464, 2390, 2468, 3306, 
         2326, 2467, 1356, 2470, 2327, 2150, 3186, 2328, 2151, 3187, 2329, 
         2152}], Line3DBox[{2154, 3021, 3232, 2153, 3022, 3233, 2155, 2391, 
         2392, 3307, 2156, 1358, 2459, 2393, 2157, 3292, 2394, 2462, 2395, 
         2158, 3188, 2330, 2159, 3189, 2331, 2160, 3023, 3234, 2161, 3024, 
         3235, 2162, 2396, 2466, 2397, 3309, 2163, 2398, 2469, 1363, 2164, 
         3293, 2399, 2471, 2400, 2165, 3190, 2332, 2166, 3191, 2333, 2167}], 
        Line3DBox[{2169, 2477, 2478, 3311, 2168, 2401, 2402, 3312, 2170, 2403,
          2472, 3236, 3070, 2171, 3071, 3308, 2473, 2404, 2172, 1370, 2405, 
         2173, 3192, 2334, 2174, 3193, 2335, 2175, 3025, 3237, 2176, 3026, 
         3238, 2177, 2406, 2474, 1372, 2178, 2407, 2475, 3239, 3072, 2179, 
         3073, 3310, 2476, 2408, 2180, 3294, 2409, 2410, 2181, 3194, 2336, 
         2182}], Line3DBox[{2184, 2480, 2481, 3313, 2183, 2411, 2557, 3240, 
         2577, 2576, 2185, 2412, 2479, 3241, 3074, 2186, 3027, 3242, 2187, 
         3028, 3243, 2188, 1248, 2189, 3195, 2337, 2190, 3029, 3244, 2191, 
         3030, 3245, 2192, 3031, 3246, 2193, 3032, 3247, 2194, 3075, 3248, 
         2413, 2195, 2578, 2579, 3336, 2558, 2414, 2196, 3337, 2580, 2581, 
         2197}], Line3DBox[{106, 427, 342, 475, 1096, 107, 405, 1097, 108, 
         1098, 109, 1099, 110, 1100, 111, 1101, 112, 1102, 113, 1103, 114, 
         1104, 115, 1105, 116, 1106, 117, 1107, 118, 1530, 406, 119, 1588, 
         500, 348, 438, 120}], 
        Line3DBox[{2211, 2416, 2582, 2583, 3338, 3096, 2210, 2487, 3259, 3087,
          2209, 3258, 3040, 2208, 3257, 3039, 2207, 3256, 3038, 2206, 3255, 
         3037, 2205, 3254, 3036, 2204, 1260, 2203, 3253, 3035, 2202, 3252, 
         3034, 2201, 3251, 3033, 2200, 3086, 3250, 2536, 2484, 2199, 3085, 
         3249, 2535, 2483, 2198, 3092, 3329, 2543, 2482, 2415, 2485}], 
        Line3DBox[{2212, 2417, 2574, 2590, 3333, 2338, 2552, 2486, 3196, 2339,
          2213, 3197, 2340, 2214, 3198, 2341, 2215, 3199, 2342, 2216, 3200, 
         2343, 2217, 3201, 2344, 2218, 1273, 2219, 3202, 2345, 2220, 3203, 
         2346, 2221, 3204, 2347, 2222, 3089, 3205, 2488, 2348, 2223, 3088, 
         3206, 2490, 2349, 2489, 3093, 3330, 2544, 2537, 2350, 2491}], 
        Line3DBox[{2224, 2573, 3041, 3332, 2591, 2418, 2554, 3334, 2575, 2351,
          2553, 2419, 3207, 2352, 2225, 3208, 2353, 2226, 3209, 2354, 2227, 
         3210, 2355, 2228, 3211, 2356, 2229, 3042, 3260, 2230, 1284, 2231, 
         3212, 2357, 2232, 3213, 2358, 2233, 3076, 3214, 2493, 2359, 2559, 
         2584, 2585, 3215, 2560, 2360, 2494, 3314, 2492, 2361, 2234}], 
        Line3DBox[{2236, 3043, 3261, 2235, 2420, 3044, 3295, 2237, 2421, 2496,
          3315, 2362, 2495, 3077, 3216, 2498, 2363, 2497, 1395, 2499, 2364, 
         2238, 3217, 2365, 2239, 3218, 2366, 2240, 3045, 3262, 2241, 3046, 
         3263, 2242, 2422, 1294, 2243, 2423, 2501, 3316, 2367, 2500, 3078, 
         3219, 2503, 2368, 2502, 3317, 2424, 2369, 2538, 3328, 2504, 2370, 
         2244}], Line3DBox[{2246, 3047, 3264, 2245, 3048, 3265, 2247, 2425, 
         2506, 3049, 3296, 2505, 1404, 2509, 2371, 2508, 3318, 2426, 2511, 
         2372, 2248, 3220, 2373, 2249, 3221, 2374, 2250, 3050, 3266, 2251, 
         3051, 3267, 2252, 2427, 2514, 3052, 3297, 2513, 2428, 2517, 1304, 
         2516, 3320, 2429, 2375, 2253, 3222, 2376, 2254, 3223, 2377, 2255}], 
        Line3DBox[{2257, 3053, 3268, 2256, 3054, 3269, 2258, 2430, 2507, 1411,
          2259, 3079, 3319, 2510, 2431, 2260, 3298, 2432, 2512, 2433, 2261, 
         3299, 2434, 2435, 2262, 3224, 2378, 2263, 2519, 2520, 3321, 2264, 
         2436, 2437, 3322, 2265, 2438, 2515, 2439, 3323, 2266, 2440, 2518, 
         3270, 3080, 2267, 1421, 2441, 2268, 3225, 2379, 2269, 3226, 2380, 
         2270}], Line3DBox[{2272, 3055, 3271, 2271, 3056, 3272, 2273, 3057, 
         3273, 2274, 3058, 3274, 2275, 3081, 3275, 2442, 2276, 3097, 3300, 
         2443, 2561, 2444, 2277, 3324, 2522, 2523, 2278, 2524, 2525, 3325, 
         2279, 2445, 2562, 2446, 3339, 3098, 2280, 2447, 2521, 3276, 3082, 
         2281, 3059, 3277, 2282, 3060, 3278, 2283, 1326, 2284, 3227, 2381, 
         2285}], Line3DBox[{2299, 2531, 1524, 2298, 3288, 3067, 2297, 3287, 
         3066, 2296, 3286, 3065, 2295, 3091, 3285, 2540, 2528, 2294, 3090, 
         3284, 2539, 2527, 2293, 3326, 2545, 2546, 2526, 2548, 2547, 2292, 
         2567, 2568, 2563, 2588, 2587, 3340, 2291, 2586, 3283, 3099, 2290, 
         3282, 3064, 2289, 3281, 3063, 2288, 3280, 3062, 2287, 3279, 3061, 
         2286, 1521, 2529, 2530}], 
        Line3DBox[{2593, 2894, 1771, 2592, 3397, 2767, 2594, 3398, 2768, 2595,
          3399, 2769, 2596, 3157, 3458, 2895, 2770, 2597, 3158, 3459, 2897, 
         2771, 2896, 2070, 2973, 2964, 2994, 2772, 3010, 2995, 2996, 2979, 
         3001, 1775, 3000, 2999, 3472, 2773, 2598, 3400, 2774, 2599, 3401, 
         2775, 2600, 3402, 2776, 2601, 3403, 2777, 2602, 1991, 2778, 2899}], 
        Line3DBox[{2604, 3100, 3341, 2603, 1782, 2605, 3404, 2779, 2606, 3405,
          2780, 2607, 3151, 3460, 2900, 2781, 2985, 993, 2986, 2782, 2901, 
         3406, 2898, 2783, 2965, 2902, 3101, 3342, 2608, 2843, 2981, 989, 
         2980, 2844, 3454, 2784, 2609, 3407, 2785, 2610, 3408, 2786, 2611, 
         3409, 2787, 2612, 3410, 2788, 2613}], 
        Line3DBox[{2615, 3102, 3343, 2614, 3103, 3344, 2616, 2845, 1793, 2617,
          2846, 2904, 2789, 2903, 1919, 2906, 2790, 2905, 3411, 2847, 2791, 
         2966, 3412, 2907, 2792, 2618, 3104, 3345, 2619, 2848, 3105, 3346, 
         2620, 2849, 2909, 1796, 2908, 2850, 2911, 2793, 2910, 1925, 2912, 
         2794, 2621, 3413, 2795, 2622, 3414, 2796, 2623}], 
        Line3DBox[{2625, 3106, 3347, 2624, 3107, 3348, 2626, 746, 2003, 826, 
         747, 828, 2004, 748, 2627, 3415, 2797, 2628, 3416, 2798, 2629, 3108, 
         3349, 2630, 3109, 3350, 2631, 749, 2005, 830, 750, 832, 2006, 751, 
         2632, 3417, 2799, 2633, 3418, 2800, 2634}], 
        Line3DBox[{2636, 2918, 2919, 3351, 2635, 2851, 2852, 3352, 2637, 2853,
          2913, 1933, 2638, 2854, 2914, 2855, 2639, 1934, 2856, 2640, 3419, 
         2801, 2641, 3420, 2802, 2642, 3110, 3353, 2643, 3111, 3354, 2644, 
         2857, 2915, 1936, 2645, 2858, 2916, 2859, 2646, 1937, 2917, 2860, 
         2647, 3421, 2861, 2862, 2648, 3422, 2803, 2649}], 
        Line3DBox[{2651, 2921, 2922, 3355, 2650, 2863, 2987, 994, 2652, 2864, 
         2920, 3461, 3152, 2653, 3112, 3356, 2654, 3113, 3357, 2655, 1823, 
         2656, 3423, 2804, 2657, 3114, 3358, 2658, 3115, 3359, 2659, 3116, 
         3360, 2660, 3117, 3361, 2661, 3153, 3455, 2865, 2662, 995, 2988, 
         2866, 2663, 3424, 3004, 3005, 2664}], 
        Line3DBox[{612, 933, 848, 981, 1677, 613, 911, 1678, 614, 1679, 615, 
         1680, 616, 1681, 617, 1682, 618, 1683, 619, 1684, 620, 1685, 621, 
         1686, 622, 1687, 623, 1688, 624, 2067, 912, 625, 2113, 1006, 854, 
         944, 626}], 
        Line3DBox[{2678, 2868, 3006, 3007, 2106, 2677, 2928, 3463, 3161, 2676,
          3369, 3125, 2675, 3368, 3124, 2674, 3367, 3123, 2673, 3366, 3122, 
         2672, 3365, 3121, 2671, 1835, 2670, 3364, 3120, 2669, 3363, 3119, 
         2668, 3362, 3118, 2667, 3160, 3469, 2968, 2925, 2666, 3159, 3468, 
         2967, 2924, 2665, 2072, 2974, 2923, 2867, 2926}], 
        Line3DBox[{2679, 2869, 3003, 3011, 1841, 2982, 2927, 3462, 2805, 2680,
          3425, 2806, 2681, 3426, 2807, 2682, 3427, 2808, 2683, 3428, 2809, 
         2684, 3429, 2810, 2685, 1848, 2686, 3430, 2811, 2687, 3431, 2812, 
         2688, 3432, 2813, 2689, 3163, 3464, 2929, 2814, 2690, 3162, 3465, 
         2931, 2815, 2930, 2074, 2975, 2969, 2816, 2932}], 
        Line3DBox[{2691, 3002, 3126, 3474, 3012, 2870, 2984, 992, 2983, 2871, 
         3456, 2817, 2692, 3433, 2818, 2693, 3434, 2819, 2694, 3435, 2820, 
         2695, 3436, 2821, 2696, 3127, 3370, 2697, 1859, 2698, 3437, 2822, 
         2699, 3438, 2823, 2700, 3154, 3466, 2934, 2824, 2989, 999, 2990, 
         2825, 2935, 3439, 2933, 2826, 2701}], 
        Line3DBox[{2703, 3128, 3371, 2702, 2872, 3129, 3372, 2704, 2873, 2937,
          1864, 2936, 2874, 2939, 2827, 2938, 1953, 2940, 2828, 2705, 3440, 
         2829, 2706, 3441, 2830, 2707, 3130, 3373, 2708, 3131, 3374, 2709, 
         2875, 1869, 2710, 2876, 2942, 2831, 2941, 1956, 2944, 2832, 2943, 
         3442, 2877, 2833, 2970, 3443, 2945, 2834, 2711}], 
        Line3DBox[{2713, 3132, 3375, 2712, 3133, 3376, 2714, 780, 2041, 874, 
         781, 876, 2042, 782, 2715, 3444, 2835, 2716, 3445, 2836, 2717, 3134, 
         3377, 2718, 3135, 3378, 2719, 783, 2044, 879, 784, 881, 2045, 785, 
         2720, 3446, 2837, 2721, 3447, 2838, 2722}], 
        Line3DBox[{2724, 3136, 3379, 2723, 3137, 3380, 2725, 2878, 2946, 1965,
          2726, 2879, 2947, 2880, 2727, 1966, 2948, 2881, 2728, 3448, 2882, 
         2883, 2729, 3449, 2839, 2730, 2951, 2952, 3381, 2731, 2884, 2885, 
         3382, 2732, 2886, 2949, 1971, 2733, 2887, 2950, 2888, 2734, 1972, 
         2889, 2735, 3450, 2840, 2736, 3451, 2841, 2737}], 
        Line3DBox[{2739, 3138, 3383, 2738, 3139, 3384, 2740, 3140, 3385, 2741,
          3141, 3386, 2742, 3155, 3457, 2890, 2743, 1000, 2991, 2891, 2744, 
         3452, 2954, 2955, 2745, 2956, 2957, 3387, 2746, 2892, 2992, 1001, 
         2747, 2893, 2953, 3467, 3156, 2748, 3142, 3388, 2749, 3143, 3389, 
         2750, 1898, 2751, 3453, 2842, 2752}], 
        Line3DBox[{2766, 2963, 2061, 2765, 3396, 3150, 2764, 3395, 3149, 2763,
          3394, 3148, 2762, 3165, 3471, 2972, 2960, 2761, 3164, 3470, 2971, 
         2959, 2760, 2076, 2976, 2958, 2978, 2977, 2759, 2997, 2998, 2993, 
         3009, 2111, 2758, 3008, 3473, 3166, 2757, 3393, 3147, 2756, 3392, 
         3146, 2755, 3391, 3145, 2754, 3390, 3144, 2753, 2058, 2961, 
         2962}]}, 
       {GrayLevel[0.2], 
        Line3DBox[{1014, 1193, 3167, 1015, 1203, 1036, 3230, 1214, 1048, 3233,
          1223, 1059, 1366, 3312, 1464, 1234, 1071, 1571, 3240, 1378, 1547, 
         1244, 1084, 3249, 1472, 1255, 1097, 1475, 1267, 3196, 1109, 1384, 
         1544, 1567, 3334, 1568, 1120, 1390, 3295, 1288, 1132, 3265, 1297, 
         1143, 3269, 1308, 1155, 3272, 1318, 1168, 3279, 1329, 1181}], 
        Line3DBox[{1016, 1194, 3168, 1017, 1204, 3177, 1037, 1345, 1215, 1049,
          1357, 3307, 1454, 1224, 1060, 3236, 1367, 1465, 1235, 1072, 3241, 
         1379, 1245, 1085, 3250, 1473, 1256, 1098, 1268, 3197, 1110, 1385, 
         1278, 3207, 1121, 1391, 1489, 1289, 3315, 1133, 1402, 1500, 3296, 
         1298, 1144, 1411, 1508, 1309, 1156, 3273, 1319, 1169, 3280, 1330, 
         1182}], 
        Line3DBox[{1018, 1195, 3169, 1019, 1205, 3178, 1038, 1346, 1347, 3185,
          1445, 1358, 1455, 1359, 1457, 3308, 1368, 1466, 1369, 1073, 3242, 
         1246, 1086, 3251, 1257, 1099, 1269, 3198, 1111, 1279, 3208, 1122, 
         1392, 1490, 1393, 3216, 1492, 1403, 1501, 1404, 1503, 3319, 1412, 
         1509, 1413, 1157, 3274, 1320, 1170, 3281, 1331, 1183}], 
        Line3DBox[{1020, 1429, 1430, 3170, 1431, 1340, 1341, 3179, 1441, 1348,
          1444, 3304, 1349, 1447, 1360, 3292, 1456, 1361, 1061, 1370, 1371, 
         1074, 3243, 1247, 1087, 3252, 1258, 1100, 1270, 3199, 1112, 1280, 
         3209, 1123, 1394, 1491, 1395, 1493, 1405, 1502, 3318, 1406, 1504, 
         1414, 3298, 1510, 1415, 1158, 3275, 1423, 1424, 1171, 3282, 1332, 
         1184}], Line3DBox[{1021, 1432, 1433, 3171, 1435, 1342, 1545, 3335, 
         1570, 1569, 1546, 1350, 1446, 3305, 1351, 1050, 1225, 3188, 1062, 
         1236, 3192, 1075, 1248, 1088, 3253, 1259, 1101, 1271, 3200, 1113, 
         1281, 3210, 1124, 1290, 3217, 1134, 1299, 3220, 1145, 1416, 3299, 
         1417, 1553, 1579, 1580, 3300, 1554, 1425, 1172, 3283, 1583, 1584, 
         1185}], Line3DBox[{1022, 1339, 1434, 1534, 3301, 1533, 1528, 1436, 
         1442, 3302, 1437, 1039, 1448, 1529, 3327, 1449, 1051, 1226, 3189, 
         1063, 1237, 3193, 1076, 1249, 3195, 1089, 1260, 1102, 1272, 3201, 
         1114, 1282, 3211, 1125, 1291, 3218, 1135, 1300, 3221, 1146, 1310, 
         3224, 1159, 1515, 3324, 1516, 1556, 1586, 3340, 1587, 1585, 1427, 
         1522}], Line3DBox[{8, 433, 302, 499, 2589, 23, 401, 2533, 38, 2147, 
         53, 2160, 68, 2175, 83, 2190, 98, 2204, 113, 2218, 128, 2229, 143, 
         2240, 158, 2250, 173, 2263, 188, 2278, 409, 203, 2292, 478, 392, 430,
          218}], Line3DBox[{1025, 1198, 3173, 1026, 1344, 1208, 3180, 1042, 
         1353, 1450, 3291, 1218, 1054, 1362, 3309, 1458, 1229, 1066, 1372, 
         1467, 1240, 1079, 3246, 1252, 1092, 3256, 1263, 1105, 1275, 3203, 
         1117, 1285, 3212, 1128, 1396, 1294, 1138, 1407, 1505, 3297, 1303, 
         1149, 1419, 3323, 1514, 1313, 1162, 3276, 1426, 1323, 1175, 3285, 
         1520, 1335, 1188}], 
        Line3DBox[{1027, 1199, 3174, 1028, 1209, 3181, 1043, 1354, 1451, 1219,
          3306, 1055, 1363, 1459, 1230, 1067, 3239, 1373, 1468, 1241, 1080, 
         3247, 1253, 1093, 3257, 1264, 1106, 1276, 3204, 1118, 1286, 3213, 
         1129, 1397, 1494, 1295, 3316, 1139, 1408, 1506, 1304, 1150, 3270, 
         1420, 1314, 1163, 3277, 1324, 1176, 3286, 1336, 1189}], 
        Line3DBox[{1029, 1200, 3175, 1030, 1210, 3182, 1044, 1355, 1452, 1356,
          1453, 1364, 3293, 1460, 1365, 1461, 3310, 1374, 1469, 1375, 1081, 
         3248, 1380, 1381, 1094, 3258, 1265, 1107, 1480, 1481, 3205, 1482, 
         1386, 1387, 3214, 1487, 1398, 1495, 1399, 3219, 1497, 1409, 1507, 
         3320, 1410, 1151, 1421, 1422, 1164, 3278, 1325, 1177, 3287, 1337, 
         1190}], Line3DBox[{1031, 1201, 3176, 1032, 1211, 3183, 1045, 1220, 
         3186, 1056, 1231, 3190, 1068, 1376, 3294, 1377, 1548, 1572, 3336, 
         1382, 1549, 1383, 1095, 3259, 1476, 1477, 1530, 1478, 1479, 3206, 
         1484, 1388, 1551, 1389, 3215, 1578, 1552, 1400, 1496, 3317, 1401, 
         1140, 1305, 3222, 1152, 1315, 3225, 1165, 1326, 1178, 3288, 1338, 
         1191}], Line3DBox[{1033, 1439, 1440, 1034, 1212, 3184, 1046, 1221, 
         3187, 1057, 1232, 3191, 1069, 1242, 3194, 1082, 1573, 3337, 1574, 
         1575, 3338, 1576, 1577, 1550, 1558, 1557, 1588, 1559, 1560, 1483, 
         1538, 1537, 3330, 1531, 1485, 1488, 3314, 1486, 1130, 1498, 1532, 
         3328, 1499, 1141, 1306, 3223, 1153, 1316, 3226, 1166, 1327, 3227, 
         1179, 1524, 1525, 1526}], 
        Line3DBox[{1180, 1328, 1521, 1167, 1317, 3271, 1154, 1307, 3268, 1142,
          1296, 3264, 1131, 1287, 3261, 1119, 1277, 3332, 1593, 1595, 1594, 
         1108, 3333, 1266, 1591, 1543, 1562, 1561, 1096, 1254, 1541, 1474, 
         1536, 1535, 3329, 1083, 1243, 1471, 3313, 1470, 1070, 1233, 1463, 
         3311, 1462, 1058, 1222, 3232, 1047, 1213, 3229, 1035, 1202, 3228, 
         1013, 1192, 1428, 1527}], 
        Line3DBox[{1186, 1333, 1523, 1540, 3326, 1539, 1173, 1321, 1518, 3325,
          1517, 1160, 1311, 1512, 3321, 1511, 1147, 1301, 3266, 1136, 1292, 
         3262, 1126, 1283, 3260, 1115, 1273, 1103, 1261, 3254, 1090, 1250, 
         3244, 1077, 1238, 3237, 1064, 1227, 3234, 1052, 1216, 3231, 1040, 
         1206, 3303, 1443, 1023, 1196, 3331, 1565, 1564, 1590, 1589, 1438}], 
        Line3DBox[{1187, 1334, 1519, 3284, 1174, 1322, 1555, 3339, 1582, 1581,
          1161, 1312, 1513, 3322, 1418, 1148, 1302, 3267, 1137, 1293, 3263, 
         1127, 1284, 1116, 3202, 1274, 1104, 1262, 3255, 1091, 1251, 3245, 
         1078, 1239, 3238, 1065, 1228, 3235, 1053, 1217, 3290, 1352, 1041, 
         1207, 1566, 3289, 1542, 1343, 1024, 3172, 1197, 1563, 1592}], 
        Line3DBox[{1597, 1772, 3397, 1598, 1782, 1619, 3344, 1792, 1631, 3348,
          1800, 1641, 1932, 3352, 2010, 1810, 1652, 994, 2084, 1819, 1665, 
         3468, 2016, 1830, 1678, 2019, 1842, 3462, 1690, 1945, 2081, 992, 
         1701, 1950, 3372, 1863, 1713, 3376, 1871, 1723, 3380, 1881, 1734, 
         3384, 1890, 1747, 3390, 1901, 1760}], 
        Line3DBox[{1599, 1773, 3398, 1600, 1783, 3404, 1620, 1917, 1793, 1632,
          1926, 2003, 1801, 1642, 1933, 2011, 1811, 1653, 3461, 1941, 1820, 
         1666, 3469, 2017, 1831, 1679, 1843, 3425, 1691, 1946, 1853, 3456, 
         1702, 1951, 2033, 1864, 1714, 1959, 2041, 1872, 1724, 1965, 2046, 
         1882, 1735, 3385, 1891, 1748, 3391, 1902, 1761}], 
        Line3DBox[{1601, 1774, 3399, 1602, 1784, 3405, 1621, 739, 2904, 817, 
         747, 829, 2914, 754, 1654, 3356, 1821, 1667, 3362, 1832, 1680, 1844, 
         3426, 1692, 1854, 3433, 1703, 774, 2939, 867, 781, 877, 2947, 787, 
         1736, 3386, 1892, 1749, 3392, 1903, 1762}], 
        Line3DBox[{1603, 1980, 1981, 3458, 1982, 1912, 1913, 3460, 1992, 1918,
          1995, 1919, 1997, 1927, 2004, 1928, 1643, 1934, 1935, 1655, 3357, 
         1822, 1668, 3363, 1833, 1681, 1845, 3427, 1693, 1855, 3434, 1704, 
         1952, 2034, 1953, 2035, 1960, 2042, 1961, 2043, 1966, 2047, 1967, 
         1737, 3457, 1974, 1975, 1750, 3393, 1904, 1763}], 
        Line3DBox[{1604, 1983, 1984, 3459, 1986, 1914, 2082, 993, 2083, 1920, 
         1996, 3411, 1921, 1633, 1802, 3415, 1644, 1812, 3419, 1656, 1823, 
         1669, 3364, 1834, 1682, 1846, 3428, 1694, 1856, 3435, 1705, 1865, 
         3440, 1715, 1873, 3444, 1725, 1968, 3448, 1969, 2090, 1000, 2091, 
         1976, 1751, 3473, 2108, 2109, 1764}], 
        Line3DBox[{1605, 1911, 1985, 2071, 2070, 2065, 1987, 1993, 3406, 1988,
          1622, 1998, 2066, 3412, 1999, 1634, 1803, 3416, 1645, 1813, 3420, 
         1657, 1824, 3423, 1670, 1835, 1683, 1847, 3429, 1695, 1857, 3436, 
         1706, 1866, 3441, 1716, 1874, 3445, 1726, 1883, 3449, 1738, 2052, 
         3452, 2053, 2093, 2111, 2112, 2110, 1978, 2059}], 
        Line3DBox[{514, 939, 808, 1005, 3010, 529, 907, 2965, 544, 2618, 559, 
         2629, 574, 2642, 589, 2657, 604, 2671, 619, 2685, 634, 2696, 649, 
         2707, 664, 2717, 679, 2730, 694, 2745, 915, 709, 2759, 984, 898, 936,
          724}], Line3DBox[{1608, 1777, 3400, 1609, 1916, 1786, 3454, 1625, 
         1923, 2000, 1796, 1637, 1929, 2005, 1806, 1648, 1936, 2012, 1816, 
         1660, 3360, 1827, 1673, 3367, 1838, 1686, 1850, 3431, 1698, 1860, 
         3437, 1709, 1954, 1869, 1719, 1962, 2044, 1877, 1729, 1971, 2051, 
         1886, 1741, 3467, 1977, 1895, 1754, 3471, 2057, 1907, 1767}], 
        Line3DBox[{1610, 1778, 3401, 1611, 1787, 3407, 1626, 744, 2911, 824, 
         750, 833, 2916, 757, 1661, 3361, 1828, 1674, 3368, 1839, 1687, 1851, 
         3432, 1699, 1861, 3438, 1710, 777, 2942, 870, 784, 882, 2950, 792, 
         1742, 3388, 1896, 1755, 3394, 1908, 1768}], 
        Line3DBox[{1612, 1779, 3402, 1613, 1788, 3408, 1627, 1924, 2001, 1925,
          2002, 1930, 2006, 1931, 2007, 1937, 2013, 1938, 1662, 3455, 1942, 
         1943, 1675, 3369, 1840, 1688, 2024, 2025, 3464, 2026, 1947, 1948, 
         3466, 2031, 1955, 2036, 1956, 2038, 1963, 2045, 1964, 1730, 1972, 
         1973, 1743, 3389, 1897, 1756, 3395, 1909, 1769}], 
        Line3DBox[{1614, 1780, 3403, 1615, 1789, 3409, 1628, 1797, 3413, 1638,
          1807, 3417, 1649, 1939, 3421, 1940, 2085, 995, 2086, 1944, 1676, 
         3463, 2020, 2021, 2067, 2022, 2023, 3465, 2028, 1949, 2088, 999, 
         2089, 1957, 2037, 3442, 1958, 1720, 1878, 3446, 1731, 1887, 3450, 
         1744, 1898, 1757, 3396, 1910, 1770}], 
        Line3DBox[{1616, 1990, 1991, 1617, 1790, 3410, 1629, 1798, 3414, 1639,
          1808, 3418, 1650, 1817, 3422, 1663, 2103, 3424, 2104, 2105, 2106, 
         2107, 2087, 2095, 2094, 2113, 2096, 2097, 2027, 2075, 2074, 2068, 
         2029, 2032, 3439, 2030, 1711, 2039, 2069, 3443, 2040, 1721, 1879, 
         3447, 1732, 1888, 3451, 1745, 1899, 3453, 1758, 2061, 2062, 2063}], 
        Line3DBox[{1759, 1900, 2058, 1746, 1889, 3383, 1733, 1880, 3379, 1722,
          1870, 3375, 1712, 1862, 3371, 1700, 1852, 3474, 2118, 2120, 2119, 
         1689, 1841, 2116, 2080, 2099, 2098, 1677, 1829, 2078, 2018, 2073, 
         2072, 1664, 1818, 2015, 3355, 2014, 1651, 1809, 2009, 3351, 2008, 
         1640, 1799, 3347, 1630, 1791, 3343, 1618, 1781, 3341, 1596, 1771, 
         1979, 2064}], 
        Line3DBox[{1765, 1905, 2060, 2077, 2076, 1752, 1893, 2055, 3387, 2054,
          1739, 1884, 2049, 3381, 2048, 1727, 1875, 3377, 1717, 1867, 3373, 
         1707, 1858, 3370, 1696, 1848, 1684, 1836, 3365, 1671, 1825, 3358, 
         1658, 1814, 3353, 1646, 1804, 3349, 1635, 1794, 3345, 1623, 1785, 
         3342, 1994, 1606, 1775, 2102, 2101, 2115, 2114, 1989}], 
        Line3DBox[{1766, 1906, 2056, 3470, 1753, 1894, 2092, 1001, 1740, 1885,
          2050, 3382, 1970, 1728, 1876, 3378, 1718, 1868, 3374, 1708, 1859, 
         1697, 3430, 1849, 1685, 1837, 3366, 1672, 1826, 3359, 1659, 1815, 
         3354, 1647, 1805, 3350, 1636, 1795, 3346, 1922, 1624, 989, 2079, 
         1915, 1607, 3472, 1776, 2100, 2117}]}, {}, {}, {}, {}, {}}},
     VertexNormals->CompressedData["
1:eJzsvXlYjl30PxqZ57lIhopkaFCR6dlIGUoUUSFzQhKFUIkyJM0qlCgiSoNk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      "]],
    Axes->True,
    AxesLabel->{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(x\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(k\\), \\(y\\)]\\)\"", TraditionalForm], 
      FormBox["\"\[Epsilon](k)\"", TraditionalForm]},
    AxesOrigin->{Automatic, Automatic, Automatic},
    BoxRatios->{1, 1, 0.4},
    DisplayFunction->Identity,
    FaceGrids->None,
    FaceGridsStyle->Automatic,
    Method->{"DefaultBoundaryStyle" -> Directive[
        GrayLevel[0.3]], "RotationControl" -> "Globe"},
    PlotLabel->FormBox["\"m=0\"", TraditionalForm],
    PlotRange->
     NCache[{{-Pi, Pi}, {-Pi, Pi}, {-2., 2.}}, {{-3.141592653589793, 
      3.141592653589793}, {-3.141592653589793, 3.141592653589793}, {-2., 2.}}],
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    Ticks->{Automatic, Automatic, Automatic}], ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFnXeclcX1/xeWIhARFY0dbCgCtqCxhTMqmliwF2xYKSJ2xQBGQcFeUKMi
KmIXgxGwIuJzRbBE1ASDsHEFEVAvLsjeZYGFBX673533Gefsndcv/9wXn4zz
zHyeM2fOOc/MZ3e95OrT+jYtKSl5rk1JSWnd7ycPttxu/a6tcvyW/N//VmZ3
bN7l0Hn3NFe8m8ePufekc9+oaqL4qx7fbKslq3eZWpuBX9zkt/1UK75P09+2
r1D8+wgvV7xPaQNe4v8Hfm9p1F5se9+/2P79eKT4eGrFjt/P19n5en6c5cf/
21k++Te8dov7UXxN10dertkr8Az+9vG3P7Xu0cAz+Iu7ft1rm/0rlWfwu/f8
YHmruZXKM/gFaz6+/O3LCsoz+LJHev3zmVkF5Rn812zPqdN/0vZi28Oz7R+e
i4+nVuz44dnOF54tP/Bs+YRn+DPvS3H659/8brXjN7cN7lhQnsF/f+Jnfxq6
5yrlGXz41vkbr+u6WnkGv+zKQd36/G+N8gzebYdRp6wurFWewZt8/9rl+5xR
ozzb9vBs+4fn4uOpFTt+eLbzhWfLDzxbPuEZnuL13lxx834VZzz8m98bjjj+
hMmf6LzC/z/qpw793XrlGfzgsd0+f6HVRuUZ/G/Pz/zsgzmblGfwwmdyzdI/
luTg2baHZ9s/PBcfT63Y8cOznS88W37g2fIZ+43qbJ+mMc/grK/Yb1Rnxh4C
r378sd+ozl76w65fz1+1yfiN6qx26GUvD53L+ytXfJ8eT3beu7Q0F/uN6qxf
xfujLxtYqjzb9rHfCP3HfsOOp1bs+GO/EeYb+43AT+w3Ap+xPVdk3zctZs8V
Gf4ttueKLF7vtcqfsR/FYz4rFL+ox1Y7fbxZs1xszxXZqtkXbjdnUPNcbM8V
2Xd7DL7tih+bG3sO7WN7Dv3H9mzHUyt2/LE9h/nG9hz4ie058BnzXJ6xX8c8
l2fsLzHP5VnsD2t13bN+Y57Lrb0pHvNTrvhFHS676rxCC8NzeXZ7i6/H97yp
peE5tI95Dv3HPNvx1Iodf8xzmG/Mc+An5jnwGccfJSX3Gp7B2d/hGTzej2rV
j+I/4Rk8Xu8Vihv7VBw+S4r+bzPl2baHZ9s/PBcfT63ijB+e7Xzh2fIDz5ZP
Y8+SsGdJ2LMk7FkS9iwJe5aEPUvCniVhz5KwZ0nYsyTsWRL2LAl7loQ9i7Vn
xpXwz5Lwz5Lwz5Lwz5Lwz5Lwz5Lwz5Lwz5Lwz5Lwz5Lwz5Lwz5Lwz5Lwz2L9
M89PxBuSiDckEW9IIt6QRLwhiXhDEvGGJOINu17E9m/iDUnEG5KINyQRb0gi
3pDi8UatJOJnScTPkoifJRE/SyJ+lkT8LIn4WRLxsyTiZ7u+pPh4NH6WRPws
ifhZEvGz2PiZ/hL5oEvkgy6RD7pEPugS+aBL5IMukQ+6RD7oEvmgS+SDLpEP
ukQ+6BL5oEvkg87mg/x3ifqGS9Q3XKK+4RL1DZeob7hEfcMl6hsuUd9wifqG
S9Q3XKK+4RL1DZeob7hEfcPZ+kYcjzSq17lEvc4l6nUuUa9ziXqdS9TrXKJe
5xL1Opeo17lEvc4l6nUuUa+z691Zfky9Tvnc4/jvB+66d0mO3zW1tRWbblkF
7vgFf+mkJ/a+/KyWOX73faB35cNNw/sCb2P6B189/6vtpx0a8H6z3z/umKw0
N2H8788sWYB/q9HnyLi5d17Td6XitH/64/mtC12rPA+V2v6MH356bsrolYrT
/t333vrH9f3wY0u1/au5flds9cZKxWl//ppj9v/+DPaV2dp+5mfD7m758UrF
aX/o9CvLvvivtpdEe7Ht/XMlMR6x4/HtXIJ/Z/nn3/AN//QLDv+0h2/4pz04
/NMevuGf9uDwT3v4Zr60Bzf8C/g3l9/X/tx/ErfPFt7D79tfOenRaS2xJ2f7
gTf7XMZDP7wvxgNu3m9mnxvHD7OzJYsHd5j4XeiX8dKe98v/n5iX2HnZ8TAv
O34zL0nMS4wd6jjj8ZQrvt8v9/+89MxG8xU7X+ZHP2b8khi/2PHTT8JOhPdr
3rsk3rvtx+/vlWLsU3Fjz95/1oixf8XNelH/adaX4qxH438c4zf+yjF+43+c
tU/aJ/yPbS+2vfE/djxixwNftIdPcNrDJ3zRHj7BaQ+f8EV7+ASnPXyafcol
9iln/KSz7eP328q21++Ddr8jTrn07Svb370w7F/gVxxyZtmpt1fqPqXtf92r
8vRdC/rewXfvc8rfjnyqkMXrq3nuzlfLT+u4sGD8ZMB5X7YfMy8dP+2YB+OP
466ajPHH+UVlFo+/ufpzM36tB+JP4vgwtI/zxNmZma/GX7H/KVe/Sv8817aP
86zQv3mu2OfyHDt+297wIGZeLoWzbgyf6mcM/+pP4vel9uMS9uMS9uMS9qP9
MD5wxsn4wBkn49P2fpxmHen6MvGM4sTn/Hd95q1/bfDzIT4HX/jm/u6TD0J8
Dv7ii4ftePOnIT637eN9syKj/xgvz0x7l8B1n+S5tE/gar+J/hN4hSR4cAke
XIIHbU+/4PR/8NWndDzwiM1y/I459ccbOpco7hI47V2iveL4I/67Uv/eacf/
b3C1H3D+zX+XaJ9LtLd4LtGPs8/drlvPM+rb8+vzLFn57uxB9X7A4p/2PHNU
fd5qcffstMM71OWtxfupboQ3tK9I4OWNcOwh0V4S/TfC/XgS7Wsb4X6+LsFP
I9z/O4Xn4NXyzG/VxZ+Nq9kr8AzeOf/VqHWPBp7BH1ty0F7b7F+pPIP/+s8O
77aaW6k8g1eeut/eb19WUJ7BT2vZvu8zswrKM3i+x8lXTv9J24ttD8+2f3gu
Pp5aseOHZztfeLb8wLPlE57hz/IMTv/8m9/cCbucNbhjQXkG3/Bt15Khe65S
nsHnvvxD1+u6rlaewd86//zvLvjfGuUZ/N8jptRWF9Yqz+Br9v1n+33OqFGe
bXt4tv3Dc/Hx1IodPzzb+cKz5QeeLZ/wDE+WZ3DzfhVnPPyb34nHbNV88ic6
L8UnzcjN7+fWK8/gn3XdOOqFVhuVZ/AJ775xxwdzNinP4BeM2ePkpX8scfBs
28Oz7R+ei4+nVuz44dnOF54tP/Bs+Yz9RnUjnsFZX7HfqM6MPWTgjD/2G9XZ
WetHPDp/1SbjN6qzG9q9fv/QucynXPELPrp/671LS13sN6qziUdvGnbZwFLl
2baP/UboP/Ybdjy1Yscf+40w39hvBH5iv1HdiGfmXdyeKzL8W2zPFVm83rHn
Cms/isd8Vii+/aZnWn+8WTMX23NFtu9pD/5uzqDw/Ru8+Yhn/3rFj82NPYf2
sT2H/mN7tuOpFTv+2J7DfGN7DvzE9lyR4Lk8wXN5xv4S81yexf4Qnst1/cY8
l1t7Uzzmp1zxdgdee/l5hRaG5/Js/El/HtfzppaG59A+5jn0H/Nsx1Mrdvwx
z2G+Mc+Bn5jn8kY8l0T/CzyDsL/H/r2kJN6PwjkT/Ge8fkpK4vUezpkY+1Qc
PkuK/m8z5dm2h2fbPzwXH084Z8L44dnOF54tP/Bs+TT2LJZn8IQ9S8KeJWHP
krBnSdizJOxZEvYsCXuWhD1Lwp4lYc+SsGdJ2LMU57kiwXOFJPyzJPyzJPyz
JPyzJPyzJPyzJPyzJPyzJPyzJPyzJPyzJPyzJPxzI57j9dQo3pBEvCGJeEMS
8YYk4g1JxBuSiDckEW/Y9SK2fxNvSCLekES8IYl4QxLxRsKeaxP2XCuJ+FkS
8bMk4mdJxM+SiJ8lET9LIn6WRPxs15cUH4/Gz5KInyURP0sifm7Ec+zvG+WD
LpEPukQ+6BL5oEvkgy6RD7pEPugS+aBL5IMukQ+6RD7oEvmgS+SDLpEPOstz
vH82qm+4RH3DJeobLlHfcIn6hkvUN1yivuES9Q2XqG+4RH3DJeobLlHfcIn6
hkvUNxrxHMcjjep1ipt6neLwXLyf6kY4PBfHyxvh8JxoL4n+G+GmXmfH3wg3
9TrLTyPc1OsUf/OeJx6q/57E7563nvL6pltWgTt+wZtdf9dF9fVwfp/uvv3K
h5uG9wVu+we/7439W087NODlG9sNqf9uvPz0ezqXLMC/1WS0v/WdLa+6pu9K
xWm/S6vnv6zsWuV5qNT2Az/4261TRq9UnPZ3X/rmJdf3w48t1fbLbxjptnpj
peK0/6bbRwsWnoEfn63t9yy599yWH69UnPY//Djl9i/+q+0l0V5se/9cSYxH
7Hh8O5fg31n++Td8wz/9gsM/7eEb/mkPDv+0h2/4pz04/NMevpkv7cEN//p+
ZnQ/u+25/yRun63v4ZHpnV5/dFpL5/txth94s89lPPTD+2I84Ob9Zva5+AHw
cx6es8vE78g7tL3QnvfL/5+Yl9h52fEwLzt+My9JzEuMHeo44/GUK965Tf+l
S89sNF+x82V+9GPGL4nxix0//STsRHi/5r1L4r3bfvz+XinGPhU39uz9Z40Y
+1fcrBf1n2Z9Kc56NP7HMX7jrxzjN/7HWfukfcL/2PZi2xv/Y8cjdjzwRXv4
BKc9fMIX7eETnPbwCV+0h09w2sOn2adcYp9yxk862z5+v61s+0bfB/GnxCmv
l3xdfdfCsH+B/7x51aun3l6p+xT4J3ds9dbpuxb0vYNXf3HSH498qiDx+mqe
W3HgP1t2XFgwfjLgvC/bj5mXjp92zIPxx3FXTcb44/yiMovH31z9uRm/xlP4
kzg+DO3jPHF2ZuardbbY/5Tr/0//PNe2j/Os0L95rtjn8hw7ftve8CBmXi6F
s24Mn+pnDP/qT+L3pfbjEvbjEvbjEvaj/TA+cMbJ+MAZJ+MDZ5xmHTWKV+06
JT7nv3t18V/vGPx8iM/B3/3+860++SDE5+BfdJj5y7BPQ3xu28f7ZkVG/zFe
npn2LoHneD7PjefTCNd6aaL/BF4hCR5cggeX4EHb0y84/bc9pd+59ecw+N3v
uvfrz4eAuwROe5dorzj+iP+O9047669ol7If/rtE+1yivcVziX4a7Qs3vjwt
P21D0NN4YeWZ16zbbWU2Z9c/3HpzWVM933JvQ3vFaX/JdgvPGTp0ZdbnkDM7
Dx24Sc+57OTvF4DTfsq33XaaWMX5lhptP6vJb/vX+3a5q/z9hYb2ecU3RXiZ
4peVRrikcMZz/SUt5m36vED/Urz/vLYf+v7UymHDC4xT7DjB9Rzm3VPHLGtN
/zVi5wtO+85LLhrz4G2V8CYJPrX9Lcc3P+aE1fpeXOJ9Ofu+/HvX9nv49uDW
HrAT7se02Pccd/jtwR7ACy98d+O86Tp+vU+z7VfDZ4y5tErfO/iS3Ly/rN67
Wt87uIzo/O9Xv1it7x186pQnDhjZca2+d/DO5yyYs9MmxaU4nhfbD+8LvEf0
3Bqx44R/Oy94tjzAp+UNPrlX1P+TVx7eqnWl8gl+wZ0PlXccUKV8glct6DC8
fKCOU/FJc4ds97uRNconeOWQsfsuOKFW+QS/Yvezjv5l2EblE/zal0874aIf
NymfxfG82H7gs/hza8SOEz7tvODT8gCflrfYj1VnP3/b8dEBYyuNv6rOXn/s
TzuP2bba+KXq7Met8/v80rtG+QT/PvvdnGfGblA+wYcfvfVbD00sycEn+JR5
JaU/dmyag0/wB6teemuLdtQj8D8Wz4vtJ/Yn9rk1YscZ+4cwr9gPBB7i9R54
i+2zItuh20l/7rfK2mdFdsLN/15TdfNqY58VWbuTu2yx7J31xj4rsr3P+P6q
TleW5GL7rMiumtJr6duvNM3F9lmRPXn0Kdt8dnGzXGyfFdmcvz/fs/nNzXOx
fVo8L7af2D7tc2vEjjO2zzCv2D4DD7F9VmQvXX3FkA7bFQyf5dnpG3qenT+6
YPgsz06+6E/nju+/xvBZnt215yFnfN1jg+GzPCttdcRrRw9uYvgszy4trP76
k2Wlhs/y7Kc2t/bv/mVzw2d5Ju7JR9Y2bWn4LM/abtmrTY82LQ2f5dmPvp+Y
T/vcGrHjjPkM84r5DDzAG/HgY0vP33r5hYE38Ir9361oOzXwBt595oDLr5oV
eANfdNLEpXv8J/AG3np+bsefejdT3sC/3ubmj549voXyA77t0C9vWTA68GPb
w0/x/msUZzzwY8cPP3a+xq4kYVeSsCtJ2JUk7EoSdiXGrlTXIrYrtR9J2I8k
7EcS9iMJ+xFrP3oO3a9H48ck4cck4cck4cck4cck4cck4cck4cck4cck4cck
4cck4cfE+DHVe0jsp5LYTyWxn0piP5XEfiqJ/VQS+6kk9lNJ7KeS2E8lsZ9K
Yj+VxH4qxffTWknEe5KI9yQR70ki3pNEvCeJeE8S8Z4k4j1JxHuSiPckEe9J
It6TRLwnNt7j/noiH3GJfMQl8hGXyEdcIh9xiXzEJfIRl8hHXCIfcYl8xCXy
EZfIR1wiH3E2H+Fela0DgNt8H5w8NF7vzR35bLzem7s4L9Z83Nl8HNzm3dr+
vvsHHdk25NfgJ33w/df198VM/uts/mvnCw/cxyEvNvUQR35t6h5upzivVzxR
33CJ+oZL1Ddcor5hcK1jaD+mXmGeq3UJHaepP+i8TJ1BeYA3fm8a+F71M7sE
3rZ+YYs+469pkdt4QumKYdcE3iaPv3TOyMUtcl/85bmHT70pzGuP1re+Vt/P
q/mhr009JtjDjBZf71rfjwyf/dcl96pdyUWlez1W38/Nn+7sOu1ZqfPauGlo
6/o65fT+309qPSbM66naL2/p9VnL3LhFc0t6HBLmdVjNblUHHLFZ7tfZ316x
sVWYV/c9F7Ye069pbnW32M/wO+66Q/9w9nPBz1y7y51VF51Ymms14aZnFlwd
7Hzxnc99+XhdPzPWzZFBXYIfGDFy9VH1/fRbt+noZx5frfPqMOL4d+r7+eSD
PVrd9+Eqndf0v43rUv9dcfCN3ToftaGg8zpvaOGZzgc2y73y1X2fH3pPsP+a
wce2b/tiM9Upxf4fv37sXYXfN8+9aez/x2Oa9/553Ibs8gsfeuGWQpjvrvKa
mzxyY1byRft205uEfYrf+ZMmb+pyarXa/xdjNt5V/13mqb16XL9yyhq1/yse
PW1D8ydLctfPHbBH3w41av+tHn7p2mWbN8ltObL9HwbPr1H7f/mBdUu/HN4k
98Ud/54z+gfFpWeb+xb+VDfOL4ZcdEJF07BPDW/W/dNJdePc+rRvj6z5qFb5
fH/Dt5OG1I1z+p7n/W/3dRqfyM3rPzyxfpxrr9p6xZbrNA6UHdZu82H9ONH/
gc93V11+UP04e78+s3OfJcGvnlU5fUL9OHc2fvWyI08cO/6a1dlnbseBuw8J
+/74w1bddvlZa7L3dlqxavLEVcpj+R+euuLAI9Zmt/R5suSkx9Yqn/ze2e6Z
f/VcsF75PKNTxREzW67LRs6864jzB2xUPkd3+Pue9y9fl/VePm9W/2YlGkfN
3u6Itmd9vT5bdUOz0uHnKO7X1+rs9DknzM8maBzr19GarF3t1wuuP1fzAmlY
L2uzK4845PwXj9ikfA4u/OvbdfVxitetgs8pv1w386O6cZ739ytfHdJtjfK5
YskOr91XN85hP738uz4PhX1/nwUzHj2zbpzDzb4/c0inqZNHrshuPeSSo976
NfC5y8GHz9p175XZbU9MfHRAxxDPn7vf4teWbV6ZDWzywZjJ24Z4/rG9732s
/jtg75EfrHztxk3KJ7+FobWFL25tonFp2x2/7X9MVpXNP/mRG06ZFuLS49vf
fkrbF1dlOx71ygOjLwxxaYMdrsiOPfa5K0Z2DfF8g73V2cfn05/v80mp8tlg
V5WqLwqfq5ZvuUv9OOctbpv12LRR+dz/p6kt6sd538VnPVtvz/A56PuLf+1Z
N84vx5989O2Hhbj0lbJW8zevG+dGE5fmrnnzT7vt/X22bPZ7HWtdyI/+eGmz
Ld6sWpTd+cV5S5ftHvLHSWee8f0x2eKs/UujDx87V+O9bO+/vDC5/jve3zff
vtOG0pA/Ntj5T9mx7+1z3uH7hvyR3/tvu/qyLh+F/KjBbpdlJ97fqW/Hf4b8
qIG377Odrmqz/XmLWiifDfwsUh1R+GzgYXF277Lt+xzdN+SVS+ZMzn1TN87H
Ti5dPWhhyI/On9Xk4QF14xz55Zy9dt+1Vvn5dFinPbpOnZhN//2LK07+Tf1h
zH8efmqPqe9nHx1/92fD/v4bfg68+5Gye2ZlJx668dt140N+Pbr20/kdp87O
Hlsw8LtFEwI/h/wfz//Jao+b0fvi7UL9oYHPudmLvZZPvurXwMPwvTa137lu
PDduGru4910hv27A389mdlw185Lf1B/GX5B9NbduPNcOr36sV5dQf2hoPzs7
acjf3rrj6ZBfT/prh25T6sZzzaTnFh176Qbl4cGjLryupu755788aGD9vgwP
z/1f/3Pl451u/3jRpb/hoaEfoR948M8Vnqt20jBOicdZJvxuee7Y9RP2CPP1
/Aj8MF/Pp8R81ojnX+Bf59vwvoT3xXxPfPXZ7vctXyaL9rn+kF5rg5+Z+86p
l66re/7J/7vs13GPBz/j7UewH+br7U2wN+br7VNi+8xn3p5V95L5+3Uh8brI
C7+sI33vDetO4nVX43lbKqxT5aFhXcs2fl3Dg/cbstHUAbyfEfwMPHi/JPgl
ePB+TPBj8OD9nsR+L595Pyn4SfyD96sS+9Uy8X5Ydoj8cF683xb8NvzwG/v5
GvH7grAvwI/fR4R9BH78PiXDTV7v9zVhX4Mfvw8K+yD8+H1T9R7hx++zEu+z
+czvy8K+DD9+H5d4Hy8Tv+9LvO/nvV2tE+IEePFxhcRxRY2emyAOgR8ftwhx
C/z4uMjtbPJ0H0c54ij48XGX6i7Cj4/THHEa/Pi4TuK4Lu/tZKMQB8KPjxsl
jhvLxMeZLo4z8+LjUkdcCj8+jnXXRXFsjfi41xH3woOPt92bJr/28bnqHMKD
j+cd8Tw8+PjfEf/Dg88XXJwvlMnP7ebNrH/us++6rlfcXaXzalgvzdzG8ou6
f15epfOa+Pv9yuufe+2En3bcfobWSfw6KnX3DLs1X9k11Bn4JQ8i3vB5kyNv
gof51YP7b/v6Zu70t599/4Xf5Nc+/3LkX/Dg8zVHvgYPPr9z5Hfw4PNBF+eD
ZdL5kTeer3/uted3XDjigJAv3/vYhfvVn4949o9z97v7nJAvL3+izbT65244
YMuqUYNCvnzy0+8cW//cuz/Yb0S9rhTz93mus3nu9j6PuGXYqLvGDdA4X/gl
b+Lfvr2jveEtB2/0/6TPZ097fNveJ3ZpZD+5Z/476tlRU4L9nNQw/hzjN3zm
ug/c+dHf4v6953jv4B/4PHTK9bvtWFB7KGSetxy8mfeSmzr2gVGfLgq4t7cc
9mbsOXdUp0duqJq3Ste1f1853he4rQ+AezvPYefgNu/GP3g7ycV2UpYVr0uU
ZX595eL1VZYVz/fVDm3/UrwftU87X7HzYt1ZOwG39Rnjn3MflR41edktjfxz
bl2vq/oevqnS7nfZwh23bT5ow0q732XTRv3Q5uAJVTZ+yJotnltddXuj+CG7
4oh9l1x3XLWNu7JE3JURd5m4KHv+3E5bdZ/e3MaNGXEj69T2A27zHXiz4wG3
eZOJk7NEnJwRJzM+O06Nc4rG+YqLxf8/cXJ22s8VbR7bvIXNI7QfeLDjBLf5
DjzY+YLbvMnkU5LIp4T+dR9vyGuEvMbkR2LmpTpkB3T/dv6pVwd+fP4ocf6o
+aZgP2a+Oh7Dj+Y7Zr5i5uts3mTybknk3YIdGvtshNt8xNinGPt0ibzG+fqJ
UD8x9QQx69T5OoxQhzF1BjHr3fl6l1DvMvUfMX7D+bqZUDczdSEx/sf5+qRQ
nzT1Omf8mPN1TqHOaep4Dn9o9gsX7xe6vzi7v/j9yNn9yMYbZr9wZr/Iisdv
uh85ux8Vj3O0/mz7l+L9aF3azlfsvEy92rFfm/q8Y983dWxH/GDq9o44hLjI
19UddXVT93bEOeD++4Lj+wK4j5cc8ZL5fuHM/uhSuI1jzblKZ85V5ux5S+Io
zlvG362C7mP8nSuvON/FeO/2XCvPRYdz6B9m3LbN23Y8NdmR87pcVna4/a5a
mT3b58Wru0y35+uWZiWDpw2v3jX4kwSuepsjDv7lh7LeYZzFz8/w3Xl2ht+O
v/+Gfkz/YvvnHAjnl0w/YvtBnzIxr0Y4upWGH9XVNHyqrib8m/foEu9Rv4ea
c78uPkedV93HUy/Y976e/wj+BLxnu76nPZ4LfsDiMT/l2Rn+HBG4PX9l2ott
z3kSzg2a8bjEeAyeV5x58b64p/LWQSsH1uXRwr7Z8N+Fc/LgtD//z21PHDp0
JXlXZtuD037C1C5N63im3tGoPevU4nF92+JlKVxSOOM59OH37q+zB633JZ6r
7au2yF6vsyutcyXGr+3b3bfnJctah3sxxfvX+zK5GZ+9evWDt1VqHpvgU9v3
eun1fU5Yre+l0f0IcPu+sCvbHtzag8aZ/p59s4ptDjr89mAP4Du80fqSedN1
/KoH+GPf/uPHXKr3+xTPf3jntqv3rtb3Dj7hhHYPvvrFan3v4LVLD1h6e8e1
+t7Bb1wz+dadNikuxfG82H54X8WfWyN2nPBv5wXPlgeNYw1v8Ik+QeneJ9+2
VetK5RN8911+/azjgCrlE7x1jyMuLR+o41R835H5FW1G1iif4EP+9U7NdyfU
Kp/gHz7YpcUvwzYqn+D/6P9Sq4t+3KR8FsfzYvuBz+LPDTpbjBM+7bzg0/IA
n5a32I9VZ1tO3XHEgLGVxl9VZ0/lJ28xZttq45eqs3F/7bXdL721Dqt46YW7
vvPM2A3KJ/jbPf/3/EMTSxx8gu87vdOvSzuyDssU71/15Pgt2nF/GP9j8bzY
fmJ/Yp9bI3acsX8I84r9QOAhXu+Bt9g+K7IL3/5Q6vYdY58VWbMdtlxZdfNq
Y58V2YxbPmyx7J31xj4rskFbnz2g05UlLrbPiqxw+d3lb7/S1MX2WZEt+HrH
Np9d3MzF9lmRtRqz5WHNb27uYvu0eF5sP7F92ufWiB1nbJ9hXrF9Bh5i+6zI
3ujf+dIO2xUMn+XZxA0jTqnb3w2f5dn+i/911vj+awyf5dl2PatO+7rHBsNn
eVb21fX/OHpwE8NnefZL7xX//mRZqeGzPOv0r08u7f5lc8NnefZcdZvRa5u2
NHyWZ2e9ctVmdfGe4TP0E/Npn6u6PjrOmM8wr5jPwIM9r77bTRW/q4uXlDfw
Vdd9s6zt1MAb+JbtXh941azAG3izFQ/Vnw9X3sBf2+H9HX7q3Ux5Ax+0qvWM
Z49vofyAP9BhYH28rfzY9vBTvP9wXp3x2PPqjB9+7HyNXUnCriRhV5KwK0nY
lSTsSoxd6b3S2K7UfiRhP5KwH0nYjyTsR6z9cJ+V9Wj8mCT8mCT8mCT8mCT8
mCT8mCT8mCT8mCT8mCT8mCT8mCT8mBg/pnp3if1UEvupJPZTSeynkthPJbGf
SmI/lcR+Kon9VBL7qST2U0nsp5LYT6X4floriXhPEvGeJOI9ScR7koj3JBHv
SSLek0S8J4l4TxLxniTiPUnEe5KI98TGe+hgJfIRl8hHXCIfcYl8xCXyEZfI
R1wiH3GJfMQl8hGXyEdcIh9xiXzEJfIRZ/MR9BlsHQDc5vvg5KHxem/uyGfj
9d7cxXmx5uPO5uOqF2fybvD//HvuQUe2LZj1GMZp8lln81mf/zqTLzfCTX1D
cVPHMP0UEu3zCbwshUuin0a4qUvYcTbCTZ3B8pDUN+B33Fk7Vz2zS+Bt3aOv
9qv/XrxwxXlLhl0TeLt15BOL679Tf7np2odOvSnMi37unHXtJVOPCe+dfq5e
fE73Jfeq/Qj9nPnF1lt32lP14lQ/44TC2Edajwnzuvvim76r/25+9ZpuhT8d
EuaFzsPfek/pv7FVmFevP/RsWn8u3foTfnttedzeZz8X/MnZ7Xarrf+eXll9
YH39XOdFP+2fvG7BFV3CeqefY2dtsWDc46t1XvQzvn+Hf9z74SqdF3pXg4/p
VH7khoLO6+Llm6rrv+8f2+aLMYfeo/uI+/HbFdfVf79GdxH7v+Jf3/1a/x3c
2v/xtzxxUP259DPGrHrmlkKY7xnn3bRf/bn06se/bT+9SdiP9H7GylyzrqdW
q/2jF3TWV4MHrZyyRu3/0CF3tW3xZEluUs2Jbft2qFH7/6D/TffWfwef8ocp
LQfPr1H7P/qsfpt9NbxJ7rWzl44e/YPiwjivb3n92l+ahv2IcbY56h+L135U
q3wyzut2GjZ093XhfBXjzA1eN2bLdRrvCeNELxQ+GefqAy5r3WdJ8J+M0/rP
BrtdnW19wFN9dx8S9vcG+1yTDZ0/Y8Pkiat0fA12uDbrduLdLU96bK3xJzXZ
iI7Hf9FzwXrlc7fWu51Ufy69+cfTDjh/wEbls+tPm/5cfy79+Q93e6d/sxKN
lw6e+d2R9efS5e6rlt16juLCODc8XTItm6DxqjDOQR9tP+36czX+F8a56P5J
W7x4xCbjT2r07xTAJ+McNrDkhiHd1iifjPO90Z1XXPBQ2N8Zp93fG97vimyL
5U17vPVr4LPhPa7MOly02fgBHUPc3vC+KrMV/3vkhcnbhrgdfarZ126x7rUb
Nymf/HYf92b9eUWNPxvWXVX2Q8f+V54yLcSfDetrVbbV4fsPH31hiD8ZZ59T
/nbuyK4hbmec+1zz7X19PilVPhkn+szx/l6ZtWufu7/Hpo3KJ+PEnuGTcZ4/
560utx8W4k/GaePPhvF8n03dbeWOta5g4qVF2dfz3lu+bPeQJzb0vzjbd/WB
fx47V+M69P2yRYOO7bKhNOSJDfbzU7ZD56MvOHzfkCfyO++EMy7p8lHIgxrs
YVn2/qkf9+n4z5AHMc73p7y61XmLWiifjBNdcfhknDOf6H7K0X1LTTy/NLts
8MifBy0MeRDjnDh7xFa771pr4vOJ2SH7jfv55Attnvh+VnHP/rOH/X2NiX9m
Zbu9PmnRuvE2j56dlYyeuHDRhMBPw/j/k928z43nXLxdM5PvzM2OP3XDpKt+
tfngxOyCfW79ofddNo9+P1ty7s0fXfKbOgPj2fm4gx7u1aWZyQdnZ991O2fy
HU+HPJrxtHix8ttjL91g4qIyYV+O48C5cs6bB+YWXbrGxNX/EfoxPAjPjePA
WRKPM5xLr/z7gnUT9mhp8ri5Aj9xnPwfifnU+Qr8x3ncLOF9MV9vhzJpbM99
e62tNHFgXtivma+3H8F+zLoQ7I35evuU2D7JIxapTj7zZzzxugjn0llH8MB4
4nWn9i+sUz1X7MfDutZ7ag1+o1G+7/2M4GfggeebfRZ/K/gxePB+T2K/l/fx
w0rBT+IfvF+V2K+WCeOM/XBeGCd+m/HxG/t59bfCvgA/jJN9BH78PtUof/f7
mrCvwY/fB4V90Ozvqg8PP36flXifzXt7WyPsy/Dj93GJ9/EyYZwu2vfzwjiJ
E+CFccZxRYibiEPgh3ESt8CPj4sa5eM+jnLEUfDj4y7VaTfxpCNOgx+eH9tb
3tvJRiEOhB8fN0ocN5YJ44zjzLwwTuJS+GGccRyr8aQj7oUHH283yqN9fK66
6PDg43lHPA8P6J0S/8ODzxdcnC+UCc89OJtWMfDuKp0Xz10iQ0o/L6/SefHc
Sw7eYu12M0LdgF/yHeIKn9c0qhs80uPMefXndvbq1aL+3I7OF5088izm6/My
R17GfNEbJI9jvj7vc3HeVyY8t1XuuW9GHBDyYp47+LCjOt59TsiLee6/Txq3
cNSgkA/6fNPZvJW84LzH7jx63ACN2/WXPMjkEY72hp8c/BgechPueOHPJ3Zp
ZA+53x9SPWDUlFA/oX08fuUnd+9hL/X6dFHA6Sd+v2o/uadWyTZV81bpOiIv
hjdwm4+Dk29iV+A2z2U9wkP8vsqy4nWAsoy8Nbbnsqx4fq32YPuX4v2ondj5
ip0X9m/foz0HTj3E+MPcjB1/fmnZLY38Ye6bk/8rh2+qtPtLdkpZxdorNqy0
+0v2QKH/TwdNqLL7dfblgWvyVbc32q+z10d9/sl1x1XbOCdLxDmZeV/EIdnX
xzfZvPv05jZOy4jT4npR6CeuQ4b8At7seMBtnmLi0iwRl2bEpXE9LYyTfxeP
qxUXi/9/4tLsr0dfv/ljm7ewcbv2E9cnwzjjunfIL+LzOWG+cT085Ckmf5FE
/iL0z3sCJ48w+YiYeWk8P3PNN/NOvTrw49+XxPma5neC/Zj56ngMP5pfmPmK
ma/ybfghz5VEnivYobHPRriN/419irFPl8gjHPEt9QqTv4tZp464l7qHyevF
rHdHfEh9ydRbxPgNR9xIncrUYcT4H0d8RT3Q1Mec8WOOuIu6oqmbOfyh2S9c
7H90f3F2f2G/tvuR3ffNfuHMfpEVj5d0P3J2Pyoeb2i91/YvxfvROrCdr9h5
mfqwY7829XDHvk8cQnvq0qZu7IgrwOmH+rypnzviE3uu2+x3LoXb+NCcP2z0
fcHjOfs9hXOJfPeJ/VU4n8n7suc8Y/9Qkut35bKh27xtn1uTnfTue+eVHW6/
M1Zmk854rX+X6fa82dLsjT8+NaR61+AHErjq2B/Rr295We8wzuLnScq0boO/
jf1h6Mf0L7Z/zkVwnsf0I7Yf6gaJeTXCyaMNP5pnGz5Vrx7+zXt0ifeo3wfN
OVgXnyvOqw78iRNvubTnP4IfAH/klWl7PJ4L69fiMT/hvJY9v815JNNebHvO
V3COzozHJcZj8LzizIv7Cbw3dLe4F6H3FRrWkeo7g6NXhv4vOLpw6NiCo7/H
eXRwdCDR6SvePtSZ6B/dNDsezuXbeTFf9nP0x5gv+L1mvuDotjFfcPTxmC84
OoSqh+txdB053w+OTib2AY6+KOf7bXvVqTT9w2fx8dSKHT982vnCZ4I3Z3mD
T/JR9MrgExx9PPgER4cQPsHRe4RPcPQz4RMcPVL4BEfHFT5te/i0/cNn8fHU
ih0/fNr5wic4en3waXnDbnV/8feS4Bl8luEZHH1CeNbvbl4HEp7B0duEZ3D0
S+EZHD1YeAZHRxeebXt4tv3Dc/HxhHo544dnO194Bkf/EJ4tb7F/KGTc84r9
QyFDry/2D4UMXcrYPxRUdz32DwXVD4/9Q0F1sGP/UFA959g/FDJ0jGP/ENrH
/iH0H/sHOx79Hq7jj/1DmG/sH+qe6/UkY/8QeIvtOZ9x3yq253y2qWkxe85n
6HPG9pxX3fvYnvOq3x7bc151yGN7zqsud2zP+Qwd6dieQ/vYnkP/sT3b8YRz
dow/tucw39ieG/HmLG8xz2UZ99dinssy9Cpjnssy9FFjnsv07w7EPJepfn7M
c5nqwMc8l6nOecxzWcY9xJjnMtU/j3kO/cc82/GEuj7jj3kO8415bsSbs7wZ
PiXBpyT4lASfkuBTDJ8a98Gn4UcS/EiCH0nwo+M3PEhxHvKSWL+SWL+SWL+S
WL+SWL+qZ27WryTWr7Y361cS61cS61cS61fna9ap2HVKXm78p+KJfUd6FN93
JLHvSGLfkcS+I4l9RxL7jiT2HUnsO5LYdySx7+h8zf4ixfeXGjH7vuKJeEkS
8ZIk4iVJxEuSiJckES9JIl6SRLwkiXhJEvGSJOIlna+Ji8TGReTNJl5VPBHn
SyLOl0ScL4k4XxJxviTifEnE+ZKI8yUR50sizpdEnC+JOF+4J27ifLFxPvW9
RH7qEvmpS+SnLpGfukR+6hL5qUvkpy6Rn7pEfuoS+alL5KcukZ+6RH5qeXOW
N1P3UL1xU99wifqGS9Q3nKlvKE59Az61Tu/v6cMnOPf64dO2N/UTx71+Uz9x
ifqJS9RPXKJ+4kxdSHHqQuhxU29BXw7danB0XdBfBkdPBh1hcHRs0HUCRz8H
PSNwdH7Q0wFHVwcdHHD0M9GvAUc3Et0ZcPQS0Q3UerDnB/0RcHRI0OmmToIe
DnrT4OjwoJsMjv4Peljg6A6hAwWOPhI6QeDogqLvA44eJro84OhAoocIji4i
+oDg6ASil00d429efxLdZ3B0O9EvBkfv9HWv2wuOHix6narz6nU70akER68S
PRpw9BvRMQRHzxAdauoD6I6ipwyOXis6wuCPej1b9DHB13idTHR2wNGNRGcH
HB1F9JrJo9GPRacYHH1ddH/A0Z9E9wccPUb0yMgf0e9FX484Hz0idPTA0S9C
/x0cPU90zMHRQUWPGxz9WHSlwdEHQ39Nv495nTT0wsDR40V/Fhw9cHRXwdFf
RW9Ux+91R9F7Akf3CV0nzZu8vhM6hsT5fb1eEzr44OigoucOjn4suuTg6O6i
rw2OLjF60+Dos6G3C47uLjqz4OjNoq8Kjs4qulrg6GuhnwWOjhb6/sTn6MGi
Uw+Oji566+DoD6MbDo4+8zNeRxscnWp0csHRy0UfFpy/d4C+qvbjdS/RGwVH
PxM9feJk9IHRhQdHVxl9c3B0p9H71u9cXn8bvVrwp71uLXqv4Oh/on8Kjo4o
evTEmeg/o6sOjj42OuPg6ISjo0ochZ4qOqpax/b6qNvHfljA0cG0+yN6l+Do
vKF3yf6CXtx/vV6kfgfxOnujve4h/aDv96zXT6Q9OoHoA9r4AZ1Bu5+i32fj
EHQA7b5s4iX9joY+LLyhe4Y+LDj6aejDsi/wftGHBUefDX1YcOwEfVhwdN7Q
h2VfwM7RhwVHLw59WHDWC/qw4Ed73Tn0Utlf8A/ow4L38Pp16KiC42fQnQTH
v6E7CY7+JHqa1OvYL4wf0/7R0bPjMf5Nx49urNYVvf9HNxac/cLsXzoedDDB
zX4XzoP49mY/yhL7kY7HjFMS49R9zdRpVbfN1GmFOq2JH1T/07x33RfM+5UE
/wL/Jp4R7MrEM4J9mvhKsHMTXwnrBR1D/BV6hiZuFNYjOobg6Bk+GceTwro2
/srhr0w87/AbJt9x+Bnjxxx+zMT/Dn9l/KHDH5q8ySX8nvbjnyv2ucZ/aj/+
uWKfa/ykztfzI5Yf42+VB3RRaU9+hP4p7ckf0TmlPXkWeqa0Jw81eZDqlJp8
UPVIzb6m+pPmHIXmyyZP1PboQrJfoE+ILiQ4eoboQoKjf4j+Izh6ieg2gqO7
iA6jxdFbtP2YemBGXYt+8D/oRprvUML3FMYDbto72958NxS+f5nvYo1wjff8
91zzXVj4nm54cwneXII3l+BN+0GnEpz3hU4lOO8XnUpw7MHUl3LUf0x9KXd6
8fpSLlFf0vboUbLfofcY42UZ+pDoQiZwfe+J9gk8LzyXc3iMk3sxDe3COaWG
Wa4M+n0e574Jum/g3MNCvwyc+2ucuwJH/wd9luLtwzkl+lf9DjMezp/ZeTFf
4kn0KJiv1pHMfMHR62C+4OiiMF9w9GfQHQNHz4dzbODoI5k6cA5dKc6x2fbw
afuHz+LjCeeUGD982vnCZ4I3Z3mDz1j3K/Cp53y8Lgp8gqM/A59aR/I6P/AJ
jm4SfKouiNehMt8vMvS74NO2h0/bP3wWH084p8T44dPOFz7BY52WcE7J8kl+
YfkER38GPsHR+YFPcPSU4BMcfSrVg/M4el/m+1qGTprqf5n28Gn7h8/i4wnn
kRg/fNr5wic4+jbwaXmL/UAhi88th/NIxf1AIUP/J/YDBdXVjP1AQfUhYz9Q
UJ3D2A8UVK/PfBfO0KmL/UBoH/uB0H/sB+x4wnkkxh/7gTDf2A8UslgvKJxH
sjyz38Xnh8N5pOL2nM/QX4rtOa+6prE951WfM7bnvOpMxvacV73E2J7zGTqB
sT2H9rE9h/5je7bjCeeRGH9sz2G+sT034s1Z3mKey7JYrymcRyrOc10e4/Wv
Yp7LVFc25rlM9VFjnstU5zPmuUx1LE2em3GuPua5TPUtY55D/zHPdjzhPBLj
j3kO8415bsSbs7wZPiXBpyT4lASfkuBTDJ9ar4BPw48k+JEEP5LgR2I9tHAe
qTgP+QQPeUmsX0msX0msX0msX0msX0msX0msX0msX0msX0msX4l158J5pMS+
I8Z/Kp7YdySx70hi35HEviOJfUcS+44k9h1J7DuS2Hckse9IYt+RWGcvnEcq
7vdqxOz7iifiJUnES5KIlyQRL0kiXpJEvCSJeEkS8ZIk4iVJxEuSiJd0viYu
asQndTYTlypu+dTzPMXjeUnE85KI5yURz0sinpdEPC+JeF4S8bwk4nlJxPOS
iOclvvcUziMV9wNNXSIPdcX9QFOXyENdIg91iTzUJfJQl8hDXSIPdYk81CXy
UJfIQ10iD3WJPNTy5ixvpr6huh+mjuESdQyXqGM4U8dQnDoGfIJz7ww+wbmn
Bp+2vamTOO6pmTqJS9RJXKJO4hJ1EmfqP4rDJ/oOtt6CDqDWu/z9YvTswLnX
jC4bOPep0RcA5x439+rBuW/OvW5w7ndzH9vWkbhHbetI3H+28+Iesq0jcW8W
nPuz6B5SD+FeNvp94NwHR4cOnHvo6DKAc/8dPQJw7ulzX13rM14Pinvmeg7K
6yBxPxwc/R/udYOjh8P9bXB0Y9AfpF7R1esOoaMHvtzrNaEHB47OFfpoqs/k
dcDQPwJHrwk9F3B0irhHDY5uD/elwdG34f4w9QH0prgnDI5OF/d7tZ7gdcy4
NwuOPhI6QeDoBXFfFBxdHfTvyKO397ph6MHp+SKvq8Z9cnB0h7g3Do4+DzoX
5I/otrGuifO5L8+61u8FXq+JdQ2OzhXrGhx9MNY1OHoUrGtwdDlY19re662x
rsHRGWNdg6OryboGR1eKdQ2OzgDrWvMpryfAuiaeR8+Kda15h9cBY12Do5/G
utb8wuvLsa7B0f1gXYMv9vpprGtwdMNY1+DoZbGutX+v28C6BkefgXVNvP2D
1z1jXYOjF8e6BkdPj3UNjq4g6xocfTPWNfhkr+vFugZHN4l1DY7+klnXsoXX
uzPrWvUAzbpWXUSzruVsryfGOiWuQ2+QdQqO7iL6EcQn6FmhY4VfQp/K+DcB
R+fI7jvoGYGj44GeEX4bPRD0jGiPrgh6RrRHnwS/AY4ODPovdl9GR8buU+iz
2P0dnRe735k4JEccgt4WvKGDga6WnlP1ehq0xx9iJ+hzgaPXQT/g2Bv6XODo
fqBXhV9lHaHPBY5+CDpW4KxHeFPc+wH0d8DR/4F/6lT4T7PetX/s0I7H+AEd
P/am9TfvD9HtAsd/Gn+u4+G9gxv/r36b9sY/Zwn/rOMx45TEOCUeZziHQ73R
1CeF+qTZN1V/ybx39Z/m/UqCf4F/s48LdmX2ccE+aY9/QE/GxD+C/dMP+Fde
T8bERcI6MvGnYz2a+Nyxfo1/cLF/COdn8AMmnncJv6Htsf/i/YdzMvRj/Ikd
v9jxowNFe+Jw9J5oT56CrhPtiedNvO3wn+g60Q95kMlHHH7YxOeq42TyFNVr
MvuC6vlQT7B5nMlftD36O/jbWAcmnJNBN4Z9VvMvrzPDPqvf970uDfssOPo2
6N1YHF0b24+pU2XUW+gH/4A+j/k+ItT5432/TEx7Z9ub71nCdxnzvaYRzvrl
O6PhxyX4cQl+XIIf7QfdH3DeC3EMOO+ROAec927qGznqD6a+kUvUN3KJ+oa2
R9+HfQf9nBgvy9DbifOmRri+30T7BJ4XnmvO1+k5Z39OW+Mozmmb83t6/tmc
u9Nz1P58o9ot5xv9OUnFOSfpz41r/su5cX/OXHHOmftz6YpzLt2fe9dzApx7
H9FwTl7XN+fk/bl6xTlX78/hK845fH9uX3HO7ft7AUH3w98L8PcINJ/lHsH4
hnsH+j2aewf+noLi3FPw9xoU516DvwehOPcg/L0Jxbk34e9lqB1yL8Pf49B8
mXsc/t6H4tz78PdHNE7j/oi/b6I49038/RTFuZ/i77Mozn0Wf49G1wX3aPy9
G427uHfj7+kozj0df69Hce71+HtD6j+5N+TvGSnOPSN/L0nx+F6Sxr163tic
JxfuQ5nz8ML9KXPuXbhv5e9naf643t/P8ve5FOc+lznPL9z/mh6f2xfui/n7
ZYpzv+yhhvto6ke5j+bvrynO/TV/301x7rs9Fd9TEO7HmXsKwn26HeL7IML9
O39fT/NN7utNarjfp98vuN/n7wMq3t7fB/T3BxW/3N8f9PcNFee+ob+fqN8j
uJ/o7zMqzn1Gc9/Ecf/R35fU+JD7kv5+peLcr/T3QzWe4X6ouefiuE/q75/q
fsr9U39fVXHuq/r7troPct/W9JNbuOO2zQdtWJn9Go8/N23UD20OnlBl+881
Wzy3uur2Sjuv3BVH7LvkuuOquVer7blXa+67Zdx387izuLlXmCXuFWbcKzT3
+7Lnz+20VffpzXO+vbPtff/O9m/8iST6kUQ/ev/RzEvv9xl+HPyY+8iKm/u5
Dp7NPWXHezH3dh3v0dxfdrx3f+9Y23Pv2N/L1vbcy6YOwHun/mPyGq2rUJdg
Hydfo/4ATt7H39sAp+7E358Ap05FnM9+TV0rjp9r9O+SEGeCUzcjzgSnzkZd
i32WOh5/fwicuh9//wOcOiF/DwOcuiJ/BwKcOiR//wA8rluG/Z26KPUucOqo
6HSDU3clrwSnfkv+CE69lzwRnPowur3g1JOp47G+qFdTrwOnvo3OODj1cPS7
td7i6+fks+DU58lPwannoxcMHtf/w/5OHcPUqfTvwpg6m/A9wtTThO8X2LPG
A/57B/YMzveROP6vEb6n8HfadH/331+M/Qvfa4z9SxP/fcfYv/7dFmP/+vdK
TH1S+N5k6pPC9ylTBxa+Z7FewPn+xXoB53sZ6wWc72usF3C+x7FewPl+R10L
/8b3Pupa4HwfNHVm/Xsipp7s+P7I+tLv+P57JfU6+z3a1Lf1+7WpY+v3btaF
/T6OHrTtx7TPoeNtxplDD5z1Zb87m+9oGd/RzPcs1e1nPIn2up8m2ottr/m+
H4/5Pq64+V7smJf5bu7gAX9Fe75r4x/0vpX5e4X6fb/82d2G3cj3sFBH2uOC
d/rU38fBX4NPXt/6l+1erVT/C372f/eo3q+F/n24UE9o0ueV0z8I33vA7xr7
kaz4s36HDnrMK/9391/+rd/d9fvClPVvbniv/0r9Ds08Nr1SeGqnDws6fvAz
fuj3a9U+q3T84DO6DDp8/1vDOTzwPUffP9ZdE86TgW/ds+vKHbdepePU7/it
j7tYXtJ+9fv7nH2XDjjkPK27Kc74GSfz2O+vJ/f64176PU/xrzZ76tBLLgv7
H/gx80+/c/99wjlg8Js7fzz3htM26PjBH7hs2O6jn1qj4we/bkT1my3bhnNI
qivi58X4weP3Evg+bOutLl+2Ub+/Kr5g0s3/eujdEl1v4P0/+POhXW4P59LA
7/fjZDzg7T3/jAcc++G5jGvCO/cumNqkVJ8LfuR7h5WsrynNxe+rkHXy7z1+
X4Usttsyfc6srm/f958F4Z4S6736h+/afdhXeVb/MPKyh76pOV7fS/gu37r0
qvbDw70F8E9fbnrR62tKczGfZbLTurcOXbo81DfBP47GE/6eKvPFHsAHFOW/
TLCfmP8wr5j/Mnm395DL6/OCmIe8PHVQ/5/r62kxD3np9/feW7fbuN7wkJcZ
Y1a9etxLJYaHvOyxxTK326qmhoe8fPOXB9rOfq+ZmW9e4vce/j4VdhjPNy+s
o3i+jcfPc14Y0XlUfT0q9jN18f2b2ffbvrTR+JmCdFv+aMk7fUJcCx7Pqyz0
E7338He0WF+x/ylI7B+CLscvV01Y2s+tt+tUx2nWqfJv1qnap1mnkvBXhh/1
V9I3eu/qr3RdGD/p2I/w+9hXvE+VhfpqtL7yivNc+AJnnLF91qgfpn9weIjX
XU1m7FbxmOdQd+W9GLvK7HsEj/1qmeZNxj8ojl3F+1ohi+0w/N17xmnsSvkx
6zpLrGuzH4X3z7oz69r4Z/37jFliXWfxegl/vw7+zbrO+kXvPdRhGD92hT0W
92NlWcKf231Wcfyq8edZ7IfVn2f4bePPM/y88eeZ9Q+aDxZdp2W6Low/13nF
dp4X9rV43RWEfVDjG493iuIltU9x8XwV573H/NcI+3jMf420j+MuXU/ECWad
CnGFWadi7FBx1hfjgT8TfypOXMR4wImjTFwnD5hxgsf2o/7K7Efh73V8GfsH
xfFXxk864sz4fdXFOz4uNfGzY14mfnbEvSZ+drx3Ez874moTP7vTfRxu4mdH
3G7yEWfjfHDei8lTXGw/IW6N47e85kGJPMXFeU34DhvnQSE/jfejoMv0tPcz
8f7eNGfXHe8N/xOvI9s+fK982vgxePqs9233HPKvRnabWZ7h7/QoP9J1nX0U
vUf1D+qX4jgwn8GniZPFtNd1GfMf/t7sR1FepvG/mHHqeRjmZfIUgQfzXlzi
vTjzXrS/xHtxifei/Ru7zZnxiM2XjT/MsDfjhzPs0/CZmX6c5dnkNWL6UZ55
Lv3a9WLydBfPK+iPwZvJFzKDa95kebb82zhw5x0P2q5u3YldLzM/v6VN3XsR
a//LZz3xTJ2daHvw6VMLc+v2R93/wDfb7PG2dfGD2PUysu+jhTo7FBs33nfz
1vV+WOL1UpOdu9fyQe2Hh/O+4D/PvPKVurhF3wf47H7bza+Lx8S+9/fGXfNz
3fsSu05PeP9/f6pbL2LjyQHDe9bvF9ov+A7LT6/f7wxvhaz6rtoL6uIKF9tz
Xf67bZMedXGXjhN8xr1VtW/3CffWwL8w48eOJg/5XaHOfsTGje8tWnFH3X6n
4wTvlPvys7r9WvNw8Hd6NP+uLn5wMc/57Ks7nj6kzs8YnvPZ86883qYunjQ8
53VeNp7kvdh4spW3BxsH7lC1tH4fN+MvyxZvGnFIXRxixl8X7427ZuO6mvB3
zHVd3H/JPXVxlxlnmXkvId7Drmy8F9tziOvo38Z1c57t8HTd/mjtStZuNuvZ
uv3d2omY8SvOe7Fx3ZKvXzqkbl+260gmlZ5dUxdX2HUkOx02eN+6eMmuI4FP
G9ftFduJ4ti5jevey386qi5+sP5BfvdK54F18Y/YuO7yg/t9WBfX6fsFt+ME
j+0hxHXYuY3r+sfrVHH8iY3r/nj8Gevr4iLzvpq6G3ZYc2VdXCc2rmNeNq6D
fxvXFX/vTZ31q/hnxmPjNHi2cVpsD7/Zl2I71PhqF+/nzXNzMR7qzPRj4rcc
z7V1ZmMPar/My8ZvMQ+hbhzzFurGxs4V573E8U/THO/R1o3j8YS6BXZi6jBZ
bFehbhz721A3Nn5M3yd2buvGrAsTj2XMy9aNY55DnhHvR6FuzLqO48ma7Afv
B2zdmHGauDGDf1s3xh7i+LBg9xfF8XsmXs1477ZuHNthqBvjh219OPbboT6M
nzf7iNj9WuOo4vuI8duhDry4KJ9l6sds/ZZ90OzXYuIZxeN9NtRv2ZdtvsA+
bvZrid9LqOsSJ9i6LnZu42HiEBMXCXFL7A8LEsc5oX4bzyvUb+1+DY6d2/ot
cZrNg4jrbNwex4GhrkvcaNaRvhezjqR4/FAjsT8J8RFxr/EnsllkD6Guiz3b
fM3E4brv4FdtHZg43+ZTF3U6+s66vMPud7m4/1C/ZPxmv8vBs83LsBNbD2Sc
Zt1lsd0Gu7D7JuvL9KPrOtFPo/Zar4jGGfaTeF6hDmPyF8XhzeZ38Gz26xx2
aMajvNm6BP3YuoFtb9epzevpx7yvRjxoHOLH+f8A8t8IUQ==
     "], {{
       {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJw1mgW4F1XXxWfuDHP+9yBKCCoWoSggiIEKgtid2IAiiCgoYHf3+9rd3R2v
BYiCdEmJAhYI0iEloeL3W8+a73nuuXv9z5zpc/Zee+1p3HNA5/5VSZL0zZKE
v2RgkSR1sC9nbsK/MuCCNEl60X5PbHenzQMfmifJR9hrGHttSJIp4Hfo+x68
DHwP9nO27QEusE0rSbIcfAv9w/l9ALgu9nT2aQD+GDuXbRvAv2Hn0NaDZ2M/
Zdzu4Bz7Ga0NuAZ2a/Z5EzxAfVzXAh2TdhT9/CXzuP6TANxaMh/8E+POALfE
/qhzg1tgZ9FOAzfHzqSdCt4VO4N2CngXbMr138exsppJshX2Dfr709+Y/sXg
m7jOY+ivB/4A24T+peCb6T+Z3/XBH2FHsE8ncD2dh99sThZwbceBa4B/Bzdi
34XgG9l4Av1bgj/E/suNHAteSP8C2l+6L+zvtI26X+wOjHsffAXH3wb8Fvhi
vWOO+ZCeC9ffFPsZ/dfT3xL8Ffh23Uv5Tq8G7wb+GnwHuBH4Q/BV4K7BY/T+
e/PMd6O1pLXn93T6H2fM/poH4CfA++aeG4+Ah4O3Y+xj2B1pH9B/Jf2twEPB
d4JbgIeAbwOfy9hmtJ/4PYPzrsDei31N7x68iGd1FuM3B68Bnw1eA76LMT/r
WZS4LcdYCd6K9j777oL9h/EfgHcFbwLvw5jViY+7E8f5HHsD23cGf6F3AZ5C
Ow7cCNuM/oF67+CrOcck8OYxSQ6mfzb4Jfqvov9b8DY8+w70/wB+Us+Hc/0D
7qa5zu/u2D2wNej/F3wJbQW/B2A7Yf+gXQw+EFuPY/bQnOd4g2mRfa7GHogN
tEvZtp4x12C3w65mn8vBh2DX0q4EH4atyz4vgM8HL6P1A3fEbmKf/2iNcM1f
MaYux7xNz5VtV+i9a14x5nxwyv1uAF+r9cL4nN93gHem7x/a3Vo7wds05jVw
Q9oF4CrGVnPsg2lX8fugzNd+uRYufR1Tj9sSe3jq/XfjOI9hB3OMzeg7hHYh
v4ewz03YS7E3aL2nxhnnuFHvi/H1+P0i+AI9B37fDP4L+2vm99AaW5v9Dk29
rT3n+rtca3PYdja4DXZLjvMSuA+4JvhJ8DngBbRe4H2wm7NPV/BK7Hf8PhHc
FNs+9ZrVHJrDWm5d+rd5md/pXtivaPuBa2Hn0s4B74ldSDsPvC92cebn3w4b
g33aP9XMWa4n5RwXYRexrTf9+2Gn007SvNYckz8CL8F+ye99wDWxQ7RWwZth
26X2w/LRy/ndXxgbOO5D4K7gAvwguIswz/lRXSfH/Ffzh21V+JkDOE5WvqOp
jDse2xg7gXYEeFvsONphWiPYkbQD9c6xo2gHgetjN+N4T4F7aC3w3DqWvm4i
v4/UPMeOpx0OboidRjsB3ATbVn5E751jdKTNAD9FX0+uayfaj3p/XP/b9N2p
tQV+D3w3uDv4LfAd4Fejr+9rnvNr0dc9FHw2+E3w7Yx5Pfo6htF/FvgN8G30
9wJ/CL4P/Ci4DtcxDPwIuLZ8H/hh8BbyueAHwbXkB8HngT9i3/vBZ4JfAV8P
3gR+HXyr1hr4VfAN4Bo89ycVV+gbTrsi9zr9Jnr9z+DahkWv5x/AQ6N9xPfg
IdF+5zvwV9F+Zzr4y+h5MA38afRcnAQeHO07poKrOe+fmdd4BXxV7jX+GK0+
+Bv6C/rfzO0nP4+ex1PY97Po+ToZ/AW4T+75PCJ6ns0CPw5uAB7Oce4HR/Ag
8CXg0ez7NPhi3Sf4KXB/8FDwE+C7wCnjP5ZPAleB/we+FDyGMc9ozoIz+j8B
XwYeS/+z4AHgYeAnwX3AX4Aflg8DfwJ+SL4Q/D/wg+CLwIPBj4H7gb8GPw6+
HPwt+DnwM+AmnGsc+Gnw9uCx4KfA24HHgJ8ANwSPAt8nX6l4A74XXFFMAt8D
rqFYDv4vOAd/Cu4N/phzPQB+Htyc/kngF8Hv0P85z/Ol6PX/JfhZ8C6MmciY
J8HbgkeDHwJvLn4Afg68K/hb8CvRfuor9n052ncMAb8A3o8xk/VsaWMTz8NP
ov3jt4x5K3p9jgCvBF/I+BWM/RP8sPgJfned/In8OHgj+FlwLfAG8NPgmuJc
0bH8C46zHvw4/RX6F0Xzg8/oXxrNHQeBp0TH8gXgSdEc6HfNc/zJNonX0brg
eNqB4yyL5pqDGbMkmisMBK8Gi1zOBG/LuBaMb4uNtB3Ej7F9grnT1uDWjB0J
/i/79w3mObU0F+hvxPjnsD2wTWizxAP0/rH3Mb6N3oM4D3h3zQXwPeA9cz/b
+xVrKj5OG+y0YG4u/j41mqMs5DpbsO1O+j/UXA3mV/XouyCY+zUA91Y8AG8B
/l907JnIvtOiOdki8PRoXrgE/G40Vx4Nnl/ynj/BI6Pj4o/g0dE842fwj9HX
vRL8fjT/HgueFX3Pf4A/iObo48AfR3OjCeA3o339cPAb0fHjG/Db0fF1JPid
aL4+CvxeNKcfA/4oOn6PB8+MfqYrwL/If+Z+F79G89dV9I+J5gq/gCdG89S5
4B+i3+Uy8LfRnHgeeHI0X5wPHhudG/wKHhedn8wGj4/m4nPAE6I5+m/g36Jj
0lrwnGiOuAb8XTQvXwyeHc2nV4NnRM+D5eDvo3nzUvCo6Bj5E7gveCD3+wjv
sxXv8lXe6YhgTtQpNbcczZxviv0P/aPATRLHu7HgnRPnbvKdLUTF9D7ob1Zy
7zHgnTSfg33MtuI5VfZ/24FXC2sugLvn9pc6/gb6vyucDyovHJT5OH9V2V/q
vH9X2V82BysplX/dHri2yjGwoXhxlWOp1uyyKvvmluKTmX3/bto1s1/fC1yd
2ZfvDY7YdzPntnOqzGduAR+fOYbsCa6U3EPXGTL77HZaF4p5tPbg2pnz0x7s
/280vxJXaZD52evZbuT434MPBm+VOUc7V9yWGDiZ3/sD6ygG0w6Rr8js428D
nwj+mXYUeAetcd5brdQ5gLiiuNzOOiatM7iZeAn71mPM7dhminn0f4Q9jL46
JcdeJD4hPsA17KqYkTgm/l1tbqZkdLl4hi5TXE48RvcO/kLxnOP001rldxdx
Reyg3DmL+NVqfvcUf1NSG82HGwTH2+vAR2WOsdeDjwa3YtsDmg/YX/h9NHhH
7HraRYnzkY2Z+afyoMbB7+sv8Bap57Tm8/bBx39dcaTMLxqW/ryPeKZ8m+IG
46/JHTOVFxybOWbeAD4GvCFzHiSu+2/mfEe50j+0yxLnUH9nzlMOxm7KnFsp
J5oSrEtMY45vFp0PKi+cnJtnvpQ7bt9K/wmMryE/Cz6LMVO1lsDdsIH+T8Bn
B8ftd8GXZ+aDel+nal5wvG1Sr21xxnuxp2fmlfeDz9TcZ//HwV9ij2Bs/dQx
QLzpduxJmXnHc+DemeP8PeDTMnPS+8BnZOYpL4MvzKwPKPeRZnRC8HVOUA4V
rM8049rHan7oGnJz583Af1SZIzPtkuXg01JrQRXdT2qdRFNG3Faa1Gz+/RKc
H03leX5ZWFcRvxUHeQd8WWbO8jb40sx5mXKTbuDzOObaxFrAkML6ibSUU1Jr
NdKDxPdrYVdxrhidpytfF1d9WO8lMw96BtxLazM6piu2S9MYJp+Zme98I18K
fruM9f2D+cA4XSe4ZnTcV/zfUO3r0XU1rPg4F2quVvseda/iFZPB19C/A3gq
+DrlksH61uDCsb42eBC4LmNe4NyxpvnAeM0Zto/O/Ww7Y3/g92nKCxjzU7AG
Mp59qxk/GHwefQfRXgOPxB7Js9oqdb4t3v2I5mRmfvqsxuvdVswZxB3EKxuB
/6yyj20MXgeeHoxHcq5ZwXFE8WRjtf2kYpF47tPgc7X2qx0vFJdmBms2+1Ws
7SgWfEP/j8E6TTv6awXn76uCuaHu5VaOc77yTtqcxDqRxndhe5/U82Nf2jod
O/V1zy48h6U9SmfaO/W5l1Q51nTLrVFKq9RzlNYpXetRxYqK+Vsd7F70T6D/
AfoPyJ1fPqvYUrEfqI/dW1yb/gc1b/ndNDUfa0f/d/Q/lllD3Sv1+d7PvS4O
x76XW196N7d+cTP4Hfm/3HqRNKKuqX1dX62x1L5SfvLG3DqJ9JKNwfjtYO3w
jNTaoubh0WzvEj1Xjwd3jX6erWmtaNtzrSMYu13Fc176n/DcKs/hI3Vt1Z53
3dh3CX17ptZAF9H2SL0G/g7WXOT/a7N/49T8U3xfa2ckdt+Kn4F0VPnV18Tb
la8w9sTU61br9xXxMXF8+k5I/Xw1b/QOpTmPKDnzE9h9Kr4WabajcvvqN8o4
dlD5rOoH6wZrsANzx96LsZuwHVLHub6pNdDO5VzTMzqZti3t6NR+oXXp58cH
34/u6xnsQeKY4BcUzxnbPPWa36tizXMrbNvc9/cQYzrl1kGfE5dh266pdcUD
xa/pf57+fcp7eRi8orB+I31Yz/W41H6hEh2L5mKPpW/Hsl9z8PjUc1f+Wz5a
/nlTYb1qcfCc1nb5Gq0hraUt9G5y64qHs/3u3HFmQskXupbzUAeTPxEX/f9a
wrzE61DHkq9WzqdndZ34em7OIm1TeaHi47WZ9chu0jz5fVHq4/CXHJFZIxT/
2VRtnjIwWsM7M7UeJ91W9yIONC43T5BWtn9mjUrcQDp5w9Rx7cHcMbZfZv1/
69S+sV95zVuU93FBeQ2aC5oT0xJv71fGIY3Rtap2MqCcJ/JL/cv5o/GdS9yy
nEPnl2vtfq7hFV2nYmPFcV9zqUa0LntnmfsO0jwv/d6Acq3qeDqHNPpjtG5T
z787c+u0nRnfgL6zU/PFK4Lfr3zULhWvh2X0zc7MA3fHLg1eA9IP52deI9LY
9q/4fUvzXFlyJGm6S8pnq2fcJbU+KU7WqeJzi5/ofcbynZ6VmsdKv761nAOa
CwdU/O7FaZV/S6M+ObN+IL7aStdW8sYO2FUlZxNP05qulOtaOfo5tJmJ32f3
1DxJObTycOXgip1aE/LnVwb7Eq3He3PHw4niYrk1z+46F/Z09mXaJZeUvkI+
Qzz1FvBx2OYV81X56onlcaSTbllyZj1n5Wd5eZ2yNUosrb+HYpLuNzp3ejRY
X5QcsRS/e2V0XvFCySFVZ5F+Ip4pfyRdRTxzbuLaTfNgvicdTH5D/vRV7Oml
DiC9SDq+5skHwbmyfJT8pGL3idhzOedpwTFXulDT4PzlvWCdWff1anD9THW0
89nn1OC5Kq1J+YLuU/enG7kM+7Xy6WCO+j62STBnfjdYxxdvfyu4xqEY17Hi
3OPc0mdr7YsPiBfI1+nd6R0qHsnny/cfmTlfuCN3nUDvRe9HdQHNE723HYLz
lDd0jcHPX7lXh3KOXct+OwbnDm+W3Gw+eMeK+YnmxM4V8wStY8XrNqVWIy1L
61d+skV5/Vpru5QcQD5AcXWnin2xtCzpptKa3srNi9Sv7YojigWKi6p3XI+9
GdsvmDdKi7somKuIt3YPrv1JQ9gvmN9K3ztJ7zixJnZicH1Tmkbn4BqrdLN2
wdxPGvW+wZxNGvXJwXVGaU3ngD9NrJOcEVyLlI4hrjwM/AjXsHswV1f+vVtw
ziINs2Vw3iENs0VwXiM9tk0wJ5fmKZ6tuKoa4h7BvFS66P605xPr6j2C63fS
eQYE62bSTy4J1takt4i7KvZJSxQHlm+UfvhT4Xxfmq04/8uKu9E5r3yXtErV
JqWhPZ+b22vd/BydL/eXL47m9MPKZ67aqnS2FzVPg+uG0sFUL5EPkY79TGaf
JD3w6aysU+TWDZVTaD5cHKwHSiPqGVyXlG6mfENjpF8dHxwrpS2LG4hLiBv9
XFi7kB4+v7DmIN1bdTr5W+mZyrmk20gvVY6geqg0T+V34srSQhewb9vEtY+Z
hfMIab+LC9etpNHNKPUiactXROsmzwfnyL8l1n8WFa43ScdTXNc1P5C7fqS4
oPhQBPsN6cZrCuse0lrWFtY9XmR7FtyvtbmwcD1L9RdxCHEJ1bz/LFzzeknn
L5ynq44zt9SjpPfMKlwLlqat8Ycm1hLXFa5PSeeUPiWd6gyOeWxwLqyceETh
XEy6+urCWpCuc3j5TYXyIWlYyl+Ux6wvXKuSPqm8TLmwvo9YVbj+JT1zY+Ha
lrTQlYW/GZBmrhxKtWzp3vqGQP29cutoO4FPAafB9S9pp0qspe1I/9xQuO4m
3bUquC4pjXfv4Hgq/VBaUG+O8WG0XiT+pFroIeAnEmub4kPiRfoeQrxE/OQe
8MHB9VBpnh3LNa68vE5wjVt1pWOC67DSTg8NrutJF5VO1CtxHWqr4Fqn6lNb
B9cxVbdqn7nu2Tc31xTnvDJ33fkWcRrs0cF1bWm21cHfeKjGJA1LHEa1qkrw
9x6qN9UNrrGqzlU7uM6rOlf7YG1EtbmjSt8izbZDcN1T+vCvPM8OietN+jZF
+aM0QX2bojnWE7yssK6l+a/vXcTJpQP+UlgDVF3pn8J62it63oX5zMvgeeVc
0vxsG1xPl66+nP5jEsd6aT3ynzfl1tNuTlwvax3MPeRjQ/A3LarZyU9Kc5Mm
v7SwxqialGq4dzH2AezvhXVL1dQWlGtBtbDjgr/90JxXnn4stmc059eaHZq7
zqaavWKr+KrW9FrF4cK6rmqg0ggaJdaHVZ/UdwB6j6phKoYeobynsP6suuek
whqv6lnSPqSBqAY6ubDeq7qbtBLlT6pBKH4rjutbAvFAfRchbnFJGev1jYA4
h7iHcjrVKsU/9T2F+K14yh9c87DCmrbqv+J+4ovDcmsQWsuqFy+sMu+T3qVv
crQWV6h2UeVvkHQv+sZA6+iz3Fxa335ojUkTaVz6B+V6yl0Vb17MnBsq1ktD
0Zhzcn9fpPxZz1016gWJc21xbHFvabTSHKRFTMqdUytG/RVdE5qXWEPQt0bS
wZTb63st+YwF0fxZ9XrFMH03Je1IGpLqsUpwtO70PZLyefE/5RHSFTVvlN/J
B6yJ1qzEecR9lEMpn/pG5yqsyas2Mb2w3q5a6g+F9Xlx2hllfFH9VN/8yNcu
5Jjrq6wLHZI7F5aWIm1V+oni6t/RceW3coy+rZJfHZOb74r3Hpa7Ri3eKD1Y
34npOyvpHUML1zJUx781WvMVjz0z+Dsl1by6BH8HpZrL9YxZl1lzPqCMBfJ1
N0Tr1+KN+jZpTenzOwXrqKqD35VZD9T1XBet44sn3x6tO4tv3xitR4tb3hSt
g4v3HhmsCatG/HqZe3TlONdGa+jyIddE1w/kQ6QLqXYgXihu/17iWp6+EVAu
JI5xYLAPH176Oo1RPfq2aI1bPPyq6HqGYq44s7QjaUhTeG6tEtfBb4nWx8XV
pe3IJ62K1gdUg5CPPjxYs1Vd++vCNR19I6FcT/mdvjnSc9X3PeLYV0fXSBS7
lVeKJ6vmoG8I9X3gJ7m/G5SvXc7YxVXOifRM9L2WtK1PwUcE68aqa9ct9Trp
dv8HK/VK0A==
             "]], Polygon3DBox[CompressedData["
1:eJxFmnX4FdXXxefec7jn3guYhE0bYHeLGCh2/pRQCTvAFru7scXuxkQEJJQS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             "]], Polygon3DBox[CompressedData["
1:eJwt1nfcllUdx/GL5354BktWsWTEngqGiAwxEBVIUGRFL0VANBeYsxSkRMli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             "]]},
           Annotation[#, "Charting`Private`Tag$33352#1"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
           "Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 0, 2}]}}]}, 
       {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJxFmgnYVtP6xt9v+/a29rdMCREVKgllColGTZonCQ1EZoUylJRKplKhaNKk
kAwp8zzPwzGHZJ4O55g5jul//9zrXP/rete17r3etac1PM/93M/eafiofiOz
SqVywUaVin6Vc2Kl8lteqbQpK5W8qFS20J9H6fh3lY2F+6neSO2bCR8hPFD9
BglfrvP+1HEpPEB1P7X3F75KeKzKnsItdF5Q2Ub4aLWNU58xOj5X55aq66j9
GLX/oRKE+6serz7n6r8L1KdHTaVykPAM4X9V69pVlUpbHb8uPFp4f+F/h0ql
mc6dpvO+FN5VuFON36Ui3EvX/Evlv+rfVXWV2n8X7iZcEf5N+FDhauHN1f9I
4UK4Sri38NO65lbCXXX923R8g/r/pfu/qTJG+HD9d4vaVwj/obaNdW6mtj5q
u1v1RSrVKmN1/n/UZxnvp/KL8C269vXqP0n/j1T9Tx03FZ4k3FClpfAFus7X
at+da+m8ndV+gPBEtf9L7XsIX6r2mWqfKzxL9Q6Fx+Ts3NeaLjyZuVWpL3yi
2rcvfO5ZwrWEGwifJPyjrtlCuLPGcEu17yh8stp3Et5feIJwg8J9xgvXE24u
fI7wP/X+V+i99lHbf3KPf0/VffV8/YT3VXs/XfdH9Vml+5yp443Ufo/wL8yT
2nuorlH7tmofLhyFtxM+Vrh+4XV1rvCHwc/GNb8T3ku4ifAqlWmMG8+usp/w
+eqfCf+h63cX/kL9m6i9o57lc+FdhA+p8b1Yz4epz0+Mu/q3Vr1Wff4UPkjv
cbPwz6w94VuFfxX+nnWhcyfr3FGqf2As6K/6W5VPhA9QfZf+v1DlpyqPz7eq
26l+VtcpeBc9w686/k7t7XPvyx+ED2H9qnwv3IE5UvlK+GDVP7MOhNuovlXl
euE/NQ/dda0pwh117TeD92Artd2m5ztKuLXqQXqHi9TnVtWrdTxE7e1Vv6X+
WwsfqP7X6pqz1OdLXXNAadxD/z8TbB9aqM9zwft3P+FDWW/sKbVdorZxOp6q
/btQ15mp9i90nTuYH5XPd