#!/usr/bin/env python
# The code calculates the time autocorrelation function of a sequence of data
# Output: normalized time autocorrelation function as a function of time

# author: Sai Lyu, EPFL, Nov 2019

import math
f1=open('DATA.dat','r')
ff1=f1.readlines()
f1.close()

f1=open('DATA.dat','r')
nline=0
for line in f1:
   nline+=1
f1.close()

g1=open('CORRELATION.dat','w')
g1.write('#k      Caa(k)'+'\n')

def avg(alist):
  return sum(alist)/len(alist)

def var2 (Alist) :
  var2=0
  suma=sum(Alist)
  for i in range (len(Alist))  :
     var2 += (Alist[i]-suma/len(Alist))**2/len(Alist)
  return var2

tau=0 # correlation time
for k in range (100): # k is virtual time
  print("CAA({})".format(k))
  alist=[]
  blist=[]
  ablist=[]
  for i in range (nline-k):
     aa=float(ff1[i].split()[0])
     bb=float(ff1[i+k].split()[0])
     alist.append(aa)
     blist.append(bb)
     ablist.append(aa*bb)
  caa_k=( avg(ablist)-avg(blist)*avg(alist))/var2(alist)
  if k==0 :
     caa_k0=caa_k
  tau+=caa_k     # tau is correlation time
#  print caa_k
  g1.write(str(k)+' '+str(caa_k)+'\n')

g1.close()

tau-=caa_k0*0.5
print('correlation time obtained by integrating C_AA(k) is ',round(tau,2))
