%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   Exercice 2: Methode du 1er harmonique 
%   Saturation
%   1) Gain equivalent normalise de la saturation
%   2) Creation d un cycle limite en BF avec cette non-linearite
%   3) Comparaison avec la prediction theorique de la frequence d
%       oscillation et son amplitude
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
close all


%Estimation du gain equivalent N(A)
a=1.5;                  %limites de saturation
k=2;                    %Gain lineaire
A=[0:0.1:25];           %Input amplitude
N=zeros(1,length(A));   %Declaration de la variable de gain equivalent

for i=1:length(A)
    N(i) = My_Describing_F_Sat(a,k,A(i));
end

%Affichage
figure(1)
plot(A,N),grid
title('Describing function of saturation')
xlabel('Amplitude de l'' excitation')
ylabel ('Gain equivalent N(A)')


% Systeme en boucle fermee sur la saturation
[t,x] = ode45(@(t,x) My_BF_Saturation(t,x,a,k), [0 20],[0.1,0,0]);
figure(2)
plot(t,x(:,1)),grid
title('Cycle limite avec saturation')

% comparaison avec la prediction theorique

w=linspace(0,100,100000);

% Creer le vecteur G(jw)
Gjw = 5./(0.001*(j*w).^3 + 0.03*(j*w).^2 + 0.3*j*w + 1);

%Afficher le diagramme de Nyquist de la partie linaire
figure(3)
plot(real(Gjw),imag(Gjw)), grid
title('Niquist de G(jw) et trace de -1/N(A)')
xlabel('Axe rel')
ylabel ('Axe imag')
hold

% Afficher la trace de moins la rciproque du gain quivalent sur 
% le mme diagramme
plot(real(-1./N),imag(-1./N),'r')



% Supprimez les %%% et compltez les %...

% Solution analytique pour la pulsation d'intersection w0:
%%% w0= %...

% Valeur de G(jw)  w=w0:
%%% Gjw0 = 5/(0.001*(j*w0)^3 + 0.03*(j*w0)^2 + 0.3*j*w0 + 1)

% On dessine un joli point en G(j*w0)
%%% figure(3)
%%% plot(real(Gjw0),imag(Gjw0),'*g')

% Recherche numrique de l'amplitude correspondante
%%% A0 = fminsearch(@(A00) norm(Gjw0+1/My_Describing_F_Sat(a,k,A00))^2,3)

% Synthse d'une sinusode de pulsation w0 et d'amplitude A0
% (utilisez t comme variable temporelle (dj existante))
%%% x_estim = %...
%%% figure(2)
%%% hold
%%% plot(t,x_estim,'r')
%%% title('Comparaison de la solution et l''estime')




