clear; close all

%% Generate the system
% P = tf(21.53, [1 1.833 70.28 69.44 0]);

% s = tf('s')
% zeta = 0.1;
% wn = 8.3337;
% P = 0.31/(s+1) * wn^2 / (s^2 + 2*zeta*wn*s + wn^2) / s

P = tf(21.5297, [1.0000    2.6667   71.1173   69.4506         0])

step(P*s)
%%

Td = 0.01;
K = 1 + Td*tf([1 0],1);

rlocus(K*P)
grid on

%%

clf
rlocus(K*P, logspace(-3,log10(53),1000))
axis([-1.5 1 -10 10])
grid on

%%

clf
step(feedback(2.58*K*P,1),feedback(9.6*K*P,1))
grid on
