%% Optimal Control Course EE 715 at EPFL
% Problem Set #5 
%
% Author(s):    tillmann.muehlpfordt@kit.edu, alexander.engelmann@kit.edu, timm.faulwasser@kit.edu
% Date:         April 10, 2017
%% 
function [PAR, CON, SC, SCx, SCu] = parameters
%% Definition of system parameters
PAR.alpha   = 30.828;       % h^�?�1
PAR.beta    = 86.688;       % h^�?�1
PAR.delta   = 3.522E-4;     % m^3K kJ^�?�1
PAR.gamma   = 0.1;          % K/kJ
PAR.TIn     = 104.9;        % K kJ^-1
PAR.T0      = 273.15;       % K
PAR.cIn     = 5.1E3;        % mol/m^3
PAR.K10     = 1.287E12;     % 1/h
PAR.K20     = 9.043E6;      % m^3/(mol h)
PAR.E1      = 9758.3;
PAR.E2      = 8560.0;
PAR.H1      = 4.2;          % kJ/mol
PAR.H2      =-11.0;         % kJ/mol
PAR.H3      =-41.85;        % kJ/mol

%% Constraints
CON.cA  = [0,  6E3];
CON.cB  = [0,  4E3];
CON.T   = [70, 2E2];
CON.u1  = [3,  35];
CON.u2  = [1E2,  2E2];

%% Scaling factors
SC.cA = 1E-3;
SC.cB = 1E-3;
SC.T  = 1E-2;
SC.u2 = SC.T;
SC.u1 = 1E-1;

SCu     =   [SC.u1; SC.u2];
SCx     =   [SC.cA; SC.cB; SC.T];

end

