%% Optimal Control Course EE 715 at EPFL
% Problem Set #5 Ex 1 & 2
%
% Author(s):    tillmann.muehlpfordt@kit.edu, alexander.engelmann@kit.edu, timm.faulwasser@kit.edu
% Date:         April 10, 2017
%% initialize
clear all;
% close all;
clc;
set(groot, 'defaultAxesTickLabelInterpreter','latex');
set(groot, 'defaultLegendInterpreter','latex');
linewidth   =   1.5;
%%
[PAR,CON,~,SCx,SCu] = parameters; 
nx      =   3;
nu      =   2;

dt      =   1E-3; % sampling period
% MPC time 
T       =   0.2;      % T has to be changed to 0.2 in 1d) for to consider 
N       =   T/dt;      % the complete simulation interval
tmpc    =   0:dt:T;
% simulation time
t0      =   0; %start time
tf      =   0.12; %end time of simulation
tsim    =   0:dt:tf;
ksim    =   length(tsim);
% initial condition
x0      =   [1.5E3; 1.2E3; 70.0]; % initial condition

% weights
Q       =   1e2*diag([1,1,1]);
R       =   1e1*diag([1,1]);

% constraints
umin    =   [CON.u1(1); CON.u2(1)];
umax    =   [CON.u1(2); CON.u2(2)];
xmin    =   [CON.cA(1); CON.cB(1); CON.T(1)];
xmax    =   [CON.cA(2); CON.cB(2); CON.T(2)];
% %% solve steady state optimization problem
% import casadi.*
% 
% opti = casadi.Opti();
% 
% X       =   opti.variable(nx,1);
% U       =   opti.variable(nu,1);
% J       =   -X(2)*U(1);
% opti.subject_to(CSTR_ode(0,X,U) == 0);
% opti.subject_to(SCu.*umin <= U <= SCu.*umax);
% opti.subject_to(SCx.*xmin <= X <= SCx.*xmax);
% 
% opti.minimize(J);
% 
% opti.solver('ipopt');
% sol = opti.solve();
% 
% xSS  =   sol.value(X);
% uSS  =   sol.value(U);
% scaled results:
 xSS     =   [2.1747; 1.1051; 1.2850];
 uSS     =   [3.5000; 1.4270];
%keyboard
%% Ex 2
%clear opti sol

% ##############################################
% build OCP
%import casadi.*
opti    =   casadi.Opti();
X       =   opti.variable(nx,N+1);
U       =   opti.variable(nu,N);

X1init   =   opti.parameter;
X2init   =   opti.parameter;
X3init   =   opti.parameter;
J       =   0;
for i=1:N
    % dynamics
    xx      =   rk4(@(t,x,u)CSTR_ode(t,x,u),dt,tmpc(i),X(:,i),U(:,i));
    opti.subject_to(X(:,i+1) == xx);
   
    % cost
    dx      =   X(:,i+1) - xSS;
    du      =   U(:,i) - uSS;
    J       =   J + 0.5*dx'*Q*dx + 0.5*du'*R*du;
end
%state constraints
opti.subject_to(SCu.*umin <= U <= SCu.*umax);
opti.subject_to(SCx.*xmin <= X <= SCx.*xmax);

%initial condition
opti.subject_to(X(1,1) == X1init);
opti.subject_to(X(2,1) == X2init);
opti.subject_to(X(3,1) == X3init);

% opti.subject_to(X(1,1) == SCx(1)*x0(1));
% opti.subject_to(X(2,1) == SCx(2)*x0(2));
% opti.subject_to(X(3,1) == SCx(3)*x0(3));

% terminal penalty
%J  = J + 1e9*(X(:,end)-xSS)'*(X(:,end)-xSS);


% ##############################################
% solve initial OCP
% set initial condition
opti.set_value(X1init, SCx(1)*x0(1));
opti.set_value(X2init, SCx(2)*x0(2));
opti.set_value(X3init, SCx(3)*x0(3));

% initial guess
opti.set_initial(X, repmat(SCx.*x0,1,N+1));
opti.set_initial(U, repmat(SCu.*(umax-umin)/2,1,N));



% solve open-loop problem
opti.minimize(J);
opti.solver('ipopt');
sol = opti.solve();
% plot
plotresults(tmpc,sol.value(X),sol.value(U),xSS,uSS,[10,11])

keyboard
%% EX 2 
% *% ##############################################
% MPC iterations
 [xsim,usim] = MPCloop(U,X,[X1init, X2init, X3init],opti,@(t,x,u)CSTR_ode(t,x,u),dt,tf,SCx.*x0,SCu.*(umax-umin)/2,SCx.*x0);
 
 plotresults(tsim,xsim,usim,xSS,uSS,[12,13])
 
 %% cost comparison
 xsim(2,1:end-1)*usim(1,:)';


