%% Optimal Control Course EE 715 at EPFL
% Problem Set #5 Exercise 2
%
% Author(s):    tillmann.muehlpfordt@kit.edu, alexander.engelmann@kit.edu, timm.faulwasser@kit.edu
% Date:         April 10, 2017
%
%
%% ODE right-hand side
function dx = CSTR_ode(t,x,u)
    % extract parameters
    [PAR, ~, SC] = parameters; 
    alpha   =   PAR.alpha;     
    beta    =   PAR.beta;       
    delta   =   PAR.delta;     
    gam     =   PAR.gamma;         
    TIn     =   PAR.TIn*SC.T;      
    T0      =   PAR.T0*SC.T;       
    cIn     =   PAR.cIn*SC.cA;        
    K10     =   PAR.K10;     
    K20     =   PAR.K20;     
    E1      =   PAR.E1;
    E2      =   PAR.E2;
    H1      =   PAR.H1;          
    H2      =   PAR.H2;         
    H3      =   PAR.H3;  
    % extract state
    cA      =   x(1);
    cB      =   x(2);
    T       =   x(3);
    % extract input
    u1      =   u(1);
    u2      =   u(2);
    % Arrhenius terms & enthalpy
    k1      =   exp(-E1/((T0+T)/SC.T))*K10;
    k2      =   exp(-E2/((T0+T)/SC.T))*K20;     
    h       =   -delta*(k1*(cA/SC.cA*H1 +cB/SC.cB*H2) ...
                    + k2*cA/SC.cA*cA/SC.cA*H3);
    % RHS
    dcA     =   SC.cA*(-k1*cA/SC.cA -k2*cA/SC.cA*cA/SC.cA ...
		              +((cIn-cA)/SC.cA)*u1/SC.u1);
    dcB     =   SC.cB*(k1*(cA/SC.cA-cB/SC.cB)-cB/SC.cB*u1/SC.u1); 
    dT      =   SC.T*(h + alpha*(u2-T)/SC.T + (TIn-T)/SC.T*u1/SC.u1); 
    dx      =   [dcA; dcB; dT];
end