function plotresults(t,x,u,xSS,uSS,fignum)
linewidth = 1.5;
[~,~,~,SCx,SCu] = parameters; 
ksim    =   length(t);
% rescale results
x    =   x./repmat(SCx,1,ksim);
u    =   u./repmat(SCu,1,ksim-1);
xSSp    =   xSS./SCx;
uSSp    =   uSS./SCu;
warning('The results have to be normalized for plotting.')
figure(fignum(1))
subplot(3,1,1)
plot(t,xSSp(1)*ones(size(t)),'LineWidth',linewidth);
hold on;
plot(t,x(1,:),'Linewidth',linewidth);
grid on;
xlabel('$t$ [h]','interpreter','Latex');
ylabel('$c_A(t)$ [mol/m$^3$]','interpreter','Latex');
subplot(3,1,2)
plot(t,xSSp(2)*ones(size(t)),'LineWidth',linewidth);
hold on;
plot(t,x(2,:),'Linewidth',linewidth);
grid on;
xlabel('$t$ [h]','interpreter','Latex');
ylabel('$c_B(t)$ [mol/m$^3$]','interpreter','Latex');
subplot(3,1,3)
plot(t,xSSp(3)*ones(size(t)),'LineWidth',linewidth);
hold on;
plot(t,x(3,:),'Linewidth',linewidth);
grid on;
xlabel('$t$ [h]','interpreter','Latex');
ylabel('$T(t)$ [K]','interpreter','Latex');

figure(fignum(2))
subplot(2,1,1)
plot(t,uSSp(1)*ones(size(t)),'LineWidth',linewidth);
hold on;
stairs(t(1:end-1),u(1,:),'Linewidth',linewidth);
grid on
xlabel('$t$ [h]','interpreter','Latex');
ylabel('$u_1^\star(t)$ [1/h]','interpreter','Latex');
subplot(2,1,2)
plot(t,uSSp(2)*ones(size(t)),'LineWidth',linewidth);
hold on;
stairs(t(1:end-1),u(2,:),'Linewidth',linewidth);
grid on
xlabel('$t$ [h]','interpreter','Latex');
ylabel('$u_2^\star(t)$ $[^\circ$C]','interpreter','Latex');