%% Optimal Control Course EE 715 at EPFL
% Problem Set #4 Exercise 1 b c
%
% Author(s):    tillmann.muehlpfordt@kit.edu, alexander.engelmann@kit.edu, timm.faulwasser@kit.edu
% Date:         April 10, 2017

clc;
close all;
clear all;
%%
nx       =   3;
nu       =   1;
% set parameter values
x0      =   [20*pi/180; 0; 1.5];
% x_term  =   [22*pi/180; 0; 1.5];
umax    =   1*1000;
umin    =   -umax;
lmax    =   x0(3);


t0      =   0;
dt      =   0.025;
N       =   150;
Tf      =   N*dt;
tmpc    =   0:dt:Tf;

Q       =   0*diag([0,0,1]);
R       =   0.01;


%% set up OCP -- maximize height
import casadi.*
opti = casadi.Opti();

X       =   opti.variable(nx,N+1);
U       =   opti.variable(nu,N);
%xInit   =   opti.parameter(n,1,'xInit', 'full');
g       =   [];
J       =   0;
for k=1:N
    xx      =   rk4(@(s,z,v)Swing_ODE(s,z,v),dt,tmpc(k),X(:,k),U(:,k));
    opti.subject_to(X(:,k+1)==xx);   
    
    dx      =   X(:,k+1);
    J       =   J + ( dx'*Q*dx + U(:,k)'*R*U(:,k) )*dt;
end
opti.subject_to(umin <= U <= umax)
opti.subject_to(0.9*lmax <= X(3,:) <= lmax);
opti.subject_to(X(:,1) == x0);
J       =   J - ( X(3,end)*(1-cos(X(1,end))) );

opti.set_initial(X, x0+zeros(nx, N+1));
opti.set_initial(U, 0.5*(umax-umin)+zeros(nu, N));
%% solve open-loop problem
opti.minimize(J);
opti.solver('ipopt');
sol = opti.solve();


%% plotting
xsol    =   sol.value(X);
lsol    =   xsol(3,:);
xsol    =   xsol(1:2,:);
usol    =   sol.value(U);

figure(1)
plot(tmpc,xsol'*180/pi);
xlabel('$t$','interpreter','latex');
ylabel('$\varphi(t), \dot{\varphi}(t)$','interpreter','latex');
grid on;
hold on;

figure(2)
plot(tmpc,lsol)
xlabel('$t$','interpreter','latex');
ylabel('$\ell(t)$','interpreter','latex');
grid on;
hold on;

figure(3)
plot(tmpc(1:end-1),usol)
xlabel('$t$','interpreter','latex');
ylabel('$u(t)$','interpreter','latex');
grid on;
hold on;


%% set up OCP -- periodic reference
import casadi.*
X       =   opti.variable(nx,N+1);
U       =   opti.variable(nu,N);
X1init   =   opti.parameter;
X2init   =   opti.parameter;
X3init   =   opti.parameter;
opti.set_value(X1init, x0(1));
opti.set_value(X2init, x0(2));
opti.set_value(X3init, x0(3));

J       =   0;

ref     =   23*pi/180*cos(sqrt(9.81/lmax)*tmpc+0.2);
Q1      =   1e5;
R       =   0.1;

for k=1:N
    xx      =   rk4(@(s,z,v)Swing_ODE(s,z,v),dt,tmpc(k),X(:,k),U(:,k));
    opti.subject_to(X(:,k+1)==xx);
    
    dx      =   X(1,k+1) - ref(k);
    J       =   J + ( dx'*Q1*dx + U(:,k)'*R*U(:,k) )*dt;
end
opti.subject_to(umin <= U <= umax)
opti.subject_to(0.9*lmax <= X(3,:) <= lmax);
opti.subject_to(X(1,1) == X1init);
opti.subject_to(X(2,1) == X2init);
opti.subject_to(X(3,1) == X3init);

opti.set_initial(X, x0+zeros(nx, N+1));
opti.set_initial(U, 0.5*(umax-umin)+zeros(nu, N));
%% solve open-loop problem
opti.minimize(J);
opti.solver('ipopt');
sol = opti.solve();


%% plotting
xsol    =   sol.value(X);
lsol    =   xsol(3,:);
xsol    =   xsol(1:2,:);
usol    =   sol.value(U);

figure(4)
plot(tmpc,xsol'*180/pi);
xlabel('$t$','interpreter','latex');
ylabel('$\varphi(t), \dot{\varphi}(t)$','interpreter','latex');
grid on;
hold on;
plot(tmpc,ref*180/pi);

figure(5)
plot(tmpc,lsol)
xlabel('$t$','interpreter','latex');
ylabel('$\ell(t)$','interpreter','latex');
grid on;
hold on;

figure(6)
plot(tmpc(1:end-1),usol)
xlabel('$t$','interpreter','latex');
ylabel('$u(t)$','interpreter','latex');
grid on;
hold on;

%% solve NMPC loop



