% dy = dlagrange(wk,xk,x)
% arguments:
%   wk : row vector of size N+1 containing the interpolation coefficients
%   xk : row vector of size N+1 containing the interpolation points, xk(1)<...<xk(N+1)
%   x  : points at which the Lagrange polynomial is to be evaluated
% output:
%   dy : derivative of the Lagrange polynomial at x

function dy = dlagrange(wk,xk,x)
%keyboard
    [dum,N] = size(wk);
    dy = 0.;
    for k = 1:N
        sum = 0.;
        for i = 1:N
            if i ~= k
                prod = 1.;
                for j = 1:N
                    if j ~= k && j ~= i
                        prod = prod * (x-xk(j)) / (xk(k)-xk(j));
                    end
                end
                sum = sum + prod / (xk(k)-xk(i));
            end
        end
        dy = dy + wk(k) * sum;
    end

end