function P1EX7_d()
%% Optimal Control (EE-715)
% Course at EPFL
% Problem Set #1 Exercise 7 Task d
%
%
% Autor:    timm.faulwasser@kit.edu
% Date:     20-07-16
% Status:   final

clc;
clear all
close all


% xtest=[0,0;...
%        1,1;...
%        -1,-1];

xtest=[0,0;...
       1,1;...
       -1,-1; ...
       100, 1000];
   
%make plot of function to optimize
P1EX7_a
hold on

%fmincon options
options = optimset('Algorithm','sqp','HessUpdate','bfgs','Display','iter',...
                   'Diagnostics','on','TolX',1e-7,'TolFun',1e-7,...
                   'TolCon',1e-7,'MaxFunEval',150,'MaxIter',100);
%fmincon options
% options = optimset('Algorithm','interior-point','Display','iter',...
%                    'Diagnostics','on','TolX',1e-7,'TolFun',1e-7,...
%                    'TolCon',1e-7,'MaxFunEval',150,'MaxIter',100);
               
%loop over initial guesses
for i=1:length(xtest)
    
    xopt=fmincon(@cost,...   %cost function
                 xtest(i,:),... %initial guess
	             [],...      %A from Au<=B
	             [],...      %B
	             [],...      %Ae from Ae u=Be
	             [],...      %Be
	             [],...      %lower bound for u (u_i>=LB)
	             [],...      %upper bound for u (u_i<=UB)
	             @constr,... %function defining the equality/inequality constraints
                 options)  

    if i<4   
       plot3(xopt(1),xopt(2),-cost(xopt),'bo', 'Linewidth', 4)
    end
    
end	 
keyboard
end

%% define objective
function objective=cost(x)
objective=-exp(-x(1)^2-x(2)^2);
end

%% define constraints 
function [ineqconstr,eqconstr]=constr(x)
eqconstr=x(2)+x(1)^2-1;
ineqconstr=[];
end
