function P2EX2_d
%% Optimal Control (EE-715)
% Course at EPFL
% Problem Set #1 Exercise 8 Task d
%
%
% Autor:    timm.faulwasser@kit.edu
% Date:     20-07-16
% Status:   final


clc
clear all
close all

%options = optimoptions('fmincon');
options = optimset;
options.TolFun =  1E-7; 
options.TolCon =  1E-7; 
options.TolX   =  1E-7;
options.Algorithm  = 'sqp';
options.GradConstr = 'on';
options.GradObj    = 'on';

x_guess = [1 1 1];

%linear constraints
A_ineq = [-1, 2, 1];
b_ineq = 3;

A_eq = [];
b_eq = [];

lb = [0, 0, 0]';
ub = [];

delta_theta = 0.5;

theta = [0:delta_theta:30];


for i = 1:length(theta)
    
    theta_i = theta(i);
    
    [xopt,fval,exitflag,output,lambda,grad,hessian] =fmincon(@objective,...
    x_guess,A_ineq,b_ineq,A_eq,b_eq,lb,ub,@(x)constr(x,theta_i), options);  
                                                
    F(i) = fval;
    Lambda(i) = lambda.ineqnonlin;
    
    i
end

%% plotting 
                                                
figure
subplot(2,1,1)
plot(theta, F,'-*')
xlabel('\theta')
ylabel('f_{opt}')

maxL = max(Lambda)

subplot(2,1,2)
plot(theta, Lambda,'-*')
xlabel('\theta')
ylabel('\omega')
axis([0, 30, 0, 100]);

%% slope of f(xi(theta)) at theta=15

i = floor(length(theta)/2);
theta(i+1)
df_dtheta = (F(i+2) - F(i))/(2*delta_theta)
nu = Lambda(i+1)

% keyboard
end

%% define objective
function [f, df] = objective(x)
f = x(1)^2+x(1)*x(2)+2*x(2)^2-6*x(1)-2*x(2)-12*x(3);
df = [2*x(1)+x(2)-6; x(1)+4*x(2)-2; -12];
end

%% define nonlinear constraints
function [g,h, grad_g, grad_h]=constr(x,theta)
g(1) = 2*x(1)^2+x(2)^2 -theta;
h = [];
grad_g = [4*x(1); 2*x(2); 0];
grad_h = [];
end

