%% Optimal Control (EE-715)
% Course at EPFL
% Problem Set #1 Exercise 6
%
%
% Author(s):    tillmann.muehlpfordt@kit.edu, alexander.engelmann@kit.edu, timm.faulwasser@kit.edu
% Date:         April 10, 2017

% ex 6.a)
n = 10;
h = 1e-12;
x = pi + ones(n,1); 

% compute gradients
g_forward   = grad(@speel, x, h, 'forward');
g_backward  = grad(@speel, x, h, 'backward');
g_central   = grad(@speel, x, h, 'central');

% ex. 6.b)
g_imag      = grad(@speel, x, h, 'imag');

% ex. 6.c)
g_cas       = grad(@speel, x, h, 'cas');

% ex. 6.c)
g_anal      = gradSpeel(x)';
errors      = [max(abs(g_forward-g_anal)),max(abs(g_backward-g_anal)),...
               max(abs(g_central-g_anal)),max(abs(g_imag-g_anal)), ...
               max(abs(g_cas-g_anal))];

display('Computational errors (max-norm) for')
display('forward     backward    central     imaginary            CasADi' )
display(num2str(errors))

% Speelpeening's function
function f = speel(x)
    f = 1;
    for i=1:length(x)
       f = f * x(i);
    end
end

% computing gradients by different methods
function g = grad(f, x, h, method)
    n = length(x);
    g = zeros(n,1);
    if strcmp(method,'forward')
        for i=1:n
            ei      = zeros(n,1);
            ei(i)   = 1;
            g(i)    = (f(x+h*ei) - f(x))/h;
        end
    end
    if strcmp(method,'backward')
        for i=1:n
            ei      = zeros(n,1);
            ei(i)   = 1;
            g(i)    = (f(x) - f(x-h*ei))/h;
        end
    end
    if strcmp(method,'central')
        for i=1:n
            ei      = zeros(n,1);
            ei(i)   = 1;
            g(i)    = (f(x+0.5*h*ei) - f(x-0.5*h*ei))/h;
        end
    end
    if strcmp(method,'imag')
        for i=1:n
            ei      = zeros(n,1);
            ei(i)   = 1;
            g(i)    = imag((f(x+1i*h*ei) - f(x)))/h;
        end
    end
    if strcmp(method,'cas')
        import casadi.*
        xSym        = SX.sym('x',[n 1]);
        fCas        = f(xSym);
        fCasG       = gradient(fCas,xSym);
        fCasGfun    = Function('speelCasGfun',{xSym},{fCasG});
        
        g           = full(fCasGfun(x));
    end
end


% analytic gradient of Speelpeening's function
function g_s = gradSpeel(x)
    g_s = ones(1,length(x));
    for i = 1:length(x)
        for j = 1:length(x)
            if i ~= j
                g_s(i) = g_s(i)*x(j);
            end
        end
    end
end