// File: WinScreen.kt
package com.epfl.esl.android_midterm_2024

import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.asImageBitmap
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import androidx.navigation.NavController

@Composable
fun WinScreen(
    navController: NavController, gameViewModel: GameViewModel
) {
    val originalImage = gameViewModel.originalImage

    Column(
        modifier = Modifier
            .fillMaxSize()
            .background(Color(0xFFB7FFBA))
            .padding(16.dp),
        horizontalAlignment = Alignment.CenterHorizontally,
        verticalArrangement = Arrangement.Center
    ) {
        originalImage?.let {
            Image(
                bitmap = it.asImageBitmap(),
                contentDescription = "Completed Image",
                modifier = Modifier.size(300.dp),
                contentScale = ContentScale.FillBounds
            )
        }

        Spacer(modifier = Modifier.height(32.dp))

        //* TODO: Checkpoint 3
        //  Modify the Text to show as the score the number of retriesLeft,
        //  stored in the GameViewModel *//

        Text(text = "You Win! Score: ", fontSize = 32.sp)


        // END TODO 3

        Spacer(modifier = Modifier.height(32.dp))

        Button(onClick = {
            //* TODO: Checkpoint 1
            // Implement the navigation back to the GameScreen *//



            // END TODO 1
        }) {
            Text(text = "Return to Main Screen")
        }
    }
}
