// File: MainActivity.kt
package com.epfl.esl.android_midterm_2024

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.navigation.compose.*
import com.epfl.esl.android_midterm_2024.ui.theme.AndroidMidterm2024Theme

class MainActivity : ComponentActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            AndroidMidterm2024Theme {
                val navController = rememberNavController()

                //* TODO: Checkpoint 1
                // Connect the GameViewModel with the MainActivity. *//



                // END TODO 1

                NavHost(navController = navController, startDestination = "game_screen") {
                    composable("game_screen") {
                        GameScreen(navController, gameViewModel)
                    }
                    composable("win_screen") {
                        WinScreen(navController, gameViewModel)
                    }
                    composable("lose_screen") {
                        LoseScreen(navController, gameViewModel)
                    }
                }
            }
        }
    }
}
